/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.client.TrackworkPartialModels;
import edn.stratodonut.trackwork.tracks.blocks.WheelBlock;
import edn.stratodonut.trackwork.tracks.blocks.WheelBlockEntity;
import java.util.function.BiConsumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SimpleWheelRenderer
extends KineticBlockEntityRenderer<WheelBlockEntity> {
    public SimpleWheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(WheelBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean springFlip;
        BlockState state = be.m_58900_();
        Direction.Axis rotationAxis = SimpleWheelRenderer.getRotationAxisOf((KineticBlockEntity)be);
        BlockPos visualPos = be.m_58899_();
        float angleForBE = SimpleWheelRenderer.getAngleForBE(be, visualPos, rotationAxis, partialTicks);
        Direction trackDir = (Direction)state.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        float axisMult = trackDir.m_122434_() == Direction.Axis.X ? 1.0f : -1.0f;
        float horizontalOffset = be.getPointHorizontalOffset();
        float axialOffset = be.getPointAxialOffset();
        boolean bl = springFlip = trackDir.m_122421_() == Direction.AxisDirection.NEGATIVE;
        if (!springFlip) {
            angleForBE *= -1.0f;
        } else {
            horizontalOffset *= -1.0f;
            axialOffset *= -1.0f;
        }
        float yRot = ((Direction)state.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122435_();
        float wheelTravel = be.getWheelTravel(partialTicks) - be.getWheelRadius();
        double wheelTuck = Math.sqrt(2.25 - (double)Math.min(1.0f, wheelTravel * wheelTravel)) - 1.5 - (double)axialOffset;
        if (state.m_61138_(WheelBlock.VISUAL_VARIANT) && state.m_61143_(WheelBlock.VISUAL_VARIANT) != WheelBlock.VisualVariant.no_lower_rib) {
            SimpleWheelRenderer.ribTransform(CachedBuffers.partial((PartialModel)TrackworkPartialModels.SIMPLE_WHEEL_RIB, (BlockState)state), yRot, wheelTravel, ms, buffer, light, new Vec3((double)(horizontalOffset * -axisMult), 0.0, (double)axialOffset), springFlip);
        }
        if (state.m_61138_(WheelBlock.VISUAL_VARIANT) && state.m_61143_(WheelBlock.VISUAL_VARIANT) != WheelBlock.VisualVariant.no_spring && state.m_61143_(WheelBlock.VISUAL_VARIANT) != WheelBlock.VisualVariant.no_lower_rib) {
            SimpleWheelRenderer.ribTransform(CachedBuffers.partial((PartialModel)TrackworkPartialModels.SIMPLE_WHEEL_RIB_UPPER, (BlockState)state), yRot, wheelTravel, ms, buffer, light, new Vec3((double)(horizontalOffset * -axisMult), -0.5625, (double)axialOffset), false);
        }
        BiConsumer<SuperByteBuffer, Float> springTransform = (spring, angle) -> ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)spring.translate(0.0f, 0.875f, 0.375f)).translate(0.0f, -0.4375f, 0.75f)).rotateXDegrees(angle.floatValue())).translate(0.0f, -0.4375f, -0.75f);
        float springBaseLength = 0.25f;
        float springEndPointLength = 0.75f;
        double diagonalLength = Math.sqrt(springEndPointLength * springEndPointLength + springBaseLength * springBaseLength);
        double diagonalRibOffset = -Math.atan(springBaseLength);
        double diagonalSpringOffset = 1.5707963267948966 - Math.abs(diagonalRibOffset);
        double ribAngle = Math.atan((double)(wheelTravel + 0.3f) / 1.1);
        double scaleLength = Math.sqrt((double)(springEndPointLength * springEndPointLength) + diagonalLength * diagonalLength - (double)(2.0f * springEndPointLength) * diagonalLength * Math.cos(1.5707963267948966 + ribAngle - diagonalRibOffset));
        if (state.m_61138_(WheelBlock.VISUAL_VARIANT) && state.m_61143_(WheelBlock.VISUAL_VARIANT) != WheelBlock.VisualVariant.no_spring && state.m_61143_(WheelBlock.VISUAL_VARIANT) != WheelBlock.VisualVariant.no_lower_rib) {
            float springAngle = (float)Math.toDegrees(Math.asin((double)springEndPointLength * Math.sin(1.5707963267948966 + ribAngle - diagonalRibOffset) / scaleLength) + diagonalSpringOffset - 1.5707963267948966);
            SuperByteBuffer springBase = CachedBuffers.partial((PartialModel)TrackworkPartialModels.SIMPLE_WHEEL_SPRING_BASE, (BlockState)state);
            ((SuperByteBuffer)springBase.center()).rotateYDegrees(-yRot);
            springTransform.accept(springBase, Float.valueOf(0.0f));
            ((SuperByteBuffer)springBase.translate((springFlip ? 0.75f : 0.0f) + horizontalOffset * -axisMult, 0.0f, axialOffset)).uncenter();
            springBase.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
            SuperByteBuffer springCoil = CachedBuffers.partial((PartialModel)TrackworkPartialModels.SIMPLE_WHEEL_SPRING_COIL, (BlockState)state);
            ((SuperByteBuffer)springCoil.center()).rotateYDegrees(-yRot);
            springTransform.accept(springCoil, Float.valueOf(springAngle));
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)springCoil.translate((springFlip ? 0.75f : 0.0f) + horizontalOffset * -axisMult, 0.4375f, axialOffset)).scale(1.0f, (float)scaleLength / 1.3125f, 1.0f)).translate(0.0f, -0.4375f, 0.0f)).uncenter();
            springCoil.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
        }
        SuperByteBuffer wheels = be.getWheelRadius() > 1.0f ? CachedBuffers.partial((PartialModel)TrackworkPartialModels.LARGE_SIMPLE_WHEEL, (BlockState)state) : (be.getWheelRadius() > 0.8f ? CachedBuffers.partial((PartialModel)TrackworkPartialModels.SIMPLE_WHEEL, (BlockState)state) : (be.getWheelRadius() > 0.5f ? CachedBuffers.partial((PartialModel)TrackworkPartialModels.MED_SIMPLE_WHEEL, (BlockState)state) : CachedBuffers.partial((PartialModel)TrackworkPartialModels.SMALL_SIMPLE_WHEEL, (BlockState)state)));
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)wheels.center()).rotateYDegrees(-yRot)).translate((double)(horizontalOffset * -axisMult), (double)(-wheelTravel) - 0.5, -wheelTuck)).rotateYDegrees(be.getSteeringValue() * 30.0f)).rotateZDegrees(-angleForBE)).uncenter();
        wheels.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
    }

    public static void ribTransform(SuperByteBuffer rib, float yRot, float wheelTravel, PoseStack ms, MultiBufferSource buffer, int light, Vec3 offset, boolean flip) {
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)rib.center()).rotateYDegrees(-yRot)).translate(offset.f_82479_, -0.5 - offset.f_82480_, 1.5 + offset.f_82481_)).rotateXDegrees((float)(-Math.toDegrees(Math.atan((wheelTravel + 0.3f) / 1.1f))))).translate(0.0, 0.5 + offset.f_82480_, -1.375)).uncenter();
        rib.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    public static float getAngleForBE(WheelBlockEntity be, BlockPos pos, Direction.Axis axis, float partialTick) {
        if (be.isFreespin) {
            return be.getFreeWheelAngle(partialTick);
        }
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float offset = SimpleWheelRenderer.getRotationOffsetForPosition((KineticBlockEntity)be, (BlockPos)pos, (Direction.Axis)axis);
        return (time * be.getWheelSpeed() * 3.0f / 10.0f + offset) % 360.0f;
    }

    protected BlockState getRenderedBlockState(WheelBlockEntity be) {
        return SimpleWheelRenderer.shaft((Direction.Axis)SimpleWheelRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }

    public int m_142163_() {
        return (Integer)TrackworkConfigs.client().trackRenderDist.get();
    }
}

