/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.client.TrackworkPartialModels;
import edn.stratodonut.trackwork.tracks.blocks.PhysEntityTrackBlockEntity;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlock;
import edn.stratodonut.trackwork.tracks.render.TrackBeltRenderer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PhysEntityTrackRenderer
extends KineticBlockEntityRenderer<PhysEntityTrackBlockEntity> {
    public PhysEntityTrackRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(PhysEntityTrackBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        BlockState state = be.m_58900_();
        Direction.Axis rotationAxis = PhysEntityTrackRenderer.getRotationAxisOf((KineticBlockEntity)be);
        BlockPos visualPos = be.m_58899_();
        float angleForBE = PhysEntityTrackRenderer.getAngleForBE(be, visualPos, rotationAxis);
        Direction.Axis trackAxis = (Direction.Axis)state.m_61143_((Property)TrackBaseBlock.AXIS);
        if (trackAxis == Direction.Axis.X) {
            angleForBE *= -1.0f;
        }
        SuperByteBuffer cogs = be.getWheelRadius() < 0.6f ? CachedBuffers.partial((PartialModel)TrackworkPartialModels.COGS, (BlockState)state) : (be.getWheelRadius() > 0.8f ? CachedBuffers.partial((PartialModel)TrackworkPartialModels.LARGE_COGS, (BlockState)state) : CachedBuffers.partial((PartialModel)TrackworkPartialModels.MED_COGS, (BlockState)state));
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateYDegrees(trackAxis == Direction.Axis.X ? 0.0f : 90.0f)).rotateXDegrees(-angleForBE)).translate(0.0f, 0.5625f, 0.0f)).uncenter();
        cogs.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        if (be.getAssembled()) {
            TrackBeltRenderer.renderBelt(be, partialTicks, ms, buffer, light, new TrackBeltRenderer.ScalableScroll(be, (float)((double)be.getSpeed() * ((double)be.getWheelRadius() / 0.5)), trackAxis));
        }
    }

    public static float getAngleForBE(KineticBlockEntity be, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float offset = PhysEntityTrackRenderer.getRotationOffsetForPosition((KineticBlockEntity)be, (BlockPos)pos, (Direction.Axis)axis);
        return (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f;
    }

    protected BlockState getRenderedBlockState(PhysEntityTrackBlockEntity be) {
        return PhysEntityTrackRenderer.shaft((Direction.Axis)PhysEntityTrackRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }

    public int m_142163_() {
        return (Integer)TrackworkConfigs.client().trackRenderDist.get();
    }
}

