/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import edn.stratodonut.trackwork.TrackworkUtil;
import edn.stratodonut.trackwork.tracks.data.OleoWheelData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.bodies.properties.BodyKinematics;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public final class OleoWheelController
implements ShipPhysicsListener {
    @JsonIgnore
    public static double RPM_TO_RADS = 0.10471975512;
    @JsonIgnore
    public static double MAXIMUM_SLIP = 10.0;
    @JsonIgnore
    public static double MAXIMUM_SLIP_LATERAL = MAXIMUM_SLIP * 1.5;
    @JsonIgnore
    public static double MAX_FREESPIN_SLIP = 0.07;
    @JsonIgnore
    public static double MAXIMUM_G = 490.5;
    public static Vector3dc UP = new Vector3d(0.0, 1.0, 0.0);
    private HashMap<Long, OleoWheelData> wheelData = new HashMap();
    @JsonIgnore
    private final ConcurrentHashMap<Long, TrackworkUtil.ClipResult> suspensionData = new ConcurrentHashMap();
    @JsonIgnore
    private ConcurrentHashMap<Long, OleoWheelData> wheelUpdateData = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<Long> removedWheels = new ConcurrentLinkedQueue();
    private volatile Vector3dc suspensionAdjust = new Vector3d(0.0, 1.0, 0.0);
    private volatile float suspensionStiffness = 1.0f;
    private volatile float suspensionDampening = 1.2f;

    public static OleoWheelController getOrCreate(LoadedServerShip ship) {
        return (OleoWheelController)ship.getOrPutAttachment(OleoWheelController.class, OleoWheelController::new);
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        this.wheelUpdateData.forEach((id, data) -> this.wheelData.merge((Long)id, (OleoWheelData)data, OleoWheelData::updateWith));
        this.wheelUpdateData.clear();
        while (!this.removedWheels.isEmpty()) {
            Long removeId = (Long)this.removedWheels.remove();
            this.wheelData.remove(removeId);
        }
        if (this.wheelData.isEmpty()) {
            return;
        }
        double coefficientOfPower = java.lang.Math.min(2.0, 3.0 / (double)this.wheelData.size());
        this.wheelData.forEach((id, data) -> {
            ComputeResult result = this.computeForce((OleoWheelData)data, physShip, physLevel, coefficientOfPower);
            this.suspensionData.put((Long)id, result.clipResult);
            if (result.linearForce.isFinite()) {
                physShip.applyWorldForce(result.linearForce, physShip.getTransform().getPositionInWorld());
            }
            if (result.torque.isFinite()) {
                physShip.applyWorldTorque(result.torque);
            }
        });
    }

    private ComputeResult computeForce(OleoWheelData data, PhysShip ship, PhysLevel physLevel, double coefficientOfPower) {
        if (data.susScaled == 0.0) {
            data.lastSuspensionForce = null;
            return new ComputeResult((Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), TrackworkUtil.ClipResult.MISS);
        }
        Direction.Axis axis = data.wheelAxis;
        float steeringValue = data.steeringValue;
        float axialOffset = data.axialOffset;
        float horizontalOffset = data.horizontalOffset;
        double susScaled = data.susScaled;
        double restOffset = data.wheelRadius - 0.5;
        BodyKinematics pose = ship.getKinematics();
        ShipTransform shipTransform = ship.getTransform();
        double m = ship.getMass();
        Vector3d localUp = shipTransform.getShipToWorldRotation().transform(UP, new Vector3d());
        double gravity_factor = Math.max((double)0.3, (double)localUp.dot(UP));
        Vec3 start = BlockPos.m_122022_((long)data.blockPos).m_252807_();
        Vec3 worldSpaceNormal = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)TrackworkUtil.getActionNormal(axis)), new Vector3d()).mul(susScaled + 0.5));
        Vec3 worldSpaceStart = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)start.m_82520_(0.0, -restOffset, 0.0))));
        Vec3 worldSpaceOffset = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform((Vector3dc)TrackworkUtil.getForwardVec3d(axis, 1.0f).mul((double)horizontalOffset).add((Vector3dc)TrackworkUtil.getAxisAsVec(axis).mul((double)axialOffset)), new Vector3d()));
        TrackworkUtil.ClipResult clipResult = TrackworkUtil.clipAndResolvePhys(physLevel, ship, (Vector3dc)TrackworkUtil.getAxisAsVec(axis).rotateAxis((double)(steeringValue * Math.toRadians((float)30.0f)), 0.0, 1.0, 0.0), (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceStart.m_82549_(worldSpaceOffset)), (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal), data.wheelRadius, 2, ship.getId());
        Vector3d forceVec = clipResult.trackTangent().mul(data.wheelRadius / 0.5, new Vector3d());
        double suspensionTravel = clipResult.equals(TrackworkUtil.ClipResult.MISS) ? susScaled : clipResult.suspensionLength().length() - 0.5;
        Vector3d suspensionForce = VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal.m_82490_(susScaled - suspensionTravel)).negate();
        boolean isOnGround = !clipResult.equals(TrackworkUtil.ClipResult.MISS);
        Vector3d wheelContactPosition = VectorConversionsMCKt.toJOML((Vec3)worldSpaceStart.m_82549_(worldSpaceOffset));
        Vector3d wheelNormal = VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal);
        Vector3d trackRelPosShip = VectorConversionsMCKt.toJOML((Vec3)start).sub(shipTransform.getPositionInShip(), new Vector3d());
        Vector3d tForce = new Vector3d();
        Vector3d trackNormal = wheelNormal.normalize(new Vector3d());
        Vector3d trackSurface = forceVec.mul((double)data.wheelRPM * RPM_TO_RADS * 0.5, new Vector3d());
        Vector3dc velocityAtPosition = TrackworkUtil.accumulatedVelocity(shipTransform, pose, (Vector3dc)wheelContactPosition);
        if (isOnGround) {
            velocityAtPosition = velocityAtPosition.sub(clipResult.groundVelocity(), new Vector3d());
        }
        double suspensionCompressionDelta = 0.0;
        if (data.lastSuspensionForce != null) {
            suspensionCompressionDelta = suspensionForce.sub(data.lastSuspensionForce, new Vector3d()).length();
        }
        data.lastSuspensionForce = suspensionForce;
        if (isOnGround) {
            double suspensionDelta = velocityAtPosition.dot((Vector3dc)trackNormal) + suspensionCompressionDelta;
            double tilt = 1.0 + this.tilt((Vector3dc)trackRelPosShip);
            Vector3d springForce = suspensionForce.mul(m * 4.0 * coefficientOfPower * (double)this.suspensionStiffness * tilt, new Vector3d());
            tForce.add((Vector3dc)springForce);
            double damperMagnitude = m * -suspensionDelta * coefficientOfPower * (double)this.suspensionDampening;
            if (damperMagnitude > 0.0) {
                damperMagnitude *= 0.5;
            }
            Vector3d damperForce = trackNormal.mul(damperMagnitude, new Vector3d());
            tForce.add((Vector3dc)damperForce);
            if (data.wheelRPM == 0.0f) {
                tForce = new Vector3d(0.0, tForce.y(), 0.0);
            }
        }
        if (isOnGround || trackSurface.lengthSquared() > 0.0) {
            Vector3d surfaceVelocity = velocityAtPosition.sub((Vector3dc)trackNormal.mul(velocityAtPosition.dot((Vector3dc)trackNormal), new Vector3d()), new Vector3d());
            Vector3d slipVelocity = trackSurface.sub((Vector3dc)surfaceVelocity, new Vector3d());
            Vector3d driveDir = forceVec.normalize(new Vector3d());
            Vector3d driveSlip = driveDir.mul(driveDir.dot((Vector3dc)slipVelocity), new Vector3d());
            Vector3d lateralSlip = slipVelocity.sub((Vector3dc)driveSlip, new Vector3d());
            if (isOnGround) {
                slipVelocity = data.isFreespin ? driveSlip.normalize(Math.min((double)driveSlip.length(), (double)MAX_FREESPIN_SLIP), new Vector3d()).add((Vector3dc)lateralSlip.normalize(Math.min((double)lateralSlip.length(), (double)MAXIMUM_SLIP_LATERAL), new Vector3d())) : driveSlip.normalize(Math.min((double)driveSlip.length(), (double)MAXIMUM_SLIP), new Vector3d()).add((Vector3dc)lateralSlip.normalize(Math.min((double)lateralSlip.length(), (double)MAXIMUM_SLIP_LATERAL), new Vector3d()), new Vector3d());
                tForce.add((Vector3dc)slipVelocity.mul(1.0 * m * coefficientOfPower * gravity_factor, new Vector3d()));
            } else if (!data.isFreespin && forceVec.length() != 0.0) {
                slipVelocity = driveSlip.normalize(Math.min((double)driveSlip.length(), (double)MAXIMUM_SLIP), new Vector3d());
                tForce.add((Vector3dc)slipVelocity.mul(1.0 * m * coefficientOfPower * gravity_factor, new Vector3d()));
            }
        }
        Vector3d trackRelPos = shipTransform.getShipToWorldRotation().transform((Vector3dc)trackRelPosShip, new Vector3d());
        Vector3d torque = trackRelPos.cross((Vector3dc)tForce, new Vector3d());
        return new ComputeResult((Vector3dc)tForce, (Vector3dc)torque, clipResult);
    }

    public double updateTrackBlock(BlockPos pos, OleoWheelData data) {
        this.wheelUpdateData.put(pos.m_121878_(), data);
        return (double)Math.round((double)(this.suspensionAdjust.y() * 16.0)) / 16.0 * (double)((9.0f + 1.0f / (this.suspensionStiffness * 2.0f - 1.0f)) / 10.0f);
    }

    public void removeTrackBlock(BlockPos pos) {
        this.removedWheels.add(pos.m_121878_());
    }

    public float setDamperCoefficient(float delta) {
        this.suspensionStiffness = Math.clamp((float)1.0f, (float)4.0f, (float)(this.suspensionStiffness + delta));
        return this.suspensionStiffness;
    }

    public void adjustSuspension(Vector3f delta) {
        Vector3dc old = this.suspensionAdjust;
        this.suspensionAdjust = new Vector3d(Math.clamp((double)-0.5, (double)0.5, (double)(old.x() + (double)(delta.x() * 5.0f))), Math.clamp((double)0.1, (double)1.0, (double)(old.y() + (double)delta.y())), Math.clamp((double)-0.5, (double)0.5, (double)(old.z() + (double)(delta.z() * 5.0f))));
    }

    public void resetSuspension() {
        double y = this.suspensionAdjust.y();
        this.suspensionAdjust = new Vector3d(0.0, y, 0.0);
    }

    private double tilt(Vector3dc relPos) {
        return Math.signum((double)relPos.x()) * this.suspensionAdjust.z() + Math.signum((double)relPos.z()) * this.suspensionAdjust.x();
    }

    @Nonnull
    public TrackworkUtil.ClipResult getSuspensionData(BlockPos pos) {
        return this.suspensionData.getOrDefault(pos.m_121878_(), TrackworkUtil.ClipResult.MISS);
    }

    public static <T> boolean areQueuesEqual(Queue<T> left, Queue<T> right) {
        return Arrays.equals(left.toArray(), right.toArray());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OleoWheelController)) {
            return false;
        }
        OleoWheelController otherController = (OleoWheelController)other;
        return Objects.equals(this.wheelData, otherController.wheelData) && Objects.equals(this.wheelUpdateData, otherController.wheelUpdateData) && OleoWheelController.areQueuesEqual(this.removedWheels, otherController.removedWheels);
    }

    private record ComputeResult(Vector3dc linearForce, Vector3dc torque, TrackworkUtil.ClipResult clipResult) {
    }
}

