/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.blocks;

import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import edn.stratodonut.trackwork.TrackAmbientGroups;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.TrackworkMod;
import edn.stratodonut.trackwork.TrackworkUtil;
import edn.stratodonut.trackwork.sounds.TrackSoundScapes;
import edn.stratodonut.trackwork.tracks.ITrackPointProvider;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlockEntity;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlock;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlockEntity;
import edn.stratodonut.trackwork.tracks.data.PhysEntityTrackData;
import edn.stratodonut.trackwork.tracks.forces.PhysEntityTrackController;
import edn.stratodonut.trackwork.wheel.WheelEntity;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.internal.joints.VSJoint;
import org.valkyrienskies.core.internal.joints.VSJointMaxForceTorque;
import org.valkyrienskies.core.internal.joints.VSJointPose;
import org.valkyrienskies.core.internal.joints.VSRevoluteJoint;
import org.valkyrienskies.core.internal.physics.PhysicsEntityData;
import org.valkyrienskies.core.internal.physics.PhysicsEntityServer;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class PhysEntityTrackBlockEntity
extends TrackBaseBlockEntity
implements ITrackPointProvider {
    private float wheelRadius = 0.5f;
    protected final Supplier<Ship> ship;
    @Deprecated(forRemoval=true)
    private Integer trackID;
    @Nullable
    private Long wheelId = null;
    private boolean assembled = false;
    public boolean assembleNextTick = true;
    MutableComponent chatMessage = MutableComponent.m_237204_((ComponentContents)ComponentContents.f_237124_);

    public PhysEntityTrackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.ship = () -> VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)pos);
    }

    public static PhysEntityTrackBlockEntity large(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        PhysEntityTrackBlockEntity be = new PhysEntityTrackBlockEntity(type, pos, state);
        be.wheelRadius = 1.0f;
        return be;
    }

    public static PhysEntityTrackBlockEntity med(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        PhysEntityTrackBlockEntity be = new PhysEntityTrackBlockEntity(type, pos, state);
        be.wheelRadius = 0.75f;
        return be;
    }

    public void destroy() {
        LoadedServerShip ship;
        super.destroy();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.assembled && (ship = (LoadedServerShip)this.ship.get()) != null) {
            PhysEntityTrackController controller = PhysEntityTrackController.getOrCreate(ship);
            controller.removeTrackBlock((ServerLevel)this.f_58857_, this.m_58899_());
            this.cleanupWheel();
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_ && this.assembled) {
            LoadedServerShip ship = (LoadedServerShip)this.ship.get();
            if (ship != null) {
                if (this.wheelId != null && WheelEntity.aliveInLevel((ServerLevel)this.f_58857_, this.wheelId)) {
                    this.asyncConstrainWheel(ship, this.wheelId, (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_())));
                } else {
                    this.assemble();
                }
                return;
            }
            this.disassemble();
            this.assembleNextTick = true;
        }
    }

    private void assemble() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!TrackBaseBlock.isValidAxis((Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS))) {
                return;
            }
            ServerLevel slevel = (ServerLevel)this.f_58857_;
            LoadedServerShip ship = (LoadedServerShip)this.ship.get();
            if (ship != null) {
                PhysEntityTrackController controller = PhysEntityTrackController.getOrCreate(ship);
                if (this.getAssembled()) {
                    this.disassemble();
                    controller.removeTrackBlock((ServerLevel)this.f_58857_, this.m_58899_());
                }
                this.assembled = true;
                Vector3d trackLocalPos = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()));
                long wheelId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)slevel).allocateShipId(VSGameUtilsKt.getDimensionId((Level)slevel));
                double wheelRadius = this.wheelRadius;
                Vector3d wheelGlobalPos = ship.getTransform().getShipToWorld().transformPosition((Vector3dc)trackLocalPos, new Vector3d());
                ShipTransform transform = ShipTransformImpl.Companion.create((Vector3dc)wheelGlobalPos, (Vector3dc)new Vector3d());
                PhysicsEntityData wheelData = WheelEntity.DataBuilder.createBasicData(wheelId, transform, 0.5, 200.0);
                WheelEntity.createInLevel(slevel, wheelData);
                ValkyrienSkiesMod.getOrCreateGTPA((String)ValkyrienSkies.getDimensionId((Level)this.f_58857_)).disableCollisionBetween(wheelId, ship.getId());
                this.asyncConstrainWheel(ship, wheelId, (Vector3dc)trackLocalPos);
                this.wheelId = wheelId;
                this.sendData();
            }
        }
    }

    public void disassemble() {
        this.assembled = false;
        this.cleanupWheel();
    }

    private void asyncConstrainWheel(LoadedServerShip ship, long wheelId, Vector3dc trackLocalPos) {
        ServerLevel slevel = (ServerLevel)this.f_58857_;
        double attachCompliance = 1.0E-8;
        double attachMaxForce = 1.0E50;
        double hingeMaxForce = 1.0E25;
        Vector3d axis = TrackworkUtil.getAxisAsVec((Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS));
        Quaterniond hingeOrientation = new Quaterniond();
        if (this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS) == Direction.Axis.Z) {
            hingeOrientation = hingeOrientation.rotateLocalY(1.5707963267948966);
        }
        VSRevoluteJoint axle = new VSRevoluteJoint(Long.valueOf(ship.getId()), new VSJointPose(trackLocalPos, (Quaterniondc)hingeOrientation), Long.valueOf(wheelId), new VSJointPose((Vector3dc)new Vector3d(0.5, 0.5, 0.5), (Quaterniondc)new Quaterniond()), new VSJointMaxForceTorque((float)attachMaxForce, (float)hingeMaxForce), attachCompliance, null, null, null, null, Boolean.valueOf(true));
        PhysEntityTrackData.CreateData trackData = new PhysEntityTrackData.CreateData(trackLocalPos, (Vector3dc)axis, wheelId, 0.0, 0.0, axle, this.getSpeed());
        ValkyrienSkiesMod.getOrCreateGTPA((String)ValkyrienSkies.getDimensionId((Level)slevel)).addJoint((VSJoint)axle, 0, id -> PhysEntityTrackController.getOrCreate(ship).addTrackBlock(this.m_58899_(), trackData, (int)id));
    }

    @Override
    public void tick() {
        LoadedServerShip ship;
        super.tick();
        if (this.trackID != null) {
            this.assembled = false;
            this.trackID = null;
        }
        if (this.ship.get() != null && !this.assembled && this.f_58857_ != null) {
            if (this.assembleNextTick) {
                this.assemble();
                this.assembleNextTick = false;
            } else {
                this.assembleNextTick = true;
            }
            return;
        }
        if (this.f_58857_ == null) {
            return;
        }
        if (this.assembled && !this.f_58857_.f_46443_ && (ship = (LoadedServerShip)this.ship.get()) != null) {
            boolean isWheelAlive;
            boolean bl = isWheelAlive = this.wheelId != null && WheelEntity.aliveInLevel((ServerLevel)this.f_58857_, this.wheelId);
            if (!isWheelAlive) {
                this.assemble();
            } else {
                PhysicsEntityServer wheel = WheelEntity.getInLevel((ServerLevel)this.f_58857_, this.wheelId);
                Vector3d idealPos = ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_())));
                double distance = idealPos.distance(wheel.getShipTransform().getPositionInWorld());
                if (distance > 2.0) {
                    WheelEntity.moveTo((ServerLevel)this.f_58857_, this.wheelId, (Vector3dc)idealPos);
                }
            }
            if (this.wheelId == null || !WheelEntity.aliveInLevel((ServerLevel)this.f_58857_, this.wheelId)) {
                TrackworkMod.warn("Wheel is NULL after assembly! At {}", (Object)this.m_58899_().toString());
                return;
            }
            PhysEntityTrackController controller = PhysEntityTrackController.getOrCreate(ship);
            PhysEntityTrackData.UpdateData data = new PhysEntityTrackData.UpdateData(0.0, 0.0, this.getSpeed(), this.wheelId);
            controller.updateTrackBlock(this.m_58899_(), data);
            List hits = this.f_58857_.m_45976_(LivingEntity.class, new AABB(this.m_58899_()).m_82406_(0.25));
            Vec3 worldPos = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()))));
            for (LivingEntity e : hits) {
                SuspensionTrackBlockEntity.push((Entity)e, worldPos);
                if (!(e instanceof ServerPlayer)) continue;
                ServerPlayer p = (ServerPlayer)e;
                p.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)p));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        float spd = Math.abs((float)this.getSpeed());
        float pitch = Mth.m_14036_((float)(spd / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        if (spd < 8.0f) {
            return;
        }
        TrackSoundScapes.play(TrackAmbientGroups.TRACK_SPROCKET_AMBIENT, this.f_58858_, pitch);
    }

    public boolean getAssembled() {
        return this.assembled;
    }

    public void cleanupWheel() {
        if (this.wheelId != null) {
            WheelEntity.removeInLevel((ServerLevel)this.f_58857_, this.wheelId);
        }
    }

    public void addMassStats(List<Component> tooltip, float mass) {
        Component.m_237113_((String)"Total Mass").m_130940_(ChatFormatting.GRAY);
        Component.m_237113_((String)String.valueOf(mass)).m_130946_(" kg").m_130940_(ChatFormatting.WHITE);
    }

    @Override
    public float getPointDownwardOffset(float partialTicks) {
        return (float)((double)this.wheelRadius - 0.5);
    }

    @Override
    public float getPointHorizontalOffset() {
        return 0.0f;
    }

    @Override
    public boolean isBeltLarge() {
        return (double)this.wheelRadius > 0.75;
    }

    @Override
    public Vec3 getTrackPointSlope(float partialTicks) {
        return new Vec3(0.0, (double)(Mth.m_14179_((float)partialTicks, (float)((Float)this.nextPointVerticalOffset.getFirst()).floatValue(), (float)((Float)this.nextPointVerticalOffset.getSecond()).floatValue()) - this.getPointDownwardOffset(partialTicks)), (double)this.nextPointHorizontalOffset);
    }

    @Override
    @NotNull
    public ITrackPointProvider.PointType getTrackPointType() {
        return ITrackPointProvider.PointType.WRAP;
    }

    @Override
    public float getWheelRadius() {
        return this.wheelRadius;
    }

    public float getSpeed() {
        if (!this.assembled) {
            return 0.0f;
        }
        float maxRpm = ((Integer)TrackworkConfigs.server().maxRPM.get()).intValue();
        return Math.clamp((float)(-maxRpm), (float)maxRpm, (float)super.getSpeed());
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Assembled", this.assembled);
        if (this.trackID != null) {
            compound.m_128405_("trackBlockID", this.trackID.intValue());
        }
        if (this.wheelId != null) {
            compound.m_128356_("wheelId", this.wheelId.longValue());
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.assembled = compound.m_128471_("Assembled");
        if (this.trackID == null && compound.m_128441_("trackBlockID")) {
            this.trackID = compound.m_128451_("trackBlockID");
        }
        if (this.wheelId == null && compound.m_128441_("wheelId")) {
            this.wheelId = compound.m_128454_("wheelId");
        }
        super.read(compound, clientPacket);
    }

    public float calculateStressApplied() {
        float impact;
        if (this.f_58857_.f_46443_ || !((Boolean)TrackworkConfigs.server().enableStress.get()).booleanValue() || !this.assembled || this.m_58900_().m_61143_(TrackBaseBlock.PART) != TrackBaseBlock.TrackPart.start) {
            return super.calculateStressApplied();
        }
        Ship ship = this.ship.get();
        if (ship == null) {
            return super.calculateStressApplied();
        }
        double mass = ((ServerShip)ship).getInertiaData().getMass();
        this.lastStressApplied = impact = this.calculateStressApplied((float)mass);
        return impact;
    }

    public float calculateStressApplied(float mass) {
        double impact = (double)(mass / 1000.0f) * (Double)TrackworkConfigs.server().stressMult.get() * (double)(2.0f * this.wheelRadius) * 8.0;
        if (impact < 0.0) {
            impact = 0.0;
        }
        return (float)impact;
    }
}

