/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.client;

import edn.stratodonut.trackwork.TrackSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class HornSoundInstance
extends AbstractTickableSoundInstance {
    private boolean playing;
    private int ticksLeft;
    private int note;
    @Nonnull
    private BlockPos anchorPos;
    @Nullable
    private Ship ship;

    public HornSoundInstance(int note, BlockPos pos, @Nullable Ship ship) {
        super((SoundEvent)TrackSounds.HORN.get(), SoundSource.RECORDS, SoundInstance.m_235150_());
        this.note = note;
        this.f_119578_ = true;
        this.playing = true;
        this.f_119573_ = 0.5f;
        this.f_119579_ = 0;
        this.keepAlive();
        this.anchorPos = pos;
        Vector3d worldPos = VectorConversionsMCKt.toJOML((Vec3)pos.m_252807_());
        if (ship != null) {
            worldPos = ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)this.anchorPos.m_252807_()));
        }
        this.f_119575_ = worldPos.x();
        this.f_119576_ = worldPos.y();
        this.f_119577_ = worldPos.z();
        this.ship = ship;
    }

    public void m_7788_() {
        if (this.ship != null) {
            Vector3d worldPos = this.ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)this.anchorPos.m_252807_()));
            this.f_119575_ = worldPos.x();
            this.f_119576_ = worldPos.y();
            this.f_119577_ = worldPos.z();
        }
        if (this.playing) {
            this.f_119573_ = Math.min(1.0f, this.f_119573_ + 0.5f);
            --this.ticksLeft;
            if (this.ticksLeft == 0) {
                this.kill();
            }
            return;
        }
        this.f_119573_ = Math.max(0.0f, this.f_119573_ - 0.5f);
        if (this.f_119573_ == 0.0f) {
            this.m_119609_();
        }
    }

    public void kill() {
        this.playing = false;
    }

    public void keepAlive() {
        this.ticksLeft = 2;
    }

    public void setPitch(float pitch) {
        this.f_119574_ = pitch;
    }

    public int getNote() {
        return this.note;
    }
}

