/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.bodies.properties.BodyKinematics;
import org.valkyrienskies.core.api.physics.RayCastResult;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.PhysLevel;

public class TrackworkUtil {
    public static final Vector3dc ZERO = new Vector3d();

    public static Vector3dc accumulatedVelocity(ShipTransform t, BodyKinematics pose, Vector3dc worldPosition) {
        return pose.getVelocity().add((Vector3dc)pose.getAngularVelocity().cross((Vector3dc)worldPosition.sub(t.getPositionInWorld(), new Vector3d()), new Vector3d()), new Vector3d());
    }

    @Nonnull
    public static ClipResult clipAndResolvePhys(PhysLevel physLevel, PhysShip ship, Vector3dc steeringAxis, Vector3dc start, Vector3dc clipVector, double wheelRadius, int order, long ... ignoreWheelIds) {
        Stream<Vector3dc> points;
        Vector3d worldSpaceAxis = ship.getTransform().getShipToWorldRotation().transform(steeringAxis, new Vector3d());
        Vector3d normal = clipVector.normalize(new Vector3d());
        Vector3d tangent = worldSpaceAxis.cross((Vector3dc)normal, new Vector3d());
        if (order == 0) {
            points = Stream.of(start);
        } else if (order == 1) {
            contactWidth = 0.5;
            points = Stream.of(tangent.mul(-contactWidth, new Vector3d()).add(start), start, tangent.mul(contactWidth, new Vector3d()).add(start));
        } else if (order == 2) {
            contactWidth = 0.707106781187 * wheelRadius;
            double heightOverArc = wheelRadius * 0.292893218813;
            points = Stream.of(tangent.mul(-contactWidth, new Vector3d()).add(start).sub((Vector3dc)normal.mul(heightOverArc, new Vector3d())), start, tangent.mul(contactWidth, new Vector3d()).add(start).sub((Vector3dc)normal.mul(heightOverArc, new Vector3d())));
        } else {
            throw new IllegalArgumentException(String.format("Invalid clip order. Must be 0, 1 or 2, received %d", order));
        }
        Optional<ReducedRayCastResult> accumResult = points.map(arg_0 -> TrackworkUtil.lambda$clipAndResolvePhys$0(physLevel, (Vector3dc)normal, clipVector, ignoreWheelIds, arg_0)).filter(Objects::nonNull).filter(result -> result.getHitBody().getId() != ship.getId()).map(result -> new ReducedRayCastResult(result.getDistance(), result.getVelocity())).reduce((a, b) -> new ReducedRayCastResult(Math.min((double)a.distance, (double)b.distance), (Vector3dc)a.velocity.add(b.velocity, new Vector3d())));
        if (accumResult.isEmpty()) {
            return ClipResult.MISS;
        }
        ReducedRayCastResult bResult = new ReducedRayCastResult(accumResult.get().distance, accumResult.get().velocity);
        Vector3d worldSpacehitExact = normal.normalize(bResult.distance, new Vector3d()).add(start);
        Vector3d forceNormal = start.sub((Vector3dc)worldSpacehitExact, new Vector3d());
        return new ClipResult((Vector3dc)normal.cross((Vector3dc)worldSpaceAxis, new Vector3d()).normalize(), (Vector3dc)forceNormal, bResult.velocity());
    }

    public static double roundTowardZero(double val) {
        if (val < 0.0) {
            return Math.ceil((double)val);
        }
        return Math.floor((double)val);
    }

    public static Direction.Axis around(Direction.Axis axis) {
        if (axis.m_122478_()) {
            return axis;
        }
        return axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
    }

    public static Vec3 getActionNormal(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3(0.0, -1.0, 0.0);
            case Direction.Axis.Y -> new Vec3(0.0, 0.0, 0.0);
            case Direction.Axis.Z -> new Vec3(0.0, -1.0, 0.0);
        };
    }

    public static Vector3d getAxisAsVec(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vector3d(1.0, 0.0, 0.0);
            case Direction.Axis.Y -> new Vector3d(0.0, 1.0, 0.0);
            case Direction.Axis.Z -> new Vector3d(0.0, 0.0, 1.0);
        };
    }

    public static Vector3d getForwardVec3d(Direction.Axis axis, float length) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vector3d(0.0, 0.0, (double)length);
            case Direction.Axis.Y -> new Vector3d(0.0, 0.0, 0.0);
            case Direction.Axis.Z -> new Vector3d((double)length, 0.0, 0.0);
        };
    }

    private static /* synthetic */ RayCastResult lambda$clipAndResolvePhys$0(PhysLevel physLevel, Vector3dc normal, Vector3dc clipVector, long[] ignoreWheelIds, Vector3dc p) {
        return physLevel.rayCast(p, normal, clipVector.length(), ignoreWheelIds);
    }

    public record ClipResult(@Nonnull Vector3dc trackTangent, @Nullable Vector3dc suspensionLength, @Nullable Vector3dc groundVelocity) {
        public static final ClipResult MISS = new ClipResult((Vector3dc)new Vector3d(), null, null);
    }

    public record ReducedRayCastResult(double distance, @Nonnull Vector3dc velocity) {
        public static final ReducedRayCastResult ZERO = new ReducedRayCastResult(0.0, (Vector3dc)new Vector3d());
    }
}

