/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.TaigaTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class UmbranTreeFeature
extends BOPTreeFeature<TaigaTreeConfiguration> {
    public UmbranTreeFeature(Codec<TaigaTreeConfiguration> codec) {
        super(codec);
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int baseHeight, int height, TaigaTreeConfiguration config) {
        for (int y = 0; y <= height; ++y) {
            int trunkWidth = config.trunkWidth * (height - y) / height + 1;
            int trunkStart = Mth.m_14165_((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = Mth.m_14107_((double)(0.25 + (double)trunkWidth / 2.0));
            int start = y <= baseHeight ? trunkStart : trunkStart - 1;
            int end = y <= baseHeight ? trunkEnd : trunkEnd + 1;
            for (int x = start; x <= end; ++x) {
                for (int z = start; z <= end; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(LevelAccessor world, RandomSource rand, BlockPos pos, int leavesRadius, int trunkStart, int trunkEnd, FoliagePlacer.FoliageSetter leaves, TaigaTreeConfiguration config) {
        int start = trunkStart - leavesRadius;
        int end = trunkEnd + leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                int distFromTrunk;
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || (distFromTrunk = (x < 0 ? trunkStart - x : x - trunkEnd) + (z < 0 ? trunkStart - z : z - trunkEnd)) >= 4 && (distFromTrunk != 4 || rand.m_188503_(2) != 0)) continue;
                this.placeLeaves(world, pos.m_7918_(x, 0, z), leaves, config);
                if (x != start && x != end && z != start && z != end || rand.m_188503_(3) == 0) continue;
                this.placeLeaves(world, pos.m_7918_(x, -1, z), leaves, config);
            }
        }
        if (rand.m_188503_(6) != 0 && leavesRadius > 1) {
            this.placeLeaves(world, pos.m_7918_(-1, 1, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, 1, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(0, 1, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(0, 1, 1), leaves, config);
        }
    }

    public void generateBranch(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, int length, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TaigaTreeConfiguration config) {
        Direction.Axis axis = direction.m_122434_();
        Direction sideways = direction.m_122427_();
        boolean slant = true;
        int slantOffset = 0;
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.m_5484_(direction, i - (int)Math.floor(slantOffset)).m_6625_((int)Math.floor(slantOffset));
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.m_188503_(2) != 0) continue;
                this.placeLeaves(world, pos1.m_5484_(sideways, j), leaves, config);
            }
            if (length - i > 2) {
                this.placeLeaves(world, pos1.m_7494_(), leaves, config);
                this.placeLeaves(world, pos1.m_7494_().m_5484_(sideways, -1), leaves, config);
                this.placeLeaves(world, pos1.m_7494_().m_5484_(sideways, 1), leaves, config);
            }
            if (!slant || i <= 2) continue;
            ++slantOffset;
        }
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        int trunkEnd;
        int trunkStart;
        int trunkWidth;
        boolean topLeaves;
        int baseHeight;
        TaigaTreeConfiguration config = (TaigaTreeConfiguration)configBase;
        while (startPos.m_123342_() >= world.m_141937_() + 1 && world.m_46859_(startPos) || world.m_8055_(startPos).m_204336_(BlockTags.f_13035_)) {
            startPos = startPos.m_7495_();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int leavesHeight = height - (baseHeight = GeneratorUtil.nextIntBetween(random, height / 5, height / 3));
        if (leavesHeight < 3) {
            return false;
        }
        if (!this.checkSpace((LevelAccessor)world, startPos.m_7494_(), baseHeight, height, config)) {
            return false;
        }
        BlockPos pos = startPos.m_6630_(height);
        boolean bl = height <= 20 ? true : (topLeaves = random.m_188503_(3) == 0);
        if (topLeaves) {
            this.placeLeaves((LevelAccessor)world, pos, leaves, config);
        }
        pos.m_7495_();
        for (int i = 0; i < leavesHeight; ++i) {
            trunkWidth = config.trunkWidth * i / height + 1;
            trunkStart = Mth.m_14165_((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = Mth.m_14107_((double)(0.25 + (double)trunkWidth / 2.0));
            int radius = Math.min(Math.min((i + 2) / 3, 3 + (leavesHeight - i)), 6);
            if (radius == 0) {
                if (topLeaves) {
                    this.placeLeaves((LevelAccessor)world, pos, leaves, config);
                } else {
                    this.placeLog((LevelAccessor)world, pos, logs, config);
                }
            } else if (radius < 4) {
                if (i % 3 == 0) {
                    this.generateLeafLayer((LevelAccessor)world, random, pos, radius, trunkStart, trunkEnd, leaves, config);
                } else if (topLeaves) {
                    this.placeLeaves((LevelAccessor)world, pos, leaves, config);
                } else {
                    this.placeLog((LevelAccessor)world, pos, logs, config);
                }
            } else if (i % 3 == 0) {
                this.generateBranch((LevelAccessor)world, random, pos.m_7918_(trunkStart, 0, trunkStart), Direction.NORTH, radius, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.m_7918_(trunkEnd, 0, trunkStart), Direction.EAST, radius, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.m_7918_(trunkEnd, 0, trunkEnd), Direction.SOUTH, radius, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.m_7918_(trunkStart, 0, trunkEnd), Direction.WEST, radius, logs, leaves, config);
            }
            pos = pos.m_7495_();
        }
        for (int y = 0; y < height - 1; ++y) {
            trunkWidth = config.trunkWidth * (height - y) / height + 1;
            trunkStart = Mth.m_14165_((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = Mth.m_14107_((double)(0.25 + (double)trunkWidth / 2.0));
            if (trunkWidth < 1 || trunkWidth > config.trunkWidth) {
                trunkStart = 0;
                trunkEnd = 0;
            }
            for (int x = trunkStart; x <= trunkEnd; ++x) {
                for (int z = trunkStart; z <= trunkEnd; ++z) {
                    if (y == 1) {
                        world.m_7731_(startPos.m_7918_(x, y - 1, z), Blocks.f_50493_.m_49966_(), 3);
                    }
                    this.placeLog((LevelAccessor)world, startPos.m_7918_(x, y, z), logs, config);
                }
            }
        }
        return true;
    }
}

