/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block.entity;

import biomesoplenty.api.block.BOPBlockEntities;
import biomesoplenty.block.AnomalyBlock;
import com.google.common.base.Suppliers;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AnomalyBlockEntity
extends BlockEntity {
    private long lastTime = -1L;
    private BlockState lastState = null;
    private final Supplier<LinkedHashSet<BlockState>> renderStates = Suppliers.memoize(() -> {
        Registry blockRegistry = this.f_58857_.m_9598_().m_175515_(Registries.f_256747_);
        return blockRegistry.m_6579_().stream().map(e -> ((Block)e.getValue()).m_49966_()).filter(state -> state.m_60799_() == RenderShape.MODEL).collect(Collectors.toCollection(LinkedHashSet::new));
    });

    public AnomalyBlockEntity(BlockPos pos, BlockState state) {
        super(BOPBlockEntities.ANOMALY, pos, state);
    }

    public BlockState getRenderState() {
        BlockState renderState;
        Level level = this.m_58904_();
        if (level == null) {
            return Blocks.f_50016_.m_49966_();
        }
        long time = level.m_46467_();
        if (this.lastTime == time && this.lastState != null) {
            return this.lastState;
        }
        RandomSource random = RandomSource.m_216335_((long)Mth.m_14057_((Vec3i)this.m_58899_()));
        BlockState state = this.m_58900_();
        LinkedHashSet<BlockState> renderStates = this.renderStates.get();
        int index = random.m_188503_(renderStates.size());
        switch ((AnomalyBlock.AnomalyType)((Object)state.m_61143_(AnomalyBlock.ANOMALY_TYPE))) {
            case VOLATILE: {
                index *= (int)(time / 2L);
                break;
            }
            case QUIRKY: {
                index += (int)(time / 10L);
                break;
            }
            case UNSTABLE: {
                float slowWeight = 0.98f;
                int mode = (Mth.m_14205_((double)(Mth.m_14031_((float)((float)time / 20.0f)) + 0.98f)) + 1) / 2;
                if (mode > 0) {
                    index += (int)(time / 100L);
                    break;
                }
                index += (int)time;
            }
        }
        index = Mth.m_14100_((int)index, (int)renderStates.size());
        this.lastState = renderState = (BlockState)renderStates.stream().skip(index).findFirst().orElseThrow();
        this.lastTime = time;
        return renderState;
    }
}

