/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.sound.context;

import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.api.SoundDefinition;
import dev.imb11.sounds.api.context.DynamicSoundContext;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class ScreenHandlerSoundContext
implements DynamicSoundContext<AbstractContainerMenu> {
    private final boolean isOpening;

    public ScreenHandlerSoundContext() {
        this(true);
    }

    public ScreenHandlerSoundContext(boolean isOpening) {
        this.isOpening = isOpening;
    }

    public static ScreenHandlerSoundContext of(boolean isOpening) {
        return new ScreenHandlerSoundContext(isOpening);
    }

    @Override
    public SoundInstance handleContext(AbstractContainerMenu context, SoundEvent fallback, float pitch, float volume) {
        SoundEvent soundEvent = null;
        try {
            MenuType type = context.m_6772_();
            for (SoundDefinition definition : DynamicSoundHelper.getDefinitions("screens")) {
                if (!definition.getKeys().isValid(type)) continue;
                soundEvent = definition.getSoundEvent();
                if (definition.getPitch().isPresent()) {
                    pitch = definition.getPitch().get().floatValue();
                }
                if (definition.getVolume().isPresent()) {
                    volume = definition.getVolume().get().floatValue();
                }
                break;
            }
        }
        catch (Exception ignored) {
            SoundsClient.LOGGER.debug("Screen of type {} has no declared ScreenHandlerType - ignoring.", (Object)context.getClass().getName());
        }
        fallback = this.isOpening ? SoundsConfig.get(UISoundsConfig.class).inventoryOpenSoundEffect.fetchSoundEvent() : SoundsConfig.get(UISoundsConfig.class).inventoryCloseSoundEffect.fetchSoundEvent();
        if (soundEvent == null) {
            soundEvent = fallback;
        }
        return this.createSoundInstance(soundEvent, pitch, volume);
    }

    @Override
    public SoundInstance getExample(SoundEvent fallback, float pitch, float volume) {
        return this.createSoundInstance(fallback, pitch, volume);
    }
}

