/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.gui;

import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.config.ChatSoundsConfig;
import dev.imb11.sounds.config.ModConfig;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import dev.imb11.sounds.config.utils.ConfigGroup;
import dev.imb11.sounds.gui.DynamicGridWidget;
import dev.imb11.sounds.gui.ImageButtonWidget;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class SoundsConfigScreen
extends Screen {
    private final Screen parent;
    public float timeSinceLastSupporter = -1.0f;
    public int supporterIndex = -1;

    public SoundsConfigScreen(@Nullable Screen parent) {
        super((Component)Component.m_237115_((String)"sounds.config.title"));
        this.parent = parent;
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
        assert (this.f_96541_ != null);
        float soundsConfigTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"sounds.config.title"));
        context.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"sounds.config.title"), this.f_96543_ / 2, 10, 0xFFFFFF);
        if (this.timeSinceLastSupporter == -1.0f) {
            this.timeSinceLastSupporter = Util.m_137550_();
            this.supporterIndex = 0;
        }
        if (this.timeSinceLastSupporter + 2000.0f < (float)Util.m_137550_()) {
            ++this.supporterIndex;
            if (this.supporterIndex >= SoundsClient.SUPPORTERS.length) {
                this.supporterIndex = 0;
            }
            this.timeSinceLastSupporter = Util.m_137550_();
        }
        String supporter = SoundsClient.SUPPORTERS[this.supporterIndex];
        float timePassed = ((float)Util.m_137550_() - this.timeSinceLastSupporter) / 2000.0f;
        float fadeBetween = (Mth.m_14031_((float)(timePassed * (float)Math.PI)) + 1.0f) / 2.0f;
        if ((double)fadeBetween < 0.01) {
            fadeBetween = 0.0f;
        }
        int alpha = (int)(fadeBetween * 255.0f);
        int color = alpha << 24 | 0xFFFFFF;
        MutableComponent text = Component.m_237113_((String)supporter).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)" supports me on Ko-Fi!").m_130940_(ChatFormatting.WHITE));
        int textX = 10;
        int spaceBetween = this.f_96543_ / 2 - 40;
        int textTotalHeight = this.f_96547_.m_239133_((FormattedText)text, spaceBetween - 20);
        Objects.requireNonNull(this.f_96547_);
        int targetY = 10 + 9 / 2;
        int textY = targetY - textTotalHeight / 2;
        context.m_280554_(this.f_96547_, (FormattedText)text, textX, textY, spaceBetween - 20, color);
    }

    protected void m_7856_() {
        super.m_7856_();
        Objects.requireNonNull(this.f_96547_);
        int fontHeight = 9;
        DynamicGridWidget grid = new DynamicGridWidget(10, 10 + fontHeight + 10, this.f_96543_ - 20, this.f_96544_ - 20 - fontHeight - 10 - 20);
        grid.setPadding(3);
        ConfigGroup[] configGroups = SoundsConfig.getAll();
        configGroups = (ConfigGroup[])Arrays.stream(configGroups).sorted(Comparator.comparing(o -> o.getClass().getSimpleName())).toArray(ConfigGroup[]::new);
        for (ConfigGroup configGroup2 : configGroups = (ConfigGroup[])Arrays.stream(configGroups).filter(configGroup -> configGroup.getClass() != ModConfig.class).toArray(ConfigGroup[]::new)) {
            if (configGroup2 instanceof ChatSoundsConfig) {
                grid.addChild(new ImageButtonWidget(0, 0, 0, 0, configGroup2.getName(), configGroup2.getImage(), btn -> this.f_96541_.m_91152_(configGroup2.getYACL().generateScreen((Screen)this))), 1, 2);
                continue;
            }
            if (configGroup2 instanceof WorldSoundsConfig) {
                grid.addChild(new ImageButtonWidget(0, 0, 0, 0, configGroup2.getName(), configGroup2.getImage(), btn -> this.f_96541_.m_91152_(configGroup2.getYACL().generateScreen((Screen)this))), 2, 2);
                continue;
            }
            if (configGroup2 instanceof UISoundsConfig) {
                grid.addChild(new ImageButtonWidget(0, 0, 0, 0, configGroup2.getName(), configGroup2.getImage(), btn -> this.f_96541_.m_91152_(configGroup2.getYACL().generateScreen((Screen)this))), 2, 1);
                continue;
            }
            grid.addChild(new ImageButtonWidget(0, 0, 0, 0, configGroup2.getName(), configGroup2.getImage(), btn -> this.f_96541_.m_91152_(configGroup2.getYACL().generateScreen((Screen)this))));
        }
        grid.calculateLayout();
        grid.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        int discordAndKoFiButtonsWidth = 230;
        int doneButtonWidth = this.f_96543_ - discordAndKoFiButtonsWidth;
        Button buttonWidget = Button.m_253074_((Component)CommonComponents.f_130655_, btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 - doneButtonWidth / 2, this.f_96544_ - 30, doneButtonWidth, 20).m_253136_();
        Button koFiButton = Button.m_253074_((Component)Component.m_237113_((String)"Donate").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD), btn -> Util.m_137581_().m_137646_("https://ko-fi.com/mineblock11")).m_252987_(10, this.f_96544_ - 30, 100, 20).m_253136_();
        Button discordButton = Button.m_253074_((Component)Component.m_237113_((String)"Discord").m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.BOLD), btn -> Util.m_137581_().m_137646_("https://discord.imb11.dev/")).m_252987_(this.f_96543_ - 110, this.f_96544_ - 30, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)buttonWidget);
        this.m_142416_((GuiEventListener)koFiButton);
        this.m_142416_((GuiEventListener)discordButton);
    }
}

