/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.api.TagList;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class SoundDefinition<T> {
    private final SoundEvent soundEvent;
    private final TagList<T> keys;
    private final Optional<Float> volume;
    private final Optional<Float> pitch;

    protected SoundDefinition(SoundEvent soundEvent, TagList<T> keys, Optional<Float> volume, Optional<Float> pitch) {
        this.soundEvent = soundEvent;
        this.keys = keys;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static <T> Codec<SoundDefinition<T>> getCodec(ResourceKey<? extends Registry<T>> registryKey) {
        return RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.xmap(SoundEvent::m_262824_, SoundEvent::m_11660_).fieldOf("soundEvent").forGetter(SoundDefinition::getSoundEvent), (App)TagList.getCodec(registryKey).fieldOf("keys").forGetter(SoundDefinition::getKeys), (App)ExtraCodecs.f_184349_.optionalFieldOf("volume").forGetter(SoundDefinition::getVolume), (App)ExtraCodecs.f_184349_.optionalFieldOf("pitch").forGetter(SoundDefinition::getPitch)).apply((Applicative)builder, SoundDefinition::new));
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    public TagList<T> getKeys() {
        return this.keys;
    }

    public Optional<Float> getPitch() {
        return this.pitch;
    }

    public Optional<Float> getVolume() {
        return this.volume;
    }

    public static class Builder<T> {
        private final SoundEvent soundEvent;
        private final TagList<T> keys = new TagList(new ArrayList());
        private final Registry<T> registry;
        private Optional<Float> volume = Optional.empty();
        private Optional<Float> pitch = Optional.empty();

        public Builder(SoundEvent soundEvent, Registry<T> registry) {
            this.soundEvent = soundEvent;
            this.registry = registry;
        }

        public Builder<T> addKey(T key) {
            this.keys.add(Either.left((Object)((ResourceKey)this.registry.m_7854_(key).orElseThrow(() -> new RuntimeException("SoundDefinition.Builder: Could not find RegistryKey for " + key.toString())))));
            return this;
        }

        @SafeVarargs
        public final Builder<T> addMultipleKeys(T ... keys) {
            for (T key : keys) {
                this.addKey(key);
            }
            return this;
        }

        @SafeVarargs
        public final Builder<T> addMultipleKeys(TagKey<T> ... keys) {
            for (TagKey<T> key : keys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder<T> addKey(TagKey<T> key) {
            this.keys.add(Either.right(key));
            return this;
        }

        public Builder<T> setVolume(float volume) {
            this.volume = Optional.of(Float.valueOf(volume));
            return this;
        }

        public Builder<T> setPitch(float pitch) {
            this.pitch = Optional.of(Float.valueOf(pitch));
            return this;
        }

        public SoundDefinition<T> build() {
            return new SoundDefinition<T>(this.soundEvent, this.keys, this.volume, this.pitch);
        }
    }
}

