/*
 * Decompiled with CFR 0.152.
 */
package ru.vanilaworld.mekanismbomb.procedures;

import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BombExplosionProcedure {
    public static void execute(Level level, double x, double y, double z) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BombExplosionProcedure.performSphericalExplosion(serverLevel, x, y, z, 10000.0f);
    }

    private static void performSphericalExplosion(final ServerLevel level, double centerX, double centerY, double centerZ, float power) {
        final float blocksPerTick = 8.0f + power * 0.15f;
        float maxRadius = (float)Math.cbrt(power) * 2.8f;
        final ArrayList<BlockPos> blocksToDestroy = new ArrayList<BlockPos>();
        int minX = (int)Math.floor(centerX - (double)maxRadius);
        int maxX = (int)Math.ceil(centerX + (double)maxRadius);
        int minY = (int)Math.floor(centerY - (double)maxRadius);
        int maxY = (int)Math.ceil(centerY + (double)maxRadius);
        int minZ = (int)Math.floor(centerZ - (double)maxRadius);
        int maxZ = (int)Math.ceil(centerZ + (double)maxRadius);
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    BlockPos pos = new BlockPos(dx, dy, dz);
                    double dax = (double)pos.m_123341_() + 0.5 - centerX;
                    double day = (double)pos.m_123342_() + 0.5 - centerY;
                    double daz = (double)pos.m_123343_() + 0.5 - centerZ;
                    double distSq = dax * dax + day * day + daz * daz;
                    float distance = (float)Math.sqrt(distSq);
                    float destructionChance = 1.6f - distance / maxRadius;
                    destructionChance *= destructionChance;
                    FluidState fluid = level.m_6425_(pos);
                    if (distance <= maxRadius && ThreadLocalRandom.current().nextFloat() < destructionChance) {
                        blocksToDestroy.add(pos);
                        continue;
                    }
                    if (fluid.m_76178_() || !(distance <= maxRadius)) continue;
                    blocksToDestroy.add(pos);
                }
            }
        }
        blocksToDestroy.sort((a, b) -> Double.compare(a.m_203198_(centerX, centerY, centerZ), b.m_203198_(centerX, centerY, centerZ)));
        final int[] index = new int[]{0};
        final int totalBlocks = blocksToDestroy.size();
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onServerTick(TickEvent.ServerTickEvent event) {
                if (event.phase != TickEvent.Phase.END || level.f_46443_) {
                    return;
                }
                if (index[0] >= totalBlocks) {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                    return;
                }
                int toDestroyThisTick = (int)Math.ceil(blocksPerTick);
                toDestroyThisTick = Math.min(toDestroyThisTick, totalBlocks - index[0]);
                for (int i = 0; i < toDestroyThisTick; ++i) {
                    boolean isWater;
                    BlockPos pos = (BlockPos)blocksToDestroy.get(index[0] + i);
                    BlockState state = level.m_8055_(pos);
                    FluidState fluid = level.m_6425_(pos);
                    if (state.m_60800_((BlockGetter)level, pos) < 0.0f || state.m_60795_()) continue;
                    boolean bl = isWater = !fluid.m_76178_();
                    if (isWater) {
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                        if (level.f_46441_.m_188501_() < 0.7f) {
                            level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2 + (double)level.f_46441_.m_188501_() * 0.6, (double)pos.m_123343_() + 0.5, 12 + level.f_46441_.m_188503_(8), 0.4, 0.6, 0.4, 0.12);
                            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5, 5 + level.f_46441_.m_188503_(6), 0.25, 0.5, 0.25, 0.08);
                        }
                        if (level.f_46441_.m_188501_() < 0.35f) {
                            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.7f + level.f_46441_.m_188501_() * 0.6f, 0.9f + level.f_46441_.m_188501_() * 0.4f);
                        }
                    } else {
                        level.m_46961_(pos, false);
                    }
                    if (!(level.f_46441_.m_188501_() < 0.08f)) continue;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
                index[0] = index[0] + toDestroyThisTick;
                if (index[0] % 40 == 0) {
                    // empty if block
                }
            }
        });
    }
}

