/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.vEntityManaging.types.constraints;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.spaceeye.vmod.reflectable.ReflectableItemDelegate;
import net.spaceeye.vmod.reflectable.ReflectableObject;
import net.spaceeye.vmod.utils.GetHingeRotationKt;
import net.spaceeye.vmod.utils.LinspaceKt;
import net.spaceeye.vmod.utils.NbtUtilKt;
import net.spaceeye.vmod.utils.ServerObjectsHolder;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.utils.vs.ConstraintsCopyKt;
import net.spaceeye.vmod.utils.vs.MyGameToPhysicsAdapterKt;
import net.spaceeye.vmod.utils.vs.VSShipPosTransformsKt;
import net.spaceeye.vmod.vEntityManaging.VEntity;
import net.spaceeye.vmod.vEntityManaging.util.TwoShipsMConstraint;
import net.spaceeye.vmod.vEntityManaging.util.VEAutoSerializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipInertiaData;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.ShipInertiaDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.internal.joints.VSDistanceJoint;
import org.valkyrienskies.core.internal.joints.VSJoint;
import org.valkyrienskies.core.internal.joints.VSJointMaxForceTorque;
import org.valkyrienskies.core.internal.joints.VSJointPose;
import org.valkyrienskies.core.internal.physics.PhysicsEntityData;
import org.valkyrienskies.core.internal.physics.PhysicsEntityServer;
import org.valkyrienskies.core.internal.physics.VSCapsuleCollisionShapeData;
import org.valkyrienskies.core.internal.physics.VSCollisionShapeData;
import org.valkyrienskies.core.internal.world.VsiServerShipWorld;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b:\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004By\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u0012\n\u0010\r\u001a\u00060\u000bj\u0002`\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u0017\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0003\u0010\u0018JR\u0010`\u001a\u0004\u0018\u00010a2\u0006\u0010b\u001a\u00020c2\u001a\u0010d\u001a\u0016\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\b\u0012\u00060\u000bj\u0002`\f0e2\"\u0010f\u001a\u001e\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060W0eH\u0016J \u0010g\u001a\u00020h2\u0006\u0010b\u001a\u00020c2\u0006\u0010i\u001a\u00020\u00152\u0006\u0010j\u001a\u00020\u0006H\u0016J \u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020\u00152\u0006\u0010n\u001a\u00020\u00152\u0006\u0010o\u001a\u00020\u0015H\u0002J\u0018\u0010p\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010q\u001a\u00020\u0015H\u0002J\u0010\u0010r\u001a\u00020s2\u0006\u0010b\u001a\u00020cH\u0002J\u001c\u0010t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020s0v0u2\u0006\u0010b\u001a\u00020cH\u0002J\n\u0010w\u001a\u0004\u0018\u00010xH\u0016J\u0012\u0010y\u001a\u0004\u0018\u00010a2\u0006\u0010z\u001a\u00020xH\u0016J\u0018\u0010{\u001a\u00020Q2\u0006\u0010b\u001a\u00020c2\u0006\u0010O\u001a\u00020QH\u0002J\u001c\u0010|\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020s0v0u2\u0006\u0010b\u001a\u00020cH\u0016J\u0010\u0010}\u001a\u00020h2\u0006\u0010b\u001a\u00020cH\u0016R+\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00068V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00068V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\u001f\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001dR+\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u001f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R+\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010\u001f\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R+\u0010\b\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b-\u0010\u001f\u001a\u0004\b+\u0010\u001b\"\u0004\b,\u0010\u001dR+\u0010\t\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b0\u0010\u001f\u001a\u0004\b.\u0010\u001b\"\u0004\b/\u0010\u001dR+\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b5\u0010\u001f\u001a\u0004\b1\u00102\"\u0004\b3\u00104R+\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00158F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b:\u0010\u001f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R+\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b?\u0010\u001f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R+\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bB\u0010\u001f\u001a\u0004\b@\u0010<\"\u0004\bA\u0010>R\u001b\u0010C\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bE\u0010\u001f\u001a\u0004\bD\u00107R+\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bH\u0010\u001f\u001a\u0004\bF\u0010<\"\u0004\bG\u0010>R+\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00158F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bK\u0010\u001f\u001a\u0004\bI\u00107\"\u0004\bJ\u00109R+\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00158F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bN\u0010\u001f\u001a\u0004\bL\u00107\"\u0004\bM\u00109R \u0010O\u001a\b\u0012\u0004\u0012\u00020Q0PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR,\u0010V\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020Y0W0PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010S\"\u0004\b[\u0010UR \u0010\\\u001a\b\u0012\u0004\u0012\u00020]0PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010S\"\u0004\b_\u0010U\u00a8\u0006~"}, d2={"Lnet/spaceeye/vmod/vEntityManaging/types/constraints/PhysRopeConstraint;", "Lnet/spaceeye/vmod/vEntityManaging/util/TwoShipsMConstraint;", "Lnet/spaceeye/vmod/vEntityManaging/util/VEAutoSerializable;", "<init>", "()V", "sPos1", "Lnet/spaceeye/vmod/utils/Vector3d;", "sPos2", "sDir1", "sDir2", "shipId1", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipId2", "stiffness", "", "maxForce", "ropeLength", "segments", "", "massPerSegment", "", "radius", "angleLimit", "(Lnet/spaceeye/vmod/utils/Vector3d;Lnet/spaceeye/vmod/utils/Vector3d;Lnet/spaceeye/vmod/utils/Vector3d;Lnet/spaceeye/vmod/utils/Vector3d;JJFFFIDDD)V", "<set-?>", "getSPos1", "()Lnet/spaceeye/vmod/utils/Vector3d;", "setSPos1", "(Lnet/spaceeye/vmod/utils/Vector3d;)V", "sPos1$delegate", "Lnet/spaceeye/vmod/reflectable/ReflectableItemDelegate;", "getSPos2", "setSPos2", "sPos2$delegate", "getShipId1", "()J", "setShipId1", "(J)V", "shipId1$delegate", "getShipId2", "setShipId2", "shipId2$delegate", "getSDir1", "setSDir1", "sDir1$delegate", "getSDir2", "setSDir2", "sDir2$delegate", "getSegments", "()I", "setSegments", "(I)V", "segments$delegate", "getRadius", "()D", "setRadius", "(D)V", "radius$delegate", "getMaxForce", "()F", "setMaxForce", "(F)V", "maxForce$delegate", "getStiffness", "setStiffness", "stiffness$delegate", "compliance", "getCompliance", "compliance$delegate", "getRopeLength", "setRopeLength", "ropeLength$delegate", "getAngleLimit", "setAngleLimit", "angleLimit$delegate", "getMassPerSegment", "setMassPerSegment", "massPerSegment$delegate", "data", "", "Lorg/valkyrienskies/core/internal/physics/PhysicsEntityData;", "getData", "()Ljava/util/List;", "setData", "(Ljava/util/List;)V", "relState", "Lkotlin/Pair;", "Lorg/joml/Vector3d;", "Lorg/joml/Quaterniond;", "getRelState", "setRelState", "entities", "Lorg/valkyrienskies/core/internal/physics/PhysicsEntityServer;", "getEntities", "setEntities", "iCopyVEntity", "Lnet/spaceeye/vmod/vEntityManaging/VEntity;", "level", "Lnet/minecraft/server/level/ServerLevel;", "mapped", "", "centerPositions", "iOnScaleBy", "", "scaleBy", "scalingCenter", "makeInertiaTensor", "Lorg/joml/Matrix3d;", "l", "r", "mass", "makeActualRadius", "length", "makeData", "", "makeConstraints", "", "Ljava/util/concurrent/CompletableFuture;", "iNbtSerialize", "Lnet/minecraft/nbt/CompoundTag;", "iNbtDeserialize", "tag", "shipIdCheck", "iOnMakeVEntity", "iOnDeleteVEntity", "VMod"})
@SourceDebugExtension(value={"SMAP\nPhysRopeConstraint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysRopeConstraint.kt\nnet/spaceeye/vmod/vEntityManaging/types/constraints/PhysRopeConstraint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n1#2:348\n1557#3:349\n1628#3,3:350\n1557#3:353\n1628#3,3:354\n1557#3:357\n1628#3,3:358\n1557#3:361\n1628#3,3:362\n1557#3:365\n1628#3,3:366\n1863#3,2:369\n1863#3,2:371\n*S KotlinDebug\n*F\n+ 1 PhysRopeConstraint.kt\nnet/spaceeye/vmod/vEntityManaging/types/constraints/PhysRopeConstraint\n*L\n112#1:349\n112#1:350,3\n143#1:353\n143#1:354,3\n280#1:357\n280#1:358,3\n311#1:361\n311#1:362,3\n339#1:365\n339#1:366,3\n345#1:369,2\n247#1:371,2\n*E\n"})
public final class PhysRopeConstraint
extends TwoShipsMConstraint
implements VEAutoSerializable {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReflectableItemDelegate sPos1$delegate;
    @NotNull
    private final ReflectableItemDelegate sPos2$delegate;
    @NotNull
    private final ReflectableItemDelegate shipId1$delegate;
    @NotNull
    private final ReflectableItemDelegate shipId2$delegate;
    @NotNull
    private final ReflectableItemDelegate sDir1$delegate;
    @NotNull
    private final ReflectableItemDelegate sDir2$delegate;
    @NotNull
    private final ReflectableItemDelegate segments$delegate;
    @NotNull
    private final ReflectableItemDelegate radius$delegate;
    @NotNull
    private final ReflectableItemDelegate maxForce$delegate;
    @NotNull
    private final ReflectableItemDelegate stiffness$delegate;
    @NotNull
    private final ReflectableItemDelegate compliance$delegate;
    @NotNull
    private final ReflectableItemDelegate ropeLength$delegate;
    @NotNull
    private final ReflectableItemDelegate angleLimit$delegate;
    @NotNull
    private final ReflectableItemDelegate massPerSegment$delegate;
    @NotNull
    private List<PhysicsEntityData> data;
    @NotNull
    private List<Pair<org.joml.Vector3d, Quaterniond>> relState;
    @NotNull
    private List<PhysicsEntityServer> entities;

    public PhysRopeConstraint() {
        ReflectableItemDelegate<Object> it;
        ReflectableItemDelegate<Vector3d> reflectableItemDelegate;
        int n = this.getI();
        this.setI(n + 1);
        ReflectableItemDelegate<Vector3d> reflectableItemDelegate2 = reflectableItemDelegate = this.get(n, new Vector3d());
        PhysRopeConstraint physRopeConstraint = this;
        boolean bl = false;
        it.getMetadata().put("NoTagSerialization", true);
        physRopeConstraint.sPos1$delegate = reflectableItemDelegate.provideDelegate(this, $$delegatedProperties[0]);
        int n2 = this.getI();
        this.setI(n2 + 1);
        ReflectableItemDelegate<Vector3d> reflectableItemDelegate3 = this.get(n2, new Vector3d());
        it = reflectableItemDelegate3;
        physRopeConstraint = this;
        boolean bl2 = false;
        it.getMetadata().put("NoTagSerialization", true);
        physRopeConstraint.sPos2$delegate = reflectableItemDelegate3.provideDelegate(this, $$delegatedProperties[1]);
        int n3 = this.getI();
        this.setI(n3 + 1);
        ReflectableItemDelegate<Long> reflectableItemDelegate4 = this.get(n3, -1L);
        it = reflectableItemDelegate4;
        physRopeConstraint = this;
        boolean bl3 = false;
        it.getMetadata().put("NoTagSerialization", true);
        physRopeConstraint.shipId1$delegate = reflectableItemDelegate4.provideDelegate(this, $$delegatedProperties[2]);
        int n4 = this.getI();
        this.setI(n4 + 1);
        ReflectableItemDelegate<Long> reflectableItemDelegate5 = this.get(n4, -1L);
        it = reflectableItemDelegate5;
        physRopeConstraint = this;
        boolean bl4 = false;
        it.getMetadata().put("NoTagSerialization", true);
        physRopeConstraint.shipId2$delegate = reflectableItemDelegate5.provideDelegate(this, $$delegatedProperties[3]);
        int n5 = this.getI();
        this.setI(n5 + 1);
        this.sDir1$delegate = this.get(n5, new Vector3d()).provideDelegate(this, $$delegatedProperties[4]);
        n5 = this.getI();
        this.setI(n5 + 1);
        this.sDir2$delegate = this.get(n5, new Vector3d()).provideDelegate(this, $$delegatedProperties[5]);
        n5 = this.getI();
        this.setI(n5 + 1);
        this.segments$delegate = this.get(n5, 0).provideDelegate(this, $$delegatedProperties[6]);
        n5 = this.getI();
        this.setI(n5 + 1);
        this.radius$delegate = this.get(n5, 0.0).provideDelegate(this, $$delegatedProperties[7]);
        n5 = this.getI();
        this.setI(n5 + 1);
        this.maxForce$delegate = this.get(n5, Float.valueOf(-1.0f)).provideDelegate(this, $$delegatedProperties[8]);
        n5 = this.getI();
        this.setI(n5 + 1);
        this.stiffness$delegate = this.get(n5, Float.valueOf(-1.0f)).provideDelegate(this, $$delegatedProperties[9]);
        n5 = this.getI();
        this.setI(n5 + 1);
        this.compliance$delegate = this.get(n5, 1.0E-100).provideDelegate(this, $$delegatedProperties[10]);
        n5 = this.getI();
        this.setI(n5 + 1);
        this.ropeLength$delegate = this.get(n5, Float.valueOf(0.0f)).provideDelegate(this, $$delegatedProperties[11]);
        n5 = this.getI();
        this.setI(n5 + 1);
        this.angleLimit$delegate = this.get(n5, 0.0).provideDelegate(this, $$delegatedProperties[12]);
        n5 = this.getI();
        this.setI(n5 + 1);
        this.massPerSegment$delegate = this.get(n5, 0.0).provideDelegate(this, $$delegatedProperties[13]);
        this.data = new ArrayList();
        this.relState = new ArrayList();
        this.entities = new ArrayList();
    }

    @Override
    @NotNull
    public Vector3d getSPos1() {
        return (Vector3d)this.sPos1$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Override
    public void setSPos1(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.sPos1$delegate.setValue(this, $$delegatedProperties[0], vector3d);
    }

    @Override
    @NotNull
    public Vector3d getSPos2() {
        return (Vector3d)this.sPos2$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Override
    public void setSPos2(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.sPos2$delegate.setValue(this, $$delegatedProperties[1], vector3d);
    }

    @Override
    public long getShipId1() {
        return ((Number)this.shipId1$delegate.getValue(this, $$delegatedProperties[2])).longValue();
    }

    @Override
    public void setShipId1(long l) {
        this.shipId1$delegate.setValue(this, $$delegatedProperties[2], l);
    }

    @Override
    public long getShipId2() {
        return ((Number)this.shipId2$delegate.getValue(this, $$delegatedProperties[3])).longValue();
    }

    @Override
    public void setShipId2(long l) {
        this.shipId2$delegate.setValue(this, $$delegatedProperties[3], l);
    }

    @NotNull
    public final Vector3d getSDir1() {
        return (Vector3d)this.sDir1$delegate.getValue(this, $$delegatedProperties[4]);
    }

    public final void setSDir1(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.sDir1$delegate.setValue(this, $$delegatedProperties[4], vector3d);
    }

    @NotNull
    public final Vector3d getSDir2() {
        return (Vector3d)this.sDir2$delegate.getValue(this, $$delegatedProperties[5]);
    }

    public final void setSDir2(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.sDir2$delegate.setValue(this, $$delegatedProperties[5], vector3d);
    }

    public final int getSegments() {
        return ((Number)this.segments$delegate.getValue(this, $$delegatedProperties[6])).intValue();
    }

    public final void setSegments(int n) {
        this.segments$delegate.setValue(this, $$delegatedProperties[6], n);
    }

    public final double getRadius() {
        return ((Number)this.radius$delegate.getValue(this, $$delegatedProperties[7])).doubleValue();
    }

    public final void setRadius(double d) {
        this.radius$delegate.setValue(this, $$delegatedProperties[7], d);
    }

    public final float getMaxForce() {
        return ((Number)this.maxForce$delegate.getValue(this, $$delegatedProperties[8])).floatValue();
    }

    public final void setMaxForce(float f) {
        this.maxForce$delegate.setValue(this, $$delegatedProperties[8], Float.valueOf(f));
    }

    public final float getStiffness() {
        return ((Number)this.stiffness$delegate.getValue(this, $$delegatedProperties[9])).floatValue();
    }

    public final void setStiffness(float f) {
        this.stiffness$delegate.setValue(this, $$delegatedProperties[9], Float.valueOf(f));
    }

    public final double getCompliance() {
        return ((Number)this.compliance$delegate.getValue(this, $$delegatedProperties[10])).doubleValue();
    }

    public final float getRopeLength() {
        return ((Number)this.ropeLength$delegate.getValue(this, $$delegatedProperties[11])).floatValue();
    }

    public final void setRopeLength(float f) {
        this.ropeLength$delegate.setValue(this, $$delegatedProperties[11], Float.valueOf(f));
    }

    public final double getAngleLimit() {
        return ((Number)this.angleLimit$delegate.getValue(this, $$delegatedProperties[12])).doubleValue();
    }

    public final void setAngleLimit(double d) {
        this.angleLimit$delegate.setValue(this, $$delegatedProperties[12], d);
    }

    public final double getMassPerSegment() {
        return ((Number)this.massPerSegment$delegate.getValue(this, $$delegatedProperties[13])).doubleValue();
    }

    public final void setMassPerSegment(double d) {
        this.massPerSegment$delegate.setValue(this, $$delegatedProperties[13], d);
    }

    @NotNull
    public final List<PhysicsEntityData> getData() {
        return this.data;
    }

    public final void setData(@NotNull List<PhysicsEntityData> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.data = list;
    }

    @NotNull
    public final List<Pair<org.joml.Vector3d, Quaterniond>> getRelState() {
        return this.relState;
    }

    public final void setRelState(@NotNull List<Pair<org.joml.Vector3d, Quaterniond>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.relState = list;
    }

    @NotNull
    public final List<PhysicsEntityServer> getEntities() {
        return this.entities;
    }

    public final void setEntities(@NotNull List<PhysicsEntityServer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.entities = list;
    }

    public PhysRopeConstraint(@NotNull Vector3d sPos1, @NotNull Vector3d sPos2, @NotNull Vector3d sDir1, @NotNull Vector3d sDir2, long shipId1, long shipId2, float stiffness, float maxForce, float ropeLength, int segments, double massPerSegment, double radius, double angleLimit) {
        Intrinsics.checkNotNullParameter((Object)sPos1, (String)"sPos1");
        Intrinsics.checkNotNullParameter((Object)sPos2, (String)"sPos2");
        Intrinsics.checkNotNullParameter((Object)sDir1, (String)"sDir1");
        Intrinsics.checkNotNullParameter((Object)sDir2, (String)"sDir2");
        this();
        this.setSPos1(sPos1.copy());
        this.setSPos2(sPos2.copy());
        this.setSDir1(sDir1.copy());
        this.setSDir2(sDir2.copy());
        this.setShipId1(shipId1);
        this.setShipId2(shipId2);
        this.setStiffness(stiffness);
        this.setMaxForce(maxForce);
        this.setRopeLength(ropeLength);
        this.setSegments(segments);
        this.setMassPerSegment(massPerSegment);
        this.setRadius(radius);
        this.setAngleLimit(angleLimit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public VEntity iCopyVEntity(@NotNull ServerLevel level, @NotNull Map<Long, Long> mapped, @NotNull Map<Long, Pair<Vector3d, Vector3d>> centerPositions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PhysRopeConstraint physRopeConstraint;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(mapped, (String)"mapped");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
        Vector3d vector3d = ConstraintsCopyKt.tryMovePosition(this.getSPos1(), this.getShipId1(), centerPositions);
        if (vector3d == null) {
            return null;
        }
        Vector3d vector3d2 = ConstraintsCopyKt.tryMovePosition(this.getSPos2(), this.getShipId2(), centerPositions);
        if (vector3d2 == null) {
            return null;
        }
        Long l = mapped.get(this.getShipId1());
        if (l == null) {
            return null;
        }
        Long l2 = mapped.get(this.getShipId2());
        if (l2 == null) {
            return null;
        }
        PhysRopeConstraint con = physRopeConstraint = new PhysRopeConstraint(vector3d, vector3d2, this.getSPos1().copy(), this.getSPos2().copy(), l, l2, this.getStiffness(), this.getMaxForce(), this.getRopeLength(), this.getSegments(), this.getMassPerSegment(), this.getRadius(), this.getAngleLimit());
        boolean bl = false;
        Ship ship = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(con.getShipId1());
        Intrinsics.checkNotNull((Object)ship);
        ServerShip ship2 = (ServerShip)ship;
        Iterable iterable = CollectionsKt.zip((Iterable)this.data, (Iterable)this.relState);
        PhysRopeConstraint physRopeConstraint2 = con;
        boolean $i$f$map = false;
        void var11_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            PhysicsEntityData data = (PhysicsEntityData)pair.component1();
            Pair state = (Pair)pair.component2();
            org.joml.Vector3d sPos = (org.joml.Vector3d)state.component1();
            Quaterniond rot = (Quaterniond)state.component2();
            long l3 = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).allocateShipId(VSGameUtilsKt.getDimensionId((Level)((Level)level)));
            org.joml.Vector3d vector3d3 = ship2.getShipToWorld().transformPosition(sPos.sub((Vector3dc)this.getSPos1().toJomlVector3d()).add((Vector3dc)con.getSPos1().toJomlVector3d()));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"transformPosition(...)");
            Vector3dc vector3dc = (Vector3dc)vector3d3;
            Vector3dc vector3dc2 = data.getTransform().getPositionInWorld();
            Quaterniond quaterniond = rot.premul(ship2.getTransform().getRotation());
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond, (String)"premul(...)");
            collection.add(PhysicsEntityData.copy$default((PhysicsEntityData)data, (long)l3, (ShipTransform)ShipTransformImpl.Companion.create(vector3dc, vector3dc2, (Quaterniondc)quaterniond, data.getTransform().getScaling()), null, null, null, null, (int)0, (double)0.0, (double)0.0, (double)0.0, (boolean)false, (int)2044, null));
        }
        physRopeConstraint2.data = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        return physRopeConstraint;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void iOnScaleBy(@NotNull ServerLevel level, double scaleBy, @NotNull Vector3d scalingCenter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)scalingCenter, (String)"scalingCenter");
        this.setMassPerSegment(this.getMassPerSegment() * scaleBy);
        this.setRadius(this.getRadius() * scaleBy);
        this.setRopeLength(this.getRopeLength() * (float)scaleBy);
        float segmentLength = this.getRopeLength() / (float)this.getSegments();
        double radius = 0.0;
        radius = this.getRadius();
        double length = (double)segmentLength * 0.5;
        if (length < radius) {
            radius = length / (double)2;
        }
        if (length > radius * (double)4) {
            radius = length / (double)4;
        }
        double linkLength = length - radius;
        Matrix3d inertiaTensor = this.makeInertiaTensor(linkLength, radius, this.getMassPerSegment());
        Iterable iterable = CollectionsKt.zip((Iterable)this.data, (Iterable)this.entities);
        PhysRopeConstraint physRopeConstraint = this;
        boolean $i$f$map = false;
        void var13_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PhysicsEntityData data = (PhysicsEntityData)pair.component1();
            PhysicsEntityServer entity = (PhysicsEntityServer)pair.component2();
            long l = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).allocateShipId(VSGameUtilsKt.getDimensionId((Level)((Level)level)));
            Vector3dc vector3dc = (Vector3dc)new Vector3d(entity.getShipTransform().getPositionInWorld()).minus(scalingCenter).times(scaleBy).plus(scalingCenter).toJomlVector3d();
            Vector3dc vector3dc2 = entity.getShipTransform().getPositionInShip();
            Quaterniondc quaterniondc = entity.getShipTransform().getRotation();
            org.joml.Vector3d vector3d = entity.getShipTransform().getScaling().mul(scaleBy, scaleBy, scaleBy, new org.joml.Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            ShipTransform shipTransform = ShipTransformImpl.Companion.create(vector3dc, vector3dc2, quaterniondc, (Vector3dc)vector3d);
            org.joml.Vector3d vector3d2 = entity.getInertiaData().getCenterOfMassInShip().get(new org.joml.Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"get(...)");
            double d = this.getMassPerSegment();
            Matrix3d matrix3d = inertiaTensor.get(new Matrix3d());
            Intrinsics.checkNotNullExpressionValue((Object)matrix3d, (String)"get(...)");
            collection.add(PhysicsEntityData.copy$default((PhysicsEntityData)data, (long)l, (ShipTransform)shipTransform, (ShipInertiaData)((ShipInertiaData)new ShipInertiaDataImpl(vector3d2, d, matrix3d)), null, null, (VSCollisionShapeData)((VSCollisionShapeData)new VSCapsuleCollisionShapeData(radius, linkLength)), (int)0, (double)0.0, (double)0.0, (double)0.0, (boolean)false, (int)2008, null));
        }
        physRopeConstraint.data = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        this.onDeleteVEntity(level);
        this.onMakeVEntity(level);
    }

    private final Matrix3d makeInertiaTensor(double l, double r, double mass) {
        double rSq = r * r;
        double cM_temp = l * rSq * Math.PI;
        double hsM_temp = 2.0 * rSq * r * Math.PI * 0.3333333333333333;
        double density = mass / (cM_temp + hsM_temp);
        double cM = cM_temp * density;
        double hsM = hsM_temp * density;
        Matrix3d inertiaTensor = new Matrix3d();
        inertiaTensor.m11 = rSq * cM * 0.5;
        inertiaTensor.m00 = inertiaTensor.m22 = inertiaTensor.m11 * 0.5 + cM * l * l * 0.08333333333333333;
        double temp0 = hsM * 2.0 * rSq / 5.0;
        inertiaTensor.m11 += temp0 * 2.0;
        double temp1 = l * 0.5;
        double temp2 = temp0 + hsM * (temp1 * temp1 + 0.375 * l * r);
        inertiaTensor.m00 += temp2 * 2.0;
        inertiaTensor.m22 += temp2 * 2.0;
        return inertiaTensor;
    }

    private final double makeActualRadius(double radius, double length) {
        double length2 = length * 0.5;
        double radius2 = radius;
        if (length2 < radius2) {
            radius2 = length2 / (double)2;
        }
        if (length2 > radius2 * (double)4) {
            radius2 = length2 / (double)4;
        }
        return radius2;
    }

    private final boolean makeData(ServerLevel level) {
        Vector3d rPos1 = this.getShipId1() == -1L ? this.getSPos1().copy() : VSShipPosTransformsKt.posShipToWorld$default(VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(this.getShipId1()), this.getSPos1(), null, 4, null);
        Vector3d rPos2 = this.getShipId2() == -1L ? this.getSPos2().copy() : VSShipPosTransformsKt.posShipToWorld$default(VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(this.getShipId2()), this.getSPos2(), null, 4, null);
        Vector3d rDir = rPos1.minus(rPos2).normalize();
        double segmentLength = (double)this.getRopeLength() / (double)this.getSegments();
        Vector3d startDir = rPos1.minus(rDir.times(segmentLength / 2.0));
        Vector3d stopDir = rPos2.plus(rDir.times(segmentLength / 2.0));
        Quaterniond rot = GetHingeRotationKt.getHingeRotation$default(rDir, null, 2, null);
        ArrayList<Double> xLin = LinspaceKt.linspace(startDir.x, stopDir.x, this.getSegments());
        ArrayList<Double> yLin = LinspaceKt.linspace(startDir.y, stopDir.y, this.getSegments());
        ArrayList<Double> zLin = LinspaceKt.linspace(startDir.z, stopDir.z, this.getSegments());
        double length = segmentLength * 0.5;
        double radius = this.makeActualRadius(this.getRadius(), length);
        double linkLength = length - radius;
        Matrix3d tensor = this.makeInertiaTensor(linkLength, radius, this.getMassPerSegment());
        if (!tensor.isFinite()) {
            return false;
        }
        int n = this.getSegments();
        for (int i2 = 0; i2 < n; ++i2) {
            Double d = xLin.get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"get(...)");
            Number number = d;
            Double d2 = yLin.get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"get(...)");
            Number number2 = d2;
            Double d3 = zLin.get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"get(...)");
            Vector3d pos = new Vector3d(number, number2, d3);
            long l = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).allocateShipId(VSGameUtilsKt.getDimensionId((Level)((Level)level)));
            ShipTransform shipTransform = ShipTransformImpl.Companion.create((Vector3dc)pos.toJomlVector3d(), (Vector3dc)new org.joml.Vector3d(), (Quaterniondc)rot, (Vector3dc)new org.joml.Vector3d());
            org.joml.Vector3d vector3d = new org.joml.Vector3d();
            double d4 = this.getMassPerSegment();
            Matrix3d matrix3d = tensor.get(new Matrix3d());
            Intrinsics.checkNotNullExpressionValue((Object)matrix3d, (String)"get(...)");
            this.data.add(new PhysicsEntityData(l, shipTransform, (ShipInertiaData)new ShipInertiaDataImpl(vector3d, d4, matrix3d), (Vector3dc)new org.joml.Vector3d(), (Vector3dc)new org.joml.Vector3d(), (VSCollisionShapeData)new VSCapsuleCollisionShapeData(radius, linkLength), 0, 0.0, 0.0, 0.0, true, 960, null));
        }
        return true;
    }

    private final List<CompletableFuture<Boolean>> makeConstraints(ServerLevel level) {
        return this.withFutures((Function2<? super TwoShipsMConstraint.HelperFn, ? super TwoShipsMConstraint, Unit>)((Function2)(arg_0, arg_1) -> PhysRopeConstraint.makeConstraints$lambda$8(this, level, arg_0, arg_1)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CompoundTag iNbtSerialize() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void it;
        ListTag listTag;
        CompoundTag compoundTag = VEAutoSerializable.DefaultImpls.iNbtSerialize(this);
        if (compoundTag == null) {
            return null;
        }
        CompoundTag tag = compoundTag;
        VsiServerShipWorld vsiServerShipWorld = ServerObjectsHolder.INSTANCE.getShipObjectWorld();
        ServerShip ship = vsiServerShipWorld != null && (vsiServerShipWorld = vsiServerShipWorld.getAllShips()) != null ? (ServerShip)vsiServerShipWorld.getById(this.getShipId1()) : null;
        NbtUtilKt.putVector3d(tag, "scaling", (Vector3dc)new org.joml.Vector3d(1.0, 1.0, 1.0));
        ListTag listTag2 = listTag = new ListTag();
        String string = "data";
        CompoundTag compoundTag2 = tag;
        boolean bl = false;
        Iterable iterable = this.entities;
        void var7_9 = it;
        boolean $i$f$map = false;
        void var9_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pos;
            void entity;
            CompoundTag compoundTag3;
            PhysicsEntityServer physicsEntityServer = (PhysicsEntityServer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            CompoundTag it2 = compoundTag3 = new CompoundTag();
            boolean bl3 = false;
            NbtUtilKt.putVector3d(tag, "scaling", entity.getShipTransform().getScaling());
            it2.m_128356_("shipId", entity.getId());
            NbtUtilKt.putVector3d(it2, "positionInWorld", entity.getShipTransform().getPositionInWorld());
            NbtUtilKt.putQuatd(it2, "rotation", entity.getShipTransform().getRotation());
            Vector3dc vector3dc = entity.getShipTransform().getPositionInWorld();
            String string2 = "posRelToShip1";
            CompoundTag compoundTag4 = it2;
            boolean bl4 = false;
            ServerShip serverShip = ship;
            void var24_26 = serverShip != null && (serverShip = serverShip.getWorldToShip()) != null && (serverShip = serverShip.transformPosition((Vector3dc)pos, new org.joml.Vector3d())) != null ? (Vector3dc)serverShip : pos;
            NbtUtilKt.putVector3d(compoundTag4, string2, (Vector3dc)var24_26);
            Quaterniondc quaterniondc = entity.getShipTransform().getRotation();
            ServerShip serverShip2 = ship;
            if (serverShip2 == null || (serverShip2 = serverShip2.getTransform()) == null || (serverShip2 = serverShip2.getRotation()) == null || (serverShip2 = serverShip2.invert(new Quaterniond())) == null) {
                serverShip2 = new Quaterniond();
            }
            Quaterniond quaterniond = quaterniondc.premul((Quaterniondc)serverShip2, new Quaterniond());
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond, (String)"premul(...)");
            NbtUtilKt.putQuatd(it2, "rotRelToShip1", (Quaterniondc)quaterniond);
            collection.add(compoundTag3);
        }
        var7_9.addAll((Collection)((List)destination$iv$iv));
        Unit unit = Unit.INSTANCE;
        compoundTag2.m_128365_(string, (Tag)listTag);
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public VEntity iNbtDeserialize(@NotNull CompoundTag tag) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        VEntity vEntity = VEAutoSerializable.DefaultImpls.iNbtDeserialize(this, tag);
        if (vEntity == null) {
            return null;
        }
        VEntity entity = vEntity;
        PhysRopeConstraint cfr_ignored_0 = (PhysRopeConstraint)entity;
        Tag tag2 = tag.m_128423_("data");
        Intrinsics.checkNotNull((Object)tag2, (String)"null cannot be cast to non-null type net.minecraft.nbt.ListTag");
        ListTag dataTag = (ListTag)tag2;
        if (dataTag.size() != ((PhysRopeConstraint)entity).getSegments()) {
            return this;
        }
        double length = (double)this.getRopeLength() / (double)this.getSegments() * 0.5;
        double radius = this.makeActualRadius(this.getRadius(), length);
        double linkLength = length - radius;
        org.joml.Vector3d vector3d = NbtUtilKt.getVector3d(tag, "scaling");
        if (vector3d == null) {
            vector3d = new org.joml.Vector3d(1.0, 1.0, 1.0);
        }
        org.joml.Vector3d scaling = vector3d;
        Iterable iterable = (Iterable)dataTag;
        PhysRopeConstraint physRopeConstraint = (PhysRopeConstraint)entity;
        boolean $i$f$map = false;
        void var13_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tag3;
            Tag tag4 = (Tag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)tag3, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            CompoundTag cfr_ignored_1 = (CompoundTag)tag3;
            org.joml.Vector3d vector3d2 = NbtUtilKt.getVector3d((CompoundTag)tag3, "posRelToShip1");
            Intrinsics.checkNotNull((Object)vector3d2);
            Quaterniond quaterniond = NbtUtilKt.getQuatd((CompoundTag)tag3, "rotRelToShip1");
            Intrinsics.checkNotNull((Object)quaterniond);
            this.relState.add((Pair<org.joml.Vector3d, Quaterniond>)new Pair((Object)vector3d2, (Object)quaterniond));
            long l = ((CompoundTag)tag3).m_128454_("shipId");
            org.joml.Vector3d vector3d3 = NbtUtilKt.getVector3d((CompoundTag)tag3, "positionInWorld");
            Intrinsics.checkNotNull((Object)vector3d3);
            Vector3dc vector3dc = (Vector3dc)vector3d3;
            Vector3dc vector3dc2 = (Vector3dc)new org.joml.Vector3d();
            Quaterniond quaterniond2 = NbtUtilKt.getQuatd((CompoundTag)tag3, "rotation");
            Intrinsics.checkNotNull((Object)quaterniond2);
            collection.add(new PhysicsEntityData(l, ShipTransformImpl.Companion.create(vector3dc, vector3dc2, (Quaterniondc)quaterniond2, (Vector3dc)scaling), (ShipInertiaData)new ShipInertiaDataImpl(new org.joml.Vector3d(), this.getMassPerSegment(), this.makeInertiaTensor(linkLength, radius, this.getMassPerSegment())), (Vector3dc)new org.joml.Vector3d(), (Vector3dc)new org.joml.Vector3d(), (VSCollisionShapeData)new VSCapsuleCollisionShapeData(radius, linkLength), 0, 0.0, 0.0, 0.0, false, 1984, null));
        }
        physRopeConstraint.data = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        return entity;
    }

    private final PhysicsEntityData shipIdCheck(ServerLevel level, PhysicsEntityData data) {
        if (!VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().contains(data.getShipId())) {
            return data;
        }
        return PhysicsEntityData.copy$default((PhysicsEntityData)data, (long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).allocateShipId(VSGameUtilsKt.getDimensionId((Level)((Level)level))), null, null, null, null, null, (int)0, (double)0.0, (double)0.0, (double)0.0, (boolean)false, (int)2046, null);
    }

    @Override
    @NotNull
    public List<CompletableFuture<Boolean>> iOnMakeVEntity(@NotNull ServerLevel level) {
        CompletableFuture<Boolean> completableFuture;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        CompletableFuture<Boolean> it = completableFuture = new CompletableFuture<Boolean>();
        boolean bl = false;
        it.complete(true);
        return CollectionsKt.listOf(completableFuture);
    }

    @Override
    public void iOnDeleteVEntity(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super.iOnDeleteVEntity(level);
        Iterable $this$forEach$iv = this.entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhysicsEntityServer it = (PhysicsEntityServer)element$iv;
            boolean bl = false;
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).deletePhysicsEntity(it.getId());
        }
    }

    @Override
    @NotNull
    public <T> ReflectableItemDelegate<T> get(int pos, @NotNull T t) {
        return VEAutoSerializable.DefaultImpls.get(this, pos, t);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public CompoundTag tSerialize() {
        return VEAutoSerializable.DefaultImpls.tSerialize(this);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    public void tDeserialize(@NotNull CompoundTag tag) {
        VEAutoSerializable.DefaultImpls.tDeserialize(this, tag);
    }

    @Override
    @JsonIgnore
    @NotNull
    public CompoundTag tGetBuffer() {
        return VEAutoSerializable.DefaultImpls.tGetBuffer(this);
    }

    @Override
    @JsonIgnore
    @Nullable
    public ReflectableObject getReflectObjectOverride() {
        return VEAutoSerializable.DefaultImpls.getReflectObjectOverride(this);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return VEAutoSerializable.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return VEAutoSerializable.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    public void setFromVararg(@NotNull Object[] items) {
        VEAutoSerializable.DefaultImpls.setFromVararg(this, items);
    }

    private static final Unit makeConstraints$lambda$8(PhysRopeConstraint this$0, ServerLevel $level, TwoShipsMConstraint.HelperFn $this$withFutures, TwoShipsMConstraint it) {
        Intrinsics.checkNotNullParameter((Object)$this$withFutures, (String)"$this$withFutures");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Vector3d dir = new Vector3d(1, 0, 0);
        float stiffness = this$0.getStiffness() <= 0.0f ? Float.MAX_VALUE : this$0.getStiffness();
        VSJointMaxForceTorque maxForceTorque = this$0.getMaxForce() < 0.0f ? null : new VSJointMaxForceTorque(this$0.getMaxForce(), this$0.getMaxForce());
        long prevId = 0L;
        prevId = this$0.getShipId1();
        Vector3d prevPos = null;
        prevPos = this$0.getSPos1();
        Vector3d prevDir = null;
        prevDir = this$0.getSDir1().unaryMinus();
        float minAngle = (float)(-this$0.getAngleLimit() / 2.0);
        float maxAngle = (float)(this$0.getAngleLimit() / 2.0);
        Object limit = null;
        Iterable $this$forEach$iv = this$0.entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhysicsEntityServer entity = (PhysicsEntityServer)element$iv;
            boolean bl = false;
            VSCollisionShapeData vSCollisionShapeData = entity.getCollisionShapeData();
            Intrinsics.checkNotNull((Object)vSCollisionShapeData, (String)"null cannot be cast to non-null type org.valkyrienskies.core.internal.physics.VSCapsuleCollisionShapeData");
            double length = ((VSCapsuleCollisionShapeData)vSCollisionShapeData).getLength();
            VSCollisionShapeData vSCollisionShapeData2 = entity.getCollisionShapeData();
            Intrinsics.checkNotNull((Object)vSCollisionShapeData2, (String)"null cannot be cast to non-null type org.valkyrienskies.core.internal.physics.VSCapsuleCollisionShapeData");
            double radius = ((VSCapsuleCollisionShapeData)vSCollisionShapeData2).getRadius();
            $this$withFutures.mc((VSJoint)new VSDistanceJoint(Long.valueOf(prevId), new VSJointPose((Vector3dc)prevPos.toJomlVector3d(), (Quaterniondc)GetHingeRotationKt.getHingeRotation$default(prevDir, null, 2, null)), Long.valueOf(entity.getId()), new VSJointPose((Vector3dc)dir.times(length + radius).toJomlVector3d(), (Quaterniondc)GetHingeRotationKt.getHingeRotation$default(dir, null, 2, null)), maxForceTorque, this$0.getCompliance(), Float.valueOf(0.0f), Float.valueOf(0.0f), null, null, null, 1792, null), $level);
            $this$withFutures.getFutures().add(MyGameToPhysicsAdapterKt.getGtpa($level).disableCollisionBetweenBodies(prevId, entity.getId()));
            prevId = entity.getId();
            prevPos = dir.unaryMinus().times(length + radius);
            prevDir = dir;
        }
        $this$withFutures.mc((VSJoint)new VSDistanceJoint(Long.valueOf(prevId), new VSJointPose((Vector3dc)prevPos.toJomlVector3d(), (Quaterniondc)GetHingeRotationKt.getHingeRotation$default(prevDir, null, 2, null)), Long.valueOf(this$0.getShipId2()), new VSJointPose((Vector3dc)this$0.getSPos2().toJomlVector3d(), (Quaterniondc)GetHingeRotationKt.getHingeRotation$default(this$0.getSDir2(), null, 2, null)), maxForceTorque, this$0.getCompliance(), Float.valueOf(0.0f), Float.valueOf(0.0f), null, null, null, 1792, null), $level);
        $this$withFutures.getFutures().add(MyGameToPhysicsAdapterKt.getGtpa($level).disableCollisionBetweenBodies(prevId, this$0.getShipId2()));
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "sPos1", "getSPos1()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "sPos2", "getSPos2()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "shipId1", "getShipId1()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "shipId2", "getShipId2()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "sDir1", "getSDir1()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "sDir2", "getSDir2()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "segments", "getSegments()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "radius", "getRadius()D", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "maxForce", "getMaxForce()F", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "stiffness", "getStiffness()F", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(PhysRopeConstraint.class, "compliance", "getCompliance()D", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "ropeLength", "getRopeLength()F", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "angleLimit", "getAngleLimit()D", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PhysRopeConstraint.class, "massPerSegment", "getMassPerSegment()D", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

