/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.vEntityManaging.types.constraints;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.spaceeye.vmod.reflectable.ReflectableItemDelegate;
import net.spaceeye.vmod.reflectable.ReflectableObject;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.vEntityManaging.ServerLevelExtensionFnsKt;
import net.spaceeye.vmod.vEntityManaging.VEntity;
import net.spaceeye.vmod.vEntityManaging.util.ExtendableVEntity;
import net.spaceeye.vmod.vEntityManaging.util.VEAutoSerializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.Ship;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004B!\b\u0016\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\u0003\u0010\tJ\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0012\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001eH\u0016JR\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\"\u001a\u00020#2\u001a\u0010)\u001a\u0016\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\u00070*2\"\u0010+\u001a\u001e\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0,0*H\u0016JF\u0010-\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001c2\n\u0010/\u001a\u00060\u0006j\u0002`\u00072\n\u00100\u001a\u00060\u0006j\u0002`\u00072\u0006\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u001eH\u0016J\u001c\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0017050\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u00106\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R+\u0010\b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u000e\u00103\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lnet/spaceeye/vmod/vEntityManaging/types/constraints/DisabledCollisionConstraint;", "Lnet/spaceeye/vmod/vEntityManaging/util/ExtendableVEntity;", "Lnet/spaceeye/vmod/vEntityManaging/util/VEAutoSerializable;", "<init>", "()V", "shipId1", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipId2", "(JJ)V", "i", "", "<set-?>", "getShipId1", "()J", "setShipId1", "(J)V", "shipId1$delegate", "Lnet/spaceeye/vmod/reflectable/ReflectableItemDelegate;", "getShipId2", "setShipId2", "shipId2$delegate", "iStillExists", "", "allShips", "Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "Lorg/valkyrienskies/core/api/ships/Ship;", "iAttachedToShips", "", "iGetAttachmentPoints", "Lnet/spaceeye/vmod/utils/Vector3d;", "shipId", "iOnScaleBy", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "scaleBy", "", "scalingCenter", "iCopyVEntity", "Lnet/spaceeye/vmod/vEntityManaging/VEntity;", "mapped", "", "centerPositions", "Lkotlin/Pair;", "iMoveAttachmentPoints", "pointsToMove", "oldShipId", "newShipId", "oldCenter", "newCenter", "beingRemoved", "iOnMakeVEntity", "Ljava/util/concurrent/CompletableFuture;", "iOnDeleteVEntity", "VMod"})
public final class DisabledCollisionConstraint
extends ExtendableVEntity
implements VEAutoSerializable {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @JsonIgnore
    private int i;
    @NotNull
    private final ReflectableItemDelegate shipId1$delegate;
    @NotNull
    private final ReflectableItemDelegate shipId2$delegate;
    private boolean beingRemoved;

    public DisabledCollisionConstraint() {
        int n = this.i;
        this.i = n + 1;
        this.shipId1$delegate = this.get(n, -1L).provideDelegate(this, $$delegatedProperties[0]);
        n = this.i;
        this.i = n + 1;
        this.shipId2$delegate = this.get(n, -1L).provideDelegate(this, $$delegatedProperties[1]);
    }

    public final long getShipId1() {
        return ((Number)this.shipId1$delegate.getValue(this, $$delegatedProperties[0])).longValue();
    }

    public final void setShipId1(long l) {
        this.shipId1$delegate.setValue(this, $$delegatedProperties[0], l);
    }

    public final long getShipId2() {
        return ((Number)this.shipId2$delegate.getValue(this, $$delegatedProperties[1])).longValue();
    }

    public final void setShipId2(long l) {
        this.shipId2$delegate.setValue(this, $$delegatedProperties[1], l);
    }

    public DisabledCollisionConstraint(long shipId1, long shipId2) {
        this();
        this.setShipId1(shipId1);
        this.setShipId2(shipId2);
    }

    @Override
    public boolean iStillExists(@NotNull QueryableShipData<? extends Ship> allShips) {
        Intrinsics.checkNotNullParameter(allShips, (String)"allShips");
        boolean ship1Exists = allShips.contains(this.getShipId1());
        boolean ship2Exists = allShips.contains(this.getShipId2());
        return ship1Exists && ship2Exists || ship1Exists && -1L == this.getShipId1() || ship2Exists && -1L == this.getShipId2();
    }

    @Override
    @NotNull
    public List<Long> iAttachedToShips() {
        List toReturn = new ArrayList();
        if (-1L != this.getShipId1()) {
            toReturn.add(this.getShipId1());
        }
        if (-1L != this.getShipId2()) {
            toReturn.add(this.getShipId2());
        }
        return toReturn;
    }

    @Override
    @NotNull
    public List<Vector3d> iGetAttachmentPoints(long shipId) {
        return CollectionsKt.emptyList();
    }

    @Override
    public void iOnScaleBy(@NotNull ServerLevel level, double scaleBy, @NotNull Vector3d scalingCenter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)scalingCenter, (String)"scalingCenter");
    }

    @Override
    @Nullable
    public VEntity iCopyVEntity(@NotNull ServerLevel level, @NotNull Map<Long, Long> mapped, @NotNull Map<Long, Pair<Vector3d, Vector3d>> centerPositions) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(mapped, (String)"mapped");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
        Long l = mapped.get(this.getShipId1());
        if (l == null) {
            return null;
        }
        Long l2 = mapped.get(this.getShipId2());
        if (l2 == null) {
            return null;
        }
        return new DisabledCollisionConstraint(l, l2);
    }

    @Override
    public boolean iMoveAttachmentPoints(@NotNull ServerLevel level, @NotNull List<Vector3d> pointsToMove, long oldShipId, long newShipId, @NotNull Vector3d oldCenter, @NotNull Vector3d newCenter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(pointsToMove, (String)"pointsToMove");
        Intrinsics.checkNotNullParameter((Object)oldCenter, (String)"oldCenter");
        Intrinsics.checkNotNullParameter((Object)newCenter, (String)"newCenter");
        return true;
    }

    @Override
    @NotNull
    public List<CompletableFuture<Boolean>> iOnMakeVEntity(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return CollectionsKt.listOf(ServerLevelExtensionFnsKt.disableCollisionBetween(level, this.getShipId1(), this.getShipId2(), (Function0<Unit>)((Function0)() -> DisabledCollisionConstraint.iOnMakeVEntity$lambda$0(this, level))));
    }

    @Override
    public void iOnDeleteVEntity(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.beingRemoved = true;
        ServerLevelExtensionFnsKt.enableCollisionBetween(level, this.getShipId1(), this.getShipId2());
    }

    @Override
    @Nullable
    public CompoundTag iNbtSerialize() {
        return VEAutoSerializable.DefaultImpls.iNbtSerialize(this);
    }

    @Override
    @Nullable
    public VEntity iNbtDeserialize(@NotNull CompoundTag tag) {
        return VEAutoSerializable.DefaultImpls.iNbtDeserialize(this, tag);
    }

    @Override
    @NotNull
    public <T> ReflectableItemDelegate<T> get(int pos, @NotNull T t) {
        return VEAutoSerializable.DefaultImpls.get(this, pos, t);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public CompoundTag tSerialize() {
        return VEAutoSerializable.DefaultImpls.tSerialize(this);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    public void tDeserialize(@NotNull CompoundTag tag) {
        VEAutoSerializable.DefaultImpls.tDeserialize(this, tag);
    }

    @Override
    @JsonIgnore
    @NotNull
    public CompoundTag tGetBuffer() {
        return VEAutoSerializable.DefaultImpls.tGetBuffer(this);
    }

    @Override
    @JsonIgnore
    @Nullable
    public ReflectableObject getReflectObjectOverride() {
        return VEAutoSerializable.DefaultImpls.getReflectObjectOverride(this);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return VEAutoSerializable.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return VEAutoSerializable.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    public void setFromVararg(@NotNull Object[] items) {
        VEAutoSerializable.DefaultImpls.setFromVararg(this, items);
    }

    private static final Unit iOnMakeVEntity$lambda$0(DisabledCollisionConstraint this$0, ServerLevel $level) {
        if (!this$0.beingRemoved) {
            this$0.beingRemoved = true;
            ServerLevelExtensionFnsKt.removeVEntity($level, this$0);
        }
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DisabledCollisionConstraint.class, "shipId1", "getShipId1()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DisabledCollisionConstraint.class, "shipId2", "getShipId2()J", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

