/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.shipAttachments;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.spaceeye.valkyrien_ship_schematics.interfaces.ICopyableForcesInducer;
import net.spaceeye.vmod.events.PersistentEvents;
import net.spaceeye.vmod.utils.ServerObjectsHolder;
import net.spaceeye.vmod.vsStuff.CustomBlockMassManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerTickListener;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.core.internal.world.chunks.VsiBlockType;
import org.valkyrienskies.mod.common.BlockStateInfo;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 E2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001EB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u00106\u001a\u00020(H\u0016JD\u00107\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.082\u0006\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<2\u0016\u0010>\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`@\u0012\u0004\u0012\u00020A0?H\u0016JV\u0010B\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.082\u0006\u00109\u001a\u00020:2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020=0?2\"\u0010>\u001a\u001e\u0012\b\u0012\u00060\u0007j\u0002`@\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020A0D0?H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R \u0010-\u001a\u0004\u0018\u00010.8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001e\u00103\u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010!\"\u0004\b5\u0010#\u00a8\u0006F"}, d2={"Lnet/spaceeye/vmod/shipAttachments/WeightSynchronizer;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/ServerTickListener;", "Lnet/spaceeye/valkyrien_ship_schematics/interfaces/ICopyableForcesInducer;", "<init>", "()V", "shipId", "", "getShipId", "()J", "setShipId", "(J)V", "dimensionId", "", "getDimensionId", "()Ljava/lang/String;", "setDimensionId", "(Ljava/lang/String;)V", "lastDimensionId", "getLastDimensionId", "setLastDimensionId", "massPerBlock", "", "getMassPerBlock", "()D", "setMassPerBlock", "(D)V", "targetTotalMass", "getTargetTotalMass", "setTargetTotalMass", "syncMassPerBlock", "", "getSyncMassPerBlock", "()Z", "setSyncMassPerBlock", "(Z)V", "syncWithConnectedStructure", "getSyncWithConnectedStructure", "setSyncWithConnectedStructure", "physTick", "", "physShip", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physLevel", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "level", "Lnet/minecraft/server/level/ServerLevel;", "getLevel", "()Lnet/minecraft/server/level/ServerLevel;", "setLevel", "(Lnet/minecraft/server/level/ServerLevel;)V", "updateWeights", "getUpdateWeights", "setUpdateWeights", "onServerTick", "onCopy", "Ljava/util/function/Supplier;", "shipOn", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "shipsToBeSaved", "", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "centerPositions", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "Lorg/joml/Vector3d;", "onPaste", "loadedShips", "Lkotlin/Pair;", "Companion", "VMod"})
public final class WeightSynchronizer
implements ShipPhysicsListener,
ServerTickListener,
ICopyableForcesInducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long shipId = -1L;
    @NotNull
    private String dimensionId = "";
    @NotNull
    private String lastDimensionId = "";
    private double massPerBlock = 1.0;
    private double targetTotalMass = 1.0;
    private boolean syncMassPerBlock = true;
    private boolean syncWithConnectedStructure;
    @JsonIgnore
    @Nullable
    private ServerLevel level;
    @JsonIgnore
    private boolean updateWeights;

    public final long getShipId() {
        return this.shipId;
    }

    public final void setShipId(long l) {
        this.shipId = l;
    }

    @NotNull
    public final String getDimensionId() {
        return this.dimensionId;
    }

    public final void setDimensionId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dimensionId = string;
    }

    @NotNull
    public final String getLastDimensionId() {
        return this.lastDimensionId;
    }

    public final void setLastDimensionId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lastDimensionId = string;
    }

    public final double getMassPerBlock() {
        return this.massPerBlock;
    }

    public final void setMassPerBlock(double d) {
        this.massPerBlock = d;
    }

    public final double getTargetTotalMass() {
        return this.targetTotalMass;
    }

    public final void setTargetTotalMass(double d) {
        this.targetTotalMass = d;
    }

    public final boolean getSyncMassPerBlock() {
        return this.syncMassPerBlock;
    }

    public final void setSyncMassPerBlock(boolean bl) {
        this.syncMassPerBlock = bl;
    }

    public final boolean getSyncWithConnectedStructure() {
        return this.syncWithConnectedStructure;
    }

    public final void setSyncWithConnectedStructure(boolean bl) {
        this.syncWithConnectedStructure = bl;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
    }

    @Nullable
    public final ServerLevel getLevel() {
        return this.level;
    }

    public final void setLevel(@Nullable ServerLevel serverLevel) {
        this.level = serverLevel;
    }

    public final boolean getUpdateWeights() {
        return this.updateWeights;
    }

    public final void setUpdateWeights(boolean bl) {
        this.updateWeights = bl;
    }

    public void onServerTick() {
        if (!Intrinsics.areEqual((Object)this.lastDimensionId, (Object)this.dimensionId)) {
            this.level = ServerObjectsHolder.INSTANCE.getLevelById(this.dimensionId);
            this.lastDimensionId = this.dimensionId;
        }
        if (!this.updateWeights) {
            return;
        }
        ServerLevel serverLevel = this.level;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level = serverLevel;
        ServerShip serverShip = (ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(this.shipId);
        if (serverShip == null) {
            return;
        }
        ServerShip ship = serverShip;
        if (this.syncWithConnectedStructure) {
            throw new NotImplementedError(null, 1, null);
        }
        Companion.updateMass(level, ship, false, this.syncMassPerBlock, this.massPerBlock, this.targetTotalMass);
    }

    public void onCopy(@NotNull Supplier<ServerLevel> level, @NotNull LoadedServerShip shipOn, @NotNull List<? extends ServerShip> shipsToBeSaved, @NotNull Map<Long, ? extends Vector3d> centerPositions) {
        Intrinsics.checkNotNullParameter(level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shipOn, (String)"shipOn");
        Intrinsics.checkNotNullParameter(shipsToBeSaved, (String)"shipsToBeSaved");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
    }

    public void onPaste(@NotNull Supplier<ServerLevel> level, @NotNull LoadedServerShip shipOn, @NotNull Map<Long, ? extends ServerShip> loadedShips, @NotNull Map<Long, ? extends Pair<? extends Vector3d, ? extends Vector3d>> centerPositions) {
        Intrinsics.checkNotNullParameter(level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shipOn, (String)"shipOn");
        Intrinsics.checkNotNullParameter(loadedShips, (String)"loadedShips");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
        this.shipId = shipOn.getId();
        this.dimensionId = shipOn.getChunkClaimDimension();
        this.updateWeights = true;
    }

    public void onAfterCopy(@NotNull Supplier<ServerLevel> level, @NotNull LoadedServerShip shipOn, @NotNull List<? extends ServerShip> shipsToBeSaved, @NotNull Map<Long, ? extends Vector3d> centerPositions) {
        ICopyableForcesInducer.DefaultImpls.onAfterCopy((ICopyableForcesInducer)this, level, (LoadedServerShip)shipOn, shipsToBeSaved, centerPositions);
    }

    private static final Unit _init_$lambda$0(PersistentEvents.OnBlockStateChange onBlockStateChange, Function0 function0) {
        Intrinsics.checkNotNullParameter((Object)onBlockStateChange, (String)"<destruct>");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"<unused var>");
        ServerLevel level = onBlockStateChange.component1();
        BlockPos pos = onBlockStateChange.component2();
        BlockState newState = onBlockStateChange.component3();
        boolean isMoving = onBlockStateChange.component4();
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level, (Vec3i)((Vec3i)pos));
        if (loadedServerShip == null) {
            return Unit.INSTANCE;
        }
        LoadedServerShip ship = loadedServerShip;
        WeightSynchronizer weightSynchronizer = (WeightSynchronizer)ship.getAttachment(WeightSynchronizer.class);
        if (weightSynchronizer == null) {
            return Unit.INSTANCE;
        }
        WeightSynchronizer atch = weightSynchronizer;
        atch.updateWeights = true;
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void updateMass(@NotNull ServerLevel level, @NotNull ServerShip ship, boolean resetMassToDefault, boolean syncWeightPerBlock, double weightPerBlock, double targetWeight) {
        Companion.updateMass(level, ship, resetMassToDefault, syncWeightPerBlock, weightPerBlock, targetWeight);
    }

    static {
        PersistentEvents.INSTANCE.getOnBlockStateChange().on((Function2<PersistentEvents.OnBlockStateChange, Function0<Unit>, Unit>)((Function2)WeightSynchronizer::_init_$lambda$0));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0012H\u0007\u00a8\u0006\u0013"}, d2={"Lnet/spaceeye/vmod/shipAttachments/WeightSynchronizer$Companion;", "", "<init>", "()V", "updateMass", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "ship", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "resetMassToDefault", "", "syncWeightPerBlock", "weightPerBlock", "", "targetWeight", "getOrCreate", "Lnet/spaceeye/vmod/shipAttachments/WeightSynchronizer;", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "VMod"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void updateMass(@NotNull ServerLevel level, @NotNull ServerShip ship, boolean resetMassToDefault, boolean syncWeightPerBlock, double weightPerBlock, double targetWeight) {
            BlockState state;
            int n;
            int n2;
            int n3;
            int x;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            BlockState blockState = Blocks.f_50016_.m_49966_();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            Pair pair = BlockStateInfo.INSTANCE.get(blockState);
            Intrinsics.checkNotNull((Object)pair);
            VsiBlockType air = (VsiBlockType)pair.component2();
            AABBic aABBic = ship.getShipAABB();
            if (aABBic == null) {
                return;
            }
            AABBic aabb = aABBic;
            boolean wasStatic = ship.isStatic();
            ship.setStatic(true);
            CustomBlockMassManager.INSTANCE.zeroMass(level, ship);
            double minW = Double.MAX_VALUE;
            double maxW = -1.7976931348623157E308;
            double defaultTotalMass = 0.0;
            BlockPos.MutableBlockPos mbpos = new BlockPos.MutableBlockPos(0, 0, 0);
            if (!syncWeightPerBlock && !resetMassToDefault && (x = aabb.minX() - 1) <= (n3 = aabb.maxX() + 1)) {
                while (true) {
                    int z;
                    if ((z = aabb.minZ() - 1) <= (n2 = aabb.maxZ() + 1)) {
                        while (true) {
                            int y;
                            if ((y = aabb.minY() - 1) <= (n = aabb.maxY() + 1)) {
                                while (true) {
                                    mbpos.m_122178_(x, y, z);
                                    state = level.m_8055_((BlockPos)mbpos);
                                    if (!state.m_60795_()) {
                                        Intrinsics.checkNotNull((Object)state);
                                        Pair pair2 = BlockStateInfo.INSTANCE.get(state);
                                        if (pair2 != null) {
                                            double mass = ((Number)pair2.component1()).doubleValue();
                                            minW = Math.min(minW, mass);
                                            maxW = Math.max(maxW, mass);
                                            defaultTotalMass += mass;
                                        }
                                    }
                                    if (y == n) break;
                                    ++y;
                                }
                            }
                            if (z == n2) break;
                            ++z;
                        }
                    }
                    if (x == n3) break;
                    ++x;
                }
            }
            n3 = aabb.maxX();
            for (x = aabb.minX(); x < n3; ++x) {
                n2 = aabb.maxY();
                for (int y = aabb.minY(); y < n2; ++y) {
                    n = aabb.maxZ();
                    for (int z = aabb.minZ(); z < n; ++z) {
                        Pair pair3;
                        mbpos.m_122178_(x, y, z);
                        state = level.m_8055_((BlockPos)mbpos);
                        if (state.m_60795_()) continue;
                        Intrinsics.checkNotNull((Object)state);
                        if (BlockStateInfo.INSTANCE.get(state) == null) continue;
                        double dmass = ((Number)pair3.component1()).doubleValue();
                        VsiBlockType type = (VsiBlockType)pair3.component2();
                        double mass = syncWeightPerBlock && !resetMassToDefault ? weightPerBlock : (resetMassToDefault ? dmass : dmass / defaultTotalMass * targetWeight);
                        CustomBlockMassManager.INSTANCE.setCustomMass(level, x, y, z, 0.0, mass, air, type, ship);
                    }
                }
            }
            ship.setStatic(wasStatic);
        }

        @Deprecated(message="ADDING IT TO SHIP WILL MAKE IT ACTIVATE")
        @NotNull
        public final WeightSynchronizer getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            WeightSynchronizer weightSynchronizer = (WeightSynchronizer)ship.getAttachment(WeightSynchronizer.class);
            if (weightSynchronizer == null) {
                WeightSynchronizer weightSynchronizer2;
                WeightSynchronizer it = weightSynchronizer2 = new WeightSynchronizer();
                boolean bl = false;
                it.setShipId(ship.getId());
                it.setDimensionId(ship.getChunkClaimDimension());
                ship.setAttachment((Object)it);
                weightSynchronizer = weightSynchronizer2;
            }
            return weightSynchronizer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

