/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.shipAttachments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.spaceeye.valkyrien_ship_schematics.interfaces.ICopyableForcesInducer;
import net.spaceeye.vmod.vsStuff.VSGravityManager;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.world.PhysLevel;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u001aJ\b\u0010 \u001a\u00020\u0011H\u0007JD\u0010!\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0016\u0010*\u001a\u0012\u0012\b\u0012\u00060,j\u0002`-\u0012\u0004\u0012\u00020.0+H\u0016JV\u0010/\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020)0+2\"\u0010*\u001a\u001e\u0012\b\u0012\u00060,j\u0002`-\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.010+H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015\u00a8\u00063"}, d2={"Lnet/spaceeye/vmod/shipAttachments/GravityController;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lnet/spaceeye/valkyrien_ship_schematics/interfaces/ICopyableForcesInducer;", "dimensionId", "", "<init>", "(Ljava/lang/String;)V", "getDimensionId", "()Ljava/lang/String;", "setDimensionId", "useDimensionGravity", "", "getUseDimensionGravity", "()Z", "setUseDimensionGravity", "(Z)V", "dimensionGravity", "Lorg/joml/Vector3dc;", "getDimensionGravity", "()Lorg/joml/Vector3dc;", "setDimensionGravity", "(Lorg/joml/Vector3dc;)V", "gravityVector", "getGravityVector", "setGravityVector", "physTick", "", "physShip", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physLevel", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "reset", "effectiveGravity", "onCopy", "level", "Ljava/util/function/Supplier;", "Lnet/minecraft/server/level/ServerLevel;", "shipOn", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "shipsToBeSaved", "", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "centerPositions", "", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "Lorg/joml/Vector3d;", "onPaste", "loadedShips", "Lkotlin/Pair;", "Companion", "VMod"})
public final class GravityController
implements ShipPhysicsListener,
ICopyableForcesInducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String dimensionId;
    private boolean useDimensionGravity;
    @JsonIgnore
    @NotNull
    private Vector3dc dimensionGravity;
    @JsonProperty(required=false)
    @NotNull
    private Vector3dc gravityVector;

    public GravityController(@NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        this.dimensionId = dimensionId;
        this.useDimensionGravity = true;
        Vector3dc vector3dc = VSGravityManager.INSTANCE.getDimensionGravityMutableReference(this.dimensionId);
        if (vector3dc == null) {
            vector3dc = (Vector3dc)new Vector3d(0.0, -10.0, 0.0);
        }
        this.gravityVector = this.dimensionGravity = vector3dc;
    }

    @NotNull
    public final String getDimensionId() {
        return this.dimensionId;
    }

    public final void setDimensionId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dimensionId = string;
    }

    public final boolean getUseDimensionGravity() {
        return this.useDimensionGravity;
    }

    public final void setUseDimensionGravity(boolean bl) {
        this.useDimensionGravity = bl;
    }

    @NotNull
    public final Vector3dc getDimensionGravity() {
        return this.dimensionGravity;
    }

    public final void setDimensionGravity(@NotNull Vector3dc vector3dc) {
        Intrinsics.checkNotNullParameter((Object)vector3dc, (String)"<set-?>");
        this.dimensionGravity = vector3dc;
    }

    @NotNull
    public final Vector3dc getGravityVector() {
        return this.gravityVector;
    }

    public final void setGravityVector(@NotNull Vector3dc vector3dc) {
        Intrinsics.checkNotNullParameter((Object)vector3dc, (String)"<set-?>");
        this.gravityVector = vector3dc;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        Vector3dc gravityVector = this.useDimensionGravity ? this.dimensionGravity : this.gravityVector;
        Vector3d forceDiff = gravityVector.sub(this.dimensionGravity, new Vector3d()).mul(physShip.getMass());
        if (forceDiff.lengthSquared() < (double)1.4E-45f) {
            return;
        }
        Intrinsics.checkNotNull((Object)forceDiff);
        physShip.applyInvariantForce((Vector3dc)forceDiff);
    }

    public final void reset() {
        Vector3dc vector3dc = VSGravityManager.INSTANCE.getDimensionGravityMutableReference(this.dimensionId);
        if (vector3dc == null) {
            vector3dc = (Vector3dc)new Vector3d(0.0, -10.0, 0.0);
        }
        this.gravityVector = vector3dc;
        this.useDimensionGravity = true;
    }

    @JsonIgnore
    @NotNull
    public final Vector3dc effectiveGravity() {
        return this.useDimensionGravity ? this.dimensionGravity : this.gravityVector;
    }

    public void onCopy(@NotNull Supplier<ServerLevel> level, @NotNull LoadedServerShip shipOn, @NotNull List<? extends ServerShip> shipsToBeSaved, @NotNull Map<Long, ? extends Vector3d> centerPositions) {
        Intrinsics.checkNotNullParameter(level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shipOn, (String)"shipOn");
        Intrinsics.checkNotNullParameter(shipsToBeSaved, (String)"shipsToBeSaved");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
    }

    public void onPaste(@NotNull Supplier<ServerLevel> level, @NotNull LoadedServerShip shipOn, @NotNull Map<Long, ? extends ServerShip> loadedShips, @NotNull Map<Long, ? extends Pair<? extends Vector3d, ? extends Vector3d>> centerPositions) {
        Intrinsics.checkNotNullParameter(level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shipOn, (String)"shipOn");
        Intrinsics.checkNotNullParameter(loadedShips, (String)"loadedShips");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
    }

    public void onAfterCopy(@NotNull Supplier<ServerLevel> level, @NotNull LoadedServerShip shipOn, @NotNull List<? extends ServerShip> shipsToBeSaved, @NotNull Map<Long, ? extends Vector3d> centerPositions) {
        ICopyableForcesInducer.DefaultImpls.onAfterCopy((ICopyableForcesInducer)this, level, (LoadedServerShip)shipOn, shipsToBeSaved, centerPositions);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/spaceeye/vmod/shipAttachments/GravityController$Companion;", "", "<init>", "()V", "getOrCreate", "Lnet/spaceeye/vmod/shipAttachments/GravityController;", "ship", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "VMod"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GravityController getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            GravityController gravityController = (GravityController)ship.getAttachment(GravityController.class);
            if (gravityController == null) {
                GravityController gravityController2;
                GravityController it = gravityController2 = new GravityController(ship.getChunkClaimDimension());
                boolean bl = false;
                ship.setAttachment((Object)it);
                gravityController = gravityController2;
            }
            return gravityController;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

