/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering.types.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.spaceeye.valkyrien_ship_schematics.containers.v1.BlockItem;
import net.spaceeye.valkyrien_ship_schematics.containers.v1.ChunkyBlockData;
import net.spaceeye.valkyrien_ship_schematics.interfaces.IShipSchematic;
import net.spaceeye.valkyrien_ship_schematics.interfaces.IShipSchematicInfo;
import net.spaceeye.valkyrien_ship_schematics.interfaces.v1.IShipInfo;
import net.spaceeye.valkyrien_ship_schematics.interfaces.v1.IShipSchematicDataV1;
import net.spaceeye.vmod.VMKt;
import net.spaceeye.vmod.rendering.RenderTypes;
import net.spaceeye.vmod.rendering.types.special.FakeBufferBuilder;
import net.spaceeye.vmod.rendering.types.special.FakeLevel;
import net.spaceeye.vmod.rendering.types.special.SchemMultiBufferSource;
import net.spaceeye.vmod.rendering.types.special.TransparencyWrapperBufferSource;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3d;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lnet/spaceeye/vmod/rendering/types/special/SchematicRenderer;", "", "schem", "Lnet/spaceeye/valkyrien_ship_schematics/interfaces/IShipSchematic;", "transparency", "", "renderBlockEntities", "", "<init>", "(Lnet/spaceeye/valkyrien_ship_schematics/interfaces/IShipSchematic;FZ)V", "getSchem", "()Lnet/spaceeye/valkyrien_ship_schematics/interfaces/IShipSchematic;", "getTransparency", "()F", "getRenderBlockEntities", "()Z", "matrixList", "", "Lorg/joml/Matrix4f;", "getMatrixList", "()Ljava/util/List;", "fakeLevels", "", "Lnet/spaceeye/vmod/rendering/types/special/FakeLevel;", "getFakeLevels", "setFakeLevels", "(Ljava/util/List;)V", "mySources", "Lnet/spaceeye/vmod/rendering/types/special/SchemMultiBufferSource;", "getMySources", "()Lnet/spaceeye/vmod/rendering/types/special/SchemMultiBufferSource;", "render", "", "sources", "Lnet/minecraft/client/renderer/MultiBufferSource;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "VMod"})
@SourceDebugExtension(value={"SMAP\nSchemRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemRenderer.kt\nnet/spaceeye/vmod/rendering/types/special/SchematicRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ChunkyBlockData.kt\nnet/spaceeye/valkyrien_ship_schematics/containers/v1/ChunkyBlockData\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,456:1\n1187#2,2:457\n1261#2,4:459\n1557#2:476\n1628#2,3:477\n1863#2:482\n1872#2,3:483\n1863#2,2:486\n1864#2:488\n126#3:463\n153#3,2:464\n216#3:467\n217#3:472\n155#3:475\n216#3,2:480\n30#4:466\n31#4,2:468\n33#4:471\n34#4,2:473\n1#5:470\n*S KotlinDebug\n*F\n+ 1 SchemRenderer.kt\nnet/spaceeye/vmod/rendering/types/special/SchematicRenderer\n*L\n274#1:457,2\n274#1:459,4\n341#1:476\n341#1:477,3\n355#1:482\n369#1:483,3\n394#1:486,2\n355#1:488\n286#1:463\n286#1:464,2\n306#1:467\n306#1:472\n286#1:475\n347#1:480,2\n306#1:466\n306#1:468,2\n306#1:471\n306#1:473,2\n*E\n"})
public final class SchematicRenderer {
    @NotNull
    private final IShipSchematic schem;
    private final float transparency;
    private final boolean renderBlockEntities;
    @NotNull
    private final List<Matrix4f> matrixList;
    @NotNull
    private List<FakeLevel> fakeLevels;
    @NotNull
    private final SchemMultiBufferSource mySources;

    /*
     * WARNING - void declaration
     */
    public SchematicRenderer(@NotNull IShipSchematic schem, float transparency, boolean renderBlockEntities) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map map2;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)schem, (String)"schem");
        this.schem = schem;
        this.transparency = transparency;
        this.renderBlockEntities = renderBlockEntities;
        this.fakeLevels = new ArrayList();
        this.mySources = new SchemMultiBufferSource();
        IShipSchematicInfo iShipSchematicInfo = this.schem.getInfo();
        Intrinsics.checkNotNull((Object)iShipSchematicInfo);
        Iterable $this$associate$iv = iShipSchematicInfo.getShipsInfo();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map2 = destination$iv$iv;
            IShipInfo it = (IShipInfo)element$iv$iv;
            boolean bl = false;
            it = new Pair((Object)it.getId(), (Object)it);
            map2.put(it.getFirst(), it.getSecond());
        }
        Map info = destination$iv$iv;
        IShipSchematic iShipSchematic = this.schem;
        Intrinsics.checkNotNull((Object)iShipSchematic, (String)"null cannot be cast to non-null type net.spaceeye.valkyrien_ship_schematics.interfaces.v1.IShipSchematicDataV1");
        IShipSchematicDataV1 schem2 = (IShipSchematicDataV1)iShipSchematic;
        this.mySources.setTransparency(this.transparency);
        RandomSource random = RandomSource.m_216327_();
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        Intrinsics.checkNotNull((Object)clientLevel);
        ClientLevel level = clientLevel;
        PoseStack poseStack = new PoseStack();
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        int matrixIndex = 0;
        Map map3 = schem2.getBlockData();
        SchematicRenderer schematicRenderer = this;
        boolean $i$f$map = false;
        map2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Matrix4f matrix4f;
            float f;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            long shipId = ((Number)entry2.getKey()).longValue();
            ChunkyBlockData data = (ChunkyBlockData)entry2.getValue();
            Object v = info.get(shipId);
            Intrinsics.checkNotNull(v);
            IShipInfo infoItem = (IShipInfo)v;
            Quaternionf rotationQuat = infoItem.getRotation().get(new Quaternionf());
            FakeLevel flevel = new FakeLevel(level, (ChunkyBlockData<BlockItem>)data, schem2.getFlatTagData(), schem2.getBlockPalette(), infoItem);
            this.fakeLevels.add(flevel);
            poseStack.m_85836_();
            poseStack.m_85837_(infoItem.getRelPositionToCenter().x, infoItem.getRelPositionToCenter().y, infoItem.getRelPositionToCenter().z);
            poseStack.m_252781_(rotationQuat);
            float it = f = (float)infoItem.getShipScale();
            boolean bl2 = false;
            poseStack.m_85841_(it, it, it);
            ChunkyBlockData this_$iv = data;
            boolean $i$f$forEach = false;
            Map $this$forEach$iv$iv = this_$iv.getBlocks();
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map chunk$iv;
                Map.Entry element$iv$iv;
                Map.Entry entry3 = element$iv$iv = iterator2.next();
                boolean bl3 = false;
                BlockPos cpos$iv = (BlockPos)entry3.getKey();
                Map $this$forEach$iv$iv2 = chunk$iv = (Map)entry3.getValue();
                boolean $i$f$forEach3 = false;
                Iterator iterator3 = $this$forEach$iv$iv2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    RenderType renderType;
                    BlockState state;
                    void z;
                    void y;
                    Map.Entry element$iv$iv2;
                    Map.Entry entry4 = element$iv$iv2 = iterator3.next();
                    boolean bl4 = false;
                    BlockPos pos$iv = (BlockPos)entry4.getKey();
                    Object item$iv = entry4.getValue();
                    BlockItem blockItem = (BlockItem)item$iv;
                    int n = pos$iv.m_123343_() + (cpos$iv.m_123343_() << 4);
                    int n2 = pos$iv.m_123342_();
                    int x = pos$iv.m_123341_() + (cpos$iv.m_123341_() << 4);
                    boolean bl5 = false;
                    BlockPos bpos = new BlockPos(x, (int)y, (int)z);
                    if (flevel.m_8055_(bpos) == null) continue;
                    boolean bl6 = state.m_60819_().m_76178_();
                    if (bl6) {
                        renderType = RenderTypes.INSTANCE.getSchematicBlock().getType();
                    } else if (!bl6) {
                        renderType = ItemBlockRenderTypes.m_109287_((FluidState)state.m_60819_());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    RenderType type = renderType;
                    Vector3d it2 = infoItem.getPreviousCenterPosition();
                    boolean bl7 = false;
                    Vector3d offset2 = it2.sub((double)MathKt.roundToInt((double)it2.x), (double)MathKt.roundToInt((double)it2.y), (double)MathKt.roundToInt((double)it2.z), new Vector3d());
                    Intrinsics.checkNotNull((Object)type);
                    FakeBufferBuilder buffer = this.mySources.getBuffer(type);
                    buffer.setVertexMatrixIndex(matrixIndex);
                    buffer.getVertexOffset().set((double)bpos.m_123341_() + offset2.x, (double)bpos.m_123342_() + offset2.y, (double)bpos.m_123343_() + offset2.z);
                    if (state.m_60819_().m_76178_()) {
                        blockRenderer.m_234355_(state, bpos, (BlockAndTintGetter)flevel, new PoseStack(), (VertexConsumer)buffer, true, random);
                        continue;
                    }
                    flevel.getOffset().set(bpos.m_123341_(), bpos.m_123342_(), bpos.m_123343_());
                    blockRenderer.m_234363_(new BlockPos(0, 0, 0), (BlockAndTintGetter)flevel, (VertexConsumer)buffer, state, state.m_60819_());
                    flevel.getOffset().set(0, 0, 0);
                }
            }
            ++matrixIndex;
            Matrix4f it2 = matrix4f = poseStack.m_85850_().m_252922_().get(new Matrix4f());
            boolean bl8 = false;
            poseStack.m_85849_();
            collection.add(matrix4f);
        }
        schematicRenderer.matrixList = (List)destination$iv$iv2;
    }

    public /* synthetic */ SchematicRenderer(IShipSchematic iShipSchematic, float f, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(iShipSchematic, f, bl);
    }

    @NotNull
    public final IShipSchematic getSchem() {
        return this.schem;
    }

    public final float getTransparency() {
        return this.transparency;
    }

    public final boolean getRenderBlockEntities() {
        return this.renderBlockEntities;
    }

    @NotNull
    public final List<Matrix4f> getMatrixList() {
        return this.matrixList;
    }

    @NotNull
    public final List<FakeLevel> getFakeLevels() {
        return this.fakeLevels;
    }

    public final void setFakeLevels(@NotNull List<FakeLevel> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.fakeLevels = list;
    }

    @NotNull
    public final SchemMultiBufferSource getMySources() {
        return this.mySources;
    }

    /*
     * WARNING - void declaration
     */
    public final void render(@NotNull MultiBufferSource sources, @NotNull PoseStack poseStack) {
        Iterator<Map.Entry<RenderType, FakeBufferBuilder>> $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Iterable $this$map$iv = this.matrixList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Matrix4f matrix4f;
            void it;
            Object item$iv$iv = iterator.next();
            Matrix4f matrix4f2 = (Matrix4f)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            poseStack.m_85836_();
            poseStack.m_252931_((Matrix4f)it);
            Matrix4f it2 = matrix4f = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            boolean bl2 = false;
            poseStack.m_85849_();
            collection.add(matrix4f);
        }
        List matrices = (List)destination$iv$iv;
        Map<RenderType, FakeBufferBuilder> $this$forEach$iv = this.mySources.getBuffers();
        boolean $i$f$forEach = false;
        $this$mapTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            Map.Entry<RenderType, FakeBufferBuilder> element$iv;
            Map.Entry<RenderType, FakeBufferBuilder> entry2 = element$iv = $this$mapTo$iv$iv.next();
            boolean bl = false;
            RenderType type = entry2.getKey();
            FakeBufferBuilder buf = entry2.getValue();
            VertexConsumer actualBuffer = sources.m_6299_(type);
            Intrinsics.checkNotNull((Object)actualBuffer);
            buf.apply(actualBuffer, matrices);
        }
        if (!this.renderBlockEntities) {
            return;
        }
        BlockEntityRenderDispatcher renderer = Minecraft.m_91087_().m_167982_();
        TransparencyWrapperBufferSource sources2 = new TransparencyWrapperBufferSource(sources, this.transparency);
        Iterable $this$forEach$iv2 = this.fakeLevels;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            float f;
            FakeLevel level = (FakeLevel)((Object)element$iv);
            boolean bl = false;
            IShipInfo infoItem = level.getInfoItem();
            poseStack.m_85836_();
            poseStack.m_85837_(infoItem.getRelPositionToCenter().x, infoItem.getRelPositionToCenter().y, infoItem.getRelPositionToCenter().z);
            poseStack.m_252781_(infoItem.getRotation().get(new Quaternionf()));
            float it = f = (float)infoItem.getShipScale();
            boolean bl3 = false;
            poseStack.m_85841_(it, it, it);
            List toRemove = new ArrayList();
            Iterable $this$forEachIndexed$iv = level.getBlockEntities();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                Unit it3;
                Unit unit;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int i2 = n;
                boolean bl4 = false;
                BlockPos pos = (BlockPos)pair.component1();
                BlockEntity be = (BlockEntity)pair.component2();
                if (renderer.m_112265_(be) == null) {
                    it3 = unit = Unit.INSTANCE;
                    boolean bl5 = false;
                    toRemove.add(i2);
                    continue;
                }
                if (!be.m_58903_().m_155262_(be.m_58900_())) {
                    Unit unit2;
                    Unit it4 = unit2 = Unit.INSTANCE;
                    boolean bl6 = false;
                    toRemove.add(i2);
                    continue;
                }
                poseStack.m_85836_();
                it3 = infoItem.getPreviousCenterPosition();
                boolean bl7 = false;
                Vector3d offset2 = it3.sub((double)MathKt.roundToInt((double)it3.x), (double)MathKt.roundToInt((double)it3.y), (double)MathKt.roundToInt((double)it3.z), new Vector3d());
                poseStack.m_85837_((double)pos.m_123341_() + offset2.x, (double)pos.m_123342_() + offset2.y, (double)pos.m_123343_() + offset2.z);
                try {
                    BlockEntityRenderer beRenderer;
                    it3 = unit = new PoseStack();
                    boolean bl8 = false;
                    it3.m_166856_();
                    it3.m_252931_(poseStack.m_85850_().m_252922_());
                    beRenderer.m_6922_(be, 0.0f, (PoseStack)it3, (MultiBufferSource)sources2, 0xF000F0, OverlayTexture.f_118083_);
                }
                catch (Exception e) {
                    VMKt.WLOG("Failed to render block entity\n" + ExceptionsKt.stackTraceToString((Throwable)e));
                    toRemove.add(i2);
                }
                catch (Error e) {
                    VMKt.WLOG("Failed to render block entity\n" + ExceptionsKt.stackTraceToString((Throwable)e));
                    toRemove.add(i2);
                }
                poseStack.m_85849_();
            }
            Iterable $this$forEach$iv3 = CollectionsKt.reversed((Iterable)toRemove);
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                int it5 = ((Number)element$iv2).intValue();
                boolean bl9 = false;
                level.getBlockEntities().remove(it5);
            }
            poseStack.m_85849_();
        }
    }
}

