/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering.textures;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.spaceeye.vmod.VMKt;
import net.spaceeye.vmod.gif.GIFImageMetadata;
import net.spaceeye.vmod.gif.GIFImageReader;
import net.spaceeye.vmod.gif.GIFImageReaderSpi;
import net.spaceeye.vmod.gif.GIFStreamMetadata;
import net.spaceeye.vmod.mixin.NativeImageInvoker;
import net.spaceeye.vmod.rendering.textures.WrappedByteArrayInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001a\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\u0006\u0010\u0018\u001a\u00020\u0019R\u001b\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lnet/spaceeye/vmod/rendering/textures/GIFReader;", "", "<init>", "()V", "reader", "Ljavax/imageio/ImageReader;", "kotlin.jvm.PlatformType", "getReader", "()Ljavax/imageio/ImageReader;", "Ljavax/imageio/ImageReader;", "readGIF", "", "Lnet/spaceeye/vmod/rendering/textures/GIFReader$ImageFrame;", "stream", "Ljava/io/InputStream;", "abgr2rgba", "", "it", "fastReader", "Lnet/spaceeye/vmod/gif/GIFImageReader;", "getFastReader", "()Lnet/spaceeye/vmod/gif/GIFImageReader;", "readGifToTexturesFaster", "Lnet/spaceeye/vmod/rendering/textures/GIFReader$NativeTextureWithData;", "bytes", "", "ImageFrame", "NativeTextureWithData", "NativeTextureBuilder", "VMod"})
public final class GIFReader {
    @NotNull
    public static final GIFReader INSTANCE = new GIFReader();
    private static final ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
    @NotNull
    private static final GIFImageReader fastReader = new GIFImageReader(new GIFImageReaderSpi());

    private GIFReader() {
    }

    public final ImageReader getReader() {
        return reader;
    }

    @JvmStatic
    @NotNull
    public static final List<ImageFrame> readGIF(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        reader.setInput(ImageIO.createImageInputStream(stream));
        List frames = new ArrayList();
        int width = -1;
        int height = -1;
        IIOMetadata metadata = reader.getStreamMetadata();
        if (metadata != null) {
            IIOMetadataNode screenDescriptor;
            Node node2 = metadata.getAsTree(metadata.getNativeMetadataFormatName());
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type javax.imageio.metadata.IIOMetadataNode");
            IIOMetadataNode globalRoot = (IIOMetadataNode)node2;
            NodeList globalScreenDescriptor = globalRoot.getElementsByTagName("LogicalScreenDescriptor");
            if (globalScreenDescriptor != null && globalScreenDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreenDescriptor.item(0)) != null) {
                String string = screenDescriptor.getAttribute("logicalScreenWidth");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
                width = Integer.parseInt(string);
                String string2 = screenDescriptor.getAttribute("logicalScreenHeight");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttribute(...)");
                height = Integer.parseInt(string2);
            }
        }
        BufferedImage master = null;
        Graphics2D masterGraphics = null;
        int frameIndex = 0;
        while (true) {
            BufferedImage bufferedImage;
            try {
                bufferedImage = reader.read(frameIndex);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            BufferedImage image = bufferedImage;
            if (width == -1 || height == -1) {
                width = image.getWidth();
                height = image.getHeight();
            }
            Node node3 = reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
            Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type javax.imageio.metadata.IIOMetadataNode");
            IIOMetadataNode root = (IIOMetadataNode)node3;
            Node node4 = root.getElementsByTagName("GraphicControlExtension").item(0);
            Intrinsics.checkNotNull((Object)node4, (String)"null cannot be cast to non-null type javax.imageio.metadata.IIOMetadataNode");
            IIOMetadataNode gce = (IIOMetadataNode)node4;
            String string = gce.getAttribute("delayTime");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
            int delay2 = Integer.parseInt(string);
            String disposal = gce.getAttribute("disposalMethod");
            int x = 0;
            int y = 0;
            if (master == null) {
                master = new BufferedImage(width, height, 2);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else {
                NodeList children = root.getChildNodes();
                int n = children.getLength();
                for (int nodeIndex = 0; nodeIndex < n; ++nodeIndex) {
                    Node nodeItem = children.item(nodeIndex);
                    if (!Intrinsics.areEqual((Object)nodeItem.getNodeName(), (Object)"ImageDescriptor")) continue;
                    NamedNodeMap map2 = nodeItem.getAttributes();
                    String string3 = map2.getNamedItem("imageLeftPosition").getNodeValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNodeValue(...)");
                    x = Integer.parseInt(string3);
                    String string4 = map2.getNamedItem("imageTopPosition").getNodeValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getNodeValue(...)");
                    y = Integer.parseInt(string4);
                }
            }
            Graphics2D graphics2D = masterGraphics;
            Intrinsics.checkNotNull((Object)graphics2D);
            graphics2D.drawImage((Image)image, x, y, null);
            BufferedImage copy = new BufferedImage(master.getColorModel(), master.copyData(null), master.isAlphaPremultiplied(), null);
            Intrinsics.checkNotNull((Object)disposal);
            frames.add(new ImageFrame(copy, delay2, disposal));
            if (Intrinsics.areEqual((Object)disposal, (Object)"restoreToPrevious")) {
                BufferedImage from = null;
                for (int i2 = frameIndex - 1; -1 < i2; --i2) {
                    if (Intrinsics.areEqual((Object)((ImageFrame)frames.get(i2)).getDisposal(), (Object)"restoreToPrevious") && frameIndex != 0) continue;
                    from = ((ImageFrame)frames.get(i2)).getImage();
                    break;
                }
                BufferedImage bufferedImage2 = from;
                Intrinsics.checkNotNull(bufferedImage2);
                master = new BufferedImage(bufferedImage2.getColorModel(), from.copyData(null), from.isAlphaPremultiplied(), null);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else if (Intrinsics.areEqual((Object)disposal, (Object)"restoreToBackgroundColor")) {
                masterGraphics.clearRect(x, y, image.getWidth(), image.getHeight());
            }
            ++frameIndex;
        }
        reader.dispose();
        return frames;
    }

    @JvmStatic
    public static final int abgr2rgba(int it) {
        return it & 0xFF000000 | (it & 0xFF0000) >>> 16 | it & 0xFF00 | (it & 0xFF) << 16;
    }

    @NotNull
    public final GIFImageReader getFastReader() {
        return fastReader;
    }

    @NotNull
    public final List<NativeTextureWithData> readGifToTexturesFaster(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        WrappedByteArrayInputStream stream = new WrappedByteArrayInputStream(bytes);
        fastReader.reset();
        fastReader.setInput(stream);
        fastReader.getStreamMetadata();
        long imgStartPos = stream.getStreamPosition();
        int numFrames = fastReader.getNumImages(true);
        fastReader.resetStreamSettingsWithoutMetadata();
        stream.seek(imgStartPos);
        GIFStreamMetadata gIFStreamMetadata = fastReader.getStreamMetadata();
        Intrinsics.checkNotNull((Object)gIFStreamMetadata);
        GIFStreamMetadata metadata = gIFStreamMetadata;
        int width = metadata.logicalScreenWidth;
        int height = metadata.logicalScreenHeight;
        if (width == -1 || height == -1) {
            throw new RuntimeException("Cannot read texture as width or height are not defined in stream metadata");
        }
        NativeTextureBuilder textureBuilder = new NativeTextureBuilder(width, height, width, height * VMKt.getGLMaxArrayTextureLayers());
        List textures = new ArrayList();
        int framesPerTexture = textureBuilder.calculateDimensions(numFrames).component5();
        List disposals = new ArrayList();
        BufferedImage master = null;
        Graphics2D masterGraphics = null;
        int frameIndex = 0;
        int remainingFrames = 0;
        remainingFrames = numFrames;
        while (frameIndex != numFrames) {
            NativeTextureWithData nativeTextureWithData = (NativeTextureWithData)CollectionsKt.getOrNull((List)textures, (int)(frameIndex / framesPerTexture));
            if (nativeTextureWithData == null) {
                GIFReader $this$readGifToTexturesFaster_u24lambda_u240 = this;
                boolean bl = false;
                NativeTextureWithData texture = textureBuilder.makeEmpty(remainingFrames);
                textures.add(texture);
                remainingFrames -= texture.getNumFrames();
                nativeTextureWithData = texture;
            }
            NativeTextureWithData texture = nativeTextureWithData;
            int inTexturePos = frameIndex % framesPerTexture;
            int inFrameStart = inTexturePos * width * height;
            NativeTextureWithData prevTexture = (NativeTextureWithData)textures.get(Math.max(frameIndex - 1, 0) / framesPerTexture);
            int prevInTexturePos = (frameIndex - 1) % framesPerTexture;
            int prevInFrameStart = prevInTexturePos * width * height;
            BufferedImage image = fastReader.readNext(width, height, inFrameStart * 4, texture.getBuffer(), prevInFrameStart * 4, prevTexture.getBuffer());
            GIFImageMetadata metadata2 = fastReader.getImageMetadata(frameIndex);
            int delay2 = metadata2.delayTime;
            String disposal = metadata2.getDisposalMethodString();
            texture.getDelays()[inTexturePos] = delay2;
            if (image == null) {
                Intrinsics.checkNotNull((Object)disposal);
                disposals.add(disposal);
                ++frameIndex;
                continue;
            }
            int x = 0;
            int y = 0;
            if (master == null) {
                master = new BufferedImage(width, height, 2);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else {
                x = metadata2.imageLeftPosition;
                y = metadata2.imageTopPosition;
            }
            if (frameIndex != 0) {
                int inTexturePos2 = (frameIndex - 1) % framesPerTexture;
                int inFrameStart2 = inTexturePos2 * width * height;
                ByteBuffer src = ((NativeTextureWithData)textures.get((frameIndex - 1) / framesPerTexture)).getBuffer();
                int[] nArray = new int[]{0, 0, 0, 0};
                int[] pixel = nArray;
                int rgba = 0;
                int n = width * height;
                for (int i2 = 0; i2 < n; ++i2) {
                    rgba = src.getInt((inFrameStart2 + i2) * 4);
                    pixel[0] = rgba & 0xFF;
                    pixel[1] = (rgba & 0xFF00) >>> 8;
                    pixel[2] = (rgba & 0xFF0000) >>> 16;
                    pixel[3] = (rgba & 0xFF000000) >>> 24;
                    master.getRaster().setPixel(i2 % width, i2 / width, pixel);
                }
            }
            Graphics2D graphics2D = masterGraphics;
            Intrinsics.checkNotNull((Object)graphics2D);
            graphics2D.drawImage((Image)image, x, y, null);
            DataBuffer src = master.getData().getDataBuffer();
            ByteBuffer dst = texture.getBuffer();
            int pixel = width * height;
            for (int i3 = 0; i3 < pixel; ++i3) {
                dst.putInt((inFrameStart + i3) * 4, GIFReader.abgr2rgba(src.getElem(i3)));
            }
            if (Intrinsics.areEqual((Object)disposal, (Object)"restoreToPrevious")) {
                int from = -1;
                for (int i4 = frameIndex - 1; -1 < i4; --i4) {
                    if (Intrinsics.areEqual(disposals.get(i4), (Object)"restoreToPrevious") && frameIndex != 0) continue;
                    from = i4;
                    break;
                }
                int inTexturePos3 = from % framesPerTexture;
                int inFrameStart3 = inTexturePos3 * width * height;
                ByteBuffer src2 = ((NativeTextureWithData)textures.get(from / framesPerTexture)).getBuffer();
                int[] nArray = new int[]{0, 0, 0, 0};
                int[] pixel2 = nArray;
                int rgba = 0;
                int n = width * height;
                for (int i5 = 0; i5 < n; ++i5) {
                    rgba = src2.getInt((inFrameStart3 + i5) * 4);
                    pixel2[0] = rgba & 0xFF;
                    pixel2[1] = (rgba & 0xFF00) >>> 8;
                    pixel2[2] = (rgba & 0xFF0000) >>> 16;
                    pixel2[3] = (rgba & 0xFF000000) >>> 24;
                    master.getRaster().setPixel(i5 % width, i5 / width, pixel2);
                }
            } else if (Intrinsics.areEqual((Object)disposal, (Object)"restoreToBackgroundColor")) {
                masterGraphics.clearRect(x, y, image.getWidth(), image.getHeight());
            }
            Intrinsics.checkNotNull((Object)disposal);
            disposals.add(disposal);
            ++frameIndex;
        }
        return textures;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lnet/spaceeye/vmod/rendering/textures/GIFReader$ImageFrame;", "", "image", "Ljava/awt/image/BufferedImage;", "delay", "", "disposal", "", "<init>", "(Ljava/awt/image/BufferedImage;ILjava/lang/String;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "getDelay", "()I", "getDisposal", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "VMod"})
    public static final class ImageFrame {
        @NotNull
        private final BufferedImage image;
        private final int delay;
        @NotNull
        private final String disposal;

        public ImageFrame(@NotNull BufferedImage image, int delay2, @NotNull String disposal) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)disposal, (String)"disposal");
            this.image = image;
            this.delay = delay2;
            this.disposal = disposal;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        public final int getDelay() {
            return this.delay;
        }

        @NotNull
        public final String getDisposal() {
            return this.disposal;
        }

        @NotNull
        public final BufferedImage component1() {
            return this.image;
        }

        public final int component2() {
            return this.delay;
        }

        @NotNull
        public final String component3() {
            return this.disposal;
        }

        @NotNull
        public final ImageFrame copy(@NotNull BufferedImage image, int delay2, @NotNull String disposal) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)disposal, (String)"disposal");
            return new ImageFrame(image, delay2, disposal);
        }

        public static /* synthetic */ ImageFrame copy$default(ImageFrame imageFrame, BufferedImage bufferedImage, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bufferedImage = imageFrame.image;
            }
            if ((n2 & 2) != 0) {
                n = imageFrame.delay;
            }
            if ((n2 & 4) != 0) {
                string = imageFrame.disposal;
            }
            return imageFrame.copy(bufferedImage, n, string);
        }

        @NotNull
        public String toString() {
            return "ImageFrame(image=" + this.image + ", delay=" + this.delay + ", disposal=" + this.disposal + ")";
        }

        public int hashCode() {
            int result = this.image.hashCode();
            result = result * 31 + Integer.hashCode(this.delay);
            result = result * 31 + this.disposal.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ImageFrame)) {
                return false;
            }
            ImageFrame imageFrame = (ImageFrame)other;
            if (!Intrinsics.areEqual((Object)this.image, (Object)imageFrame.image)) {
                return false;
            }
            if (this.delay != imageFrame.delay) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.disposal, (Object)imageFrame.disposal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lnet/spaceeye/vmod/rendering/textures/GIFReader$NativeTextureBuilder;", "", "frameWidth", "", "frameHeight", "maxWidth", "maxHeight", "<init>", "(IIII)V", "getFrameWidth", "()I", "getFrameHeight", "getMaxWidth", "setMaxWidth", "(I)V", "getMaxHeight", "setMaxHeight", "calculateDimensions", "Lnet/spaceeye/vmod/rendering/textures/GIFReader$NativeTextureBuilder$Data;", "requiredFrames", "makeEmpty", "Lnet/spaceeye/vmod/rendering/textures/GIFReader$NativeTextureWithData;", "Data", "VMod"})
    public static final class NativeTextureBuilder {
        private final int frameWidth;
        private final int frameHeight;
        private int maxWidth;
        private int maxHeight;

        public NativeTextureBuilder(int frameWidth, int frameHeight, int maxWidth, int maxHeight) {
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
        }

        public final int getFrameWidth() {
            return this.frameWidth;
        }

        public final int getFrameHeight() {
            return this.frameHeight;
        }

        public final int getMaxWidth() {
            return this.maxWidth;
        }

        public final void setMaxWidth(int n) {
            this.maxWidth = n;
        }

        public final int getMaxHeight() {
            return this.maxHeight;
        }

        public final void setMaxHeight(int n) {
            this.maxHeight = n;
        }

        @NotNull
        public final Data calculateDimensions(int requiredFrames) {
            int n;
            int widthTiles;
            int maxWidthTiles = this.maxWidth / this.frameWidth;
            int maxHeightTiles = this.maxHeight / this.frameHeight;
            int remainderTiles = 0;
            int n2 = widthTiles = maxWidthTiles >= requiredFrames ? requiredFrames : maxWidthTiles;
            if (maxWidthTiles >= requiredFrames) {
                n = 1;
            } else if (maxWidthTiles * maxHeightTiles >= requiredFrames) {
                remainderTiles = requiredFrames % maxWidthTiles;
                n = requiredFrames / maxWidthTiles + (remainderTiles == 0 ? 0 : 1);
            } else {
                n = maxHeightTiles;
            }
            int heightTiles = n;
            int spriteWidth = widthTiles * this.frameWidth;
            int spriteHeight = heightTiles * this.frameHeight;
            int numFrames = remainderTiles == 0 ? widthTiles * heightTiles : widthTiles * (heightTiles - 1) + remainderTiles;
            return new Data(spriteWidth, spriteHeight, widthTiles, heightTiles, numFrames);
        }

        @NotNull
        public final NativeTextureWithData makeEmpty(int requiredFrames) {
            Data data = this.calculateDimensions(requiredFrames);
            int spriteWidth = data.component1();
            int spriteHeight = data.component2();
            int widthTiles = data.component3();
            int heightTiles = data.component4();
            int numFrames = data.component5();
            int size = spriteWidth * spriteHeight * 4;
            long ptr = MemoryUtil.nmemAlloc((long)size);
            ByteBuffer buf = MemoryUtil.memByteBuffer((long)ptr, (int)size);
            NativeImage img = NativeImageInvoker.theConstructor(NativeImage.Format.RGBA, spriteWidth, spriteHeight, false, ptr);
            Intrinsics.checkNotNull((Object)img);
            Intrinsics.checkNotNull((Object)buf);
            return new NativeTextureWithData(img, buf, ptr, new int[requiredFrames], this.frameWidth, this.frameHeight, spriteWidth, spriteHeight, widthTiles, heightTiles, numFrames);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lnet/spaceeye/vmod/rendering/textures/GIFReader$NativeTextureBuilder$Data;", "", "spriteWidth", "", "spriteHeight", "widthTiles", "heightTiles", "numFrames", "<init>", "(IIIII)V", "getSpriteWidth", "()I", "getSpriteHeight", "getWidthTiles", "getHeightTiles", "getNumFrames", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "VMod"})
        public static final class Data {
            private final int spriteWidth;
            private final int spriteHeight;
            private final int widthTiles;
            private final int heightTiles;
            private final int numFrames;

            public Data(int spriteWidth, int spriteHeight, int widthTiles, int heightTiles, int numFrames) {
                this.spriteWidth = spriteWidth;
                this.spriteHeight = spriteHeight;
                this.widthTiles = widthTiles;
                this.heightTiles = heightTiles;
                this.numFrames = numFrames;
            }

            public final int getSpriteWidth() {
                return this.spriteWidth;
            }

            public final int getSpriteHeight() {
                return this.spriteHeight;
            }

            public final int getWidthTiles() {
                return this.widthTiles;
            }

            public final int getHeightTiles() {
                return this.heightTiles;
            }

            public final int getNumFrames() {
                return this.numFrames;
            }

            public final int component1() {
                return this.spriteWidth;
            }

            public final int component2() {
                return this.spriteHeight;
            }

            public final int component3() {
                return this.widthTiles;
            }

            public final int component4() {
                return this.heightTiles;
            }

            public final int component5() {
                return this.numFrames;
            }

            @NotNull
            public final Data copy(int spriteWidth, int spriteHeight, int widthTiles, int heightTiles, int numFrames) {
                return new Data(spriteWidth, spriteHeight, widthTiles, heightTiles, numFrames);
            }

            public static /* synthetic */ Data copy$default(Data data, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
                if ((n6 & 1) != 0) {
                    n = data.spriteWidth;
                }
                if ((n6 & 2) != 0) {
                    n2 = data.spriteHeight;
                }
                if ((n6 & 4) != 0) {
                    n3 = data.widthTiles;
                }
                if ((n6 & 8) != 0) {
                    n4 = data.heightTiles;
                }
                if ((n6 & 0x10) != 0) {
                    n5 = data.numFrames;
                }
                return data.copy(n, n2, n3, n4, n5);
            }

            @NotNull
            public String toString() {
                return "Data(spriteWidth=" + this.spriteWidth + ", spriteHeight=" + this.spriteHeight + ", widthTiles=" + this.widthTiles + ", heightTiles=" + this.heightTiles + ", numFrames=" + this.numFrames + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.spriteWidth);
                result = result * 31 + Integer.hashCode(this.spriteHeight);
                result = result * 31 + Integer.hashCode(this.widthTiles);
                result = result * 31 + Integer.hashCode(this.heightTiles);
                result = result * 31 + Integer.hashCode(this.numFrames);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Data)) {
                    return false;
                }
                Data data = (Data)other;
                if (this.spriteWidth != data.spriteWidth) {
                    return false;
                }
                if (this.spriteHeight != data.spriteHeight) {
                    return false;
                }
                if (this.widthTiles != data.widthTiles) {
                    return false;
                }
                if (this.heightTiles != data.heightTiles) {
                    return false;
                }
                return this.numFrames == data.numFrames;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b5\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0005H\u00c6\u0003J\t\u00106\u001a\u00020\u0007H\u00c6\u0003J\t\u00107\u001a\u00020\tH\u00c6\u0003J\t\u00108\u001a\u00020\u000bH\u00c6\u0003J\t\u00109\u001a\u00020\u000bH\u00c6\u0003J\t\u0010:\u001a\u00020\u000bH\u00c6\u0003J\t\u0010;\u001a\u00020\u000bH\u00c6\u0003J\t\u0010<\u001a\u00020\u000bH\u00c6\u0003J\t\u0010=\u001a\u00020\u000bH\u00c6\u0003J\t\u0010>\u001a\u00020\u000bH\u00c6\u0003Jw\u0010?\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010C\u001a\u00020\u000bH\u00d6\u0001J\t\u0010D\u001a\u00020EH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010%\"\u0004\b)\u0010'R\u001a\u0010\r\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010%\"\u0004\b+\u0010'R\u001a\u0010\u000e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010%\"\u0004\b-\u0010'R\u001a\u0010\u000f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010%\"\u0004\b/\u0010'R\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010%\"\u0004\b1\u0010'R\u001a\u0010\u0011\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010%\"\u0004\b3\u0010'\u00a8\u0006F"}, d2={"Lnet/spaceeye/vmod/rendering/textures/GIFReader$NativeTextureWithData;", "", "image", "Lcom/mojang/blaze3d/platform/NativeImage;", "buffer", "Ljava/nio/ByteBuffer;", "ptr", "", "delays", "", "frameWidth", "", "frameHeight", "spriteWidth", "spriteHeight", "widthTiles", "heightTiles", "numFrames", "<init>", "(Lcom/mojang/blaze3d/platform/NativeImage;Ljava/nio/ByteBuffer;J[IIIIIIII)V", "getImage", "()Lcom/mojang/blaze3d/platform/NativeImage;", "setImage", "(Lcom/mojang/blaze3d/platform/NativeImage;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "setBuffer", "(Ljava/nio/ByteBuffer;)V", "getPtr", "()J", "setPtr", "(J)V", "getDelays", "()[I", "setDelays", "([I)V", "getFrameWidth", "()I", "setFrameWidth", "(I)V", "getFrameHeight", "setFrameHeight", "getSpriteWidth", "setSpriteWidth", "getSpriteHeight", "setSpriteHeight", "getWidthTiles", "setWidthTiles", "getHeightTiles", "setHeightTiles", "getNumFrames", "setNumFrames", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "", "other", "hashCode", "toString", "", "VMod"})
    public static final class NativeTextureWithData {
        @NotNull
        private NativeImage image;
        @NotNull
        private ByteBuffer buffer;
        private long ptr;
        @NotNull
        private int[] delays;
        private int frameWidth;
        private int frameHeight;
        private int spriteWidth;
        private int spriteHeight;
        private int widthTiles;
        private int heightTiles;
        private int numFrames;

        public NativeTextureWithData(@NotNull NativeImage image, @NotNull ByteBuffer buffer, long ptr, @NotNull int[] delays, int frameWidth, int frameHeight, int spriteWidth, int spriteHeight, int widthTiles, int heightTiles, int numFrames) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)delays, (String)"delays");
            this.image = image;
            this.buffer = buffer;
            this.ptr = ptr;
            this.delays = delays;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.spriteWidth = spriteWidth;
            this.spriteHeight = spriteHeight;
            this.widthTiles = widthTiles;
            this.heightTiles = heightTiles;
            this.numFrames = numFrames;
        }

        @NotNull
        public final NativeImage getImage() {
            return this.image;
        }

        public final void setImage(@NotNull NativeImage nativeImage) {
            Intrinsics.checkNotNullParameter((Object)nativeImage, (String)"<set-?>");
            this.image = nativeImage;
        }

        @NotNull
        public final ByteBuffer getBuffer() {
            return this.buffer;
        }

        public final void setBuffer(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"<set-?>");
            this.buffer = byteBuffer;
        }

        public final long getPtr() {
            return this.ptr;
        }

        public final void setPtr(long l) {
            this.ptr = l;
        }

        @NotNull
        public final int[] getDelays() {
            return this.delays;
        }

        public final void setDelays(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.delays = nArray;
        }

        public final int getFrameWidth() {
            return this.frameWidth;
        }

        public final void setFrameWidth(int n) {
            this.frameWidth = n;
        }

        public final int getFrameHeight() {
            return this.frameHeight;
        }

        public final void setFrameHeight(int n) {
            this.frameHeight = n;
        }

        public final int getSpriteWidth() {
            return this.spriteWidth;
        }

        public final void setSpriteWidth(int n) {
            this.spriteWidth = n;
        }

        public final int getSpriteHeight() {
            return this.spriteHeight;
        }

        public final void setSpriteHeight(int n) {
            this.spriteHeight = n;
        }

        public final int getWidthTiles() {
            return this.widthTiles;
        }

        public final void setWidthTiles(int n) {
            this.widthTiles = n;
        }

        public final int getHeightTiles() {
            return this.heightTiles;
        }

        public final void setHeightTiles(int n) {
            this.heightTiles = n;
        }

        public final int getNumFrames() {
            return this.numFrames;
        }

        public final void setNumFrames(int n) {
            this.numFrames = n;
        }

        @NotNull
        public final NativeImage component1() {
            return this.image;
        }

        @NotNull
        public final ByteBuffer component2() {
            return this.buffer;
        }

        public final long component3() {
            return this.ptr;
        }

        @NotNull
        public final int[] component4() {
            return this.delays;
        }

        public final int component5() {
            return this.frameWidth;
        }

        public final int component6() {
            return this.frameHeight;
        }

        public final int component7() {
            return this.spriteWidth;
        }

        public final int component8() {
            return this.spriteHeight;
        }

        public final int component9() {
            return this.widthTiles;
        }

        public final int component10() {
            return this.heightTiles;
        }

        public final int component11() {
            return this.numFrames;
        }

        @NotNull
        public final NativeTextureWithData copy(@NotNull NativeImage image, @NotNull ByteBuffer buffer, long ptr, @NotNull int[] delays, int frameWidth, int frameHeight, int spriteWidth, int spriteHeight, int widthTiles, int heightTiles, int numFrames) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)delays, (String)"delays");
            return new NativeTextureWithData(image, buffer, ptr, delays, frameWidth, frameHeight, spriteWidth, spriteHeight, widthTiles, heightTiles, numFrames);
        }

        public static /* synthetic */ NativeTextureWithData copy$default(NativeTextureWithData nativeTextureWithData, NativeImage nativeImage, ByteBuffer byteBuffer, long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
            if ((n8 & 1) != 0) {
                nativeImage = nativeTextureWithData.image;
            }
            if ((n8 & 2) != 0) {
                byteBuffer = nativeTextureWithData.buffer;
            }
            if ((n8 & 4) != 0) {
                l = nativeTextureWithData.ptr;
            }
            if ((n8 & 8) != 0) {
                nArray = nativeTextureWithData.delays;
            }
            if ((n8 & 0x10) != 0) {
                n = nativeTextureWithData.frameWidth;
            }
            if ((n8 & 0x20) != 0) {
                n2 = nativeTextureWithData.frameHeight;
            }
            if ((n8 & 0x40) != 0) {
                n3 = nativeTextureWithData.spriteWidth;
            }
            if ((n8 & 0x80) != 0) {
                n4 = nativeTextureWithData.spriteHeight;
            }
            if ((n8 & 0x100) != 0) {
                n5 = nativeTextureWithData.widthTiles;
            }
            if ((n8 & 0x200) != 0) {
                n6 = nativeTextureWithData.heightTiles;
            }
            if ((n8 & 0x400) != 0) {
                n7 = nativeTextureWithData.numFrames;
            }
            return nativeTextureWithData.copy(nativeImage, byteBuffer, l, nArray, n, n2, n3, n4, n5, n6, n7);
        }

        @NotNull
        public String toString() {
            return "NativeTextureWithData(image=" + this.image + ", buffer=" + this.buffer + ", ptr=" + this.ptr + ", delays=" + Arrays.toString(this.delays) + ", frameWidth=" + this.frameWidth + ", frameHeight=" + this.frameHeight + ", spriteWidth=" + this.spriteWidth + ", spriteHeight=" + this.spriteHeight + ", widthTiles=" + this.widthTiles + ", heightTiles=" + this.heightTiles + ", numFrames=" + this.numFrames + ")";
        }

        public int hashCode() {
            int result = this.image.hashCode();
            result = result * 31 + this.buffer.hashCode();
            result = result * 31 + Long.hashCode(this.ptr);
            result = result * 31 + Arrays.hashCode(this.delays);
            result = result * 31 + Integer.hashCode(this.frameWidth);
            result = result * 31 + Integer.hashCode(this.frameHeight);
            result = result * 31 + Integer.hashCode(this.spriteWidth);
            result = result * 31 + Integer.hashCode(this.spriteHeight);
            result = result * 31 + Integer.hashCode(this.widthTiles);
            result = result * 31 + Integer.hashCode(this.heightTiles);
            result = result * 31 + Integer.hashCode(this.numFrames);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NativeTextureWithData)) {
                return false;
            }
            NativeTextureWithData nativeTextureWithData = (NativeTextureWithData)other;
            if (!Intrinsics.areEqual((Object)this.image, (Object)nativeTextureWithData.image)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.buffer, (Object)nativeTextureWithData.buffer)) {
                return false;
            }
            if (this.ptr != nativeTextureWithData.ptr) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.delays, (Object)nativeTextureWithData.delays)) {
                return false;
            }
            if (this.frameWidth != nativeTextureWithData.frameWidth) {
                return false;
            }
            if (this.frameHeight != nativeTextureWithData.frameHeight) {
                return false;
            }
            if (this.spriteWidth != nativeTextureWithData.spriteWidth) {
                return false;
            }
            if (this.spriteHeight != nativeTextureWithData.spriteHeight) {
                return false;
            }
            if (this.widthTiles != nativeTextureWithData.widthTiles) {
                return false;
            }
            if (this.heightTiles != nativeTextureWithData.heightTiles) {
                return false;
            }
            return this.numFrames == nativeTextureWithData.numFrames;
        }
    }
}

