/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.utils.EnvExecutor;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.spaceeye.vmod.events.AVSEvents;
import net.spaceeye.vmod.networking.S2CConnection;
import net.spaceeye.vmod.networking.Serializable;
import net.spaceeye.vmod.rendering.ClientSynchronisedRenderingData;
import net.spaceeye.vmod.rendering.RenderingTypes;
import net.spaceeye.vmod.rendering.ServerSetRenderingSchemaPacket;
import net.spaceeye.vmod.rendering.ServerSynchronisedRenderingData;
import net.spaceeye.vmod.rendering.ServerWorldSynchronisedRenderingData;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.event.RegisteredListener;
import org.valkyrienskies.core.api.events.ShipLoadEventClient;
import org.valkyrienskies.core.api.events.ShipUnloadEventClient;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.impl.networking.impl.PhysEntityCreateData;
import org.valkyrienskies.mod.api.ValkyrienSkies;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u0016"}, d2={"Lnet/spaceeye/vmod/rendering/SynchronisedRenderingData;", "", "<init>", "()V", "clientSynchronisedData", "Lnet/spaceeye/vmod/rendering/ClientSynchronisedRenderingData;", "getClientSynchronisedData", "()Lnet/spaceeye/vmod/rendering/ClientSynchronisedRenderingData;", "setClientSynchronisedData", "(Lnet/spaceeye/vmod/rendering/ClientSynchronisedRenderingData;)V", "serverSynchronisedData", "Lnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData;", "getServerSynchronisedData", "()Lnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData;", "setServerSynchronisedData", "(Lnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData;)V", "worldClientSynchronisedRenderingData", "getWorldClientSynchronisedRenderingData", "setWorldClientSynchronisedRenderingData", "makeClientEvents", "", "makeServerEvents", "VMod"})
final class SynchronisedRenderingData {
    @NotNull
    public static final SynchronisedRenderingData INSTANCE = new SynchronisedRenderingData();
    @NotNull
    private static ClientSynchronisedRenderingData clientSynchronisedData = new ClientSynchronisedRenderingData(null, 1, null);
    @NotNull
    private static ServerSynchronisedRenderingData serverSynchronisedData = new ServerSynchronisedRenderingData();
    @NotNull
    private static ClientSynchronisedRenderingData worldClientSynchronisedRenderingData = new ClientSynchronisedRenderingData("world_rendering_data");

    private SynchronisedRenderingData() {
    }

    @NotNull
    public final ClientSynchronisedRenderingData getClientSynchronisedData() {
        return clientSynchronisedData;
    }

    public final void setClientSynchronisedData(@NotNull ClientSynchronisedRenderingData clientSynchronisedRenderingData) {
        Intrinsics.checkNotNullParameter((Object)clientSynchronisedRenderingData, (String)"<set-?>");
        clientSynchronisedData = clientSynchronisedRenderingData;
    }

    @NotNull
    public final ServerSynchronisedRenderingData getServerSynchronisedData() {
        return serverSynchronisedData;
    }

    public final void setServerSynchronisedData(@NotNull ServerSynchronisedRenderingData serverSynchronisedRenderingData) {
        Intrinsics.checkNotNullParameter((Object)serverSynchronisedRenderingData, (String)"<set-?>");
        serverSynchronisedData = serverSynchronisedRenderingData;
    }

    @NotNull
    public final ClientSynchronisedRenderingData getWorldClientSynchronisedRenderingData() {
        return worldClientSynchronisedRenderingData;
    }

    public final void setWorldClientSynchronisedRenderingData(@NotNull ClientSynchronisedRenderingData clientSynchronisedRenderingData) {
        Intrinsics.checkNotNullParameter((Object)clientSynchronisedRenderingData, (String)"<set-?>");
        worldClientSynchronisedRenderingData = clientSynchronisedRenderingData;
    }

    private final void makeClientEvents() {
        EnvExecutor.runInEnv((Dist)Dist.CLIENT, SynchronisedRenderingData::makeClientEvents$lambda$6);
    }

    private final void makeServerEvents() {
        AVSEvents.INSTANCE.getServerShipRemoveEvent().on((Function2<AVSEvents.ServerShipRemoveEvent, Function0<Unit>, Unit>)((Function2)SynchronisedRenderingData::makeServerEvents$lambda$7));
        PlayerEvent.PLAYER_JOIN.register(SynchronisedRenderingData::makeServerEvents$lambda$8);
        PlayerEvent.PLAYER_QUIT.register(SynchronisedRenderingData::makeServerEvents$lambda$9);
    }

    private static final Unit makeClientEvents$lambda$6$lambda$5$lambda$0(ShipLoadEventClient event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ClientShip ship = event.getShip();
        clientSynchronisedData.subscribeToPageUpdates(ship.getId());
        return Unit.INSTANCE;
    }

    private static final void makeClientEvents$lambda$6$lambda$5$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void makeClientEvents$lambda$6$lambda$5$lambda$2(ShipUnloadEventClient event, RegisteredListener registeredListener) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)registeredListener, (String)"<unused var>");
        ClientShip ship = event.getShip();
        clientSynchronisedData.unsubscribeFromPageUpdates(ship.getId());
    }

    private static final Unit makeClientEvents$lambda$6$lambda$5$lambda$3(PhysEntityCreateData data, Function0 function0) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"<unused var>");
        clientSynchronisedData.subscribeToPageUpdates(data.getId());
        return Unit.INSTANCE;
    }

    private static final Unit makeClientEvents$lambda$6$lambda$5$lambda$4(long id2, Function0 function0) {
        Intrinsics.checkNotNullParameter((Object)function0, (String)"<unused var>");
        clientSynchronisedData.unsubscribeFromPageUpdates(id2);
        return Unit.INSTANCE;
    }

    private static final void makeClientEvents$lambda$6$lambda$5() {
        ValkyrienSkies.api().getShipLoadEventClient().on(arg_0 -> SynchronisedRenderingData.makeClientEvents$lambda$6$lambda$5$lambda$1(SynchronisedRenderingData::makeClientEvents$lambda$6$lambda$5$lambda$0, arg_0));
        ValkyrienSkies.api().getShipUnloadEventClient().on(SynchronisedRenderingData::makeClientEvents$lambda$6$lambda$5$lambda$2);
        AVSEvents.INSTANCE.getClientPhysEntityLoad().on((Function2<PhysEntityCreateData, Function0<Unit>, Unit>)((Function2)SynchronisedRenderingData::makeClientEvents$lambda$6$lambda$5$lambda$3));
        AVSEvents.INSTANCE.getClientPhysEntityUnload().on((Function2<Long, Function0<Unit>, Unit>)((Function2)SynchronisedRenderingData::makeClientEvents$lambda$6$lambda$5$lambda$4));
    }

    private static final Runnable makeClientEvents$lambda$6() {
        return SynchronisedRenderingData::makeClientEvents$lambda$6$lambda$5;
    }

    private static final Unit makeServerEvents$lambda$7(AVSEvents.ServerShipRemoveEvent serverShipRemoveEvent, Function0 handler) {
        Intrinsics.checkNotNullParameter((Object)serverShipRemoveEvent, (String)"<destruct>");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        ServerShip shipData = serverShipRemoveEvent.component1();
        serverSynchronisedData.remove$VMod(shipData.getId());
        return Unit.INSTANCE;
    }

    private static final void makeServerEvents$lambda$8(ServerPlayer it) {
        S2CConnection<ServerSetRenderingSchemaPacket> s2CConnection = clientSynchronisedData.getS2cSetSchema();
        Intrinsics.checkNotNull((Object)it);
        s2CConnection.sendToClient(it, (ServerSetRenderingSchemaPacket)((Serializable)new ServerSetRenderingSchemaPacket(RenderingTypes.INSTANCE.getSchema())));
        worldClientSynchronisedRenderingData.getS2cSetSchema().sendToClient(it, (ServerSetRenderingSchemaPacket)((Serializable)new ServerSetRenderingSchemaPacket(RenderingTypes.INSTANCE.getSchema())));
        serverSynchronisedData.subscribePlayerToReservedPages(it);
    }

    private static final void makeServerEvents$lambda$9(ServerPlayer it) {
        UUID uUID = it.m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        serverSynchronisedData.removeSubscriber$VMod(uUID);
        ServerWorldSynchronisedRenderingData serverWorldSynchronisedRenderingData = serverSynchronisedData.getWorldRenderingData$VMod();
        UUID uUID2 = it.m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        serverWorldSynchronisedRenderingData.removeSubscriber$VMod(uUID2);
    }

    static {
        INSTANCE.makeServerEvents();
        INSTANCE.makeClientEvents();
    }
}

