/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.spaceeye.vmod.utils.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Vector4d;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0015"}, d2={"Lnet/spaceeye/vmod/rendering/RenderingUtils;", "", "<init>", "()V", "ropeTexture", "Lnet/minecraft/resources/ResourceLocation;", "getRopeTexture$annotations", "getRopeTexture", "()Lnet/minecraft/resources/ResourceLocation;", "whiteTexture", "getWhiteTexture$annotations", "getWhiteTexture", "testTexture", "getTestTexture$annotations", "getTestTexture", "tof", "", "n", "", "Line", "Quad", "VMod"})
public final class RenderingUtils {
    @NotNull
    public static final RenderingUtils INSTANCE = new RenderingUtils();
    @NotNull
    private static final ResourceLocation ropeTexture = new ResourceLocation("the_vmod", "textures/misc/rope.png");
    @NotNull
    private static final ResourceLocation whiteTexture = new ResourceLocation("the_vmod", "textures/misc/white.png");
    @NotNull
    private static final ResourceLocation testTexture = new ResourceLocation("the_vmod", "textures/misc/test_texture.png");

    private RenderingUtils() {
    }

    @NotNull
    public static final ResourceLocation getRopeTexture() {
        return ropeTexture;
    }

    @JvmStatic
    public static /* synthetic */ void getRopeTexture$annotations() {
    }

    @NotNull
    public static final ResourceLocation getWhiteTexture() {
        return whiteTexture;
    }

    @JvmStatic
    public static /* synthetic */ void getWhiteTexture$annotations() {
    }

    @NotNull
    public static final ResourceLocation getTestTexture() {
        return testTexture;
    }

    @JvmStatic
    public static /* synthetic */ void getTestTexture$annotations() {
    }

    @JvmStatic
    public static final float tof(double n) {
        return (float)n;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J8\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0014"}, d2={"Lnet/spaceeye/vmod/rendering/RenderingUtils$Line;", "", "<init>", "()V", "renderLine", "", "buf", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "matrix", "Lorg/joml/Matrix4f;", "color", "Ljava/awt/Color;", "start", "Lnet/spaceeye/vmod/utils/Vector3d;", "stop", "width", "", "renderLineBox", "points", "", "VMod"})
    public static final class Line {
        @NotNull
        public static final Line INSTANCE = new Line();

        private Line() {
        }

        @JvmStatic
        public static final void renderLine(@NotNull VertexConsumer buf, @NotNull Matrix4f matrix, @NotNull Color color, @NotNull Vector3d start, @NotNull Vector3d stop, double width) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
            Vector3d wdir = stop.minus(start);
            Vector3d pdir = start.unaryMinus().minus(wdir.times(start.unaryMinus().dot(wdir) / wdir.dot(wdir))).snormalize();
            Vector3d up = pdir.cross(wdir.normalize());
            Vector3d lu = up.times(width).plus(start);
            Vector3d ld = up.unaryMinus().times(width).plus(start);
            Vector3d ru = up.unaryMinus().times(width).plus(stop);
            Vector3d rd = up.times(width).plus(stop);
            buf.m_252986_(matrix, RenderingUtils.tof(lu.x), RenderingUtils.tof(lu.y), RenderingUtils.tof(lu.z)).m_193479_(color.getRGB()).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(ld.x), RenderingUtils.tof(ld.y), RenderingUtils.tof(ld.z)).m_193479_(color.getRGB()).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(ru.x), RenderingUtils.tof(ru.y), RenderingUtils.tof(ru.z)).m_193479_(color.getRGB()).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(rd.x), RenderingUtils.tof(rd.y), RenderingUtils.tof(rd.z)).m_193479_(color.getRGB()).m_5752_();
        }

        public static /* synthetic */ void renderLine$default(VertexConsumer vertexConsumer, Matrix4f matrix4f, Color color, Vector3d vector3d, Vector3d vector3d2, double d, int n, Object object) {
            if ((n & 0x20) != 0) {
                d = 0.5;
            }
            Line.renderLine(vertexConsumer, matrix4f, color, vector3d, vector3d2, d);
        }

        @JvmStatic
        public static final void renderLineBox(@NotNull VertexConsumer buf, @NotNull Matrix4f matrix, @NotNull Color color, @NotNull List<Vector3d> points2, double width) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            Line.renderLine(buf, matrix, color, points2.get(0), points2.get(1), width);
            Line.renderLine(buf, matrix, color, points2.get(1), points2.get(2), width);
            Line.renderLine(buf, matrix, color, points2.get(2), points2.get(3), width);
            Line.renderLine(buf, matrix, color, points2.get(3), points2.get(0), width);
            Line.renderLine(buf, matrix, color, points2.get(4), points2.get(5), width);
            Line.renderLine(buf, matrix, color, points2.get(5), points2.get(6), width);
            Line.renderLine(buf, matrix, color, points2.get(6), points2.get(7), width);
            Line.renderLine(buf, matrix, color, points2.get(7), points2.get(4), width);
            Line.renderLine(buf, matrix, color, points2.get(4), points2.get(0), width);
            Line.renderLine(buf, matrix, color, points2.get(5), points2.get(1), width);
            Line.renderLine(buf, matrix, color, points2.get(6), points2.get(2), width);
            Line.renderLine(buf, matrix, color, points2.get(7), points2.get(3), width);
        }

        public static /* synthetic */ void renderLineBox$default(VertexConsumer vertexConsumer, Matrix4f matrix4f, Color color, List list, double d, int n, Object object) {
            if ((n & 0x10) != 0) {
                d = 0.1;
            }
            Line.renderLineBox(vertexConsumer, matrix4f, color, list, d);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J`\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0007Jp\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0007J\u0088\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0007J\u00a0\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0007J6\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0011H\u0007J\u0084\u0001\u0010)\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001a2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\"H\u0007JX\u00100\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0011H\u0007J \u00104\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00112\u0006\u00105\u001a\u00020%H\u0007J\u0018\u00106\u001a\u00020%2\u0006\u00107\u001a\u00020%2\u0006\u00108\u001a\u00020%H\u0007J\u009c\u0001\u00109\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u00101\u001a\u00020%2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020%2\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00112\b\b\u0002\u0010<\u001a\u00020\u001a2\b\b\u0002\u0010=\u001a\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020\u001a2\b\b\u0002\u0010>\u001a\u00020\u001a2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0@H\u0007J\u00d4\u0001\u0010A\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020%2\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u00112\u0006\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020\u00112\u0006\u0010E\u001a\u00020\u00112\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020G2\b\b\u0002\u0010<\u001a\u00020\u001a2\b\b\u0002\u0010=\u001a\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020\u001a2\b\b\u0002\u0010>\u001a\u00020\u001a2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0@H\u0007J\u009f\u0001\u0010I\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00112\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020%2u\u0010J\u001aq\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\bL\u0012\b\bM\u0012\u0004\b\b(N\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\bL\u0012\b\bM\u0012\u0004\b\b(O\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\bL\u0012\b\bM\u0012\u0004\b\b(P\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\bL\u0012\b\bM\u0012\u0004\b\b(Q\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\bL\u0012\b\bM\u0012\u0004\b\b(B\u0012\u0004\u0012\u00020\u00050KH\u0007\u00a8\u0006R"}, d2={"Lnet/spaceeye/vmod/rendering/RenderingUtils$Quad;", "", "<init>", "()V", "drawQuad", "", "buf", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "matrix", "Lorg/joml/Matrix4f;", "r", "", "g", "b", "a", "lightmapUV", "lu", "Lnet/spaceeye/vmod/utils/Vector3d;", "ld", "rd", "ru", "overlayUV", "normal", "leftLight", "rightLight", "u0", "", "u1", "v0", "v1", "nx", "ny", "nz", "makePolygonPoints", "", "sides", "radius", "", "up", "right", "pos", "drawPolygonTube", "luv0", "luv1", "wuvStart", "maxWidthUV", "lpoints", "rpoints", "makeFlatRectFacingCamera", "width", "pos1", "pos2", "lerp", "f", "height", "l", "x", "drawFlatRope", "segments", "initialLength", "luvStart", "luvIncMultiplier", "wuvMultiplier", "lightmapUVFn", "Lkotlin/Function1;", "drawTubeRope", "up1", "right1", "up2", "right2", "lerpBetweenShipRotations", "", "useDefinedUpRight", "ropePointsCreator", "fn", "Lkotlin/Function5;", "Lkotlin/ParameterName;", "name", "i", "last", "current", "up0", "VMod"})
    public static final class Quad {
        @NotNull
        public static final Quad INSTANCE = new Quad();

        private Quad() {
        }

        @JvmStatic
        public static final void drawQuad(@NotNull VertexConsumer buf, @NotNull Matrix4f matrix, int r, int g, int b, int a, int lightmapUV, @NotNull Vector3d lu, @NotNull Vector3d ld, @NotNull Vector3d rd, @NotNull Vector3d ru) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            Intrinsics.checkNotNullParameter((Object)lu, (String)"lu");
            Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
            Intrinsics.checkNotNullParameter((Object)rd, (String)"rd");
            Intrinsics.checkNotNullParameter((Object)ru, (String)"ru");
            buf.m_252986_(matrix, RenderingUtils.tof(lu.x), RenderingUtils.tof(lu.y), RenderingUtils.tof(lu.z)).m_6122_(r, g, b, a).m_85969_(lightmapUV).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(ld.x), RenderingUtils.tof(ld.y), RenderingUtils.tof(ld.z)).m_6122_(r, g, b, a).m_85969_(lightmapUV).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(rd.x), RenderingUtils.tof(rd.y), RenderingUtils.tof(rd.z)).m_6122_(r, g, b, a).m_85969_(lightmapUV).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(ru.x), RenderingUtils.tof(ru.y), RenderingUtils.tof(ru.z)).m_6122_(r, g, b, a).m_85969_(lightmapUV).m_5752_();
        }

        @JvmStatic
        public static final void drawQuad(@NotNull VertexConsumer buf, @NotNull Matrix4f matrix, int r, int g, int b, int a, int lightmapUV, int overlayUV, @NotNull Vector3d lu, @NotNull Vector3d ld, @NotNull Vector3d rd, @NotNull Vector3d ru, @NotNull Vector3d normal) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            Intrinsics.checkNotNullParameter((Object)lu, (String)"lu");
            Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
            Intrinsics.checkNotNullParameter((Object)rd, (String)"rd");
            Intrinsics.checkNotNullParameter((Object)ru, (String)"ru");
            Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
            buf.m_252986_(matrix, RenderingUtils.tof(lu.x), RenderingUtils.tof(lu.y), RenderingUtils.tof(lu.z)).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlayUV).m_85969_(lightmapUV).m_5601_(RenderingUtils.tof(normal.x), RenderingUtils.tof(normal.y), RenderingUtils.tof(normal.z)).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(ld.x), RenderingUtils.tof(ld.y), RenderingUtils.tof(ld.z)).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlayUV).m_85969_(lightmapUV).m_5601_(RenderingUtils.tof(normal.x), RenderingUtils.tof(normal.y), RenderingUtils.tof(normal.z)).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(rd.x), RenderingUtils.tof(rd.y), RenderingUtils.tof(rd.z)).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlayUV).m_85969_(lightmapUV).m_5601_(RenderingUtils.tof(normal.x), RenderingUtils.tof(normal.y), RenderingUtils.tof(normal.z)).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(ru.x), RenderingUtils.tof(ru.y), RenderingUtils.tof(ru.z)).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlayUV).m_85969_(lightmapUV).m_5601_(RenderingUtils.tof(normal.x), RenderingUtils.tof(normal.y), RenderingUtils.tof(normal.z)).m_5752_();
        }

        @JvmStatic
        public static final void drawQuad(@NotNull VertexConsumer buf, @NotNull Matrix4f matrix, int r, int g, int b, int a, int leftLight, int rightLight, @NotNull Vector3d lu, @NotNull Vector3d ld, @NotNull Vector3d rd, @NotNull Vector3d ru, float u0, float u1, float v0, float v1) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            Intrinsics.checkNotNullParameter((Object)lu, (String)"lu");
            Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
            Intrinsics.checkNotNullParameter((Object)rd, (String)"rd");
            Intrinsics.checkNotNullParameter((Object)ru, (String)"ru");
            Quad.drawQuad(buf, matrix, r, g, b, a, leftLight, rightLight, lu, ld, rd, ru, u0, u1, v0, v1, 0.0f, 1.0f, 0.0f);
        }

        @JvmStatic
        public static final void drawQuad(@NotNull VertexConsumer buf, @NotNull Matrix4f matrix, int r, int g, int b, int a, int leftLight, int rightLight, @NotNull Vector3d lu, @NotNull Vector3d ld, @NotNull Vector3d rd, @NotNull Vector3d ru, float u0, float u1, float v0, float v1, float nx, float ny, float nz) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            Intrinsics.checkNotNullParameter((Object)lu, (String)"lu");
            Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
            Intrinsics.checkNotNullParameter((Object)rd, (String)"rd");
            Intrinsics.checkNotNullParameter((Object)ru, (String)"ru");
            buf.m_252986_(matrix, RenderingUtils.tof(lu.x), RenderingUtils.tof(lu.y), RenderingUtils.tof(lu.z)).m_6122_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(leftLight).m_5601_(nx, ny, nz).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(ld.x), RenderingUtils.tof(ld.y), RenderingUtils.tof(ld.z)).m_6122_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(leftLight).m_5601_(nx, ny, nz).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(rd.x), RenderingUtils.tof(rd.y), RenderingUtils.tof(rd.z)).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(rightLight).m_5601_(nx, ny, nz).m_5752_();
            buf.m_252986_(matrix, RenderingUtils.tof(ru.x), RenderingUtils.tof(ru.y), RenderingUtils.tof(ru.z)).m_6122_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(rightLight).m_5601_(nx, ny, nz).m_5752_();
        }

        @JvmStatic
        @NotNull
        public static final List<Vector3d> makePolygonPoints(int sides, double radius, @NotNull Vector3d up, @NotNull Vector3d right, @NotNull Vector3d pos) {
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            double segment = Math.PI * 2 / (double)sides;
            List points2 = new ArrayList();
            for (int i2 = 0; i2 < sides; ++i2) {
                points2.add(up.times(Math.sin(segment * (double)i2)).plus(right.times(Math.cos(segment * (double)i2))).times(radius).plus(pos));
            }
            return points2;
        }

        @JvmStatic
        public static final void drawPolygonTube(@NotNull VertexConsumer buf, @NotNull Matrix4f matrix, int r, int g, int b, int a, int leftLight, int rightLight, float luv0, float luv1, float wuvStart, float maxWidthUV, @NotNull List<Vector3d> lpoints, @NotNull List<Vector3d> rpoints) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            Intrinsics.checkNotNullParameter(lpoints, (String)"lpoints");
            Intrinsics.checkNotNullParameter(rpoints, (String)"rpoints");
            int times2 = lpoints.size();
            float lastUV = wuvStart;
            int n = times2 - 1;
            for (int i2 = 0; i2 < n; ++i2) {
                float nextUV = lastUV + maxWidthUV / (float)times2;
                Quad.drawQuad(buf, matrix, r, g, b, a, leftLight, rightLight, lpoints.get(i2), lpoints.get(i2 + 1), rpoints.get(i2 + 1), rpoints.get(i2), luv0, luv1, lastUV, nextUV);
                lastUV = nextUV;
            }
            Quad.drawQuad(buf, matrix, r, g, b, a, leftLight, rightLight, lpoints.get(times2 - 1), lpoints.get(0), rpoints.get(0), rpoints.get(times2 - 1), luv0, luv1, lastUV, maxWidthUV);
        }

        @JvmStatic
        public static final void makeFlatRectFacingCamera(@NotNull VertexConsumer buf, @NotNull Matrix4f matrix, int r, int g, int b, int a, int lightmapUV, double width, @NotNull Vector3d pos1, @NotNull Vector3d pos2) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
            Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos2");
            Vector3d wdir = pos2.minus(pos1);
            Vector3d pdir = pos1.unaryMinus().minus(wdir.times(pos1.unaryMinus().dot(wdir) / wdir.dot(wdir))).snormalize();
            Vector3d up = pdir.cross(wdir.normalize());
            Vector3d lu = up.times(width).plus(pos1);
            Vector3d ld = up.unaryMinus().times(width).plus(pos1);
            Vector3d rd = up.unaryMinus().times(width).plus(pos2);
            Vector3d ru = up.times(width).plus(pos2);
            Quad.drawQuad(buf, matrix, r, g, b, a, lightmapUV, OverlayTexture.f_118083_, lu, ld, rd, ru, up);
        }

        @JvmStatic
        @NotNull
        public static final Vector3d lerp(@NotNull Vector3d a, @NotNull Vector3d b, double f) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return a.plus(b.minus(a).times(f));
        }

        @JvmStatic
        public static final double height(double l, double x) {
            double a = (double)2 * l;
            return x * a * (x - 1.0);
        }

        @JvmStatic
        public static final void drawFlatRope(@NotNull VertexConsumer buf, @NotNull Matrix4f matrix, int r, int g, int b, int a, double width, int segments, double initialLength, @NotNull Vector3d pos1, @NotNull Vector3d pos2, float luvStart, float luvIncMultiplier, float wuvStart, float wuvMultiplier, @NotNull Function1<? super Vector3d, Integer> lightmapUVFn) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
            Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos2");
            Intrinsics.checkNotNullParameter(lightmapUVFn, (String)"lightmapUVFn");
            Ref.FloatRef lastUV = new Ref.FloatRef();
            lastUV.element = luvStart;
            float widthUV = (float)(width * (double)2.0f * (double)wuvMultiplier);
            Quad.ropePointsCreator(pos1, pos2, segments, initialLength, (Function5<? super Integer, ? super Vector3d, ? super Vector3d, ? super Vector3d, ? super Vector3d, Unit>)((Function5)(arg_0, arg_1, arg_2, arg_3, arg_4) -> Quad.drawFlatRope$lambda$0(width, lightmapUVFn, luvIncMultiplier, lastUV, buf, matrix, r, g, b, a, wuvStart, widthUV, arg_0, arg_1, arg_2, arg_3, arg_4)));
        }

        public static /* synthetic */ void drawFlatRope$default(VertexConsumer vertexConsumer, Matrix4f matrix4f, int n, int n2, int n3, int n4, double d, int n5, double d2, Vector3d vector3d, Vector3d vector3d2, float f, float f2, float f3, float f4, Function1 function1, int n6, Object object) {
            if ((n6 & 0x800) != 0) {
                f = 0.0f;
            }
            if ((n6 & 0x1000) != 0) {
                f2 = 1.0f;
            }
            if ((n6 & 0x2000) != 0) {
                f3 = 0.0f;
            }
            if ((n6 & 0x4000) != 0) {
                f4 = 1.0f;
            }
            Quad.drawFlatRope(vertexConsumer, matrix4f, n, n2, n3, n4, d, n5, d2, vector3d, vector3d2, f, f2, f3, f4, (Function1<? super Vector3d, Integer>)function1);
        }

        @JvmStatic
        public static final void drawTubeRope(@NotNull VertexConsumer buf, @NotNull Matrix4f matrix, int r, int g, int b, int a, double radius, int segments, int sides, double initialLength, @NotNull Vector3d pos1, @NotNull Vector3d pos2, @NotNull Vector3d up1, @NotNull Vector3d right1, @NotNull Vector3d up2, @NotNull Vector3d right2, boolean lerpBetweenShipRotations, boolean useDefinedUpRight, float luvStart, float luvIncMultiplier, float wuvStart, float wuvMultiplier, @NotNull Function1<? super Vector3d, Integer> lightmapUVFn) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
            Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos2");
            Intrinsics.checkNotNullParameter((Object)up1, (String)"up1");
            Intrinsics.checkNotNullParameter((Object)right1, (String)"right1");
            Intrinsics.checkNotNullParameter((Object)up2, (String)"up2");
            Intrinsics.checkNotNullParameter((Object)right2, (String)"right2");
            Intrinsics.checkNotNullParameter(lightmapUVFn, (String)"lightmapUVFn");
            Matrix4d rot1 = new Matrix4d(right1.toJomlVector4d(), up1.toJomlVector4d(), right1.cross(up1).toJomlVector4d(), new Vector4d());
            Matrix4d rot2 = new Matrix4d(right2.toJomlVector4d(), up2.toJomlVector4d(), right2.cross(up2).toJomlVector4d(), new Vector4d());
            Ref.ObjectRef cRot = new Ref.ObjectRef();
            cRot.element = rot1;
            Ref.ObjectRef rPoints = new Ref.ObjectRef();
            Ref.ObjectRef lPoints = new Ref.ObjectRef();
            Ref.ObjectRef up = new Ref.ObjectRef();
            up.element = up1;
            Ref.ObjectRef right = new Ref.ObjectRef();
            right.element = right1;
            if (!useDefinedUpRight) {
                double l = RangesKt.coerceAtLeast((double)(initialLength - pos1.minus(pos2).dist()), (double)0.0);
                Vector3d pos22 = Quad.lerp(pos1, pos2, 1.0 / (double)segments);
                pos22.y += Quad.height(l, 1.0 / (double)segments);
                Vector3d forward = pos22.minus(pos1).snormalize();
                right.element = forward.cross(0, 1, 0).snormalize();
                up.element = ((Vector3d)right.element).cross(forward).snormalize();
            }
            Ref.IntRef lLight = new Ref.IntRef();
            lLight.element = ((Number)lightmapUVFn.invoke((Object)pos1)).intValue();
            lPoints.element = Quad.makePolygonPoints(sides, radius, (Vector3d)up.element, (Vector3d)right.element, pos1);
            float widthUV = (float)(radius * (double)2.0f * (double)wuvMultiplier);
            Ref.FloatRef leftUV = new Ref.FloatRef();
            leftUV.element = luvStart;
            Quad.ropePointsCreator(pos1, pos2, segments, initialLength, (Function5<? super Integer, ? super Vector3d, ? super Vector3d, ? super Vector3d, ? super Vector3d, Unit>)((Function5)(arg_0, arg_1, arg_2, arg_3, arg_4) -> Quad.drawTubeRope$lambda$1(pos2, useDefinedUpRight, right, right2, up, up2, lerpBetweenShipRotations, cRot, rot1, rot2, segments, rPoints, sides, radius, lightmapUVFn, leftUV, luvIncMultiplier, buf, matrix, r, g, b, a, lLight, wuvStart, widthUV, lPoints, arg_0, arg_1, arg_2, arg_3, arg_4)));
        }

        public static /* synthetic */ void drawTubeRope$default(VertexConsumer vertexConsumer, Matrix4f matrix4f, int n, int n2, int n3, int n4, double d, int n5, int n6, double d2, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, Vector3d vector3d5, Vector3d vector3d6, boolean bl, boolean bl2, float f, float f2, float f3, float f4, Function1 function1, int n7, Object object) {
            if ((n7 & 0x40000) != 0) {
                f = 0.0f;
            }
            if ((n7 & 0x80000) != 0) {
                f2 = 1.0f;
            }
            if ((n7 & 0x100000) != 0) {
                f3 = 0.0f;
            }
            if ((n7 & 0x200000) != 0) {
                f4 = 1.0f;
            }
            Quad.drawTubeRope(vertexConsumer, matrix4f, n, n2, n3, n4, d, n5, n6, d2, vector3d, vector3d2, vector3d3, vector3d4, vector3d5, vector3d6, bl, bl2, f, f2, f3, f4, (Function1<? super Vector3d, Integer>)function1);
        }

        @JvmStatic
        public static final void ropePointsCreator(@NotNull Vector3d pos1, @NotNull Vector3d pos2, int segments, double initialLength, @NotNull Function5<? super Integer, ? super Vector3d, ? super Vector3d, ? super Vector3d, ? super Vector3d, Unit> fn) {
            int i2;
            Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
            Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos2");
            Intrinsics.checkNotNullParameter(fn, (String)"fn");
            if (segments < 1) {
                return;
            }
            double l = initialLength - pos1.minus(pos2).dist();
            if (l < 0.0) {
                l = 0.0;
            }
            if ((i2 = 1) <= segments) {
                while (true) {
                    Vector3d vector3d;
                    Vector3d d0;
                    double x0 = (double)(i2 - 1) / (double)segments;
                    double x1 = (double)i2 / (double)segments;
                    Vector3d last = Quad.lerp(pos1, pos2, x0);
                    Vector3d current = Quad.lerp(pos1, pos2, x1);
                    Vector3d vector3d2 = last;
                    vector3d2.y += Quad.height(l, x0);
                    vector3d2 = current;
                    vector3d2.y += Quad.height(l, x1);
                    Vector3d d1 = d0 = last.minus(current);
                    if (i2 > 1) {
                        double xm = (double)(i2 - 2) / (double)segments;
                        vector3d = d0 = Quad.lerp(pos1, pos2, xm).minus(last).plus(d0);
                        vector3d.y += Quad.height(l, xm);
                    }
                    if (i2 < segments) {
                        double x2 = (double)(i2 + 1) / (double)segments;
                        vector3d = d1 = current.minus(Quad.lerp(pos1, pos2, x2)).plus(d1);
                        vector3d.y -= Quad.height(l, x2);
                    }
                    d0 = d0.normalize();
                    d1 = d1.normalize();
                    Vector3d up0 = last.normalize().cross(d0).normalize();
                    Vector3d up1 = current.normalize().cross(d1).normalize();
                    fn.invoke((Object)i2, (Object)last, (Object)current, (Object)up0, (Object)up1);
                    if (i2 == segments) break;
                    ++i2;
                }
            }
        }

        private static final Unit drawFlatRope$lambda$0(double $width, Function1 $lightmapUVFn, float $luvIncMultiplier, Ref.FloatRef $lastUV, VertexConsumer $buf, Matrix4f $matrix, int $r, int $g, int $b, int $a, float $wuvStart, float $widthUV, int i2, Vector3d last, Vector3d current, Vector3d up0, Vector3d up1) {
            Intrinsics.checkNotNullParameter((Object)last, (String)"last");
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)up0, (String)"up0");
            Intrinsics.checkNotNullParameter((Object)up1, (String)"up1");
            Vector3d lu = up0.times($width).plus(last);
            Vector3d ld = up0.unaryMinus().times($width).plus(last);
            Vector3d rd = up1.unaryMinus().times($width).plus(current);
            Vector3d ru = up1.times($width).plus(current);
            int prev = ((Number)$lightmapUVFn.invoke((Object)last)).intValue();
            int curr = ((Number)$lightmapUVFn.invoke((Object)current)).intValue();
            float inc = (float)current.minus(last).dist() * $luvIncMultiplier;
            float nextUV = $lastUV.element + inc;
            Quad.drawQuad($buf, $matrix, $r, $g, $b, $a, prev, curr, lu, ld, rd, ru, $lastUV.element, nextUV, $wuvStart, $widthUV);
            $lastUV.element = nextUV;
            return Unit.INSTANCE;
        }

        private static final Unit drawTubeRope$lambda$1(Vector3d $pos2, boolean $useDefinedUpRight, Ref.ObjectRef $right, Vector3d $right2, Ref.ObjectRef $up, Vector3d $up2, boolean $lerpBetweenShipRotations, Ref.ObjectRef $cRot, Matrix4d $rot1, Matrix4d $rot2, int $segments, Ref.ObjectRef $rPoints, int $sides, double $radius, Function1 $lightmapUVFn, Ref.FloatRef $leftUV, float $luvIncMultiplier, VertexConsumer $buf, Matrix4f $matrix, int $r, int $g, int $b, int $a, Ref.IntRef $lLight, float $wuvStart, float $widthUV, Ref.ObjectRef $lPoints, int i2, Vector3d last, Vector3d current, Vector3d up0, Vector3d up1) {
            Intrinsics.checkNotNullParameter((Object)last, (String)"last");
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)up0, (String)"up0");
            Intrinsics.checkNotNullParameter((Object)up1, (String)"up1");
            if (current.minus($pos2).sqrDist() < 0.001 && $useDefinedUpRight) {
                $right.element = $right2;
                $up.element = $up2;
            } else if ($lerpBetweenShipRotations) {
                $cRot.element = $rot1.lerp((Matrix4dc)$rot2, (double)i2 / (double)$segments);
                org.joml.Vector3d vector3d = ((Matrix4d)$cRot.element).getColumn(0, new org.joml.Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"getColumn(...)");
                $right.element = new Vector3d(vector3d);
                org.joml.Vector3d vector3d2 = ((Matrix4d)$cRot.element).getColumn(1, new org.joml.Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"getColumn(...)");
                $up.element = new Vector3d(vector3d2);
            } else {
                Vector3d forward = current.minus(last).snormalize();
                $right.element = forward.cross(0, 1, 0).snormalize();
                $up.element = ((Vector3d)$right.element).cross(forward).snormalize();
            }
            $rPoints.element = Quad.makePolygonPoints($sides, $radius, (Vector3d)$up.element, (Vector3d)$right.element, current);
            int rLight = ((Number)$lightmapUVFn.invoke((Object)current)).intValue();
            float rightUV = $leftUV.element + (float)current.minus(last).dist() * $luvIncMultiplier;
            Quad.drawPolygonTube($buf, $matrix, $r, $g, $b, $a, $lLight.element, rLight, $leftUV.element, rightUV, $wuvStart, $widthUV, (List)$lPoints.element, (List)$rPoints.element);
            $leftUV.element = rightUV;
            $lPoints.element = $rPoints.element;
            $lLight.element = rLight;
            return Unit.INSTANCE;
        }
    }
}

