/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.gif;

import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Node;

abstract class GIFMetadata
extends IIOMetadata {
    static final int UNDEFINED_INTEGER_VALUE = -1;

    protected static void fatal(Node node2, String reason) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(reason, node2);
    }

    protected static String getStringAttribute(Node node2, String name, String defaultValue, boolean required, String[] range) throws IIOInvalidTreeException {
        Node attr = node2.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            GIFMetadata.fatal(node2, "Required attribute " + name + " not present!");
        }
        String value = attr.getNodeValue();
        if (range != null) {
            if (value == null) {
                GIFMetadata.fatal(node2, "Null value for " + node2.getNodeName() + " attribute " + name + "!");
            }
            boolean validValue = false;
            int len = range.length;
            for (int i2 = 0; i2 < len; ++i2) {
                if (!value.equals(range[i2])) continue;
                validValue = true;
                break;
            }
            if (!validValue) {
                GIFMetadata.fatal(node2, "Bad value for " + node2.getNodeName() + " attribute " + name + "!");
            }
        }
        return value;
    }

    protected static int getIntAttribute(Node node2, String name, int defaultValue, boolean required, boolean bounded, int min, int max) throws IIOInvalidTreeException {
        String value = GIFMetadata.getStringAttribute(node2, name, null, required, null);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        int intValue = defaultValue;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            GIFMetadata.fatal(node2, "Bad value for " + node2.getNodeName() + " attribute " + name + "!");
        }
        if (bounded && (intValue < min || intValue > max)) {
            GIFMetadata.fatal(node2, "Bad value for " + node2.getNodeName() + " attribute " + name + "!");
        }
        return intValue;
    }

    protected static float getFloatAttribute(Node node2, String name, float defaultValue, boolean required) throws IIOInvalidTreeException {
        String value = GIFMetadata.getStringAttribute(node2, name, null, required, null);
        if (value == null) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    protected static int getIntAttribute(Node node2, String name, boolean bounded, int min, int max) throws IIOInvalidTreeException {
        return GIFMetadata.getIntAttribute(node2, name, -1, true, bounded, min, max);
    }

    protected static float getFloatAttribute(Node node2, String name) throws IIOInvalidTreeException {
        return GIFMetadata.getFloatAttribute(node2, name, -1.0f, true);
    }

    protected static boolean getBooleanAttribute(Node node2, String name, boolean defaultValue, boolean required) throws IIOInvalidTreeException {
        String value;
        Node attr = node2.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            GIFMetadata.fatal(node2, "Required attribute " + name + " not present!");
        }
        if ((value = attr.getNodeValue()).equals("TRUE") || value.equals("true")) {
            return true;
        }
        if (value.equals("FALSE") || value.equals("false")) {
            return false;
        }
        GIFMetadata.fatal(node2, "Attribute " + name + " must be 'TRUE' or 'FALSE'!");
        return false;
    }

    protected static boolean getBooleanAttribute(Node node2, String name) throws IIOInvalidTreeException {
        return GIFMetadata.getBooleanAttribute(node2, name, false, true);
    }

    protected static int getEnumeratedAttribute(Node node2, String name, String[] legalNames, int defaultValue, boolean required) throws IIOInvalidTreeException {
        Node attr = node2.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            GIFMetadata.fatal(node2, "Required attribute " + name + " not present!");
        }
        String value = attr.getNodeValue();
        for (int i2 = 0; i2 < legalNames.length; ++i2) {
            if (!value.equals(legalNames[i2])) continue;
            return i2;
        }
        GIFMetadata.fatal(node2, "Illegal value for attribute " + name + "!");
        return -1;
    }

    protected static int getEnumeratedAttribute(Node node2, String name, String[] legalNames) throws IIOInvalidTreeException {
        return GIFMetadata.getEnumeratedAttribute(node2, name, legalNames, -1, true);
    }

    protected static String getAttribute(Node node2, String name, String defaultValue, boolean required) throws IIOInvalidTreeException {
        Node attr = node2.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            GIFMetadata.fatal(node2, "Required attribute " + name + " not present!");
        }
        return attr.getNodeValue();
    }

    protected static String getAttribute(Node node2, String name) throws IIOInvalidTreeException {
        return GIFMetadata.getAttribute(node2, name, null, true);
    }

    protected GIFMetadata(boolean standardMetadataFormatSupported, String nativeMetadataFormatName, String nativeMetadataFormatClassName, String[] extraMetadataFormatNames, String[] extraMetadataFormatClassNames) {
        super(standardMetadataFormatSupported, nativeMetadataFormatName, nativeMetadataFormatClassName, extraMetadataFormatNames, extraMetadataFormatClassNames);
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName.equals(this.nativeMetadataFormatName)) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    protected byte[] getColorTable(Node colorTableNode, String entryNodeName, boolean lengthExpected, int expectedLength) throws IIOInvalidTreeException {
        byte[] red = new byte[256];
        byte[] green = new byte[256];
        byte[] blue = new byte[256];
        int maxIndex = -1;
        Node entry2 = colorTableNode.getFirstChild();
        if (entry2 == null) {
            GIFMetadata.fatal(colorTableNode, "Palette has no entries!");
        }
        while (entry2 != null) {
            int index;
            if (!entry2.getNodeName().equals(entryNodeName)) {
                GIFMetadata.fatal(colorTableNode, "Only a " + entryNodeName + " may be a child of a " + entry2.getNodeName() + "!");
            }
            if ((index = GIFMetadata.getIntAttribute(entry2, "index", true, 0, 255)) > maxIndex) {
                maxIndex = index;
            }
            red[index] = (byte)GIFMetadata.getIntAttribute(entry2, "red", true, 0, 255);
            green[index] = (byte)GIFMetadata.getIntAttribute(entry2, "green", true, 0, 255);
            blue[index] = (byte)GIFMetadata.getIntAttribute(entry2, "blue", true, 0, 255);
            entry2 = entry2.getNextSibling();
        }
        int numEntries = maxIndex + 1;
        if (lengthExpected && numEntries != expectedLength) {
            GIFMetadata.fatal(colorTableNode, "Unexpected length for palette!");
        }
        byte[] colorTable = new byte[3 * numEntries];
        int j = 0;
        for (int i2 = 0; i2 < numEntries; ++i2) {
            colorTable[j++] = red[i2];
            colorTable[j++] = green[i2];
            colorTable[j++] = blue[i2];
        }
        return colorTable;
    }

    protected abstract void mergeNativeTree(Node var1) throws IIOInvalidTreeException;

    protected abstract void mergeStandardTree(Node var1) throws IIOInvalidTreeException;
}

