/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.compat.patchouli;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.spaceeye.vmod.rendering.textures.GIFManager;
import net.spaceeye.vmod.rendering.textures.GIFTexture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.book.Book;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\"\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0019H\u0016J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002J(\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u001bH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lnet/spaceeye/vmod/compat/patchouli/PageGIF;", "Lvazkii/patchouli/client/book/page/abstr/PageWithText;", "<init>", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "border", "", "getBorder", "()Z", "setBorder", "(Z)V", "images", "Ljava/util/ArrayList;", "Lnet/minecraft/resources/ResourceLocation;", "Lkotlin/collections/ArrayList;", "getImages", "()Ljava/util/ArrayList;", "setImages", "(Ljava/util/ArrayList;)V", "currentFrame", "", "time", "", "getTextHeight", "onDisplayed", "", "parent", "Lvazkii/patchouli/client/book/gui/GuiBookEntry;", "left", "top", "advanceTime", "delta", "gif", "Lnet/spaceeye/vmod/rendering/textures/GIFTexture;", "render", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "mouseY", "pticks", "VMod"})
public final class PageGIF
extends PageWithText {
    @Nullable
    private String title;
    private boolean border;
    @NotNull
    private ArrayList<ResourceLocation> images = new ArrayList();
    private transient int currentFrame;
    private transient float time;

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    public final boolean getBorder() {
        return this.border;
    }

    public final void setBorder(boolean bl) {
        this.border = bl;
    }

    @NotNull
    public final ArrayList<ResourceLocation> getImages() {
        return this.images;
    }

    public final void setImages(@NotNull ArrayList<ResourceLocation> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.images = arrayList;
    }

    public int getTextHeight() {
        return 120;
    }

    public void onDisplayed(@Nullable GuiBookEntry parent, int left2, int top) {
        super.onDisplayed(parent, left2, top);
        this.currentFrame = 0;
        this.time = 0.0f;
    }

    private final void advanceTime(float delta, GIFTexture gif) {
        if (!gif.getLoadedSuccessfully().isDone() || !gif.getLoadedSuccessfully().get().booleanValue()) {
            return;
        }
        this.time += delta / 10.0f;
        int delay2 = gif.getSprites().get(this.currentFrame / gif.getFramesPerSprite()).getDelays()[this.currentFrame % gif.getFramesPerSprite()];
        if (this.time <= (float)delay2) {
            return;
        }
        if (this.time > 100.0f) {
            this.time = 0.0f;
        }
        do {
            this.time -= (float)delay2;
            int n = this.currentFrame;
            this.currentFrame = n + 1;
            if (this.currentFrame < gif.getTotalFrames()) continue;
            this.currentFrame = 0;
        } while (!(this.time <= (float)(delay2 = gif.getSprites().get(this.currentFrame / gif.getFramesPerSprite()).getDelays()[this.currentFrame % gif.getFramesPerSprite()])));
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float pticks) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        if (this.images.isEmpty()) {
            return;
        }
        ResourceLocation resourceLocation = this.images.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"get(...)");
        GIFManager.WeakReference<GIFTexture> ref = GIFManager.INSTANCE.getTextureFromLocation(resourceLocation);
        int x = 5;
        int y = 7;
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        this.advanceTime(Minecraft.m_91087_().m_91297_() * (float)50, ref.getIt());
        PoseStack poseStack = graphics.m_280168_();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        GIFTexture.blit$default(ref.getIt(), poseStack, this.currentFrame, x * 2 + 6, y * 2 + 6, 200, 200, 0.0f, 0.0f, 0.0f, 0.0f, 960, null);
        graphics.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
        if (this.border) {
            GuiBook.drawFromTexture((GuiGraphics)graphics, (Book)this.book, (int)x, (int)y, (int)405, (int)149, (int)106, (int)106);
        }
        if (this.title != null) {
            String string = this.title;
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() > 0) {
                this.parent.drawCenteredStringNoShadow(graphics, this.i18n(this.title), 58, -3, this.book.headerColor);
            }
        }
        super.render(graphics, mouseX, mouseY, pticks);
        ref.close();
    }
}

