/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.elementa.font;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.spaceeye.elementa.UIComponent;
import net.spaceeye.elementa.constraints.ConstraintType;
import net.spaceeye.elementa.constraints.resolution.ConstraintVisitor;
import net.spaceeye.elementa.font.FontProvider;
import net.spaceeye.elementa.font.data.Atlas;
import net.spaceeye.elementa.font.data.AtlasBounds;
import net.spaceeye.elementa.font.data.Font;
import net.spaceeye.elementa.font.data.Glyph;
import net.spaceeye.elementa.font.data.PlaneBounds;
import net.spaceeye.universal.UGraphics;
import net.spaceeye.universal.UMatrixStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010B\u001a\u00020A\u00a2\u0006\u0004\bD\u0010EJG\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJY\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J?\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0015\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b!\u0010\u001cJ+\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\"2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010%\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010'\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b'\u0010&J\u001f\u0010,\u001a\u00020\r2\u0006\u0010)\u001a\u00020(2\u0006\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b,\u0010-R\"\u0010.\u001a\u00020\u00018\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R$\u00105\u001a\u0004\u0018\u0001048\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\"\u0010;\u001a\u00020\u00148\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0014\u0010B\u001a\u00020A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010C\u00a8\u0006F"}, d2={"Lnet/spaceeye/elementa/font/BasicFontRenderer;", "Lnet/spaceeye/elementa/font/FontProvider;", "Lnet/spaceeye/universal/UMatrixStack;", "matrixStack", "Lnet/spaceeye/elementa/font/data/Glyph;", "glyph", "Ljava/awt/Color;", "color", "", "x", "y", "width", "height", "", "drawGlyph", "(Lnet/spaceeye/universal/UMatrixStack;Lnet/spaceeye/elementa/font/data/Glyph;Ljava/awt/Color;FFFF)V", "", "string", "originalPointSize", "scale", "", "shadow", "shadowColor", "drawString", "(Lnet/spaceeye/universal/UMatrixStack;Ljava/lang/String;Ljava/awt/Color;FFFFZLjava/awt/Color;)V", "drawStringNow", "(Lnet/spaceeye/universal/UMatrixStack;Ljava/lang/String;Ljava/awt/Color;FFF)V", "getBaseLineHeight", "()F", "getBelowLineHeight", "pointSize", "getLineHeight", "(F)F", "getShadowHeight", "Lkotlin/Pair;", "getStringDimensions", "(Ljava/lang/String;F)Lkotlin/Pair;", "getStringHeight", "(Ljava/lang/String;F)F", "getStringWidth", "Lnet/spaceeye/elementa/constraints/resolution/ConstraintVisitor;", "visitor", "Lnet/spaceeye/elementa/constraints/ConstraintType;", "type", "visitImpl", "(Lnet/spaceeye/elementa/constraints/resolution/ConstraintVisitor;Lnet/spaceeye/elementa/constraints/ConstraintType;)V", "cachedValue", "Lnet/spaceeye/elementa/font/FontProvider;", "getCachedValue", "()Lgg/essential/elementa/font/FontProvider;", "setCachedValue", "(Lgg/essential/elementa/font/FontProvider;)V", "Lnet/spaceeye/elementa/UIComponent;", "constrainTo", "Lnet/spaceeye/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "recalculate", "Z", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "Lnet/spaceeye/elementa/font/data/Font;", "regularFont", "Lnet/spaceeye/elementa/font/data/Font;", "<init>", "(Lgg/essential/elementa/font/data/Font;)V", "Elementa"})
public final class BasicFontRenderer
implements FontProvider {
    @NotNull
    private final Font regularFont;
    @NotNull
    private FontProvider cachedValue;
    private boolean recalculate;
    @Nullable
    private UIComponent constrainTo;

    public BasicFontRenderer(@NotNull Font regularFont) {
        Intrinsics.checkNotNullParameter((Object)regularFont, (String)"regularFont");
        this.regularFont = regularFont;
        this.cachedValue = this;
    }

    @Override
    @NotNull
    public FontProvider getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(@NotNull FontProvider fontProvider) {
        Intrinsics.checkNotNullParameter((Object)fontProvider, (String)"<set-?>");
        this.cachedValue = fontProvider;
    }

    @Override
    public boolean getRecalculate() {
        return this.recalculate;
    }

    @Override
    public void setRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    @Override
    @Nullable
    public UIComponent getConstrainTo() {
        return this.constrainTo;
    }

    @Override
    public void setConstrainTo(@Nullable UIComponent uIComponent) {
        this.constrainTo = uIComponent;
    }

    @Override
    public float getStringWidth(@NotNull String string, float pointSize) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return ((Number)this.getStringDimensions(string, pointSize).getFirst()).floatValue();
    }

    @Override
    public float getStringHeight(@NotNull String string, float pointSize) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return ((Number)this.getStringDimensions(string, pointSize).getSecond()).floatValue();
    }

    private final Pair<Float, Float> getStringDimensions(String string, float pointSize) {
        float width = 0.0f;
        float height = 0.0f;
        float currentPointSize = pointSize / (float)10 * this.regularFont.getFontInfo().getAtlas().getSize();
        int i2 = 0;
        while (i2 < string.length()) {
            Glyph glyph;
            char c = string.charAt(i2);
            if (c == '\u00a7' && i2 + 1 < string.length()) {
                i2 += 2;
                continue;
            }
            Glyph glyph2 = glyph = this.regularFont.getFontInfo().getGlyphs().get(c);
            if ((glyph2 != null ? glyph2.getAtlasBounds() : null) == null) {
                ++i2;
                continue;
            }
            PlaneBounds planeBounds = glyph.getPlaneBounds();
            if (planeBounds != null) {
                height = Math.max((planeBounds.getTop() - planeBounds.getBottom()) * currentPointSize, height);
            }
            boolean lastCorrection = i2 >= string.length() - 1;
            width += (glyph.getAtlasBounds().getRight() - glyph.getAtlasBounds().getLeft() - (float)lastCorrection) / this.regularFont.getFontInfo().getAtlas().getSize() * currentPointSize;
            ++i2;
        }
        return new Pair((Object)Float.valueOf(width), (Object)Float.valueOf(height));
    }

    public final float getLineHeight(float pointSize) {
        return this.regularFont.getFontInfo().getMetrics().getLineHeight() * pointSize;
    }

    @Override
    public void drawString(@NotNull UMatrixStack matrixStack, @NotNull String string, @NotNull Color color, float x, float y, float originalPointSize, float scale, boolean shadow, @Nullable Color shadowColor) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float scaledPointSize = originalPointSize / (float)10 * this.regularFont.getFontInfo().getAtlas().getSize();
        if (shadow) {
            Color color2 = shadowColor;
            if (color2 == null) {
                color2 = new Color((color.getRGB() & 0xFCFCFC) >> 2 | color.getRGB() & 0xFF000000);
            }
            this.drawStringNow(matrixStack, string, color2, x + 1.0f, y, scaledPointSize * scale);
        }
        this.drawStringNow(matrixStack, string, color, x, y - 1.0f, scaledPointSize * scale);
    }

    @Override
    public float getBaseLineHeight() {
        return this.regularFont.getFontInfo().getAtlas().getBaseCharHeight();
    }

    @Override
    public float getShadowHeight() {
        return this.regularFont.getFontInfo().getAtlas().getShadowHeight();
    }

    @Override
    public float getBelowLineHeight() {
        return this.regularFont.getFontInfo().getAtlas().getBelowLineHeight();
    }

    private final void drawStringNow(UMatrixStack matrixStack, String string, Color color, float x, float y, float originalPointSize) {
        UGraphics.bindTexture(0, this.regularFont.getTexture().getDynamicGlId());
        float currentX = x;
        int i2 = 0;
        while (i2 < string.length()) {
            char c = string.charAt(i2);
            if (c == '\u00a7' && i2 + 1 < string.length()) {
                i2 += 2;
                continue;
            }
            Glyph glyph = this.regularFont.getFontInfo().getGlyphs().get(c);
            if (glyph == null) {
                ++i2;
                continue;
            }
            PlaneBounds planeBounds = glyph.getPlaneBounds();
            if (planeBounds != null) {
                float width = (planeBounds.getRight() - planeBounds.getLeft()) * originalPointSize;
                float height = (planeBounds.getTop() - planeBounds.getBottom()) * originalPointSize;
                this.drawGlyph(matrixStack, glyph, color, currentX, y + planeBounds.getBottom() * originalPointSize, width, height);
            }
            currentX = glyph.getAtlasBounds() != null ? (currentX += (glyph.getAtlasBounds().getRight() - glyph.getAtlasBounds().getLeft()) / this.regularFont.getFontInfo().getAtlas().getSize() * originalPointSize) : (currentX += glyph.getAdvance() * originalPointSize);
            ++i2;
        }
    }

    private final void drawGlyph(UMatrixStack matrixStack, Glyph glyph, Color color, float x, float y, float width, float height) {
        AtlasBounds atlasBounds = glyph.getAtlasBounds();
        if (atlasBounds == null) {
            return;
        }
        AtlasBounds atlasBounds2 = atlasBounds;
        Atlas atlas = this.regularFont.getFontInfo().getAtlas();
        double textureTop = 1.0 - (double)(atlasBounds2.getTop() / atlas.getHeight());
        double textureBottom = 1.0 - (double)(atlasBounds2.getBottom() / atlas.getHeight());
        double textureLeft = atlasBounds2.getLeft() / atlas.getWidth();
        double textureRight = atlasBounds2.getRight() / atlas.getWidth();
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
        double doubleX = x;
        double doubleY = y;
        worldRenderer.pos(matrixStack, doubleX, doubleY + (double)height, 0.0).tex(textureLeft, textureBottom).color(color.getRed(), color.getGreen(), color.getBlue(), 255).endVertex();
        worldRenderer.pos(matrixStack, doubleX + (double)width, doubleY + (double)height, 0.0).tex(textureRight, textureBottom).color(color.getRed(), color.getGreen(), color.getBlue(), 255).endVertex();
        worldRenderer.pos(matrixStack, doubleX + (double)width, doubleY, 0.0).tex(textureRight, textureTop).color(color.getRed(), color.getGreen(), color.getBlue(), 255).endVertex();
        worldRenderer.pos(matrixStack, doubleX, doubleY, 0.0).tex(textureLeft, textureTop).color(color.getRed(), color.getGreen(), color.getBlue(), 255).endVertex();
        worldRenderer.drawDirect();
    }

    @Override
    public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }
}

