/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.elementa.constraints.resolution;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.spaceeye.elementa.UIComponent;
import net.spaceeye.elementa.components.Window;
import net.spaceeye.elementa.constraints.ConstraintType;
import net.spaceeye.elementa.constraints.SuperConstraint;
import net.spaceeye.elementa.constraints.resolution.ConstraintResolverKt;
import net.spaceeye.elementa.constraints.resolution.DirectedAcyclicGraph;
import net.spaceeye.elementa.constraints.resolution.ResolverNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010\u0007\u001a\u00020\u00062\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\nJ\u001d\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00028\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00048\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lnet/spaceeye/elementa/constraints/resolution/ConstraintVisitor;", "", "Lnet/spaceeye/elementa/constraints/SuperConstraint;", "constraint", "Lnet/spaceeye/elementa/constraints/ConstraintType;", "type", "", "setConstraint", "(Lnet/spaceeye/elementa/constraints/SuperConstraint;Lnet/spaceeye/elementa/constraints/ConstraintType;)V", "visitChildren", "(Lnet/spaceeye/elementa/constraints/ConstraintType;)V", "visitParent", "visitSelf", "", "index", "visitSibling", "(Lnet/spaceeye/elementa/constraints/ConstraintType;I)V", "Lnet/spaceeye/elementa/UIComponent;", "component", "Lnet/spaceeye/elementa/UIComponent;", "getComponent", "()Lgg/essential/elementa/UIComponent;", "currentConstraint", "Lnet/spaceeye/elementa/constraints/SuperConstraint;", "currentConstraintType", "Lnet/spaceeye/elementa/constraints/ConstraintType;", "Lnet/spaceeye/elementa/constraints/resolution/DirectedAcyclicGraph;", "Lnet/spaceeye/elementa/constraints/resolution/ResolverNode;", "graph", "Lnet/spaceeye/elementa/constraints/resolution/DirectedAcyclicGraph;", "<init>", "(Lgg/essential/elementa/constraints/resolution/DirectedAcyclicGraph;Lgg/essential/elementa/UIComponent;)V", "Elementa"})
@SourceDebugExtension(value={"SMAP\nConstraintVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstraintVisitor.kt\ngg/essential/elementa/constraints/resolution/ConstraintVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1849#2,2:67\n*S KotlinDebug\n*F\n+ 1 ConstraintVisitor.kt\ngg/essential/elementa/constraints/resolution/ConstraintVisitor\n*L\n58#1:67,2\n*E\n"})
public final class ConstraintVisitor {
    @NotNull
    private final DirectedAcyclicGraph<ResolverNode> graph;
    @NotNull
    private final UIComponent component;
    private SuperConstraint<?> currentConstraint;
    private ConstraintType currentConstraintType;

    public ConstraintVisitor(@NotNull DirectedAcyclicGraph<ResolverNode> graph, @NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.graph = graph;
        this.component = component2;
    }

    @NotNull
    public final UIComponent getComponent() {
        return this.component;
    }

    public final void setConstraint(@NotNull SuperConstraint<?> constraint, @NotNull ConstraintType type) {
        Intrinsics.checkNotNullParameter(constraint, (String)"constraint");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.currentConstraint = constraint;
        this.currentConstraintType = type;
    }

    public final void visitParent(@NotNull ConstraintType type) {
        ConstraintType constraintType;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.component.getHasParent() || this.component instanceof Window || this.component.getParent() instanceof Window) {
            return;
        }
        SuperConstraint<?> superConstraint = this.currentConstraint;
        if (superConstraint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraint");
            superConstraint = null;
        }
        if ((constraintType = this.currentConstraintType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraintType");
            constraintType = null;
        }
        this.graph.addEdge(new ResolverNode(this.component, superConstraint, constraintType), new ResolverNode(this.component.getParent(), ConstraintResolverKt.getConstraint(this.component.getParent().getConstraints(), type), type));
    }

    public final void visitSelf(@NotNull ConstraintType type) {
        ConstraintType constraintType;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        SuperConstraint<?> superConstraint = this.currentConstraint;
        if (superConstraint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraint");
            superConstraint = null;
        }
        if ((constraintType = this.currentConstraintType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraintType");
            constraintType = null;
        }
        this.graph.addEdge(new ResolverNode(this.component, superConstraint, constraintType), new ResolverNode(this.component, ConstraintResolverKt.getConstraint(this.component.getConstraints(), type), type));
    }

    public final void visitSibling(@NotNull ConstraintType type, int index) {
        ConstraintType constraintType;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.component.getHasParent()) {
            throw new IllegalStateException(StringsKt.trimIndent((String)"\n                Error during Elementa constraint validation: the current component has no parent,\n                but visitSibling was called. This shouldn't be possible -- if you are seeing this,\n                please notify an Elementa developer ASAP!\n            "));
        }
        UIComponent sibling = this.component.getParent().getChildren().get(index);
        SuperConstraint<?> superConstraint = this.currentConstraint;
        if (superConstraint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraint");
            superConstraint = null;
        }
        if ((constraintType = this.currentConstraintType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraintType");
            constraintType = null;
        }
        ResolverNode resolverNode = new ResolverNode(this.component, superConstraint, constraintType);
        Intrinsics.checkNotNullExpressionValue((Object)sibling, (String)"sibling");
        this.graph.addEdge(resolverNode, new ResolverNode(sibling, ConstraintResolverKt.getConstraint(sibling.getConstraints(), type), type));
    }

    public final void visitChildren(@NotNull ConstraintType type) {
        ConstraintType constraintType;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        SuperConstraint<?> superConstraint = this.currentConstraint;
        if (superConstraint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraint");
            superConstraint = null;
        }
        if ((constraintType = this.currentConstraintType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraintType");
            constraintType = null;
        }
        ResolverNode currNode = new ResolverNode(this.component, superConstraint, constraintType);
        Iterable $this$forEach$iv = this.component.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UIComponent it = (UIComponent)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.graph.addEdge(currNode, new ResolverNode(it, ConstraintResolverKt.getConstraint(it.getConstraints(), type), type));
        }
    }
}

