/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.elementa.components.inspector;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.spaceeye.elementa.ElementaVersion;
import net.spaceeye.elementa.UIComponent;
import net.spaceeye.elementa.UIConstraints;
import net.spaceeye.elementa.components.ScrollComponent;
import net.spaceeye.elementa.components.TreeListComponent;
import net.spaceeye.elementa.components.TreeNode;
import net.spaceeye.elementa.components.TreeNodeBuilder;
import net.spaceeye.elementa.components.UIBlock;
import net.spaceeye.elementa.components.UIContainer;
import net.spaceeye.elementa.components.UIImage;
import net.spaceeye.elementa.components.UIText;
import net.spaceeye.elementa.components.Window;
import net.spaceeye.elementa.components.inspector.InfoBlock;
import net.spaceeye.elementa.components.inspector.Inspector;
import net.spaceeye.elementa.components.inspector.InspectorNode;
import net.spaceeye.elementa.constraints.AspectConstraint;
import net.spaceeye.elementa.constraints.CenterConstraint;
import net.spaceeye.elementa.constraints.ChildBasedMaxSizeConstraint;
import net.spaceeye.elementa.constraints.ChildBasedSizeConstraint;
import net.spaceeye.elementa.constraints.HeightConstraint;
import net.spaceeye.elementa.constraints.RelativeConstraint;
import net.spaceeye.elementa.constraints.RelativeWindowConstraint;
import net.spaceeye.elementa.constraints.SiblingConstraint;
import net.spaceeye.elementa.constraints.SuperConstraint;
import net.spaceeye.elementa.constraints.TextAspectConstraint;
import net.spaceeye.elementa.constraints.WidthConstraint;
import net.spaceeye.elementa.dsl.ComponentsKt;
import net.spaceeye.elementa.dsl.ConstraintsKt;
import net.spaceeye.elementa.dsl.UtilitiesKt;
import net.spaceeye.elementa.effects.OutlineEffect;
import net.spaceeye.elementa.effects.ScissorEffect;
import net.spaceeye.elementa.events.UIClickEvent;
import net.spaceeye.elementa.events.UIScrollEvent;
import net.spaceeye.elementa.utils.ObservableAddEvent;
import net.spaceeye.elementa.utils.ObservableClearEvent;
import net.spaceeye.elementa.utils.ObservableRemoveEvent;
import net.spaceeye.elementa.utils.OptionsKt;
import net.spaceeye.universal.UGraphics;
import net.spaceeye.universal.UMatrixStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 H2\u00020\u0001:\u0001HB;\b\u0007\u0012\u0006\u0010?\u001a\u00020\u0002\u0012\b\b\u0002\u0010A\u001a\u00020@\u0012\b\b\u0002\u0010B\u001a\u00020@\u0012\b\b\u0002\u0010C\u001a\u00020\u000f\u0012\n\b\u0002\u0010E\u001a\u0004\u0018\u00010D\u00a2\u0006\u0004\bF\u0010GJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010 \u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R$\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R(\u00106\u001a\u0004\u0018\u00010\u00042\b\u00105\u001a\u0004\u0018\u00010\u00048\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\b6\u00104\u001a\u0004\b7\u00108R\u0014\u0010:\u001a\u0002098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0014\u0010<\u001a\u0002098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010;R\u0014\u0010=\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>\u00a8\u0006I"}, d2={"Lnet/spaceeye/elementa/components/inspector/Inspector;", "Lnet/spaceeye/elementa/components/UIContainer;", "Lnet/spaceeye/elementa/UIComponent;", "component", "Lnet/spaceeye/elementa/components/inspector/InspectorNode;", "componentToNode", "(Lnet/spaceeye/elementa/UIComponent;)Lnet/spaceeye/elementa/components/inspector/InspectorNode;", "Lnet/spaceeye/universal/UMatrixStack;", "matrixStack", "", "draw", "(Lnet/spaceeye/universal/UMatrixStack;)V", "findAndSelect$Elementa", "(Lnet/spaceeye/elementa/UIComponent;)V", "findAndSelect", "", "mouseX", "mouseY", "getClickSelectTarget", "(FF)Lnet/spaceeye/elementa/UIComponent;", "Ljava/lang/StackTraceElement;", "frame", "openSourceFile", "(Ljava/lang/StackTraceElement;)V", "node", "", "up", "scrollSource$Elementa", "(Lnet/spaceeye/elementa/components/inspector/InspectorNode;Z)V", "scrollSource", "setSelectedNode$Elementa", "(Lnet/spaceeye/elementa/components/inspector/InspectorNode;)V", "setSelectedNode", "Lnet/spaceeye/elementa/components/TreeListComponent;", "TreeListComponent", "Lnet/spaceeye/elementa/components/TreeListComponent;", "Lkotlin/Pair;", "clickPos", "Lkotlin/Pair;", "container", "Lnet/spaceeye/elementa/UIComponent;", "getContainer$Elementa", "()Lgg/essential/elementa/UIComponent;", "Lnet/spaceeye/elementa/components/ScrollComponent;", "infoBlockScroller", "Lnet/spaceeye/elementa/components/ScrollComponent;", "isClickSelecting", "Z", "Lnet/spaceeye/elementa/effects/OutlineEffect;", "outlineEffect", "Lnet/spaceeye/elementa/effects/OutlineEffect;", "rootNode", "Lnet/spaceeye/elementa/components/inspector/InspectorNode;", "<set-?>", "selectedNode", "getSelectedNode$Elementa", "()Lgg/essential/elementa/components/inspector/InspectorNode;", "Lnet/spaceeye/elementa/components/UIBlock;", "separator1", "Lnet/spaceeye/elementa/components/UIBlock;", "separator2", "treeBlock", "Lnet/spaceeye/elementa/components/UIContainer;", "rootComponent", "Ljava/awt/Color;", "backgroundColor", "outlineColor", "outlineWidth", "Lnet/spaceeye/elementa/constraints/HeightConstraint;", "maxSectionHeight", "<init>", "(Lgg/essential/elementa/UIComponent;Ljava/awt/Color;Ljava/awt/Color;FLgg/essential/elementa/constraints/HeightConstraint;)V", "Companion", "Elementa"})
@SourceDebugExtension(value={"SMAP\nInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Inspector.kt\ngg/essential/elementa/components/inspector/Inspector\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ElementaVersion.kt\ngg/essential/elementa/ElementaVersion\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,362:1\n9#2,3:363\n9#2,3:366\n9#2,3:369\n9#2,3:372\n9#2,3:375\n9#2,3:378\n9#2,3:381\n9#2,3:384\n9#2,3:387\n9#2,3:390\n9#2,3:393\n9#2,3:396\n1849#3,2:399\n1849#3,2:401\n1768#3,4:409\n798#3,11:413\n185#4,6:403\n1#5:424\n*S KotlinDebug\n*F\n+ 1 Inspector.kt\ngg/essential/elementa/components/inspector/Inspector\n*L\n47#1:363,3\n54#1:366,3\n59#1:369,3\n84#1:372,3\n91#1:375,3\n115#1:378,3\n120#1:381,3\n125#1:384,3\n134#1:387,3\n139#1:390,3\n144#1:393,3\n150#1:396,3\n316#1:399,2\n318#1:401,2\n185#1:409,4\n283#1:413,11\n325#1:403,6\n*E\n"})
public final class Inspector
extends UIContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InspectorNode rootNode;
    @NotNull
    private final UIContainer treeBlock;
    @NotNull
    private TreeListComponent TreeListComponent;
    @NotNull
    private final UIComponent container;
    @Nullable
    private InspectorNode selectedNode;
    @NotNull
    private final ScrollComponent infoBlockScroller;
    @NotNull
    private final UIBlock separator1;
    @NotNull
    private final UIBlock separator2;
    @Nullable
    private Pair<Float, Float> clickPos;
    @NotNull
    private final OutlineEffect outlineEffect;
    private boolean isClickSelecting;
    @NotNull
    private static final NumberFormat percentFormat;
    private static final String INTELLIJ_REST_API;
    private static boolean hintedIntelliJSupport;
    @NotNull
    private static final List<Pair<String, String>> factoryMethods;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public Inspector(@NotNull UIComponent rootComponent, @NotNull Color backgroundColor, @NotNull Color outlineColor, float outlineWidth, @Nullable HeightConstraint maxSectionHeight) {
        void $this$_init__u24lambda_u2412;
        UIComponent uIComponent;
        void $this$_init__u24lambda_u2410;
        UIConstraints $this$_init__u24lambda_u249;
        void $this$_init__u24lambda_u247;
        UIConstraints $this$_init__u24lambda_u246;
        void $this$_init__u24lambda_u241;
        UIComponent uIComponent2;
        Intrinsics.checkNotNullParameter((Object)rootComponent, (String)"rootComponent");
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        Intrinsics.checkNotNullParameter((Object)outlineColor, (String)"outlineColor");
        this.rootNode = this.componentToNode(rootComponent);
        this.outlineEffect = new OutlineEffect(outlineColor, outlineWidth, true, false, null, 24, null);
        UIComponent $this$constrain$iv = this;
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent2 = $this$constrain$iv;
        boolean bl = false;
        UIConstraints $this$_init__u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
        boolean bl2 = false;
        $this$_init__u24lambda_u240.setWidth(new ChildBasedSizeConstraint(0.0f, 1, null));
        $this$_init__u24lambda_u240.setHeight(new ChildBasedSizeConstraint(0.0f, 1, null));
        this.setIsFloating(true);
        $this$constrain$iv = new UIBlock(backgroundColor);
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent2 = $this$constrain$iv;
        bl = false;
        $this$_init__u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
        Inspector inspector = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u241.setWidth(new ChildBasedMaxSizeConstraint());
        $this$_init__u24lambda_u241.setHeight(new ChildBasedSizeConstraint(0.0f, 1, null));
        inspector.container = ComponentsKt.childOf(ComponentsKt.effect(uIComponent2, this.outlineEffect), this);
        UIComponent $this$constrain$iv2 = new UIContainer();
        boolean $i$f$constrain2 = false;
        UIComponent $this$constrain_u24lambda_u240$iv2 = $this$constrain_u24lambda_u240$iv = $this$constrain$iv2;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$_init__u24lambda_u242 = $this$constrain_u24lambda_u240$iv2.getConstraints();
        boolean bl4 = false;
        $this$_init__u24lambda_u242.setX(new CenterConstraint());
        $this$_init__u24lambda_u242.setWidth(ConstraintsKt.plus(new ChildBasedSizeConstraint(0.0f, 1, null), UtilitiesKt.pixels$default(30, false, false, 3, null)));
        $this$_init__u24lambda_u242.setHeight(ConstraintsKt.plus(new ChildBasedMaxSizeConstraint(), UtilitiesKt.pixels$default(20, false, false, 3, null)));
        UIComponent titleBlock2 = ComponentsKt.childOf(((UIContainer)$this$constrain_u24lambda_u240$iv).onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ Inspector this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Inspector.access$setClickPos$p(this.this$0, it.getRelativeX() < 0.0f || it.getRelativeY() < 0.0f || it.getRelativeX() > $this$onMouseClick.getWidth() || it.getRelativeY() > $this$onMouseClick.getHeight() ? null : TuplesKt.to((Object)Float.valueOf(it.getRelativeX()), (Object)Float.valueOf(it.getRelativeY())));
            }
        })).onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(this){
            final /* synthetic */ Inspector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                Inspector.access$setClickPos$p(this.this$0, null);
            }
        })).onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)((Function4)new Function4<UIComponent, Float, Float, Integer, Unit>(this){
            final /* synthetic */ Inspector this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UIComponent $this$onMouseDrag, float mouseX, float mouseY, int button) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
                if (Inspector.access$getClickPos$p(this.this$0) == null) {
                    return;
                }
                if (button == 0) {
                    void $this$constrain$iv;
                    void var8_8;
                    UIComponent uIComponent = this.this$0;
                    Inspector inspector = this.this$0;
                    boolean $i$f$constrain = false;
                    void $this$constrain_u24lambda_u240$iv = var8_8 = $this$constrain$iv;
                    boolean bl = false;
                    UIConstraints $this$invoke_u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
                    boolean bl2 = false;
                    float f = inspector.getLeft() + mouseX;
                    Pair pair = Inspector.access$getClickPos$p(inspector);
                    Intrinsics.checkNotNull((Object)pair);
                    $this$invoke_u24lambda_u240.setX(UtilitiesKt.pixels$default(Float.valueOf(f - ((Number)pair.getFirst()).floatValue()), false, false, 3, null));
                    float f2 = inspector.getTop() + mouseY;
                    Pair pair2 = Inspector.access$getClickPos$p(inspector);
                    Intrinsics.checkNotNull((Object)pair2);
                    $this$invoke_u24lambda_u240.setY(UtilitiesKt.pixels$default(Float.valueOf(f2 - ((Number)pair2.getSecond()).floatValue()), false, false, 3, null));
                }
            }
        })), this.container);
        UIComponent $this$constrain$iv3 = new UIText("Inspector", false, null, 6, null);
        boolean $i$f$constrain3 = false;
        UIComponent $this$constrain_u24lambda_u240$iv3 = $this$constrain_u24lambda_u240$iv2 = $this$constrain$iv3;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$_init__u24lambda_u243 = $this$constrain_u24lambda_u240$iv3.getConstraints();
        boolean bl5 = false;
        $this$_init__u24lambda_u243.setX(UtilitiesKt.pixels$default(10, false, false, 3, null));
        $this$_init__u24lambda_u243.setY(new CenterConstraint());
        $this$_init__u24lambda_u243.setWidth(new TextAspectConstraint());
        $this$_init__u24lambda_u243.setHeight(UtilitiesKt.pixels$default(14, false, false, 3, null));
        UIText title = (UIText)ComponentsKt.childOf($this$constrain_u24lambda_u240$iv2, titleBlock2);
        $this$constrain$iv3 = UIImage.Companion.ofResourceCached("/textures/inspector/click.png");
        $i$f$constrain3 = false;
        $this$constrain_u24lambda_u240$iv3 = $this$constrain_u24lambda_u240$iv2 = $this$constrain$iv3;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$_init__u24lambda_u244 = $this$constrain_u24lambda_u240$iv3.getConstraints();
        boolean bl6 = false;
        $this$_init__u24lambda_u244.setX(new SiblingConstraint(10.0f, false, 2, null));
        $this$_init__u24lambda_u244.setY(new CenterConstraint());
        $this$_init__u24lambda_u244.setWidth(new AspectConstraint(1.0f));
        $this$_init__u24lambda_u244.setHeight(UtilitiesKt.getPixels(12));
        $this$constrain$iv3 = $this$constrain_u24lambda_u240$iv2;
        UIImage $this$_init__u24lambda_u245 = (UIImage)$this$constrain$iv3;
        boolean bl7 = false;
        $this$_init__u24lambda_u245.setTextureMinFilter(UIImage.TextureScalingMode.LINEAR);
        ComponentsKt.childOf(((UIImage)$this$constrain$iv3).onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                event.stopPropagation();
                isClickSelecting = true;
                final Window rootWindow = Window.Companion.of($this$onMouseClick);
                rootWindow.setClickInterceptor$Elementa((Function3<? super Double, ? super Double, ? super Integer, Boolean>)((Function3)new Function3<Double, Double, Integer, Boolean>(){

                    @NotNull
                    public final Boolean invoke(double mouseX, double mouseY, int n) {
                        rootWindow.setClickInterceptor$Elementa(null);
                        isClickSelecting = false;
                        UIComponent targetComponent = this.getClickSelectTarget((float)mouseX, (float)mouseY);
                        if (targetComponent != null) {
                            this.findAndSelect$Elementa(targetComponent);
                        }
                        return true;
                    }
                }));
            }
        })), titleBlock2);
        $this$constrain$iv3 = new UIBlock(outlineColor);
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv3 = bl7 = $this$constrain$iv3;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        $this$_init__u24lambda_u244 = $this$constrain_u24lambda_u240$iv3.getConstraints();
        inspector = this;
        boolean bl8 = false;
        $this$_init__u24lambda_u246.setY(new SiblingConstraint(0.0f, false, 3, null));
        $this$_init__u24lambda_u246.setHeight(UtilitiesKt.pixels$default(2, false, false, 3, null));
        inspector.separator1 = (UIBlock)ComponentsKt.childOf(bl7, this.container);
        $this$constrain$iv3 = new UIContainer();
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv3 = bl7 = $this$constrain$iv3;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        $this$_init__u24lambda_u246 = $this$constrain_u24lambda_u240$iv3.getConstraints();
        inspector = this;
        boolean bl9 = false;
        $this$_init__u24lambda_u247.setWidth(ConstraintsKt.plus(new ChildBasedSizeConstraint(0.0f, 1, null), UtilitiesKt.pixels$default(10, false, false, 3, null)));
        $this$_init__u24lambda_u247.setHeight(ConstraintsKt.plus(new ChildBasedSizeConstraint(0.0f, 1, null), UtilitiesKt.pixels$default(10, false, false, 3, null)));
        inspector.treeBlock = (UIContainer)bl7;
        UIComponent $this$constrain$iv4 = new ScrollComponent(null, 0.0f, null, false, false, false, false, 0.0f, 0.0f, null, 1023, null);
        boolean $i$f$constrain4 = false;
        UIComponent $this$constrain_u24lambda_u240$iv4 = $this$constrain_u24lambda_u240$iv3 = $this$constrain$iv4;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$_init__u24lambda_u248 = $this$constrain_u24lambda_u240$iv4.getConstraints();
        boolean bl10 = false;
        $this$_init__u24lambda_u248.setY(new SiblingConstraint(0.0f, false, 3, null));
        $this$_init__u24lambda_u248.setWidth((WidthConstraint)ConstraintsKt.boundTo((SuperConstraint)new RelativeConstraint(1.0f), this.treeBlock));
        SuperConstraint superConstraint = ConstraintsKt.boundTo((SuperConstraint)new RelativeConstraint(1.0f), this.treeBlock);
        HeightConstraint heightConstraint = maxSectionHeight;
        if (heightConstraint == null) {
            heightConstraint = new RelativeWindowConstraint(1.0f / 3.0f);
        }
        $this$_init__u24lambda_u248.setHeight(ConstraintsKt.coerceAtMost(superConstraint, heightConstraint));
        ScrollComponent treeBlockScroller = (ScrollComponent)ComponentsKt.childOf($this$constrain_u24lambda_u240$iv3, this.container);
        ComponentsKt.childOf((UIComponent)this.treeBlock, treeBlockScroller);
        $this$constrain$iv4 = new TreeListComponent(this.rootNode);
        $i$f$constrain4 = false;
        $this$constrain_u24lambda_u240$iv4 = $this$constrain_u24lambda_u240$iv3 = $this$constrain$iv4;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        $this$_init__u24lambda_u248 = $this$constrain_u24lambda_u240$iv4.getConstraints();
        inspector = this;
        boolean bl11 = false;
        $this$_init__u24lambda_u249.setX(UtilitiesKt.pixels$default(5, false, false, 3, null));
        $this$_init__u24lambda_u249.setY(ConstraintsKt.plus(new SiblingConstraint(0.0f, false, 3, null), UtilitiesKt.pixels$default(5, false, false, 3, null)));
        inspector.TreeListComponent = (TreeListComponent)ComponentsKt.childOf($this$constrain_u24lambda_u240$iv3, this.treeBlock);
        $this$constrain$iv4 = new UIBlock(outlineColor);
        $i$f$constrain4 = false;
        $this$constrain_u24lambda_u240$iv4 = $this$constrain_u24lambda_u240$iv3 = $this$constrain$iv4;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        $this$_init__u24lambda_u249 = $this$constrain_u24lambda_u240$iv4.getConstraints();
        inspector = this;
        boolean bl12 = false;
        $this$_init__u24lambda_u2410.setY(new SiblingConstraint(0.0f, false, 3, null));
        $this$_init__u24lambda_u2410.setHeight(UtilitiesKt.pixels$default(2, false, false, 3, null));
        inspector.separator2 = (UIBlock)$this$constrain_u24lambda_u240$iv3;
        UIComponent $this$constrain$iv5 = new InfoBlock(this);
        boolean $i$f$constrain5 = false;
        UIComponent $this$constrain_u24lambda_u240$iv5 = uIComponent = $this$constrain$iv5;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$_init__u24lambda_u2411 = $this$constrain_u24lambda_u240$iv5.getConstraints();
        boolean bl13 = false;
        $this$_init__u24lambda_u2411.setY(new SiblingConstraint(0.0f, false, 3, null));
        $this$_init__u24lambda_u2411.setWidth(ConstraintsKt.plus(new ChildBasedMaxSizeConstraint(), UtilitiesKt.pixels$default(10, false, false, 3, null)));
        $this$_init__u24lambda_u2411.setHeight(ConstraintsKt.plus(new ChildBasedSizeConstraint(0.0f, 1, null), UtilitiesKt.pixels$default(10, false, false, 3, null)));
        InfoBlock infoBlock = (InfoBlock)uIComponent;
        $this$constrain$iv5 = new ScrollComponent(null, 0.0f, null, false, false, false, false, 0.0f, 0.0f, null, 1023, null);
        $i$f$constrain5 = false;
        $this$constrain_u24lambda_u240$iv5 = uIComponent = $this$constrain$iv5;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        $this$_init__u24lambda_u2411 = $this$constrain_u24lambda_u240$iv5.getConstraints();
        inspector = this;
        boolean bl14 = false;
        $this$_init__u24lambda_u2412.setY(new SiblingConstraint(0.0f, false, 3, null));
        $this$_init__u24lambda_u2412.setWidth((WidthConstraint)ConstraintsKt.boundTo((SuperConstraint)new RelativeConstraint(1.0f), infoBlock));
        SuperConstraint superConstraint2 = ConstraintsKt.boundTo((SuperConstraint)new RelativeConstraint(1.0f), infoBlock);
        HeightConstraint heightConstraint2 = maxSectionHeight;
        if (heightConstraint2 == null) {
            heightConstraint2 = new RelativeWindowConstraint(1.0f / 3.0f);
        }
        $this$_init__u24lambda_u2412.setHeight(ConstraintsKt.coerceAtMost(superConstraint2, heightConstraint2));
        inspector.infoBlockScroller = (ScrollComponent)uIComponent;
        ComponentsKt.childOf((UIComponent)infoBlock, this.infoBlockScroller);
        final Ref.BooleanRef recursive = new Ref.BooleanRef();
        this.onMouseScroll((Function2<? super UIComponent, ? super UIScrollEvent, Unit>)((Function2)new Function2<UIComponent, UIScrollEvent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseScroll, @NotNull UIScrollEvent event) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseScroll, (String)"$this$onMouseScroll");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (recursive.element) {
                    return;
                }
                recursive.element = true;
                treeBlock.mouseScroll(event.getDelta());
                recursive.element = false;
            }
        }));
    }

    public /* synthetic */ Inspector(UIComponent uIComponent, Color color, Color color2, float f, HeightConstraint heightConstraint, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            color = new Color(40, 40, 40);
        }
        if ((n & 4) != 0) {
            color2 = new Color(20, 20, 20);
        }
        if ((n & 8) != 0) {
            f = 2.0f;
        }
        if ((n & 0x10) != 0) {
            heightConstraint = null;
        }
        this(uIComponent, color, color2, f, heightConstraint);
    }

    @NotNull
    public final UIComponent getContainer$Elementa() {
        return this.container;
    }

    @Nullable
    public final InspectorNode getSelectedNode$Elementa() {
        return this.selectedNode;
    }

    private final InspectorNode componentToNode(UIComponent component2) {
        TreeNode treeNode = new InspectorNode(this, component2).withChildren((Function1<? super TreeNodeBuilder, Unit>)((Function1)new Function1<TreeNodeBuilder, Unit>(component2, this){
            final /* synthetic */ UIComponent $component;
            final /* synthetic */ Inspector this$0;
            {
                this.$component = $component;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TreeNodeBuilder $this$withChildren) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$withChildren, (String)"$this$withChildren");
                Iterable iterable = this.$component.getChildren();
                Inspector inspector = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    UIComponent it = (UIComponent)element$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)inspector)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    $this$withChildren.add(Inspector.access$componentToNode(inspector, it));
                }
            }
        }));
        Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type gg.essential.elementa.components.inspector.InspectorNode");
        InspectorNode node2 = (InspectorNode)treeNode;
        component2.getChildren().addObserver((arg_0, arg_1) -> Inspector.componentToNode$lambda$14(node2, this, component2, arg_0, arg_1));
        return node2;
    }

    public final void setSelectedNode$Elementa(@Nullable InspectorNode node2) {
        StackTraceElement source;
        if (node2 == null) {
            this.container.removeChild(this.separator2);
            this.container.removeChild(this.infoBlockScroller);
        } else if (this.selectedNode == null) {
            ComponentsKt.childOf((UIComponent)this.separator2, this.container);
            ComponentsKt.childOf((UIComponent)this.infoBlockScroller, this.container);
        }
        this.selectedNode = node2;
        if (node2 != null && (source = node2.getTargetComponent().getPrimarySource$Elementa()) != null) {
            List<StackTraceElement> list = node2.getTargetComponent().getFilteredSource$Elementa();
            Intrinsics.checkNotNull(list);
            node2.setSelectedSourceIndex$Elementa(list.indexOf(source));
            this.openSourceFile(source);
        }
    }

    public final void scrollSource$Elementa(@NotNull InspectorNode node2, boolean up) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        List<StackTraceElement> list = node2.getTargetComponent().getFilteredSource$Elementa();
        if (list == null) {
            return;
        }
        List<StackTraceElement> elements = list;
        int index = node2.getSelectedSourceIndex$Elementa();
        index = RangesKt.coerceIn((int)(index + (up ? 1 : -1)), (ClosedRange)((ClosedRange)CollectionsKt.getIndices((Collection)elements)));
        node2.setSelectedSourceIndex$Elementa(index);
        this.openSourceFile(elements.get(index));
    }

    private final void openSourceFile(StackTraceElement frame) {
        String string = frame.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"frame.className");
        String folder = StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null), (String)".", (String)"/", (boolean)false, (int)4, null);
        String file = folder + '/' + frame.getFileName();
        int line = frame.getLineNumber();
        try {
            URL url = new URL(INTELLIJ_REST_API + "/api/file?file=" + file + "&line=" + line + "&focused=false");
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Referer", "http://localhost");
            conn.connect();
            conn.getInputStream().skip(Long.MAX_VALUE);
        }
        catch (ConnectException url) {
        }
        catch (FileNotFoundException e) {
            if (!hintedIntelliJSupport) {
                hintedIntelliJSupport = true;
                String string2 = "IntelliJ detected! Install JetBrain's `IDE Remote Control` plugin to automatically jump to the source of the selected component.";
                System.out.println((Object)string2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final UIComponent getClickSelectTarget(float mouseX, float mouseY) {
        UIComponent hitComponent;
        UIComponent rootComponent = this.rootNode.getTargetComponent();
        UIComponent uIComponent = rootComponent instanceof Window ? (Window)rootComponent : null;
        if (uIComponent == null || (uIComponent = ((Window)uIComponent).getHoveredFloatingComponent()) == null || (uIComponent = uIComponent.hitTest(mouseX, mouseY)) == null) {
            uIComponent = rootComponent.hitTest(mouseX, mouseY);
        }
        return Intrinsics.areEqual((Object)(hitComponent = uIComponent), (Object)this) || hitComponent.isChildOf(this) ? null : hitComponent;
    }

    public final void findAndSelect$Elementa(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        InspectorNode inspectorNode = Inspector.findAndSelect$findNodeAndExpandParents(this, component2);
        if (inspectorNode == null) {
            return;
        }
        InspectorNode node2 = inspectorNode;
        if (!Intrinsics.areEqual((Object)this.selectedNode, (Object)node2)) {
            node2.toggleSelection$Elementa();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        UIComponent uIComponent;
        UIComponent uIComponent2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.separator1.setWidth(UtilitiesKt.pixels$default(Float.valueOf(this.container.getWidth()), false, false, 3, null));
        this.separator2.setWidth(UtilitiesKt.pixels$default(Float.valueOf(this.container.getWidth()), false, false, 3, null));
        if (this.isClickSelecting) {
            object = this.getMousePosition();
            float mouseX = ((Number)object.component1()).floatValue();
            float mouseY = ((Number)object.component2()).floatValue();
            uIComponent2 = this.getClickSelectTarget(mouseX, mouseY);
        } else {
            InspectorNode inspectorNode = this.selectedNode;
            uIComponent2 = uIComponent = inspectorNode != null ? inspectorNode.getTargetComponent() : null;
        }
        if (uIComponent != null) {
            ScissorEffect it;
            Object component2 = object = uIComponent;
            boolean bl = false;
            List scissors2 = CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.generateSequence(component2, (Function1)draw.1.scissors.1.INSTANCE), (Function1)draw.1.scissors.2.INSTANCE)));
            double x1 = ((UIComponent)component2).getLeft();
            double y1 = ((UIComponent)component2).getTop();
            double x2 = ((UIComponent)component2).getRight();
            double y2 = ((UIComponent)component2).getBottom();
            UGraphics.glClear(256);
            Iterable $this$forEach$iv = scissors2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ScissorEffect)element$iv;
                boolean bl2 = false;
                it.beforeDraw(matrixStack);
            }
            UIBlock.Companion.drawBlock(matrixStack, new Color(129, 212, 250, 100), x1, y1, x2, y2);
            $this$forEach$iv = CollectionsKt.asReversed((List)scissors2);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ScissorEffect)element$iv;
                boolean bl3 = false;
                it.afterDraw(matrixStack);
            }
            UGraphics.enableDepth();
            UGraphics.depthFunc(513);
            ElementaVersion this_$iv = ElementaVersion.Companion.getV0$Elementa();
            boolean $i$f$enableFor = false;
            ElementaVersion prevVersion$iv = ElementaVersion.Companion.getActive();
            ElementaVersion.Companion.setActive(this_$iv);
            try {
                boolean bl4 = false;
                UIBlock.Companion.drawBlock(matrixStack, new Color(255, 100, 100, 100), x1, y1, x2, y2);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                ElementaVersion.Companion.setActive(prevVersion$iv);
            }
            UGraphics.depthFunc(515);
            UGraphics.disableDepth();
        }
        boolean debugState = OptionsKt.getElementaDebug();
        OptionsKt.setElementaDebug(false);
        try {
            super.draw(matrixStack);
        }
        finally {
            OptionsKt.setElementaDebug(debugState);
        }
    }

    @JvmOverloads
    public Inspector(@NotNull UIComponent rootComponent, @NotNull Color backgroundColor, @NotNull Color outlineColor, float outlineWidth) {
        Intrinsics.checkNotNullParameter((Object)rootComponent, (String)"rootComponent");
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        Intrinsics.checkNotNullParameter((Object)outlineColor, (String)"outlineColor");
        this(rootComponent, backgroundColor, outlineColor, outlineWidth, null, 16, null);
    }

    @JvmOverloads
    public Inspector(@NotNull UIComponent rootComponent, @NotNull Color backgroundColor, @NotNull Color outlineColor) {
        Intrinsics.checkNotNullParameter((Object)rootComponent, (String)"rootComponent");
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        Intrinsics.checkNotNullParameter((Object)outlineColor, (String)"outlineColor");
        this(rootComponent, backgroundColor, outlineColor, 0.0f, null, 24, null);
    }

    @JvmOverloads
    public Inspector(@NotNull UIComponent rootComponent, @NotNull Color backgroundColor) {
        Intrinsics.checkNotNullParameter((Object)rootComponent, (String)"rootComponent");
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        this(rootComponent, backgroundColor, null, 0.0f, null, 28, null);
    }

    @JvmOverloads
    public Inspector(@NotNull UIComponent rootComponent) {
        Intrinsics.checkNotNullParameter((Object)rootComponent, (String)"rootComponent");
        this(rootComponent, null, null, 0.0f, null, 30, null);
    }

    private static final void componentToNode$lambda$14(InspectorNode $node, Inspector this$0, UIComponent $component, Observable observable2, Object event) {
        int n;
        IndexedValue indexedValue;
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        Object object = event;
        if (object instanceof ObservableAddEvent) {
            indexedValue = ((ObservableAddEvent)event).getElement();
        } else if (object instanceof ObservableRemoveEvent) {
            indexedValue = ((ObservableRemoveEvent)event).getElement();
        } else {
            if (object instanceof ObservableClearEvent) {
                $node.clearChildren();
                return;
            }
            return;
        }
        IndexedValue indexedValue2 = indexedValue;
        int index = indexedValue2.component1();
        Object childComponent = indexedValue2.component2();
        if (Intrinsics.areEqual((Object)childComponent, (Object)this$0)) {
            return;
        }
        Iterable $this$count$iv = (Iterable)RangesKt.until((int)0, (int)index);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator = $this$count$iv.iterator();
            while (iterator.hasNext()) {
                int n2;
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)$component.getChildren().get(it), (Object)this$0) || (n2 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int offset2 = -n;
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
        Object object2 = event;
        if (object2 instanceof ObservableAddEvent) {
            Intrinsics.checkNotNull((Object)childComponent, (String)"null cannot be cast to non-null type gg.essential.elementa.UIComponent");
            InspectorNode childNode = this$0.componentToNode((UIComponent)childComponent);
            $node.addChildAt(index + offset2, childNode);
        } else if (object2 instanceof ObservableRemoveEvent) {
            $node.removeChildAt(index + offset2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final InspectorNode findAndSelect$findNodeAndExpandParents(Inspector this$0, UIComponent component2) {
        Object v1;
        block5: {
            Iterable iterable;
            void $this$filterIsInstanceTo$iv$iv;
            if (Intrinsics.areEqual((Object)component2, (Object)this$0.rootNode.getTargetComponent())) {
                return this$0.rootNode;
            }
            if (Intrinsics.areEqual((Object)component2.getParent(), (Object)component2)) {
                return null;
            }
            InspectorNode inspectorNode = Inspector.findAndSelect$findNodeAndExpandParents(this$0, component2.getParent());
            if (inspectorNode == null) {
                return null;
            }
            InspectorNode parentNode = inspectorNode;
            TreeNode.TreeNodeComponent parentDisplay = parentNode.getDisplayComponent();
            parentDisplay.setOpened$Elementa(true);
            Iterable $this$filterIsInstance$iv = parentDisplay.getChildNodes$Elementa();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof InspectorNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable3 = iterable = (Iterable)((List)destination$iv$iv);
            for (Object e : iterable3) {
                InspectorNode it = (InspectorNode)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTargetComponent(), (Object)component2)) continue;
                v1 = e;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    public static final /* synthetic */ InspectorNode access$componentToNode(Inspector $this, UIComponent component2) {
        return $this.componentToNode(component2);
    }

    public static final /* synthetic */ void access$setClickPos$p(Inspector $this, Pair pair) {
        $this.clickPos = pair;
    }

    public static final /* synthetic */ Pair access$getClickPos$p(Inspector $this) {
        return $this.clickPos;
    }

    static {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"getPercentInstance()");
        percentFormat = numberFormat;
        INTELLIJ_REST_API = System.getProperty("elementa.intellij_rest_api", "http://localhost:63342");
        factoryMethods = new ArrayList();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\t\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u001c\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR.\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000f0\u000e8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u00178\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lnet/spaceeye/elementa/components/inspector/Inspector$Companion;", "", "", "callerClassName", "()Ljava/lang/String;", "Ljava/lang/Class;", "cls", "method", "", "registerComponentFactory", "(Ljava/lang/Class;Ljava/lang/String;)V", "kotlin.jvm.PlatformType", "INTELLIJ_REST_API", "Ljava/lang/String;", "", "Lkotlin/Pair;", "factoryMethods", "Ljava/util/List;", "getFactoryMethods$Elementa", "()Ljava/util/List;", "", "hintedIntelliJSupport", "Z", "Ljava/text/NumberFormat;", "percentFormat", "Ljava/text/NumberFormat;", "getPercentFormat$Elementa", "()Ljava/text/NumberFormat;", "<init>", "()V", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NumberFormat getPercentFormat$Elementa() {
            return percentFormat;
        }

        @NotNull
        public final List<Pair<String, String>> getFactoryMethods$Elementa() {
            return factoryMethods;
        }

        public final void registerComponentFactory(@Nullable Class<?> cls, @Nullable String method) {
            if (!OptionsKt.getDevPropSet()) {
                return;
            }
            List<Pair<String, String>> list = this.getFactoryMethods$Elementa();
            Class<?> clazz = cls;
            String string = clazz != null ? clazz.getName() : null;
            if (string == null) {
                string = this.callerClassName();
            }
            list.add((Pair<String, String>)new Pair((Object)string, (Object)method));
        }

        public static /* synthetic */ void registerComponentFactory$default(Companion companion, Class clazz, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            companion.registerComponentFactory(clazz, string);
        }

        private final String callerClassName() {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"Throwable().stackTrace");
            String string = ((StackTraceElement)SequencesKt.first((Sequence)SequencesKt.drop((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])stackTraceElementArray), (Function1)callerClassName.1.INSTANCE), (int)2))).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Throwable().stackTrace.a\u2026               .className");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

