/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.core;

import knightminer.simplytea.core.config.CocoaDrink;
import knightminer.simplytea.core.config.TeaDrink;
import knightminer.simplytea.core.config.Teapot;
import knightminer.simplytea.core.config.Tree;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public TeaDrink black_tea;
        public TeaDrink green_tea;
        public TeaDrink floral_tea;
        public TeaDrink chai_tea;
        public TeaDrink chorus_tea;
        public TeaDrink iced_tea;
        public CocoaDrink cocoa;
        public Teapot teapot;
        public Tree tree;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Stats for each available drink type").push("drinks");
            this.floral_tea = new TeaDrink("floral", builder, TeaDrink.TeaEffect.RESTFUL, 1, 0.5, 60, 2);
            this.green_tea = new TeaDrink("green", builder, TeaDrink.TeaEffect.RELAXED, 3, 0.5, 120, 2);
            this.black_tea = new TeaDrink("black", builder, TeaDrink.TeaEffect.CAFFEINATED, 4, 0.8, 210, 2);
            this.chai_tea = new TeaDrink("chai", builder, TeaDrink.TeaEffect.INVIGORATED, 5, 0.6, 150, 1);
            this.chorus_tea = new TeaDrink("chorus", builder, TeaDrink.TeaEffect.ENDERFALLING, 3, 0.9, 150, 1);
            this.iced_tea = new TeaDrink("iced", builder, TeaDrink.TeaEffect.ABSORPTION, 3, 0.9, 90, 1);
            this.cocoa = new CocoaDrink(builder, 4, 0.6);
            builder.pop();
            this.teapot = new Teapot(builder);
            this.tree = new Tree(builder);
        }
    }
}

