/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.block;

import java.util.List;
import java.util.Locale;
import knightminer.simplytea.core.Config;
import knightminer.simplytea.core.Registration;
import knightminer.simplytea.core.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;

public class TeaTrunkBlock
extends Block {
    public static final EnumProperty<TrunkType> TYPE = EnumProperty.m_61587_((String)"type", TrunkType.class);
    public static final BooleanProperty CLIPPED = BooleanProperty.m_61465_((String)"clipped");
    public static final ResourceLocation LEAVES_DROPS = new ResourceLocation("simplytea", "blocks/tea_leaves");
    public static final VoxelShape BOUNDS_STUMP = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape[] BOUNDS_UNCLIPPED = new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)12.0), Block.m_49796_((double)4.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.m_49796_((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0)};
    public static final VoxelShape[] BOUNDS_CLIPPED = new VoxelShape[]{Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)8.0, (double)9.5), Block.m_49796_((double)6.5, (double)6.5, (double)0.0, (double)9.5, (double)9.5, (double)8.0), Block.m_49796_((double)8.0, (double)6.5, (double)6.5, (double)16.0, (double)9.5, (double)9.5), Block.m_49796_((double)6.5, (double)6.5, (double)8.0, (double)9.5, (double)9.5, (double)16.0), Block.m_49796_((double)0.0, (double)6.5, (double)6.5, (double)8.0, (double)9.5, (double)9.5)};

    public TeaTrunkBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)TrunkType.STUMP))).m_61124_((Property)CLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    @Deprecated
    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        if (state.m_60734_() == this && ((Boolean)state.m_61143_((Property)CLIPPED)).booleanValue() && (double)random.m_188501_() < Config.SERVER.tree.regrowthChance()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)CLIPPED, (Comparable)Boolean.valueOf(false)));
            world.m_7260_(pos, state, (BlockState)state.m_61124_((Property)CLIPPED, (Comparable)Boolean.valueOf(false)), 8);
        }
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)Registration.tea_sapling);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (state.m_60734_() != this || ((Boolean)state.m_61143_((Property)CLIPPED)).booleanValue() || state.m_61143_(TYPE) == TrunkType.STUMP) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        Item item = heldItem.m_41720_();
        if (item instanceof ShearsItem || heldItem.canPerformAction(ToolActions.SHEARS_HARVEST)) {
            ItemStack stack = heldItem.m_41777_();
            stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
            player.m_21008_(hand, stack);
            if (world instanceof ServerLevel) {
                List<ItemStack> drops = Util.getBlockLoot(state, (ServerLevel)world, pos, player, heldItem, LEAVES_DROPS);
                for (ItemStack drop : drops) {
                    TeaTrunkBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
                }
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)CLIPPED, (Comparable)Boolean.valueOf(true)), 8);
            world.m_7260_(pos, state, (BlockState)state.m_61124_((Property)CLIPPED, (Comparable)Boolean.valueOf(true)), 8);
            world.m_5594_(player, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_60734_() != this) {
            return BOUNDS_STUMP;
        }
        TrunkType type = (TrunkType)((Object)state.m_61143_(TYPE));
        if (type == TrunkType.STUMP) {
            return BOUNDS_STUMP;
        }
        return ((Boolean)state.m_61143_((Property)CLIPPED) != false ? BOUNDS_CLIPPED : BOUNDS_UNCLIPPED)[type.getIndex() - 1];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, CLIPPED});
    }

    public static enum TrunkType implements StringRepresentable
    {
        STUMP,
        BOTTOM,
        MIDDLE,
        TOP,
        NORTH,
        EAST,
        SOUTH,
        WEST;

        private int index = this.ordinal();

        public int getIndex() {
            return this.index;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.US);
        }

        public static TrunkType fromIndex(int index) {
            if (index < 0 || index >= TrunkType.values().length) {
                index = 0;
            }
            return TrunkType.values()[index];
        }
    }
}

