/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.block.wood.PineLogBlock;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class StrippedPineTreeFeature
extends Feature<RuTreeConfiguration> {
    public StrippedPineTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int height_main = context.m_225041_().m_188503_(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int check = 0; check <= height_main; ++check) {
            if (check == height_main / 2 && !this.checkReplaceableBlob((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        int rnd = randomSource.m_188503_(2) + 4;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            if (placeCheck < height_main / rnd) {
                this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y, true, false);
            } else if (placeCheck == height_main / rnd) {
                this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y, false, true);
            } else {
                this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y, false, false);
                this.placeBranchDecorator((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == height_main) {
                if (randomSource.m_188503_(11) == 0) {
                    this.placeTop3((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                } else if (randomSource.m_188503_(11) <= 5) {
                    this.placeTop2((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                } else {
                    this.placeTop1((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                }
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public void placeTop1(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() - randomSource.m_188503_(2), pos.m_123343_());
        this.placeBlobTop(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobMed(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobBig(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobMed(level, (BlockPos)placePos, randomSource, treeConfiguration);
        if (randomSource.m_188503_(3) == 0) {
            this.placeBlobXBig(level, (BlockPos)placePos, randomSource, treeConfiguration);
        }
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        }
    }

    public void placeTop2(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() - randomSource.m_188503_(2), pos.m_123343_());
        this.placeBlobTop(level, (BlockPos)placePos, randomSource, treeConfiguration);
        this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobMed(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobMed(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobBig(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122013_(2), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122013_(2), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122020_(2), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122020_(2), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeBlobXBig(level, (BlockPos)placePos, randomSource, treeConfiguration);
        }
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
    }

    public void placeTop3(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() - randomSource.m_188503_(2), pos.m_123343_());
        this.placeBlobTop(level, (BlockPos)placePos, randomSource, treeConfiguration);
        this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        if (randomSource.m_188503_(3) == 0) {
            placePos.m_122173_(Direction.DOWN);
            this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        }
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, placePos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        }
        placePos.m_122173_(Direction.DOWN);
        this.placeBlobXSmall(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.m_122173_(Direction.DOWN);
        placePos.m_122173_(Direction.DOWN);
        if (randomSource.m_188503_(2) == 0) {
            placePos.m_122173_(Direction.DOWN);
        }
        this.placeRandomLogDecoration(level, (BlockPos)placePos, randomSource, treeConfiguration);
    }

    public void placeRandomLogDecoration(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        int chance = randomSource.m_188503_(10);
        if (chance == 0) {
            this.placeLog(level, pos.m_122012_(), randomSource, treeConfiguration, Direction.Axis.Z, false, false);
        } else if (chance == 1) {
            this.placeLog(level, pos.m_122019_(), randomSource, treeConfiguration, Direction.Axis.Z, false, false);
        } else if (chance == 2) {
            this.placeLog(level, pos.m_122029_(), randomSource, treeConfiguration, Direction.Axis.X, false, false);
        } else if (chance == 3) {
            this.placeLog(level, pos.m_122024_(), randomSource, treeConfiguration, Direction.Axis.X, false, false);
        } else {
            return;
        }
    }

    public void placeBlobTop(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        this.placeLeavesBlock(level, pos.m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_6630_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_6630_(3), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122024_(), randomSource, treeConfiguration);
    }

    public void placeBlobXBig(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(3).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(3).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(3).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(3).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(3).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(3).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(3).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(3).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(3), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(3), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(3), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(3), randomSource, treeConfiguration);
    }

    public void placeBlobBig(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2).m_122019_(), randomSource, treeConfiguration);
    }

    public void placeBlobMed(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2), randomSource, treeConfiguration);
    }

    public void placeBlobSmall(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
    }

    public void placeBlobXSmall(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, Direction.Axis axis, boolean isStripped, boolean isTransition) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (StrippedPineTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            if (treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_60734_() instanceof PineLogBlock) {
                level.m_7731_(pos, (BlockState)((BlockState)((BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis)).m_61124_((Property)PineLogBlock.IS_STRIPPED, (Comparable)Boolean.valueOf(isStripped))).m_61124_((Property)PineLogBlock.TRANSITION_BLOCK, (Comparable)Boolean.valueOf(isTransition)), 2);
            } else {
                level.m_7731_(pos, (BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 2);
            }
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public void placeBranchDecorator(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (randomSource.m_188503_(10) == 0) {
            int rd = random.nextInt(4);
            if (rd == 0) {
                this.placeNorthBranch(level, pos, randomSource, treeConfiguration);
            } else if (rd == 1) {
                this.placeSouthBranch(level, pos, randomSource, treeConfiguration);
            } else if (rd == 2) {
                this.placeEastBranch(level, pos, randomSource, treeConfiguration);
            } else {
                this.placeWestBranch(level, pos, randomSource, treeConfiguration);
            }
        }
    }

    public void placeNorthBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122012_()).m_247087_() && !level.m_151570_(pos.m_122012_())) {
            level.m_7731_(pos.m_122012_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.NORTH), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_7494_())) {
            level.m_7731_(pos.m_122012_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122012_())) {
            level.m_7731_(pos.m_122012_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122029_())) {
            level.m_7731_(pos.m_122012_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122024_())) {
            level.m_7731_(pos.m_122012_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeSouthBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122019_()).m_247087_() && !level.m_151570_(pos.m_122019_())) {
            level.m_7731_(pos.m_122019_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_7494_())) {
            level.m_7731_(pos.m_122019_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122019_())) {
            level.m_7731_(pos.m_122019_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122029_())) {
            level.m_7731_(pos.m_122019_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122024_())) {
            level.m_7731_(pos.m_122019_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeEastBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122029_()).m_247087_() && !level.m_151570_(pos.m_122029_())) {
            level.m_7731_(pos.m_122029_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.EAST), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_7494_())) {
            level.m_7731_(pos.m_122029_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122029_())) {
            level.m_7731_(pos.m_122029_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122019_())) {
            level.m_7731_(pos.m_122029_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122012_())) {
            level.m_7731_(pos.m_122029_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeWestBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122024_()).m_247087_() && !level.m_151570_(pos.m_122024_())) {
            level.m_7731_(pos.m_122024_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.WEST), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_7494_())) {
            level.m_7731_(pos.m_122024_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122024_())) {
            level.m_7731_(pos.m_122024_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122019_())) {
            level.m_7731_(pos.m_122024_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122012_())) {
            level.m_7731_(pos.m_122024_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 4;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            if (level.m_8055_((BlockPos)placePos).m_247087_() && level.m_8055_(placePos.m_7494_()).m_204336_(BlockTags.f_144274_)) {
                level.m_7731_((BlockPos)placePos, Blocks.f_152548_.m_49966_(), 2);
                break;
            }
            if (!level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_144274_) && !level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_278411_) && !level.m_46859_((BlockPos)placePos)) break;
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y, true, false);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean checkReplaceableBlob(LevelAccessor level, BlockPos pos) {
        if (!this.checkReplaceable(level, pos.m_122012_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122019_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122029_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122024_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122012_().m_122029_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122012_().m_122024_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122019_().m_122029_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122019_().m_122024_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122013_(2))) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122020_(2))) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122030_(2))) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122025_(2))) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122013_(2).m_122029_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122013_(2).m_122024_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122020_(2).m_122029_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122020_(2).m_122024_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122030_(2).m_122012_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122030_(2).m_122019_())) {
            return false;
        }
        if (!this.checkReplaceable(level, pos.m_122025_(2).m_122012_())) {
            return false;
        }
        return this.checkReplaceable(level, pos.m_122025_(2).m_122019_());
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return StrippedPineTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, StrippedPineTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, StrippedPineTreeFeature::isReplaceableBlock);
    }
}

