/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.recipe_types.alchemist_cauldron;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.registries.RecipeRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class FillAlchemistCauldronRecipe
extends Record
implements Recipe<Container> {
    private final ResourceLocation getId;
    private final Ingredient input;
    private final ItemStack returned;
    private final FluidStack result;
    private final boolean mustFitAll;
    private final Holder<SoundEvent> fillSound;

    public FillAlchemistCauldronRecipe(ResourceLocation getId, Ingredient input, ItemStack returned, FluidStack result, boolean mustFitAll, Holder<SoundEvent> fillSound) {
        this.getId = getId;
        this.input = input;
        this.returned = returned;
        this.result = result;
        this.mustFitAll = mustFitAll;
        this.fillSound = fillSound;
    }

    public FluidStack result() {
        return this.result.copy();
    }

    public ItemStack returned() {
        return this.returned.m_41777_();
    }

    public boolean m_5818_(Container input, Level level) {
        return this.input.test(input.m_8020_(0));
    }

    public ItemStack m_5874_(Container input, RegistryAccess registries) {
        return this.returned.m_41777_();
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registries) {
        return this.returned.m_41777_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.ALCHEMIST_CAULDRON_FILL_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.ALCHEMIST_CAULDRON_FILL_TYPE.get();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{FillAlchemistCauldronRecipe.class, "getId;input;returned;result;mustFitAll;fillSound", "getId", "input", "returned", "result", "mustFitAll", "fillSound"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FillAlchemistCauldronRecipe.class, "getId;input;returned;result;mustFitAll;fillSound", "getId", "input", "returned", "result", "mustFitAll", "fillSound"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FillAlchemistCauldronRecipe.class, "getId;input;returned;result;mustFitAll;fillSound", "getId", "input", "returned", "result", "mustFitAll", "fillSound"}, this, o);
    }

    public ResourceLocation m_6423_() {
        return this.getId;
    }

    public Ingredient input() {
        return this.input;
    }

    public boolean mustFitAll() {
        return this.mustFitAll;
    }

    public Holder<SoundEvent> fillSound() {
        return this.fillSound;
    }

    public static class Serializer
    implements RecipeSerializer<FillAlchemistCauldronRecipe> {
        public FillAlchemistCauldronRecipe fromJson(ResourceLocation id, JsonObject recipejson) {
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)recipejson, (String)"input"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)recipejson, (String)"result"));
            FluidStack fluid = (FluidStack)((Pair)FluidStack.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_289747_((JsonObject)recipejson, (String)"fluid")).getOrThrow(false, arg_0 -> ((Logger)IronsSpellbooks.LOGGER).error(arg_0))).getFirst();
            boolean mustFitAll = GsonHelper.m_13855_((JsonObject)recipejson, (String)"mustFitAll", (boolean)true);
            Holder sound = BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11769_);
            if (recipejson.has("sound")) {
                sound = (Holder)((Pair)BuiltInRegistries.f_256894_.m_206110_().decode((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_289747_((JsonObject)recipejson, (String)"sound")).getOrThrow(false, arg_0 -> ((Logger)IronsSpellbooks.LOGGER).error(arg_0))).getFirst();
            }
            return new FillAlchemistCauldronRecipe(id, input, result, fluid, mustFitAll, (Holder<SoundEvent>)sound);
        }

        @Nullable
        public FillAlchemistCauldronRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack result = buf.m_130267_();
            FluidStack fluid = FluidStack.readFromPacket((FriendlyByteBuf)buf);
            boolean mustFitAll = buf.readBoolean();
            Holder sound = BuiltInRegistries.f_256894_.m_263177_((Object)Objects.requireNonNull((SoundEvent)BuiltInRegistries.f_256894_.m_7745_(buf.m_130281_())));
            return new FillAlchemistCauldronRecipe(pRecipeId, input, result, fluid, mustFitAll, (Holder<SoundEvent>)sound);
        }

        public void toNetwork(FriendlyByteBuf buf, FillAlchemistCauldronRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.m_130055_(recipe.returned);
            recipe.result.writeToPacket(buf);
            buf.writeBoolean(recipe.mustFitAll);
            buf.m_130085_(((SoundEvent)recipe.fillSound.get()).m_11660_());
        }
    }
}

