/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.ice_spike;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.ice_spike.IceSpikeEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class IceSpikeRenderer
extends EntityRenderer<IceSpikeEntity> {
    private final IceSpikeModel model;

    public IceSpikeRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new IceSpikeModel(pContext.m_174023_(IceSpikeModel.LAYER_LOCATION));
    }

    public void render(IceSpikeEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        if (entity.f_19797_ < entity.getWaitTime()) {
            return;
        }
        float f = (float)entity.f_19797_ + partialTicks;
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-entity.m_146908_()));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(entity.m_146909_()));
        float anim = entity.getPositionOffset(partialTicks);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        float scale = entity.getSpikeSize();
        scale = (scale - 1.0f) * 0.25f + 1.0f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(0.0f, -anim * 68.0f / 16.0f, 0.0f);
        this.model.setupAnim(entity, partialTicks, 0.0f, 0.0f, entity.m_146908_(), entity.m_146909_());
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        this.model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(IceSpikeEntity pEntity) {
        return IronsSpellbooks.id("textures/entity/ice_spike.png");
    }

    public static class IceSpikeModel
    extends EntityModel<IceSpikeEntity> {
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"ice_spike"), "main");
        private final ModelPart bottom;
        private final ModelPart middle;
        private final ModelPart top;

        public IceSpikeModel(ModelPart root) {
            this.bottom = root.m_171324_("bottom");
            this.middle = root.m_171324_("middle");
            this.top = root.m_171324_("top");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition bottom = partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -25.0f, -9.0f, 10.0f, 24.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)25.0f, (float)4.0f));
            PartDefinition cube_r1 = bottom.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(40, 3).m_171488_(-5.0f, -10.0f, -1.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.0f, (float)0.0f, (float)-8.0f, (float)0.3295f, (float)-0.1172f, (float)0.3295f));
            PartDefinition cube_r2 = bottom.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(40, 3).m_171488_(-5.0f, -10.0f, -1.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.812f, (float)0.1172f, (float)2.812f));
            PartDefinition middle = partdefinition.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-1.0f, -25.0f, -1.0f, 8.0f, 22.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)3.0f, (float)-3.0f));
            PartDefinition cube_r3 = middle.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(40, 3).m_171488_(-5.0f, -10.0f, -1.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)0.0f, (float)6.0f, (float)-1.3526f, (float)-1.3526f, (float)1.5708f));
            PartDefinition cube_r4 = middle.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(40, 3).m_171488_(-5.0f, -10.0f, -1.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.789f, (float)1.3526f, (float)1.5708f));
            PartDefinition top = partdefinition.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(39, 38).m_171488_(-1.0f, -25.0f, -3.0f, 4.0f, 22.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-19.0f, (float)1.0f));
            PartDefinition cube_r5 = top.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(40, 3).m_171488_(-5.0f, -10.0f, -1.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)-2.0f, (float)0.1719f, (float)-0.0302f, (float)0.1719f));
            PartDefinition cube_r6 = top.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(40, 3).m_171488_(-5.0f, -10.0f, -1.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.9697f, (float)0.0302f, (float)2.9697f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
        }

        public void setupAnim(IceSpikeEntity entity, float partialTicks, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            float scale = entity.getSpikeSize();
            this.top.f_104207_ = false;
            this.bottom.f_104207_ = false;
            int ypos = 26;
            if (scale >= 3.0f) {
                this.bottom.f_104207_ = true;
                this.bottom.f_104201_ = ypos -= 26;
            }
            this.middle.f_104201_ = ypos -= 22;
            if (scale >= 2.0f) {
                this.top.f_104207_ = true;
                this.top.f_104201_ = ypos -= 22;
            }
        }

        public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
            this.bottom.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, r, g, b, a);
            this.middle.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, r, g, b, a);
            this.top.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, r, g, b, a);
        }
    }
}

