/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss;

import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMobModel;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossEntity;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.item.Item;
import org.joml.Vector2f;
import org.joml.Vector3f;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;

public class FireBossModel
extends AbstractSpellCastingMobModel {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"textures/entity/fire_boss/tyros.png");
    public static final ResourceLocation TEXTURE_SOUL_MODE = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"textures/entity/fire_boss/tyros_soul_mode.png");
    public static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"geo/tyros.geo.json");
    private static final float tilt = 0.2617994f;
    private static final Vector3f forward = new Vector3f(0.0f, 0.0f, Mth.m_14031_((float)0.2617994f) * -12.0f);
    int lastTick;

    @Override
    public ResourceLocation getTextureResource(AbstractSpellCastingMob object) {
        FireBossEntity fireBossEntity;
        if (object instanceof FireBossEntity && (fireBossEntity = (FireBossEntity)object).isSoulMode()) {
            return TEXTURE_SOUL_MODE;
        }
        return TEXTURE;
    }

    @Override
    public ResourceLocation getModelResource(AbstractSpellCastingMob object) {
        return MODEL;
    }

    @Override
    public void setCustomAnimations(AbstractSpellCastingMob entity, long instanceId, AnimationState<AbstractSpellCastingMob> animationState) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (entity instanceof FireBossEntity) {
            CoreGeoBone rightArm;
            FireBossEntity fireBossEntity = (FireBossEntity)entity;
            this.handleParticles(fireBossEntity);
            float partialTick = animationState.getPartialTick();
            Vector2f limbSwing = this.getLimbSwing(entity, entity.f_267362_, partialTick);
            fireBossEntity.isAnimatingDampener = entity.isAnimating() ? Mth.m_14179_((float)(0.15f * partialTick), (float)fireBossEntity.isAnimatingDampener, (float)0.0f) : Mth.m_14179_((float)(0.05f * partialTick), (float)fireBossEntity.isAnimatingDampener, (float)1.0f);
            if (entity.m_21205_().m_150930_((Item)ItemRegistry.HELLRAZOR.get()) || entity.m_21205_().m_150930_((Item)ItemRegistry.DECREPIT_SCYTHE.get())) {
                rightArm = this.getAnimationProcessor().getBone("right_arm");
                CoreGeoBone rightHand = this.getAnimationProcessor().getBone("bipedHandRight");
                Vector3f armPose = new Vector3f(-30.0f, -30.0f, 10.0f);
                armPose.mul((float)Math.PI / 180 * fireBossEntity.isAnimatingDampener);
                this.transformStack.pushRotation(rightArm, armPose);
                Vector3f scythePos = new Vector3f(-5.0f, 0.0f, -48.0f);
                scythePos.mul((float)Math.PI / 180 * fireBossEntity.isAnimatingDampener);
                this.transformStack.pushRotation(rightHand, scythePos);
                if (!entity.isAnimating()) {
                    float walkDampener = Mth.m_14089_((float)(limbSwing.y() * 0.6662f + (float)Math.PI)) * 2.0f * limbSwing.x() * 0.5f * -0.75f;
                    this.transformStack.pushRotation(rightArm, walkDampener, 0.0f, 0.0f);
                }
            }
            if (fireBossEntity.isHalfHealthAttacking()) {
                rightArm = this.getAnimationProcessor().getBone("right_arm");
                CoreGeoBone leftArm = this.getAnimationProcessor().getBone("left_arm");
                CoreGeoBone rightLeg = this.getAnimationProcessor().getBone("right_leg");
                CoreGeoBone leftLeg = this.getAnimationProcessor().getBone("left_leg");
                float f = (float)fireBossEntity.f_19797_ + partialTick;
                this.bobBone(rightArm, f * 3.0f, -4.0f);
                this.bobBone(leftArm, f * 3.0f, 4.0f);
                this.bobBone(rightLeg, f, -1.5f);
                this.bobBone(leftLeg, f + 90.0f, 1.5f);
            }
        }
        super.setCustomAnimations(entity, instanceId, animationState);
    }

    public void handleParticles(FireBossEntity entity) {
        CoreGeoBone particleEmitter = this.getAnimationProcessor().getBone("particle_emitter");
        CoreGeoBone body = this.getAnimationProcessor().getBone("body");
        CoreGeoBone offhand = this.getAnimationProcessor().getBone("bipedHandLeft");
    }

    @Override
    protected Vector2f getLimbSwing(AbstractSpellCastingMob entity, WalkAnimationState walkAnimationState, float partialTick) {
        Vector2f swing = super.getLimbSwing(entity, walkAnimationState, partialTick);
        swing.mul(0.6f, 1.0f);
        return swing;
    }
}

