/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import snownee.snow.CoreModule;
import snownee.snow.Hooks;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowVariant;
import snownee.snow.entity.FallingSnowEntity;
import snownee.snow.mixin.IceBlockAccess;
import snownee.snow.util.CommonProxy;

public class WorldTickHandler {
    public static void tick(ServerLevel level, LevelChunk chunk) {
        int y;
        int x = chunk.m_7697_().m_45604_();
        BlockPos.MutableBlockPos pos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, level.m_46496_(x, 0, y = chunk.m_7697_().m_45605_(), 15)).m_122032_();
        if (!level.isAreaLoaded((BlockPos)pos, 1)) {
            return;
        }
        pos.m_122173_(Direction.DOWN);
        Holder biomeHolder = level.m_204166_((BlockPos)pos);
        boolean coldEnoughToSnow = CommonProxy.coldEnoughToSnow((Level)level, (BlockPos)pos, (Holder<Biome>)biomeHolder);
        if (coldEnoughToSnow) {
            WorldTickHandler.doSnow(level, pos);
        } else {
            WorldTickHandler.doMelt(level, pos);
        }
    }

    private static void doMelt(ServerLevel level, BlockPos.MutableBlockPos pos) {
        BlockState state = level.m_8055_((BlockPos)pos);
        Block block = state.m_60734_();
        if (block instanceof IceBlockAccess) {
            IceBlockAccess ice = (IceBlockAccess)block;
            Holder biome = level.m_204166_((BlockPos)pos);
            if (CommonProxy.snowAndIceMeltInWarmBiomes((ResourceKey<Level>)level.m_46472_(), (Holder<Biome>)biome) && !CommonProxy.coldEnoughToSnow((Level)level, (BlockPos)pos, (Holder<Biome>)biome)) {
                ice.callMelt(state, (Level)level, (BlockPos)pos);
            }
            return;
        }
        BlockState stateAbove = level.m_8055_((BlockPos)pos.m_122173_(Direction.UP));
        if (stateAbove.m_60734_() instanceof SnowVariant) {
            Hooks.randomTick(stateAbove, level, (BlockPos)pos, level.f_46441_, 1.0f);
        } else if (state.m_60734_() instanceof SnowVariant) {
            pos.m_122173_(Direction.DOWN);
            Hooks.randomTick(state, level, (BlockPos)pos, level.f_46441_, 1.0f);
        }
    }

    private static void doSnow(ServerLevel level, BlockPos.MutableBlockPos pos) {
        int blizzard;
        if (!level.m_46471_()) {
            return;
        }
        int n = blizzard = SnowCommonConfig.snowGravity ? level.m_46469_().m_46215_(CoreModule.BLIZZARD_STRENGTH) : 0;
        if (blizzard > 0) {
            WorldTickHandler.doBlizzard(level, (BlockPos)pos, blizzard);
            return;
        }
        BlockState state = level.m_8055_((BlockPos)pos);
        if (SnowCommonConfig.snowAccumulationMaxLayers <= 0) {
            return;
        }
        if (!Hooks.canContainState(state)) {
            if (SnowCommonConfig.snowAccumulationMaxLayers < 9 && state.m_60734_() instanceof SnowVariant) {
                return;
            }
            state = level.m_8055_((BlockPos)pos.m_122173_(Direction.UP));
            if (!state.m_60795_() && !Hooks.canContainState(state)) {
                return;
            }
        }
        if (state.m_60795_() && !Hooks.canSnowSurvive(Blocks.f_50125_.m_49966_(), (BlockGetter)level, (BlockPos)pos)) {
            return;
        }
        if (level.m_45517_(LightLayer.BLOCK, (BlockPos)pos.m_122173_(Direction.UP)) > SnowCommonConfig.snowSpawnMaxLightLevel) {
            return;
        }
        Hooks.convert((LevelAccessor)level, (BlockPos)pos.m_122173_(Direction.DOWN), state, 1, 3, SnowCommonConfig.placeSnowOnBlockNaturally);
        for (int i = 0; i < 5 && !state.m_204336_(BlockTags.f_13031_) && !state.m_204336_(BlockTags.f_13030_) && ((state = level.m_8055_((BlockPos)pos.m_122173_(Direction.DOWN))).m_60795_() || Hooks.canContainState(state)); ++i) {
            if (!Hooks.canSnowSurvive(Blocks.f_50125_.m_49966_(), (BlockGetter)level, (BlockPos)pos)) continue;
            pos.m_122173_(Direction.UP);
            if (level.m_8055_((BlockPos)pos).m_60734_() instanceof SnowLayerBlock || level.m_45517_(LightLayer.BLOCK, (BlockPos)pos) > SnowCommonConfig.snowSpawnMaxLightLevel) break;
            Hooks.convert((LevelAccessor)level, (BlockPos)pos.m_122173_(Direction.DOWN), state, 1, 3, SnowCommonConfig.placeSnowOnBlockNaturally);
        }
    }

    private static void doBlizzard(ServerLevel world, BlockPos pos, int blizzard) {
        if (pos.m_123342_() == world.m_141928_()) {
            return;
        }
        int frequency = world.m_46469_().m_46215_(CoreModule.BLIZZARD_FREQUENCY);
        if ((frequency = Mth.m_14045_((int)frequency, (int)0, (int)10000)) == 0) {
            return;
        }
        int i = world.f_46441_.m_188503_(10000);
        if (frequency != 10000 && i >= frequency) {
            return;
        }
        if ((blizzard = Mth.m_14045_((int)blizzard, (int)1, (int)8)) > 1) {
            blizzard = world.f_46441_.m_188503_(blizzard) + 1;
        }
        pos = pos.m_6630_(64);
        FallingSnowEntity entity = new FallingSnowEntity((Level)world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() + 0.5, blizzard);
        world.m_7967_((Entity)entity);
    }
}

