/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.recipe;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class RecipeUnlockSavedData
extends SavedData {
    public static final String DATA_NAME = "farm_and_charm_recipe_unlock_data";
    private final Map<UUID, Set<ResourceLocation>> playerRecipes = new HashMap<UUID, Set<ResourceLocation>>();

    public static RecipeUnlockSavedData fromNbt(CompoundTag tag) {
        RecipeUnlockSavedData data = new RecipeUnlockSavedData();
        CompoundTag playersTag = tag.m_128469_("players");
        for (String key : playersTag.m_128431_()) {
            ListTag list = playersTag.m_128437_(key, 8);
            HashSet<ResourceLocation> recipes = new HashSet<ResourceLocation>();
            for (int i = 0; i < list.size(); ++i) {
                recipes.add(new ResourceLocation(list.m_128778_(i)));
            }
            try {
                UUID uuid = UUID.fromString(key);
                data.playerRecipes.put(uuid, recipes);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return data;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag playersTag = new CompoundTag();
        for (Map.Entry<UUID, Set<ResourceLocation>> entry : this.playerRecipes.entrySet()) {
            ListTag list = new ListTag();
            for (ResourceLocation recipe : entry.getValue()) {
                list.add((Object)StringTag.m_129297_((String)recipe.toString()));
            }
            playersTag.m_128365_(entry.getKey().toString(), (Tag)list);
        }
        tag.m_128365_("players", (Tag)playersTag);
        return tag;
    }

    public Set<ResourceLocation> getPlayerRecipes(UUID uuid) {
        return this.playerRecipes.computeIfAbsent(uuid, k -> new HashSet());
    }

    public void setPlayerRecipes(UUID uuid, Set<ResourceLocation> recipes) {
        this.playerRecipes.put(uuid, recipes);
        this.m_77762_();
    }
}

