/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.block.entity.ChickenCoopBlockEntity;
import net.satisfy.farm_and_charm.core.entity.ChickenCoopAccess;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public class ChickenGotoAndEnterCoopGoal
extends Goal {
    private final Chicken chicken;
    private int nextRepathTick;
    private int failCount;
    private BlockPos approachPos;
    private int losNextTick;
    private int spaceNextTick;

    public ChickenGotoAndEnterCoopGoal(Chicken chicken) {
        this.chicken = chicken;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        ChickenCoopAccess acc = (ChickenCoopAccess)this.chicken;
        if (acc.farmAndCharm$getCoopCooldown() > 0) {
            return false;
        }
        if (!acc.farmAndCharm$hasCoopTarget()) {
            return false;
        }
        BlockPos target = acc.farmAndCharm$getCoopTarget();
        BlockEntity be = this.chicken.m_9236_().m_7702_(target);
        if (!(be instanceof ChickenCoopBlockEntity)) {
            return false;
        }
        ChickenCoopBlockEntity coop = (ChickenCoopBlockEntity)be;
        if (!coop.hasSpaceForChicken()) {
            return false;
        }
        if (coop.containsChicken(this.chicken)) {
            return false;
        }
        BlockPos approach = this.findApproach(target);
        if (approach == null) {
            return false;
        }
        if (this.hasLineOfSight(Vec3.m_82512_((Vec3i)approach))) {
            return false;
        }
        return this.chicken.m_21573_().m_7864_(approach, 0) != null;
    }

    public void m_8056_() {
        ChickenCoopBlockEntity coop;
        BlockEntity be;
        BlockPos coopPos = ((ChickenCoopAccess)this.chicken).farmAndCharm$getCoopTarget();
        if (coopPos == null) {
            return;
        }
        this.failCount = 0;
        this.approachPos = this.findApproach(coopPos);
        if (this.approachPos == null) {
            this.clearWithCooldown(200);
            return;
        }
        Vec3 center = Vec3.m_82512_((Vec3i)this.approachPos);
        double d2 = this.chicken.m_20182_().m_82557_(center);
        if (d2 <= 1.44 && (be = this.chicken.m_9236_().m_7702_(coopPos)) instanceof ChickenCoopBlockEntity && (coop = (ChickenCoopBlockEntity)be).hasSpaceForChicken()) {
            this.chicken.m_9236_().m_5594_(null, this.chicken.m_20183_(), SoundEvents.f_11695_, this.chicken.m_5720_(), 1.0f, 1.0f);
            coop.addChicken(this.chicken);
            ((ChickenCoopAccess)this.chicken).farmAndCharm$clearCoopTarget();
            ((ChickenCoopAccess)this.chicken).farmAndCharm$setCoopCooldown(1200 * (3 + this.chicken.m_217043_().m_188503_(10)));
            this.chicken.m_21573_().m_26573_();
            return;
        }
        this.chicken.m_21573_().m_26519_(center.f_82479_, center.f_82480_, center.f_82481_, 1.0);
        this.nextRepathTick = this.chicken.f_19797_ + 10 + this.chicken.m_217043_().m_188503_(5);
        this.losNextTick = this.chicken.f_19797_;
        this.spaceNextTick = this.chicken.f_19797_;
    }

    public void m_8037_() {
        ChickenCoopBlockEntity coop;
        BlockEntity be;
        BlockPos coopPos = ((ChickenCoopAccess)this.chicken).farmAndCharm$getCoopTarget();
        if (coopPos == null) {
            return;
        }
        if (!this.chicken.m_9236_().m_8055_(coopPos).m_60713_((Block)ObjectRegistry.CHICKEN_COOP.get())) {
            ((ChickenCoopAccess)this.chicken).farmAndCharm$clearCoopTarget();
            this.chicken.m_21573_().m_26573_();
            return;
        }
        if (this.approachPos == null) {
            this.approachPos = this.findApproach(coopPos);
            if (this.approachPos == null) {
                this.clearWithCooldown(200);
                return;
            }
        }
        if (this.chicken.f_19797_ >= this.losNextTick && this.hasLineOfSight(Vec3.m_82512_((Vec3i)this.approachPos))) {
            this.losNextTick = this.chicken.f_19797_ + 10;
            ++this.failCount;
            if (this.failCount >= 3) {
                this.clearWithCooldown(200);
            }
            return;
        }
        if (this.chicken.f_19797_ >= this.spaceNextTick) {
            ChickenCoopBlockEntity coop2;
            BlockEntity be2 = this.chicken.m_9236_().m_7702_(coopPos);
            if (!(be2 instanceof ChickenCoopBlockEntity) || !(coop2 = (ChickenCoopBlockEntity)be2).hasSpaceForChicken()) {
                this.clearWithCooldown(100);
                return;
            }
            this.spaceNextTick = this.chicken.f_19797_ + 10;
        }
        Vec3 center = Vec3.m_82512_((Vec3i)this.approachPos);
        double d2 = this.chicken.m_20182_().m_82557_(center);
        if (d2 <= 1.44 && (be = this.chicken.m_9236_().m_7702_(coopPos)) instanceof ChickenCoopBlockEntity && (coop = (ChickenCoopBlockEntity)be).hasSpaceForChicken()) {
            this.chicken.m_9236_().m_5594_(null, this.chicken.m_20183_(), SoundEvents.f_11695_, this.chicken.m_5720_(), 1.0f, 1.0f);
            coop.addChicken(this.chicken);
            ((ChickenCoopAccess)this.chicken).farmAndCharm$clearCoopTarget();
            ((ChickenCoopAccess)this.chicken).farmAndCharm$setCoopCooldown(1200 * (3 + this.chicken.m_217043_().m_188503_(10)));
            this.chicken.m_21573_().m_26573_();
            return;
        }
        if (this.chicken.f_19797_ >= this.nextRepathTick) {
            BlockPos targetPos = BlockPos.m_274446_((Position)center);
            if (this.chicken.m_21573_().m_7864_(targetPos, 0) == null) {
                ++this.failCount;
                if (this.failCount >= 3) {
                    this.clearWithCooldown(200);
                    return;
                }
            } else {
                this.chicken.m_21573_().m_26519_(center.f_82479_, center.f_82480_, center.f_82481_, 1.0);
            }
            this.nextRepathTick = this.chicken.f_19797_ + 10 + this.chicken.m_217043_().m_188503_(5);
        }
    }

    public void m_8041_() {
        this.chicken.m_21573_().m_26573_();
    }

    private void clearWithCooldown(int ticks) {
        ((ChickenCoopAccess)this.chicken).farmAndCharm$clearCoopTarget();
        ((ChickenCoopAccess)this.chicken).farmAndCharm$setCoopCooldown(ticks);
        this.chicken.m_21573_().m_26573_();
        this.approachPos = null;
        this.failCount = 0;
    }

    private BlockPos findApproach(BlockPos coopPos) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockPos side = coopPos.m_121945_(d);
            if (!this.chicken.m_9236_().m_8055_(side).m_60795_() || !this.chicken.m_9236_().m_8055_(side.m_7494_()).m_60795_()) continue;
            return side;
        }
        return null;
    }

    private boolean hasLineOfSight(Vec3 to) {
        if ((this.chicken.f_19797_ & 9) != 0) {
            return false;
        }
        Vec3 from = this.chicken.m_146892_();
        BlockHitResult hit = this.chicken.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.chicken));
        return hit.m_6662_() != HitResult.Type.MISS;
    }
}

