/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class Utils {
    public static int mainTargetWidth() {
        return Minecraft.m_91087_().m_91385_().f_83915_;
    }

    public static int mainTargetHeight() {
        return Minecraft.m_91087_().m_91385_().f_83916_;
    }

    public static int mainColorTexture() {
        return Minecraft.m_91087_().m_91385_().m_83975_();
    }

    public static Vec3 cameraPosition() {
        return Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
    }

    public static int chunkRenderDistance() {
        return (int)Math.floor(Minecraft.m_91087_().f_91063_.m_109152_() / 16.0f);
    }

    public static void debugWriteTexture(int texture, int width, int height, File file) {
        if (file.exists()) {
            return;
        }
        file.getParentFile().mkdirs();
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glBindTexture((int)3553, (int)texture);
        GL12.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = (x + y * width) * 4;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = buffer.get(i + 3) & 0xFF;
                a = 255;
                int argb = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, height - 1 - y, argb);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

