/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.compat.sodium.ext.CommandListExt;
import com.koteinik.chunksfadein.compat.sodium.ext.GlBufferUsageExt;
import com.koteinik.chunksfadein.compat.sodium.ext.GlMutableBufferExt;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.LongPredicate;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.jni.JNINativeInterface;
import sun.misc.Unsafe;

public class DataBuffer {
    private static final Unsafe UNSAFE = DataBuffer.getUnsafeInstance();
    private static long ADDRESS = DataBuffer.getAddressOffset();
    private final ByteBuffer buffer;
    private final int stride;
    private final int fieldsCount;

    private static Unsafe getUnsafeInstance() {
        Field[] fields;
        for (Field field : fields = Unsafe.class.getDeclaredFields()) {
            int modifiers;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            try {
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                break;
            }
        }
        throw new UnsupportedOperationException("LWJGL requires sun.misc.Unsafe to be available.");
    }

    private static long getAddressOffset() {
        long MAGIC_ADDRESS = 0xDEADBEEF8BADF00DL & (Pointer.BITS32 ? 0xFFFFFFFFL : -1L);
        ByteBuffer bb = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer((long)MAGIC_ADDRESS, (long)0L));
        return DataBuffer.getFieldOffset(bb.getClass(), Long.TYPE, offset -> UNSAFE.getLong(bb, offset) == MAGIC_ADDRESS);
    }

    private static long getFieldOffset(Class<?> containerType, Class<?> fieldType, LongPredicate predicate) {
        for (Class<?> c = containerType; c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                long offset;
                if (!field.getType().isAssignableFrom(fieldType) || Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || !predicate.test(offset = UNSAFE.objectFieldOffset(field))) continue;
                return offset;
            }
        }
        throw new UnsupportedOperationException("Failed to find field offset in class.");
    }

    public DataBuffer(int size, int fieldsCount) {
        this.stride = fieldsCount * 4;
        this.fieldsCount = fieldsCount;
        this.buffer = MemoryUtil.memAlloc((int)(size * this.stride));
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < fieldsCount; ++j) {
                this.put(i, j, 0.0f);
            }
        }
    }

    public void put(int index, int fieldNum, float data) {
        this.buffer.putFloat(this.getPosition(index, fieldNum), data);
    }

    public float get(int index, int fieldNum) {
        return this.buffer.getFloat(this.getPosition(index, fieldNum));
    }

    public void uploadData(CommandListExt commandList, GlMutableBufferExt glBuffer) {
        commandList.uploadData(glBuffer, this.buffer, GlBufferUsageExt.STREAM_DRAW);
    }

    public void reset(int i) {
        for (int j = 0; j < this.fieldsCount; ++j) {
            this.put(i, j, 0.0f);
        }
    }

    public void delete() {
        MemoryUtil.nmemFree((long)UNSAFE.getLong(this.buffer, ADDRESS));
    }

    private int getPosition(int index, int fieldNum) {
        return index * this.stride + fieldNum * 4;
    }
}

