/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.impl.forge;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import lain.mods.skins.impl.SkinData;

public class ImageUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String judgeSkinType(byte[] data) {
        try (NativeImage image = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(data));){
            int w = image.m_84982_();
            int h = image.m_85084_();
            if (w == h * 2) {
                String string = "default";
                return string;
            }
            if (w == h) {
                int r = Math.max(w / 64, 1);
                if ((image.m_84985_(55 * r, 20 * r) & 0xFF000000) >>> 24 == 0) {
                    String string = "slim";
                    return string;
                }
                String string = "default";
                return string;
            }
            String string = "unknown";
            return string;
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer legacyFilter(ByteBuffer buffer) {
        try (NativeImage input = NativeImage.m_85062_((ByteBuffer)buffer);){
            ByteBuffer byteBuffer;
            try (NativeImage output = new NativeImage(input.m_84982_(), input.m_84982_(), true);){
                int r = Math.max(input.m_84982_() / 64, 1);
                boolean f = input.m_84982_() == input.m_85084_() * 2;
                output.m_85054_(input);
                if (f) {
                    output.m_84997_(0 * r, 32 * r, 64 * r, 32 * r, 0);
                    output.m_85025_(4 * r, 16 * r, 16 * r, 32 * r, 4 * r, 4 * r, true, false);
                    output.m_85025_(8 * r, 16 * r, 16 * r, 32 * r, 4 * r, 4 * r, true, false);
                    output.m_85025_(0 * r, 20 * r, 24 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.m_85025_(4 * r, 20 * r, 16 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.m_85025_(8 * r, 20 * r, 8 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.m_85025_(12 * r, 20 * r, 16 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.m_85025_(44 * r, 16 * r, -8 * r, 32 * r, 4 * r, 4 * r, true, false);
                    output.m_85025_(48 * r, 16 * r, -8 * r, 32 * r, 4 * r, 4 * r, true, false);
                    output.m_85025_(40 * r, 20 * r, 0 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.m_85025_(44 * r, 20 * r, -8 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.m_85025_(48 * r, 20 * r, -16 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.m_85025_(52 * r, 20 * r, -8 * r, 32 * r, 4 * r, 12 * r, true, false);
                }
                ImageUtils.setAreaOpaque(output, 0 * r, 0 * r, 32 * r, 16 * r);
                if (f) {
                    ImageUtils.setAreaTransparent(output, 32 * r, 0 * r, 64 * r, 32 * r);
                }
                ImageUtils.setAreaOpaque(output, 0 * r, 16 * r, 64 * r, 32 * r);
                ImageUtils.setAreaOpaque(output, 16 * r, 48 * r, 48 * r, 64 * r);
                byteBuffer = SkinData.toBuffer(output.m_85121_());
            }
            return byteBuffer;
        }
        catch (Throwable t) {
            return buffer;
        }
    }

    private static void setAreaOpaque(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                image.m_84988_(i, j, image.m_84985_(i, j) | 0xFF000000);
            }
        }
    }

    private static void setAreaTransparent(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                if ((image.m_84985_(i, j) >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = x; l < width; ++l) {
            for (int i1 = y; i1 < height; ++i1) {
                image.m_84988_(l, i1, image.m_84985_(l, i1) & 0xFFFFFF);
            }
        }
    }

    public static boolean validateData(byte[] data) {
        boolean bl;
        block8: {
            NativeImage image = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(data));
            try {
                boolean bl2 = bl = image != null;
                if (image == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return false;
                }
            }
            image.close();
        }
        return bl;
    }
}

