/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.events;

import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.orcinus.galosphere.init.GMobEffects;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CameraEvents {
    @SubscribeEvent
    public void computeFogColor(ViewportEvent.ComputeFogColor event) {
        Camera camera = event.getCamera();
        if (CameraEvents.renderShadowPhase(camera.m_90592_()) && CameraEvents.getViewBlockingState((LivingEntity)camera.m_90592_()) != null) {
            event.setRed(0.0f);
            event.setGreen(0.0f);
            event.setBlue(0.0f);
        }
    }

    @SubscribeEvent
    public void renderBlockScreen(RenderBlockScreenEffectEvent event) {
        if (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.BLOCK && event.getPlayer().m_21023_((MobEffect)GMobEffects.ASTRAL.get())) {
            event.setCanceled(true);
        }
    }

    @Nullable
    private static BlockState getViewBlockingState(LivingEntity player) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d = player.m_20185_() + (double)(((float)(i % 2) - 0.5f) * player.m_20205_() * 0.8f);
            double e = player.m_20188_() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double f = player.m_20189_() + (double)(((float)((i >> 2) % 2) - 0.5f) * player.m_20205_() * 0.8f);
            mutableBlockPos.m_122169_(d, e, f);
            BlockState blockState = player.m_9236_().m_8055_((BlockPos)mutableBlockPos);
            if (blockState.m_60799_() == RenderShape.INVISIBLE || !blockState.m_60831_((BlockGetter)player.m_9236_(), (BlockPos)mutableBlockPos)) continue;
            return blockState;
        }
        return null;
    }

    private static boolean renderShadowPhase(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)GMobEffects.ASTRAL.get());
    }
}

