/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.blocks.PinkSaltChamberBlock;
import net.orcinus.galosphere.blocks.PinkSaltClusterBlock;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class PinkSaltChamberBlockEntity
extends BlockEntity {
    private final List<Preserved> preserves = Lists.newArrayList();
    public final int maxCooldown = 6000;
    private int cooldown = 0;

    public PinkSaltChamberBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)GBlockEntityTypes.PINK_SALT_CHAMBER.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.cooldown = compoundTag.m_128451_("Cooldown");
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_("Cooldown", this.cooldown);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, PinkSaltChamberBlockEntity blockEntity) {
        if (blockState.m_61143_(PinkSaltChamberBlock.PHASE) == PinkSaltChamberBlock.ChamberPhase.INACTIVE) {
            return;
        }
        Optional<Preserved> preserved = blockEntity.preserves.stream().filter(LivingEntity::m_6084_).findAny();
        if (!blockEntity.preserves.isEmpty() && preserved.isEmpty()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_(PinkSaltChamberBlock.PHASE, (Comparable)((Object)PinkSaltChamberBlock.ChamberPhase.COOLDOWN)), 2);
            level.m_5594_(null, blockPos, (SoundEvent)GSoundEvents.PINK_SALT_CHAMBER_DEACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            blockEntity.preserves.clear();
            blockEntity.resetCooldown();
        }
        if (blockEntity.cooldown >= blockEntity.maxCooldown) {
            if (blockState.m_61143_(PinkSaltChamberBlock.PHASE) == PinkSaltChamberBlock.ChamberPhase.COOLDOWN) {
                boolean flag2 = false;
                for (Direction direction : Direction.values()) {
                    boolean flag;
                    BlockState relativeState = level.m_8055_(blockPos.m_121945_(direction));
                    boolean bl = flag = relativeState.m_60713_((Block)GBlocks.PINK_SALT_CLUSTER.get()) && relativeState.m_61143_((Property)PinkSaltClusterBlock.FACING) == direction;
                    if (!flag) continue;
                    flag2 = true;
                    break;
                }
                PinkSaltChamberBlock.ChamberPhase phase = flag2 ? PinkSaltChamberBlock.ChamberPhase.CHARGED : PinkSaltChamberBlock.ChamberPhase.INACTIVE;
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_(PinkSaltChamberBlock.PHASE, (Comparable)((Object)phase)), 2);
            }
            ArrayList poses = Lists.newArrayList();
            int maxCount = UniformInt.m_146622_((int)3, (int)5).m_214085_(level.m_213780_());
            if (level.m_46791_() == Difficulty.HARD) {
                maxCount = UniformInt.m_146622_((int)4, (int)10).m_214085_(level.m_213780_());
            }
            List<Player> list = level.m_45976_(Player.class, new AABB(blockPos).m_82400_(6.0)).stream().filter(LivingEntity::m_6084_).filter(player -> !player.m_150110_().f_35937_).toList();
            list.stream().filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).forEach(GCriteriaTriggers.ACTIVATE_PINK_SALT_CHAMBER::trigger);
            list.stream().findAny().ifPresent(player -> {
                int range = 5;
                int yRange = 2;
                for (int y = -yRange; y <= yRange; ++y) {
                    for (int x = -range; x <= range; ++x) {
                        for (int z = -range; z <= range; ++z) {
                            BlockPos position = blockPos.m_7918_(x, y, z);
                            if (!level.m_8055_(position.m_7495_()).m_60783_((BlockGetter)level, position.m_7495_(), Direction.UP) || !level.m_8055_(position).m_60795_()) continue;
                            poses.add(position);
                        }
                    }
                }
            });
            if (!poses.isEmpty()) {
                for (int count = 0; count < maxCount; ++count) {
                    BlockPos randomPos = (BlockPos)poses.get(level.m_213780_().m_188503_(poses.size()));
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    blockEntity.addParticles(blockPos, serverLevel, randomPos);
                    blockEntity.handleSpawning(serverLevel, randomPos);
                }
                level.m_5594_(null, blockPos, (SoundEvent)GSoundEvents.PINK_SALT_CHAMBER_SUMMON.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                blockEntity.resetCooldown();
            }
        } else {
            ++blockEntity.cooldown;
        }
    }

    private void resetCooldown() {
        this.cooldown = 0;
    }

    private void handleSpawning(ServerLevel serverLevel, BlockPos pos) {
        if (serverLevel.m_46791_() == Difficulty.PEACEFUL) {
            serverLevel.m_7731_(pos, ((Block)GBlocks.PINK_SALT_CLUSTER.get()).m_49966_(), 2);
        } else {
            Preserved preserved = (Preserved)((EntityType)GEntityTypes.PRESERVED.get()).m_262451_(serverLevel, null, null, pos, MobSpawnType.TRIGGERED, true, true);
            preserved.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            preserved.m_21530_();
            preserved.setFromChamber(true);
            serverLevel.m_47205_((Entity)preserved);
            this.preserves.add(preserved);
        }
    }

    private void addParticles(BlockPos blockPos, ServerLevel serverLevel, BlockPos pos) {
        Vec3 vec3 = blockPos.m_252807_().m_82520_(0.0, 0.5, 0.0);
        Vec3 vec32 = pos.m_252807_().m_82520_(0.0, 1.0, 0.0).m_82546_(vec3);
        Vec3 vec33 = vec32.m_82541_();
        for (int i = 1; i < Mth.m_14107_((double)vec32.m_82553_()) + 7; ++i) {
            Vec3 vec34 = blockPos.m_252807_().m_82549_(vec33.m_82490_((double)i));
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, vec34.f_82479_, vec34.f_82480_, vec34.f_82481_, 30, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

