/*
 * Decompiled with CFR 0.152.
 */
package com.kingcontaria.fastquit.mixin;

import com.kingcontaria.fastquit.FastQuit;
import com.kingcontaria.fastquit.TextHelper;
import com.kingcontaria.fastquit.WorldInfo;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Redirect(method={"clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/server/IntegratedServer;isShutdown()Z"))
    private boolean fastquit(IntegratedServer server) {
        FastQuit.savingWorlds.put(server, new WorldInfo());
        if (FastQuit.CONFIG.backgroundPriority != 0) {
            server.m_6304_().setPriority(FastQuit.CONFIG.backgroundPriority);
        }
        FastQuit.log("Disconnected \"" + server.m_129910_().m_5462_() + "\" from the client.");
        return true;
    }

    @WrapWithCondition(method={"updateScreenAndTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;runTick(Z)V")})
    private boolean fastquit$doNotOpenSaveScreen(Minecraft client, boolean tick, Screen screen) {
        return FastQuit.CONFIG.renderSavingScreen || !(screen instanceof GenericDirtMessageScreen) || !screen.m_96636_().equals(TextHelper.translatable("menu.savingLevel", new Object[0]));
    }

    @Inject(method={"destroy"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;clearLevel()V", shift=At.Shift.AFTER)})
    private void fastquit$waitForSaveOnShutdown(CallbackInfo ci) {
        FastQuit.exit();
    }

    @Inject(method={"crash"}, at={@At(value="HEAD")})
    private static void fastquit$waitForSaveOnCrash(CallbackInfo ci) {
        FastQuit.exit();
    }
}

