/*
 * Decompiled with CFR 0.152.
 */
package com.kingcontaria.fastquit;

import com.kingcontaria.fastquit.FastQuitConfig;
import com.kingcontaria.fastquit.FastQuitConfigScreen;
import com.kingcontaria.fastquit.TextHelper;
import com.kingcontaria.fastquit.WaitingScreen;
import com.kingcontaria.fastquit.WorldInfo;
import com.kingcontaria.fastquit.mixin.LevelStorageSessionAccessor;
import com.kingcontaria.fastquit.mixin.MinecraftClientAccessor;
import com.kingcontaria.fastquit.mixin.MinecraftServerAccessor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mod(value="fastquit")
public final class FastQuit {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fastquit");
    public static final FastQuitConfig CONFIG;
    public static final Map<IntegratedServer, WorldInfo> savingWorlds;
    public static final List<LevelStorageSource.LevelStorageAccess> occupiedSessions;

    public FastQuit() {
        ModLoadingContext.get().registerExtensionPoint(FastQuitConfigScreen.FACTORY.getClass(), () -> FastQuitConfigScreen.FACTORY);
        FastQuit.log("Initialized");
    }

    public static void log(String msg) {
        LOGGER.info(msg);
    }

    public static void warn(String msg) {
        LOGGER.warn(msg);
    }

    public static void error(String msg, Throwable throwable) {
        LOGGER.error(msg, throwable);
    }

    public static void exit() {
        try {
            FastQuit.log("Exiting FastQuit.");
            FastQuit.wait(savingWorlds.keySet());
        }
        catch (Throwable throwable) {
            FastQuit.error("Something went horribly wrong when exiting FastQuit!", throwable);
            savingWorlds.forEach((server, info) -> {
                try {
                    server.m_6304_().join();
                }
                catch (Throwable throwable2) {
                    FastQuit.error("Failed to wait for \"" + server.m_129910_().m_5462_() + "\"", throwable2);
                }
            });
        }
    }

    public static void wait(IntegratedServer server) {
        FastQuit.wait(Collections.singleton(server), null);
    }

    public static void wait(IntegratedServer server, @Nullable CallbackInfo cancellable) {
        FastQuit.wait(Collections.singleton(server), cancellable);
    }

    public static void wait(Collection<IntegratedServer> servers) {
        FastQuit.wait(servers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Collection<IntegratedServer> servers, @Nullable CallbackInfo cancellable) {
        if (servers == null || servers.isEmpty()) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (!client.m_18695_()) {
            if (servers.stream().anyMatch(server -> Thread.currentThread() == server.m_6304_())) {
                throw new IllegalStateException("Tried to call FastQuit.wait(...) from one of the servers it's supposed to wait for.");
            }
            client.m_18707_(() -> FastQuit.wait(servers)).join();
            return;
        }
        Screen oldScreen = client.f_91080_;
        MutableComponent stillSaving = TextHelper.translatable("fastquit.screen.waiting", String.join((CharSequence)"\" & \"", servers.stream().map(server -> server.m_129910_().m_5462_()).toList()));
        FastQuit.log(stillSaving.getString());
        servers.forEach(server -> server.m_6304_().setPriority(5));
        try {
            client.m_91152_((Screen)new WaitingScreen((Component)stillSaving, cancellable));
            while (servers.stream().anyMatch(server -> !server.m_129782_())) {
                if (cancellable != null && cancellable.isCancelled()) {
                    if (FastQuit.CONFIG.backgroundPriority != 0) {
                        servers.forEach(server -> server.m_6304_().setPriority(FastQuit.CONFIG.backgroundPriority));
                    }
                    FastQuit.log("Cancelled waiting for currently saving worlds.");
                    break;
                }
                ((MinecraftClientAccessor)client).fastquit$render(false);
            }
        }
        finally {
            if (oldScreen != null && oldScreen.getClass().getName().equals("caeruleusTait.WorldGen.gui.screens.WGConfigScreen")) {
                client.f_91080_ = oldScreen;
            } else {
                client.m_91346_(oldScreen);
            }
        }
    }

    public static Optional<IntegratedServer> getSavingWorld(Path path) {
        return savingWorlds.keySet().stream().filter(server -> ((LevelStorageSessionAccessor)((MinecraftServerAccessor)server).fastquit$getSession()).fastquit$getDirectory().f_230850_().equals(path)).findFirst();
    }

    public static Optional<IntegratedServer> getSavingWorld(LevelStorageSource.LevelStorageAccess session) {
        return savingWorlds.keySet().stream().filter(server -> ((MinecraftServerAccessor)server).fastquit$getSession() == session).findFirst();
    }

    public static Optional<LevelStorageSource.LevelStorageAccess> getSession(Path path) {
        return FastQuit.getSavingWorld(path).flatMap(server -> {
            LevelStorageSource.LevelStorageAccess session;
            LevelStorageSource.LevelStorageAccess levelStorageAccess = session = ((MinecraftServerAccessor)server).fastquit$getSession();
            synchronized (session) {
                if (((LevelStorageSessionAccessor)session).fastquit$getLock().m_13639_()) {
                    occupiedSessions.add(session);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return Optional.of(session);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Optional.empty();
            }
        });
    }

    static {
        savingWorlds = Collections.synchronizedMap(new HashMap());
        occupiedSessions = Collections.synchronizedList(new ArrayList());
        AutoConfig.register(FastQuitConfig.class, Toml4jConfigSerializer::new);
        CONFIG = (FastQuitConfig)AutoConfig.getConfigHolder(FastQuitConfig.class).getConfig();
    }
}

