/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import de.johni0702.minecraft.bobby.BobbyConfig;
import de.johni0702.minecraft.bobby.LastAccessFile;
import de.johni0702.minecraft.bobby.mixin.SimpleOptionAccessor;
import de.johni0702.minecraft.bobby.mixin.ValidatingIntSliderCallbacksAccessor;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bobby")
public class Bobby {
    static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "bobby";
    private static Bobby instance;

    public static Bobby getInstance() {
        return instance;
    }

    public Bobby() {
        instance = this;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::onInitializeClient);
    }

    public void onInitializeClient() {
        MaxRenderDistanceConfigHandler.init();
        Util.m_183992_().submit(Bobby::cleanupOldWorlds);
    }

    public boolean isEnabled() {
        return BobbyConfig.isEnabled() && (Minecraft.m_91087_().m_91092_() == null || BobbyConfig.getViewDistanceOverwrite() != 0);
    }

    static void cleanupOldWorlds() {
        List toBeDeleted;
        int deleteUnusedRegionsAfterDays = BobbyConfig.getDeleteUnusedRegionsAfterDays();
        if (deleteUnusedRegionsAfterDays < 0) {
            return;
        }
        Path basePath = Minecraft.m_91087_().f_91069_.toPath().resolve(".bobby");
        try (Stream<Path> stream = Files.walk(basePath, 4, new FileVisitOption[0]);){
            toBeDeleted = stream.filter(it -> basePath.relativize((Path)it).getNameCount() == 4).filter(it -> {
                try {
                    return LastAccessFile.isEverythingOlderThan(it, deleteUnusedRegionsAfterDays);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read last used file in " + it + ":", (Throwable)e);
                    return false;
                }
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.error("Failed to index bobby cache for cleanup:", (Throwable)e);
            return;
        }
        for (Path path : toBeDeleted) {
            try {
                MoreFiles.deleteRecursively((Path)path, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
                Bobby.deleteParentsIfEmpty(path);
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete " + path + ":", (Throwable)e);
            }
        }
    }

    private static void deleteParentsIfEmpty(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent == null) {
            return;
        }
        try (Stream<Path> stream = Files.list(parent);){
            if (stream.findAny().isPresent()) {
                return;
            }
        }
        Files.delete(parent);
        Bobby.deleteParentsIfEmpty(parent);
    }

    static class MaxRenderDistanceConfigHandler {
        private static int oldMaxRenderDistance = 0;

        MaxRenderDistanceConfigHandler() {
        }

        public static void init() {
            Minecraft.m_91087_().m_18707_(() -> MaxRenderDistanceConfigHandler.setMaxRenderDistance(BobbyConfig.getMaxRenderDistance(), true));
        }

        private static void setMaxRenderDistance(int newMaxRenderDistance, boolean increaseOnly) {
            if (oldMaxRenderDistance == newMaxRenderDistance) {
                return;
            }
            oldMaxRenderDistance = newMaxRenderDistance;
            OptionInstance viewDistance = Minecraft.m_91087_().f_91066_.m_231984_();
            OptionInstance.ValueSet valueSet = viewDistance.m_231555_();
            if (valueSet instanceof OptionInstance.IntRange) {
                OptionInstance.IntRange callbacks = (OptionInstance.IntRange)valueSet;
                ValidatingIntSliderCallbacksAccessor callbacksAcc = (ValidatingIntSliderCallbacksAccessor)callbacks;
                if (increaseOnly) {
                    callbacksAcc.setMaxInclusive(Math.max(callbacks.m_214118_(), newMaxRenderDistance));
                } else {
                    callbacksAcc.setMaxInclusive(newMaxRenderDistance);
                }
                SimpleOptionAccessor optionAccessor = (SimpleOptionAccessor)viewDistance;
                optionAccessor.setCodec(callbacks.m_213664_());
            }
        }
    }
}

