/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.unified.impl;

import com.railwayteam.railways.content.custom_bogeys.renderer.unified.ElementProvider;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.ScrollHandle;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.impl.RenderedElement;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.Affine;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.render.SpriteShiftEntry;
import org.jetbrains.annotations.NotNull;

class RenderedElementProvider
implements ElementProvider<RenderedElement> {
    private final List<RenderedElement.Single> singleElements;
    private final List<RenderedElement.Multiple> multipleElements;
    private final List<RenderedElement.Scrolling> scrollingElements;
    private boolean frozen = false;

    RenderedElementProvider(List<RenderedElement.Single> singleElements, List<RenderedElement.Multiple> multipleElements, List<RenderedElement.Scrolling> scrollingElements) {
        this.singleElements = singleElements;
        this.multipleElements = multipleElements;
        this.scrollingElements = scrollingElements;
    }

    @Override
    @NotNull
    public Affine<RenderedElement> create(@NotNull PartialModel model) {
        if (this.frozen) {
            throw new IllegalStateException("Cannot create elements after build");
        }
        RenderedElement element = new RenderedElement();
        this.singleElements.add(new RenderedElement.Single(element, model));
        return element;
    }

    @Override
    @NotNull
    public @NotNull Affine<RenderedElement> @NotNull [] create(@NotNull PartialModel model, int count) {
        if (this.frozen) {
            throw new IllegalStateException("Cannot create elements after build");
        }
        RenderedElement[] elements = new RenderedElement[count];
        for (int i = 0; i < count; ++i) {
            elements[i] = new RenderedElement();
        }
        this.multipleElements.add(new RenderedElement.Multiple(elements, model));
        return elements;
    }

    @Override
    @NotNull
    public Pair<Affine<RenderedElement>, ScrollHandle> createScrolling(@NotNull PartialModel model, @NotNull SpriteShiftEntry shift) {
        RenderedElement element = new RenderedElement();
        RenderedElement.Scrolling scrolling = new RenderedElement.Scrolling(element, model, shift);
        this.scrollingElements.add(scrolling);
        return Pair.of((Object)element, (Object)scrolling);
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }
}

