/*
 * Decompiled with CFR 0.152.
 */
package com.redcraft86.simplecloudscompat.mixin.cyclic;

import com.lothrazar.cyclic.enchant.GrowthEnchant;
import com.redcraft86.simplecloudscompat.SCCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={GrowthEnchant.class}, remap=false)
public class GrowthEnchantMixin {
    @Unique
    private ThreadLocal<BlockPos> thisPos = new ThreadLocal();

    @Redirect(method={"onEntityUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/event/entity/living/LivingEvent$LivingTickEvent;getEntity()Lnet/minecraft/world/entity/LivingEntity;"))
    private LivingEntity redirectGetEntity(LivingEvent.LivingTickEvent event) {
        this.thisPos.set(event.getEntity().m_20183_());
        return event.getEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"onEntityUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isRaining()Z", remap=true))
    private boolean redirectIsRaining(Level level) {
        try {
            BlockPos pos = this.thisPos.get();
            if (pos == null) {
                boolean bl = level.m_46471_();
                return bl;
            }
            boolean bl = SCCompat.isRaining(level, pos, false);
            return bl;
        }
        finally {
            System.out.println("Redirect: " + String.valueOf(this.thisPos.get()));
            this.thisPos.remove();
        }
    }
}

