/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Spotion;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.ChunkLoadRequest;
import com.Harbinger.Spore.ExtremelySusThings.ChunkLoaderHelper;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.ChunkLoaderMob;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Vanguard
extends UtilityEntity
implements CrossbowAttackMob,
Enemy,
ArmorPersentageBypass,
ChunkLoaderMob {
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(Vanguard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> KILLS = SynchedEntityData.m_135353_(Vanguard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RAID_TIME_OUT = SynchedEntityData.m_135353_(Vanguard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> VILLAGE = SynchedEntityData.m_135353_(Vanguard.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private int attackAnimationTick;

    public Vanguard(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21344_ = new WallClimberNavigation((Mob)this, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.vanguard_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.vanguard_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.vanguard_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        this.addTargettingGoals();
        this.f_21345_.m_25352_(1, new VanguardRangedCrossbowAttackGoal<Vanguard>(this, 12.0f));
        this.f_21345_.m_25352_(2, (Goal)new CustomMeleeAttackGoal(this, 1.0, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 6.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new VanguardFireGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatDiveGoal((Mob)this));
        super.m_8099_();
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return super.m_5639_(p_21237_, p_21238_) - 15;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.VANGUARD_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.EVOLVE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeapon) {
        return projectileWeapon == Items.f_42717_;
    }

    public void setKills(int val) {
        this.f_19804_.m_135381_(KILLS, (Object)val);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
        this.f_19804_.m_135372_(KILLS, (Object)0);
        this.f_19804_.m_135372_(RAID_TIME_OUT, (Object)0);
        this.f_19804_.m_135372_(VILLAGE, (Object)BlockPos.f_121853_);
    }

    public BlockPos getVillage() {
        return (BlockPos)this.f_19804_.m_135370_(VILLAGE);
    }

    public void setVillage(BlockPos pos) {
        this.f_19804_.m_135381_(VILLAGE, (Object)pos);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(KILLS, (Object)tag.m_128451_("kills"));
        this.f_19804_.m_135381_(RAID_TIME_OUT, (Object)tag.m_128451_("raid"));
        int x = tag.m_128451_("villageX");
        int y = tag.m_128451_("villageY");
        int z = tag.m_128451_("villageZ");
        this.setVillage(new BlockPos(x, y, z));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("kills", ((Integer)this.f_19804_.m_135370_(KILLS)).intValue());
        tag.m_128405_("raid", ((Integer)this.f_19804_.m_135370_(RAID_TIME_OUT)).intValue());
        tag.m_128405_("villageX", this.getVillage().m_123341_());
        tag.m_128405_("villageY", this.getVillage().m_123342_());
        tag.m_128405_("villageZ", this.getVillage().m_123343_());
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600, 0));
            livingEntity.f_20916_ = 0;
            livingEntity.f_19802_ = 0;
        }
        this.m_216990_((SoundEvent)Ssounds.VANGUARD_SLASH.get());
        return super.m_7327_(entity);
    }

    public void m_5993_(Entity killed, int scoreValue, DamageSource source) {
        super.m_5993_(killed, scoreValue, source);
        this.f_19804_.m_135381_(KILLS, (Object)((Integer)this.f_19804_.m_135370_(KILLS) + 1));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268428_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268631_)) {
            amount /= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7822_(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        } else {
            super.m_7822_(value);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    protected void m_213945_(RandomSource p_219059_, DifficultyInstance p_219060_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
        ItemStack itemstack = this.m_21205_();
        if (itemstack.m_150930_(Items.f_42717_)) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
            map.putIfAbsent(Enchantments.f_44959_, 1);
            map.putIfAbsent(Enchantments.f_44960_, 3);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.locateVillageOnSpawn(serverLevel);
            this.teleportToSurface((Level)serverLevel, (Mob)this);
        }
        this.m_213945_(this.f_19796_, difficulty);
        return super.m_6518_(level, difficulty, p_21436_, p_21437_, p_21438_);
    }

    private void griefBlocks() {
        AABB aabb = this.m_20191_().m_82400_(0.5).m_82386_(0.0, 0.5, 0.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!this.blockBreakingParameter(blockstate, blockpos)) continue;
            this.interactBlock(blockpos, this.m_9236_());
        }
    }

    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        float value = blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos);
        return this.f_19797_ % 20 == 0 && value > 0.0f && value <= (float)this.getBreaking();
    }

    public int getBreaking() {
        return (Integer)SConfig.SERVER.hyper_bd.get();
    }

    public boolean interactBlock(BlockPos blockPos, Level level) {
        BlockState state = level.m_8055_(blockPos);
        if (state.m_204336_(Utilities.biomass)) {
            return level.m_7731_(blockPos, ((Block)Sblocks.MEMBRANE_BLOCK.get()).m_49966_(), 3);
        }
        return level.m_46953_(blockPos, false, (Entity)this);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean p_33302_) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)p_33302_);
    }

    public void m_5811_(LivingEntity livingEntity, ItemStack itemStack, Projectile projectile, float v) {
        this.m_32322_((LivingEntity)this, livingEntity, projectile, v, 3.2f);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        this.m_32336_((LivingEntity)this, 3.2f);
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.f_19797_ % 40 == 0 && this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            this.griefBlocks();
        }
        if (this.f_19797_ % 20 == 0 && this.m_21223_() < this.m_21233_() && !this.m_21023_(MobEffects.f_19605_) && (Integer)this.f_19804_.m_135370_(KILLS) > 0) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 0));
            this.f_19804_.m_135381_(KILLS, (Object)((Integer)this.f_19804_.m_135370_(KILLS) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(RAID_TIME_OUT) > 0) {
            this.f_19804_.m_135381_(RAID_TIME_OUT, (Object)((Integer)this.f_19804_.m_135370_(RAID_TIME_OUT) - 1));
        }
        if (this.f_19797_ % 40 == 0 && this.getVillage() != BlockPos.f_121853_ && this.m_5448_() == null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.tickMovement(serverLevel);
        }
        if (this.f_19797_ % 20 == 0 && this.getVanguardRaid() <= 0 && this.compareTarget(this.m_5448_())) {
            this.callReinforcements();
        }
    }

    @Override
    public float amountOfDamage(float value) {
        return value * 0.25f;
    }

    @Override
    public String getChunkId() {
        UUID uuid1 = this.m_20148_();
        return "vanguard_" + uuid1 + "_";
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.vanguard_loot.get();
    }

    @Override
    public boolean shouldLoadChunk() {
        return (Boolean)SConfig.SERVER.vanguard_chunk_load.get() != false && this.getVillage() != BlockPos.f_121853_;
    }

    @Override
    public int chunkLifeTicks() {
        return 600;
    }

    public int getVanguardRaid() {
        return (Integer)this.f_19804_.m_135370_(RAID_TIME_OUT);
    }

    public void setVanguardRaid(int val) {
        this.f_19804_.m_135381_(RAID_TIME_OUT, (Object)val);
    }

    public boolean compareTarget(LivingEntity living) {
        if (living == null) {
            return false;
        }
        return ((List)SConfig.SERVER.proto_sapient_target.get()).contains(living.m_20078_()) || living.m_21223_() >= 100.0f || living instanceof Player;
    }

    private void callReinforcements() {
        ArrayList<String> ids = new ArrayList<String>();
        block0: while (ids.size() < (Integer)SConfig.SERVER.vanguard_raid_size.get()) {
            for (String s : (List)SConfig.SERVER.vanguard_members.get()) {
                String[] str = s.split("\\|");
                if (!(Math.random() < (double)((float)Integer.parseUnsignedInt(str[1]) / 100.0f))) continue;
                ids.add(str[0]);
                continue block0;
            }
        }
        for (String id : ids) {
            Entity entity;
            Vec3 vec3 = Utilities.generatePositionAway(this.m_20182_(), 15.0);
            ResourceLocation entityId = new ResourceLocation(id);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null || !((entity = entityType.m_20615_(this.m_9236_())) instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevelAccessor)) continue;
            ServerLevelAccessor accessor = (ServerLevelAccessor)level;
            mob.m_20984_(vec3.f_82479_, this.m_20186_(), vec3.f_82481_, false);
            mob.m_6518_(accessor, accessor.m_6436_(BlockPos.m_274446_((Position)this.m_20182_())), MobSpawnType.NATURAL, null, null);
            if (mob instanceof Infected) {
                Infected infected = (Infected)mob;
                infected.setSearchPos(this.m_20097_());
                infected.setFollowPartner((LivingEntity)this);
                infected.m_6710_(this.m_5448_());
                infected.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 0));
            }
            accessor.m_7967_((Entity)mob);
        }
        this.m_216990_((SoundEvent)Ssounds.VANGUARD_CALL.get());
        this.setVanguardRaid(6000);
    }

    private void tickMovement(ServerLevel serverLevel) {
        this.tryTeleportIfFar(serverLevel);
        this.moveTowardVillage();
        Vec3i vec3i = new Vec3i(this.getVillage().m_123341_(), (int)this.m_20182_().m_7098_(), this.getVillage().m_123343_());
        if (this.m_20238_(Vec3.m_82512_((Vec3i)vec3i)) < 100.0) {
            this.playArrivalSound();
            this.setVillage(BlockPos.f_121853_);
            this.removeChunkLoad();
        }
    }

    private void tryTeleportIfFar(ServerLevel serverLevel) {
        if (!serverLevel.m_46749_(this.getVillage())) {
            return;
        }
        double distSqr = this.m_20238_(Vec3.m_82512_((Vec3i)this.getVillage()));
        if (distSqr < 40000.0) {
            return;
        }
        BlockPos tp = this.findSafeGround(this.getVillage());
        if (tp != null) {
            this.m_6021_((double)tp.m_123341_() + 0.5, tp.m_123342_(), (double)tp.m_123343_() + 0.5);
            this.addChunkLoad(tp, serverLevel);
        }
    }

    private void moveTowardVillage() {
        this.f_21344_.m_26573_();
        Path path = this.f_21344_.m_7864_(this.getVillage(), 1);
        if (path != null) {
            this.m_21573_().m_26536_(path, 1.2);
        }
    }

    private void playArrivalSound() {
        List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(100.0));
        for (Player p : players) {
            p.m_6330_((SoundEvent)Ssounds.VANGUARD_RAID.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    private BlockPos findSafeGround(BlockPos pos) {
        ServerLevel level = (ServerLevel)this.m_9236_();
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int y = 0; y < 20; ++y) {
            if (level.m_8055_((BlockPos)mutable).m_60795_() && level.m_8055_(mutable.m_7495_()).m_280296_()) {
                return mutable.m_7949_();
            }
            mutable.m_122173_(Direction.UP);
        }
        return null;
    }

    private void addChunkLoad(BlockPos pos, ServerLevel serverLevel) {
        ChunkPos chunk = new ChunkPos(pos);
        String id = "vanguard_" + this.m_20148_();
        ChunkLoaderHelper.addRequest(new ChunkLoadRequest((ResourceKey<Level>)serverLevel.m_46472_(), new ChunkPos[]{chunk}, 0, id, this.chunkLifeTicks(), this.m_20148_()));
    }

    private void removeChunkLoad() {
        String id = "vanguard_" + this.m_20148_();
        ChunkLoaderHelper.removeRequest(id);
    }

    public boolean m_6785_(double value) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SporeSavedData data = SporeSavedData.getDataLocation(serverLevel);
            return data != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get() && value > 256.0;
        }
        return false;
    }

    private void locateVillageOnSpawn(ServerLevel serverLevel) {
        List villagers = serverLevel.m_45976_(Villager.class, new AABB(this.m_20183_()).m_82400_(256.0));
        if (!villagers.isEmpty()) {
            Villager nearest = villagers.stream().min((a, b) -> Double.compare(this.m_20280_((Entity)a), this.m_20280_((Entity)b))).orElse(null);
            BlockPos villPos = nearest.m_20183_();
            this.setVillage(villPos);
            return;
        }
        int radius = 128;
        BlockPos foundVillage = serverLevel.m_215011_(StructureTags.f_215889_, this.m_20183_(), radius, false);
        this.setVillage(Objects.requireNonNullElse(foundVillage, BlockPos.f_121853_));
    }

    public void teleportToSurface(Level level, Mob entity) {
        if (level.m_45527_(entity.m_20183_())) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Mth.m_14107_((double)entity.m_20185_()), level.m_151558_(), Mth.m_14107_((double)entity.m_20189_()));
        while (pos.m_123342_() > level.m_141937_()) {
            pos.m_122173_(Direction.DOWN);
            BlockState state = level.m_8055_((BlockPos)pos);
            BlockState stateAbove = level.m_8055_(pos.m_7494_());
            if (!state.m_60804_((BlockGetter)level, (BlockPos)pos) || !stateAbove.m_60795_()) continue;
            entity.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.01, (double)pos.m_123343_() + 0.5);
            return;
        }
    }

    public static class VanguardRangedCrossbowAttackGoal<T extends Vanguard>
    extends Goal {
        private final T mob;
        private CrossbowState state = CrossbowState.UNCHARGED;
        private final float attackRadiusSqr;
        private int attackDelay;
        private boolean fireworks;

        public VanguardRangedCrossbowAttackGoal(T mob, float attackRadius) {
            this.mob = mob;
            this.attackRadiusSqr = attackRadius * attackRadius;
        }

        public boolean m_8036_() {
            return this.isHoldingCrossbow();
        }

        public boolean m_8045_() {
            return this.isHoldingCrossbow();
        }

        private boolean isHoldingCrossbow() {
            return this.mob.m_21093_(i -> i.m_41720_() instanceof CrossbowItem);
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.mob.m_6117_()) {
                this.mob.m_5810_();
            }
            this.state = CrossbowState.UNCHARGED;
        }

        public boolean m_183429_() {
            return true;
        }

        private ItemStack createExplosiveRocket() {
            this.fireworks = true;
            ItemStack rocket = new ItemStack((ItemLike)Items.f_42688_);
            CompoundTag fw = rocket.m_41698_("Fireworks");
            fw.m_128344_("Flight", (byte)1);
            ListTag list = new ListTag();
            list.add((Object)this.makeExplosionNBT(0, new int[]{3887386}, new int[]{4312372}));
            list.add((Object)this.makeExplosionNBT(1, new int[]{15435844}, new int[]{14602026}));
            list.add((Object)this.makeExplosionNBT(4, new int[]{2437522}, new int[]{2651799}));
            fw.m_128365_("Explosions", (Tag)list);
            return rocket;
        }

        private CompoundTag makeExplosionNBT(int shape, int[] colors, int[] fades) {
            CompoundTag n = new CompoundTag();
            n.m_128344_("Type", (byte)shape);
            n.m_128385_("Colors", colors);
            n.m_128385_("FadeColors", fades);
            n.m_128379_("Trail", true);
            n.m_128379_("Flicker", true);
            return n;
        }

        private ItemStack getArrow() {
            this.fireworks = false;
            return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)((Potion)Spotion.MYCELIUM_POTION.get()));
        }

        private static void addChargedProjectile(ItemStack crossbow, ItemStack projectile) {
            CompoundTag tag = crossbow.m_41784_();
            ListTag list = tag.m_128425_("ChargedProjectiles", 9) ? tag.m_128437_("ChargedProjectiles", 10) : new ListTag();
            CompoundTag projTag = new CompoundTag();
            projectile.m_41739_(projTag);
            list.add((Object)projTag);
            tag.m_128365_("ChargedProjectiles", (Tag)list);
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            boolean hasLOS = target != null && this.mob.m_21574_().m_148306_((Entity)target);
            double dist = target == null ? 0.0 : this.mob.m_20280_((Entity)target);
            ItemStack crossbow = this.mob.m_21205_();
            if (!(crossbow.m_41720_() instanceof CrossbowItem)) {
                return;
            }
            CompoundTag tag = crossbow.m_41784_();
            if (CrossbowItem.m_40932_((ItemStack)crossbow) && this.state == CrossbowState.UNCHARGED) {
                this.state = CrossbowState.CHARGED;
                this.attackDelay = 5;
            }
            switch (this.state) {
                case UNCHARGED: {
                    if (CrossbowItem.m_40932_((ItemStack)crossbow)) break;
                    this.mob.m_6672_(InteractionHand.MAIN_HAND);
                    this.state = CrossbowState.CHARGING;
                    ((Vanguard)this.mob).m_6136_(true);
                    break;
                }
                case CHARGING: {
                    if (!this.mob.m_6117_()) {
                        this.state = CrossbowState.UNCHARGED;
                        return;
                    }
                    int useTicks = this.mob.m_21252_();
                    if (useTicks < CrossbowItem.m_40939_((ItemStack)crossbow)) break;
                    ItemStack projectile = Math.random() < 0.2 ? this.createExplosiveRocket() : this.getArrow();
                    VanguardRangedCrossbowAttackGoal.addChargedProjectile(crossbow, projectile);
                    CrossbowItem.m_40884_((ItemStack)crossbow, (boolean)true);
                    this.mob.m_21253_();
                    this.state = CrossbowState.CHARGED;
                    this.attackDelay = 5;
                    break;
                }
                case CHARGED: {
                    if (--this.attackDelay <= 0) {
                        this.state = CrossbowState.READY_TO_ATTACK;
                    }
                    ((Vanguard)this.mob).m_6136_(false);
                    break;
                }
                case READY_TO_ATTACK: {
                    if (target == null || !hasLOS || !(dist <= (double)this.attackRadiusSqr)) break;
                    ((Vanguard)this.mob).m_6504_(target, 1.0f);
                    this.mob.m_216990_(this.fireworks ? (SoundEvent)Ssounds.VANGUARD_FIREWORKS.get() : (SoundEvent)Ssounds.VANGUARD_SHOOT.get());
                    CrossbowItem.m_40884_((ItemStack)crossbow, (boolean)false);
                    tag.m_128473_("ChargedProjectiles");
                    this.state = CrossbowState.UNCHARGED;
                }
            }
        }

        static enum CrossbowState {
            UNCHARGED,
            CHARGING,
            CHARGED,
            READY_TO_ATTACK;

        }
    }

    public static class VanguardFireGoal
    extends Goal {
        private final Vanguard vanguard;
        protected BlockPos targetPos;
        protected List<BlockPos> targetPositions = new ArrayList<BlockPos>();
        protected List<BlockPos> firePositions = new ArrayList<BlockPos>();
        private static final ItemStack FLINT = new ItemStack((ItemLike)Items.f_42409_);
        private int fireCooldown = 0;

        public VanguardFireGoal(Vanguard vanguard) {
            this.vanguard = vanguard;
        }

        boolean searchForFunnyBlocks() {
            this.targetPositions.clear();
            this.firePositions.clear();
            AABB aabb = this.vanguard.m_20191_().m_82377_(10.0, 6.0, 10.0);
            boolean thereAreBurnAbleBlocks = false;
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.vanguard.m_9236_().m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (block instanceof BedBlock || block instanceof FurnaceBlock) {
                    this.targetPositions.add(blockpos.m_7949_());
                }
                if (block instanceof FireBlock) {
                    this.firePositions.add(blockpos.m_7949_());
                }
                if (!block.isFlammable(blockstate, (BlockGetter)this.vanguard.m_9236_(), blockpos, Direction.UP)) continue;
                thereAreBurnAbleBlocks = true;
            }
            if (!this.targetPositions.isEmpty() && thereAreBurnAbleBlocks) {
                this.targetPos = this.targetPositions.get(this.vanguard.m_217043_().m_188503_(this.targetPositions.size()));
                boolean hasFireNearby = this.firePositions.stream().anyMatch(pos -> pos.m_123331_((Vec3i)this.targetPos) < 36.0);
                return !hasFireNearby;
            }
            return false;
        }

        public boolean m_8036_() {
            if (this.vanguard.f_19797_ % 40 == 0) {
                return this.searchForFunnyBlocks();
            }
            return false;
        }

        public void m_8056_() {
            Path path;
            super.m_8056_();
            if (this.targetPos != null && (path = this.vanguard.f_21344_.m_7864_(this.targetPos, 1)) != null) {
                this.vanguard.f_21344_.m_26536_(path, 1.0);
            }
            this.fireCooldown = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.fireCooldown;
            if (this.targetPos != null) {
                Path path;
                double distanceSqr = this.targetPos.m_203193_((Position)this.vanguard.m_20182_());
                if (distanceSqr < 25.0) {
                    if (this.fireCooldown >= 20) {
                        this.setFire();
                        this.fireCooldown = 0;
                        Vec3 awayDirection = this.vanguard.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)this.targetPos)).m_82541_();
                        Vec3 awayPos = this.vanguard.m_20182_().m_82549_(awayDirection.m_82490_(10.0));
                        Path awayPath = this.vanguard.f_21344_.m_7864_(BlockPos.m_274446_((Position)awayPos), 1);
                        if (awayPath != null) {
                            this.vanguard.f_21344_.m_26536_(awayPath, 1.5);
                        }
                        this.m_8041_();
                    }
                } else if (this.vanguard.f_21344_.m_26571_() && (path = this.vanguard.f_21344_.m_7864_(this.targetPos, 1)) != null) {
                    this.vanguard.f_21344_.m_26536_(path, 1.0);
                }
            }
        }

        public boolean m_8045_() {
            return this.targetPos != null && this.vanguard.f_19797_ % 400 != 0;
        }

        public void setFire() {
            if (this.targetPos == null) {
                return;
            }
            AABB aabb = new AABB(this.targetPos).m_82377_(3.0, 2.0, 3.0);
            block0: for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.vanguard.m_9236_().m_8055_(blockpos);
                if (!(this.vanguard.m_217043_().m_188501_() < 0.3f)) continue;
                for (Direction direction : Direction.values()) {
                    BlockPos adjacentPos = blockpos.m_121945_(direction);
                    BlockState adjacentState = this.vanguard.m_9236_().m_8055_(adjacentPos);
                    if (!blockstate.isFlammable((BlockGetter)this.vanguard.m_9236_(), blockpos, direction) || !adjacentState.m_60795_()) continue;
                    BlockState fireState = Blocks.f_50083_.m_49966_();
                    if (!FireBlock.m_49255_((Level)this.vanguard.m_9236_(), (BlockPos)adjacentPos, (Direction)direction)) continue;
                    this.vanguard.m_9236_().m_7731_(adjacentPos, fireState, 3);
                    continue block0;
                }
            }
            this.vanguard.m_9236_().m_7471_(this.targetPos, true);
            this.vanguard.m_216990_((SoundEvent)Ssounds.VANGUARD_GRIEF.get());
        }

        public void m_8041_() {
            super.m_8041_();
            this.targetPos = null;
            this.targetPositions.clear();
            this.firePositions.clear();
            this.vanguard.f_21344_.m_26573_();
        }
    }
}

