/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.Projectile.AdaptableProjectile;
import com.Harbinger.Spore.Sentities.Projectile.VomitUsurperBall;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.BulletParameters;
import com.Harbinger.Spore.Sentities.Variants.UsurperVariants;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Usurper
extends Organoid
implements RangedAttackMob,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Usurper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.m_135353_(Usurper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BURST_CONTROL = SynchedEntityData.m_135353_(Usurper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Usurper(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public int getEmerge_tick() {
        return 60;
    }

    @Override
    public int getBorrow_tick() {
        return 100;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.usurper_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.usurper_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("timer", ((Integer)this.f_19804_.m_135370_(TIMER)).intValue());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(TIMER, (Object)tag.m_128451_("timer"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(BURST_CONTROL, (Object)0);
    }

    protected void m_8099_() {
        this.addTargettingGoals();
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 0.0, 5, 5, 1.5f){

            public boolean m_8036_() {
                return super.m_8036_() && Usurper.this.getVariant() == UsurperVariants.SPRAY;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new ScatterShotRangedGoal(this, 0.0, 40, 32.0f, 1, 4){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Usurper.this.getVariant() == UsurperVariants.DEFAULT;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    public void setBurstControl(int value) {
        this.f_19804_.m_135381_(BURST_CONTROL, (Object)value);
    }

    public int getBurstControl() {
        return (Integer)this.f_19804_.m_135370_(BURST_CONTROL);
    }

    public void countDownBurstControl() {
        this.setBurstControl(this.getBurstControl() - 1);
    }

    public void tickBurstShotController() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (this.getBurstControl() > -5) {
            this.countDownBurstControl();
        } else if (this.m_142582_((Entity)target)) {
            this.setBurstControl(this.f_19796_.m_216339_(3, 7));
        }
        if (this.getBurstControl() > 0) {
            this.m_6504_(target, 0.0f);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_5448_() == null && (Integer)this.f_19804_.m_135370_(TIMER) < 1200) {
                this.f_19804_.m_135381_(TIMER, (Object)((Integer)this.f_19804_.m_135370_(TIMER) + 1));
            } else if ((Integer)this.f_19804_.m_135370_(TIMER) >= 1200) {
                this.tickBurrowing();
            }
            if (this.f_19797_ % 20 == 0 && this.getVariant() == UsurperVariants.BURST) {
                this.tickBurstShotController();
            }
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.usurper_loot.get();
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.f_19804_.m_135370_(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            this.m_146870_();
            burrowing = -1;
        }
        this.f_19804_.m_135381_(BORROW, (Object)(burrowing + 1));
    }

    @Override
    public boolean m_6469_(DamageSource source, float value) {
        if (this.isEmerging()) {
            return false;
        }
        return super.m_6469_(source, value);
    }

    public boolean m_21525_() {
        return this.isBurrowing() || this.isEmerging();
    }

    public void m_6504_(LivingEntity livingEntity, float p_33318_) {
        if (this.getVariant() == UsurperVariants.SPRAY) {
            VomitUsurperBall.shoot((LivingEntity)this, livingEntity, (float)(1.0 * (Double)SConfig.SERVER.global_damage.get()));
        } else {
            BulletParameters parameters = (BulletParameters)((Object)Util.m_214670_((Object[])BulletParameters.values(), (RandomSource)this.f_19796_));
            AdaptableProjectile projectile = new AdaptableProjectile(parameters, this.m_9236_(), (LivingEntity)this);
            double dx = livingEntity.m_20185_() - this.m_20185_();
            double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_();
            double dz = livingEntity.m_20189_() - this.m_20189_();
            projectile.m_6027_(this.m_20185_(), this.m_20186_() + 1.2, this.m_20189_());
            projectile.m_6686_(dx, dy - projectile.m_20186_() + Math.hypot(dx, dz) * (double)0.001f, dz, 1.5f, 3.0f);
            this.m_216990_((SoundEvent)Ssounds.SPIT.get());
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.USURPER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33282_, DifficultyInstance p_33283_, MobSpawnType p_33284_, @Nullable SpawnGroupData p_33285_, @Nullable CompoundTag p_33286_) {
        UsurperVariants variant = (UsurperVariants)((Object)Util.m_214670_((Object[])UsurperVariants.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(p_33282_, p_33283_, p_33284_, p_33285_, p_33286_);
    }

    public UsurperVariants getVariant() {
        return UsurperVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(i > UsurperVariants.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return UsurperVariants.values().length;
    }

    private void setVariant(UsurperVariants variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> dataValues) {
        AttributeInstance range;
        super.m_7350_(dataValues);
        if (DATA_ID_TYPE_VARIANT.equals(dataValues) && (range = this.m_21051_(Attributes.f_22277_)) != null) {
            if (this.getVariant() == UsurperVariants.SPRAY) {
                range.m_22100_(8.0);
            } else {
                range.m_22100_(64.0);
            }
        }
    }
}

