/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Damage.SdamageTypes;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.ArmedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedPlayer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.HasUsableSlot;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Protector
extends EvolvedInfected
implements ArmedInfected,
HasUsableSlot,
RangedAttackMob {
    public static final EntityDataAccessor<Boolean> SHIELDED = SynchedEntityData.m_135353_(Protector.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> PEARLS = SynchedEntityData.m_135353_(Protector.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int ticksUnShielded;

    public Protector(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(3, (Goal)new ProtectorMeleeGoal(this, (float)((Double)SConfig.SERVER.protector_damage.get() * (Double)SConfig.SERVER.global_damage.get())));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_protector_loot.get();
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.3) {
            return SdamageTypes.knight_damage((LivingEntity)this);
        }
        return super.getCustomDamage(entity);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.protector_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.protector_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.protector_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    public boolean getShielded() {
        return (Boolean)this.f_19804_.m_135370_(SHIELDED);
    }

    public void setShielded(boolean value) {
        this.f_19804_.m_135381_(SHIELDED, (Object)value);
    }

    public int getPearls() {
        return (Integer)this.f_19804_.m_135370_(PEARLS);
    }

    public void setPearls(int e) {
        this.f_19804_.m_135381_(PEARLS, (Object)e);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHIELDED, (Object)false);
        this.f_19804_.m_135372_(PEARLS, (Object)1);
    }

    @Override
    public void m_5993_(Entity entity, int i, DamageSource damageSource) {
        super.m_5993_(entity, i, damageSource);
        if (entity instanceof EnderMan) {
            this.setPearls(this.getPearls() + this.f_19796_.m_188503_(3));
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setShielded(tag.m_128471_("shield"));
        this.setPearls(tag.m_128451_("pearls"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("shield", this.getShielded());
        tag.m_128405_("pearls", this.getPearls());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.ADVENTURER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public void m_8119_() {
        double distance;
        LivingEntity entity;
        super.m_8119_();
        if (this.ticksUnShielded > 0) {
            --this.ticksUnShielded;
        }
        if (this.f_19797_ % 200 == 0) {
            this.setShielded(false);
        }
        if (this.f_19797_ % 40 == 0 && (entity = this.m_5448_()) != null && (distance = (double)this.m_20270_((Entity)entity)) > 20.0 && this.getPearls() > 0 && this.m_142582_((Entity)entity)) {
            this.m_6504_(entity, 0.0f);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity livingEntity;
        Entity entity = source.m_7639_();
        LivingEntity target = this.m_5448_();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).equals((Object)target)) {
            ItemStack stack = livingEntity.m_21205_();
            if (this.getShielded() && stack.canDisableShield(stack, (LivingEntity)this, livingEntity)) {
                this.ticksUnShielded = 200;
                this.m_216990_(SoundEvents.f_12347_);
                this.setShielded(false);
            }
            if (this.getShielded() && this.isLookingAtMe(livingEntity)) {
                this.m_216990_(SoundEvents.f_12346_);
                return false;
            }
        } else if (entity != null && this.getShielded()) {
            this.m_216990_(SoundEvents.f_12347_);
            this.ticksUnShielded = 100;
        }
        return super.m_6469_(source, amount);
    }

    public void m_269505_(List<SynchedEntityData.DataValue<?>> values) {
        AttributeInstance attributes;
        super.m_269505_(values);
        if (values == SHIELDED && (attributes = this.m_21051_(Attributes.f_22279_)) != null) {
            attributes.m_22100_(this.getShielded() ? 0.1 : 0.2);
        }
    }

    boolean isLookingAtMe(LivingEntity entity) {
        double angleThreshold;
        Vec3 toThis;
        Vec3 lookVec = entity.m_20252_(1.0f).m_82541_();
        double dot = lookVec.m_82526_(toThis = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20188_() - entity.m_20188_(), this.m_20189_() - entity.m_20189_()).m_82541_());
        return dot > (angleThreshold = 0.9) && entity.m_142582_((Entity)this);
    }

    @Override
    public boolean hasUsableSlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.FEET || slot == EquipmentSlot.HEAD;
    }

    protected void m_213945_(RandomSource p_219059_, DifficultyInstance p_219060_) {
        InfectedPlayer.createName((LivingEntity)this, (List)SConfig.DATAGEN.name.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.HEAD, (List)SConfig.DATAGEN.player_h.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.FEET, (List)SConfig.DATAGEN.player_b.get());
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_213945_(this.f_19796_, instance);
        return super.m_6518_(serverLevelAccessor, instance, p_21436_, p_21437_, p_21438_);
    }

    @Override
    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        SporeSavedData.removeProtector(this);
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        if (!this.m_9236_().f_46443_) {
            ThrownEnderpearl pearl = new ThrownEnderpearl(this.m_9236_(), (LivingEntity)this);
            double d0 = livingEntity.m_20188_() - this.m_20188_();
            double d1 = livingEntity.m_20185_() - this.m_20185_();
            double d2 = d0;
            double d3 = livingEntity.m_20189_() - this.m_20189_();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3) * 0.2;
            pearl.m_5602_((Entity)this);
            pearl.m_6686_(d1, d2 + d4, d3, 1.6f, 12.0f);
            this.m_5496_(SoundEvents.f_11857_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_9236_().m_7967_((Entity)pearl);
            this.setPearls(this.getPearls() - 1);
        }
    }

    public static class ProtectorMeleeGoal
    extends CustomMeleeAttackGoal {
        private final float meleeDamage;

        public ProtectorMeleeGoal(Protector mob, float meleeDamage) {
            super((PathfinderMob)mob, 1.2, false);
            this.meleeDamage = meleeDamage;
        }

        @Override
        protected double getAttackReachSqr(LivingEntity entity) {
            return 4.0 + (double)(entity.m_20205_() * entity.m_20205_());
        }

        @Override
        protected void checkAndPerformAttack(LivingEntity entity, double at) {
            PathfinderMob pathfinderMob = this.mob;
            if (pathfinderMob instanceof Protector) {
                Protector protector;
                double distance = (protector = (Protector)pathfinderMob).m_20270_((Entity)entity);
                protector.setShielded(distance < 15.0 && protector.ticksUnShielded <= 0);
                if (protector.getShielded() && entity.m_21223_() > this.meleeDamage) {
                    double d0 = this.getAttackReachSqr(entity);
                    if (at <= d0 && this.ticksUntilNextAttack <= 0 && protector.m_142582_((Entity)entity)) {
                        this.resetAttackCooldown(20);
                        this.mob.m_216990_(SoundEvents.f_12346_);
                        this.mob.m_6674_(InteractionHand.MAIN_HAND);
                        entity.f_19864_ = true;
                        if (entity instanceof Mob) {
                            Mob mob1 = (Mob)entity;
                            mob1.m_6710_((LivingEntity)this.mob);
                        }
                        entity.m_7292_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 100, 0));
                        entity.m_147240_((double)1.2f, (double)Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)))));
                    }
                } else {
                    super.checkAndPerformAttack(entity, at);
                }
            }
        }
    }
}

