/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.Core.SAttributes;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.AI.HybridPathNavigation;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.BaseEntities.IkUtil.IkKrakenArm;
import com.Harbinger.Spore.Sentities.BaseEntities.IkUtil.IkKrakenLeg;
import com.Harbinger.Spore.Sentities.BaseEntities.IkUtil.IkVortexFunnel;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.Sentities.WaterInfected;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class Grakensenker
extends Calamity
implements TrueCalamity,
WaterInfected {
    public static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.m_135353_(Grakensenker.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> WATER_TICKS = SynchedEntityData.m_135353_(Grakensenker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Vector3f> RIGHT_ARM_TIP = SynchedEntityData.m_135353_(Grakensenker.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Vector3f> LEFT_ARM_TIP = SynchedEntityData.m_135353_(Grakensenker.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Integer> RIGHT_ARM_ENTITY = SynchedEntityData.m_135353_(Grakensenker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LEFT_ARM_ENTITY = SynchedEntityData.m_135353_(Grakensenker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> RIGHT_ARM_DELAY = SynchedEntityData.m_135353_(Grakensenker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LEFT_ARM_DELAY = SynchedEntityData.m_135353_(Grakensenker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<BlockPos> VORTEX_VECTOR = SynchedEntityData.m_135353_(Grakensenker.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Integer> VORTEX_TIMEOUT = SynchedEntityData.m_135353_(Grakensenker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final float MIN_HEIGHT = 0.0f;
    public static final float MAX_HEIGHT = 4.0f;
    private final IkKrakenLeg BackRightTentacle;
    private final IkKrakenLeg BackLeftTentacle;
    private final IkKrakenLeg MiddleRightTentacle;
    private final IkKrakenLeg MiddleLeftTentacle;
    private final IkKrakenLeg FrontRightTentacle;
    private final IkKrakenLeg FrontLeftTentacle;
    private final IkKrakenArm RightArmTentacle;
    private final IkKrakenArm LeftArmTentacle;
    private final IkVortexFunnel VortexFunnel;
    private final IkKrakenLeg[] TickTentacles;
    private final CalamityMultipart[] subEntities;
    public final CalamityMultipart Body;
    public final CalamityMultipart Body2;
    public final CalamityMultipart RightHand;
    public final CalamityMultipart LeftHand;
    private static final Vector3f V0 = new Vector3f();
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.GRAKEN_FRONT_MAW, HitboxesForParts.GRAKEN_HINGE, HitboxesForParts.GRAKEN_BODY, HitboxesForParts.GRAKEN_BACK_MAW);

    public Grakensenker(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.Body = new CalamityMultipart(this, "body", 5.0f, 5.0f);
        this.Body2 = new CalamityMultipart(this, "body2", 3.0f, 3.0f);
        this.RightHand = new CalamityMultipart(this, "right", 1.5f, 1.5f);
        this.LeftHand = new CalamityMultipart(this, "left", 1.5f, 1.5f);
        this.BackRightTentacle = new IkKrakenLeg(this, 7, GrakenLegsModifiers.BACK_RIGHT_TENTACLE.bodySet, GrakenLegsModifiers.BACK_RIGHT_TENTACLE.offset, GrakenLegsModifiers.BACK_RIGHT_TENTACLE.underwaterOffset, 4.0f);
        this.BackLeftTentacle = new IkKrakenLeg(this, 7, GrakenLegsModifiers.BACK_LEFT_TENTACLE.bodySet, GrakenLegsModifiers.BACK_LEFT_TENTACLE.offset, GrakenLegsModifiers.BACK_LEFT_TENTACLE.underwaterOffset, 4.0f);
        this.MiddleRightTentacle = new IkKrakenLeg(this, 7, GrakenLegsModifiers.MIDDLE_RIGHT_TENTACLE.bodySet, GrakenLegsModifiers.MIDDLE_RIGHT_TENTACLE.offset, GrakenLegsModifiers.MIDDLE_RIGHT_TENTACLE.underwaterOffset, 6.0f);
        this.MiddleLeftTentacle = new IkKrakenLeg(this, 7, GrakenLegsModifiers.MIDDLE_LEFT_TENTACLE.bodySet, GrakenLegsModifiers.MIDDLE_LEFT_TENTACLE.offset, GrakenLegsModifiers.MIDDLE_LEFT_TENTACLE.underwaterOffset, 6.0f);
        this.FrontRightTentacle = new IkKrakenLeg(this, 10, GrakenLegsModifiers.FRONT_RIGHT_TENTACLE.bodySet, GrakenLegsModifiers.FRONT_RIGHT_TENTACLE.offset, GrakenLegsModifiers.FRONT_RIGHT_TENTACLE.underwaterOffset, 8.0f);
        this.FrontLeftTentacle = new IkKrakenLeg(this, 10, GrakenLegsModifiers.FRONT_LEFT_TENTACLE.bodySet, GrakenLegsModifiers.FRONT_LEFT_TENTACLE.offset, GrakenLegsModifiers.FRONT_LEFT_TENTACLE.underwaterOffset, 8.0f);
        this.RightArmTentacle = new IkKrakenArm(this, 16, GrakenLegsModifiers.RIGHT_ARM.bodySet, GrakenLegsModifiers.RIGHT_ARM.offset, GrakenLegsModifiers.RIGHT_ARM.underwaterOffset, 4.0f, true);
        this.LeftArmTentacle = new IkKrakenArm(this, 16, GrakenLegsModifiers.LEFT_ARM.bodySet, GrakenLegsModifiers.LEFT_ARM.offset, GrakenLegsModifiers.LEFT_ARM.underwaterOffset, 4.0f, false);
        this.VortexFunnel = new IkVortexFunnel(this);
        this.TickTentacles = new IkKrakenLeg[]{this.BackRightTentacle, this.BackLeftTentacle, this.MiddleRightTentacle, this.MiddleLeftTentacle, this.FrontRightTentacle, this.FrontLeftTentacle, this.RightArmTentacle, this.LeftArmTentacle, this.VortexFunnel};
        this.subEntities = new CalamityMultipart[]{this.Body, this.Body2, this.RightHand, this.LeftHand};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        this.f_21344_ = new HybridPathNavigation((Mob)this, this.m_9236_());
        this.m_274367_(1.5f);
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_20235_ + i + 1);
        }
    }

    public CalamityMultipart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_141965_(ClientboundAddEntityPacket p_218825_) {
        super.m_141965_(p_218825_);
    }

    public IkKrakenLeg getBackRightTentacle() {
        return this.BackRightTentacle;
    }

    public IkKrakenLeg getBackLeftTentacle() {
        return this.BackLeftTentacle;
    }

    public IkKrakenLeg getMiddleRightTentacle() {
        return this.MiddleRightTentacle;
    }

    public IkKrakenLeg getMiddleLeftTentacle() {
        return this.MiddleLeftTentacle;
    }

    public IkKrakenLeg getFrontRightTentacle() {
        return this.FrontRightTentacle;
    }

    public IkKrakenLeg getFrontLeftTentacle() {
        return this.FrontLeftTentacle;
    }

    public IkKrakenLeg[] getTentacles() {
        return this.TickTentacles;
    }

    public IkKrakenArm getRightArmTentacle() {
        return this.RightArmTentacle;
    }

    public IkKrakenArm getLeftArmTentacle() {
        return this.LeftArmTentacle;
    }

    public IkVortexFunnel getVortexFunnel() {
        return this.VortexFunnel;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.m_216990_((SoundEvent)Ssounds.SIEGER_BITE.get());
        return super.m_7327_(entity);
    }

    @Override
    public void m_7023_(Vec3 vec) {
        if (this.m_21515_() && this.isInFluidType()) {
            this.m_19920_(0.1f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9).m_82520_(0.0, -0.1, 0.0));
        } else {
            super.m_7023_(vec);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        if (calamityMultipart == this.RightHand) {
            this.f_19804_.m_135381_(RIGHT_ARM_DELAY, (Object)100);
        }
        if (calamityMultipart == this.LeftHand) {
            this.f_19804_.m_135381_(LEFT_ARM_DELAY, (Object)100);
        }
        value = calamityMultipart == this.Body ? value * 3.0f : value;
        return this.m_6469_(source, value);
    }

    protected boolean m_7310_(Entity passenger) {
        return true;
    }

    @Override
    public int chemicalRange() {
        return 16;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.graken_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.graken_debuffs.get();
    }

    public float getExtendedHeight() {
        return ((Float)this.f_19804_.m_135370_(HEIGHT)).floatValue();
    }

    public void setHeight(float value) {
        this.f_19804_.m_135381_(HEIGHT, (Object)Float.valueOf(value));
    }

    public int getWaterTicks() {
        return (Integer)this.f_19804_.m_135370_(WATER_TICKS);
    }

    public void setWaterTicks(int value) {
        this.f_19804_.m_135381_(WATER_TICKS, (Object)value);
    }

    public boolean isInDeepWater() {
        return (Integer)this.f_19804_.m_135370_(WATER_TICKS) >= 40;
    }

    public Vector3f getRightArm() {
        return (Vector3f)this.f_19804_.m_135370_(RIGHT_ARM_TIP);
    }

    public Vector3f getLeftArm() {
        return (Vector3f)this.f_19804_.m_135370_(LEFT_ARM_TIP);
    }

    public void setRightArm(Vector3f vector3f) {
        this.f_19804_.m_135381_(RIGHT_ARM_TIP, (Object)vector3f);
    }

    public void setLeftArm(Vector3f vector3f) {
        this.f_19804_.m_135381_(LEFT_ARM_TIP, (Object)vector3f);
    }

    public int getRightArmDelay() {
        return (Integer)this.f_19804_.m_135370_(RIGHT_ARM_DELAY);
    }

    public int getLeftArmDelay() {
        return (Integer)this.f_19804_.m_135370_(LEFT_ARM_DELAY);
    }

    public BlockPos getVortexVector() {
        return (BlockPos)this.f_19804_.m_135370_(VORTEX_VECTOR);
    }

    public int getVortexTimeOut() {
        return (Integer)this.f_19804_.m_135370_(VORTEX_TIMEOUT);
    }

    public void setVortexVector(BlockPos vector3f) {
        this.f_19804_.m_135381_(VORTEX_VECTOR, (Object)vector3f);
    }

    public boolean hasVortex() {
        return this.f_19804_.m_135370_(VORTEX_VECTOR) != BlockPos.f_121853_;
    }

    public void setVortexTimeout(int value) {
        this.f_19804_.m_135381_(VORTEX_TIMEOUT, (Object)value);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEIGHT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(WATER_TICKS, (Object)0);
        this.f_19804_.m_135372_(RIGHT_ARM_TIP, (Object)V0);
        this.f_19804_.m_135372_(LEFT_ARM_TIP, (Object)V0);
        this.f_19804_.m_135372_(RIGHT_ARM_ENTITY, (Object)-1);
        this.f_19804_.m_135372_(LEFT_ARM_ENTITY, (Object)-1);
        this.f_19804_.m_135372_(RIGHT_ARM_DELAY, (Object)0);
        this.f_19804_.m_135372_(LEFT_ARM_DELAY, (Object)0);
        this.f_19804_.m_135372_(VORTEX_VECTOR, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(VORTEX_TIMEOUT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("height", ((Float)this.f_19804_.m_135370_(HEIGHT)).floatValue());
        tag.m_128405_("water", ((Integer)this.f_19804_.m_135370_(WATER_TICKS)).intValue());
        for (int e = 0; e < this.TickTentacles.length; ++e) {
            this.TickTentacles[e].writeVariants(tag, e);
        }
        tag.m_128405_("VX", this.getVortexVector().m_123341_());
        tag.m_128405_("VY", this.getVortexVector().m_123342_());
        tag.m_128405_("VZ", this.getVortexVector().m_123343_());
        tag.m_128405_("timeOut", this.getVortexTimeOut());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(HEIGHT, (Object)Float.valueOf(tag.m_128457_("height")));
        this.f_19804_.m_135381_(WATER_TICKS, (Object)tag.m_128451_("water"));
        for (int e = 0; e < this.TickTentacles.length; ++e) {
            this.TickTentacles[e].readVariants(tag, e);
        }
        int x = tag.m_128451_("VX");
        int y = tag.m_128451_("VY");
        int z = tag.m_128451_("VZ");
        this.setVortexVector(new BlockPos(x, y, z));
        this.setVortexTimeout(tag.m_128451_("timeOut"));
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20390_(1.0f, 1.0f + this.getExtendedHeight() * 0.5f);
    }

    public void applyYaw(CalamityMultipart part, Vec3 offset) {
        float yawRad = this.m_146908_() * ((float)Math.PI / 180);
        float spinRad = (float)this.getWaterTicks() * 0.05f;
        Vec3 pos = this.m_20182_().m_82549_(offset.m_82524_(-yawRad - 1.5707964f + spinRad));
        part.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public void m_8107_() {
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
        }
        this.applyYaw(this.Body, new Vec3(-4.5, 5.0 + (double)this.getExtendedHeight(), 0.0));
        this.applyYaw(this.Body2, new Vec3(-2.5, 2.0 + (double)this.getExtendedHeight(), 0.0));
        this.RightHand.m_6034_(this.getRightArm().x, this.getRightArm().y, this.getRightArm().z);
        this.LeftHand.m_6034_(this.getLeftArm().x, this.getLeftArm().y, this.getLeftArm().z);
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].f_19854_ = avec3[l].f_82479_;
            this.subEntities[l].f_19855_ = avec3[l].f_82480_;
            this.subEntities[l].f_19856_ = avec3[l].f_82481_;
            this.subEntities[l].f_19790_ = avec3[l].f_82479_;
            this.subEntities[l].f_19791_ = avec3[l].f_82480_;
            this.subEntities[l].f_19792_ = avec3[l].f_82481_;
        }
        super.m_8107_();
    }

    public void setRightArmEntity(int id) {
        this.f_19804_.m_135381_(RIGHT_ARM_ENTITY, (Object)id);
    }

    public void setLeftArmEntity(int id) {
        this.f_19804_.m_135381_(LEFT_ARM_ENTITY, (Object)id);
    }

    private void validateArms() {
        LivingEntity le;
        Entity e;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        int rightId = (Integer)this.f_19804_.m_135370_(RIGHT_ARM_ENTITY);
        int leftId = (Integer)this.f_19804_.m_135370_(LEFT_ARM_ENTITY);
        if (!(rightId == -1 || (e = this.m_9236_().m_6815_(rightId)) instanceof LivingEntity && (le = (LivingEntity)e).m_6084_() && le.m_20365_((Entity)this))) {
            this.f_19804_.m_135381_(RIGHT_ARM_ENTITY, (Object)-1);
        }
        if (!(leftId == -1 || (e = this.m_9236_().m_6815_(leftId)) instanceof LivingEntity && (le = (LivingEntity)e).m_6084_() && le.m_20365_((Entity)this))) {
            this.f_19804_.m_135381_(LEFT_ARM_ENTITY, (Object)-1);
        }
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        if (this.m_20096_()) {
            return SoundEvents.f_12361_;
        }
        return SoundEvents.f_11918_;
    }

    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) > 200.0) {
            return null;
        }
        return (SoundEvent)Ssounds.KRAKEN_GROWL.get();
    }

    @Override
    public void m_8119_() {
        BlockPos pos;
        super.m_8119_();
        if (this.f_19797_ % 1200 == 0 && this.getSearchArea() == BlockPos.f_121853_ && !this.isOcean(this.m_9236_().m_204166_(this.m_20097_())) && (pos = this.findOcean(this.m_9236_(), this.m_20097_())) != null) {
            this.setSearchArea(pos);
        }
        this.updateHeight();
        this.handleVortexBehavior();
        if (this.getVortexTimeOut() > 0) {
            this.setVortexTimeout(this.getVortexTimeOut() - 1);
        }
        for (BlockPos leg : this.TickTentacles) {
            leg.refreshLegStandingPoint();
            leg.applyIK();
        }
        if (this.f_19797_ % 10 == 0) {
            this.tryGrab(this.getRightArm(), true, this.getRightArmDelay() <= 0);
            this.tryGrab(this.getLeftArm(), false, this.getLeftArmDelay() <= 0);
        }
        if (this.f_19797_ % 20 == 0) {
            BlockPos vec3;
            this.validateArms();
            if (this.isInDeepWater() && !this.hasVortex() && this.getVortexTimeOut() <= 0 && this.m_5448_() == null && this.getSearchArea() == BlockPos.f_121853_ && (vec3 = this.findVortexCenter(this.m_9236_())) != null) {
                this.setVortexVector(vec3);
            }
        }
        if (this.hasVortex()) {
            int range = 8;
            for (int i = 0; i <= 2 * range; ++i) {
                for (int k = 0; k <= 2 * range; ++k) {
                    double distance = Mth.m_14116_((float)((i - range) * (i - range) + (k - range) * (k - range)));
                    if (Math.abs(i) == 2 && Math.abs(k) == 2 || !(distance < (double)range + 0.5) || !(Math.random() < 0.1)) continue;
                    BlockPos vector3f = this.getVortexVector().m_7918_(i - range, 0, k - range);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)vector3f.m_123341_(), (double)(vector3f.m_123342_() + 1), (double)vector3f.m_123343_(), 0.0, 0.05, 0.0);
                }
            }
            this.applyVortexForces();
        }
        if (this.getRightArmDelay() > 0) {
            this.f_19804_.m_135381_(RIGHT_ARM_DELAY, (Object)(this.getRightArmDelay() - 1));
        }
        if (this.getLeftArmDelay() > 0) {
            this.f_19804_.m_135381_(LEFT_ARM_DELAY, (Object)(this.getLeftArmDelay() - 1));
        }
        if (this.m_20069_()) {
            Vec3 vec3;
            LivingEntity target = this.m_5448_();
            Vec3 vec32 = vec3 = target == null ? this.m_20184_() : target.m_20182_();
            if (vec3.m_165925_() > (double)2.5E-7f) {
                double dx = vec3.f_82479_;
                double dy = vec3.f_82480_;
                double dz = vec3.f_82481_;
                double horizontal = Math.sqrt(dx * dx + dz * dz);
                float yaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                float pitch = (float)(Mth.m_14136_((double)dy, (double)horizontal) * 57.29577951308232);
                this.m_146922_(yaw);
                this.m_146926_(pitch);
                this.f_20883_ = Grakensenker.lerpRotation(this.f_19859_, this.m_146908_());
            }
        }
    }

    protected static float lerpRotation(float currentRotation, float targetRotation) {
        while (targetRotation - currentRotation < -180.0f) {
            currentRotation -= 360.0f;
        }
        while (targetRotation - currentRotation >= 180.0f) {
            currentRotation += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)currentRotation, (float)targetRotation);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        this.setVortexTimeout(1200);
        this.setVortexVector(BlockPos.f_121853_);
        return super.m_6469_(source, amount);
    }

    private void tryGrab(Vector3f handPos, boolean right, boolean canGrab) {
        boolean active;
        boolean bl = active = right ? this.isRightArmFull() : this.isLeftArmFull();
        if (active && canGrab) {
            return;
        }
        AABB aabb = new AABB((double)handPos.x - 2.0, (double)handPos.y - 2.0, (double)handPos.z - 2.0, (double)handPos.x + 2.0, (double)handPos.y + 2.0, (double)handPos.z + 2.0);
        List targets = this.m_9236_().m_6443_(LivingEntity.class, aabb, e -> e.m_6084_() && e != this && !e.m_20159_() && !e.m_20147_() && Utilities.TARGET_SELECTOR.Test((LivingEntity)e) && TargetingConditions.m_148352_().m_26885_((LivingEntity)this, e));
        if (targets.isEmpty()) {
            return;
        }
        LivingEntity living = (LivingEntity)targets.get(0);
        if (right) {
            this.setRightArmEntity(living.m_19879_());
        } else {
            this.setLeftArmEntity(living.m_19879_());
        }
        living.m_20329_((Entity)this);
    }

    public boolean isRightArmFull() {
        return (Integer)this.f_19804_.m_135370_(RIGHT_ARM_ENTITY) != -1;
    }

    public boolean isLeftArmFull() {
        return (Integer)this.f_19804_.m_135370_(LEFT_ARM_ENTITY) != -1;
    }

    public int getRightArmEntity() {
        return (Integer)this.f_19804_.m_135370_(RIGHT_ARM_ENTITY);
    }

    public int getLeftArmEntity() {
        return (Integer)this.f_19804_.m_135370_(LEFT_ARM_ENTITY);
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        float tall = passenger.m_20206_() / 2.0f;
        passenger.m_20124_(Pose.STANDING);
        if (passenger.m_19879_() == ((Integer)this.f_19804_.m_135370_(RIGHT_ARM_ENTITY)).intValue()) {
            Vector3f pos = this.getRightArm();
            callback.m_20372_(passenger, (double)pos.x, (double)(pos.y - tall), (double)pos.z);
            this.strangleVictim(passenger);
            if (passenger.m_20238_(this.m_20182_().m_82520_(0.0, (double)this.getExtendedHeight(), 0.0)) <= 4.0) {
                this.setRightArmEntity(-1);
            }
        } else if (passenger.m_19879_() == ((Integer)this.f_19804_.m_135370_(LEFT_ARM_ENTITY)).intValue()) {
            Vector3f pos = this.getLeftArm();
            callback.m_20372_(passenger, (double)pos.x, (double)(pos.y - tall), (double)pos.z);
            this.strangleVictim(passenger);
            if (passenger.m_20238_(this.m_20182_().m_82520_(0.0, (double)this.getExtendedHeight(), 0.0)) <= 4.0) {
                this.setLeftArmEntity(-1);
            }
        } else {
            callback.m_20372_(passenger, this.m_20185_(), this.m_20186_() + (double)this.getExtendedHeight(), this.m_20189_());
            if (this.f_19797_ % 20 == 0 && passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                this.m_7327_((Entity)living);
            }
        }
    }

    public void strangleVictim(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            int air = living.m_20146_();
            living.m_20301_(--air);
        }
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.graken_dpsr.get();
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (passenger.m_19879_() == ((Integer)this.f_19804_.m_135370_(RIGHT_ARM_ENTITY)).intValue()) {
            this.f_19804_.m_135381_(RIGHT_ARM_ENTITY, (Object)-1);
        }
        if (passenger.m_19879_() == ((Integer)this.f_19804_.m_135370_(LEFT_ARM_ENTITY)).intValue()) {
            this.f_19804_.m_135381_(LEFT_ARM_ENTITY, (Object)-1);
        }
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity passenger) {
        if (passenger.m_19879_() == ((Integer)this.f_19804_.m_135370_(RIGHT_ARM_ENTITY)).intValue()) {
            return new Vec3(this.getRightArm());
        }
        if (passenger.m_19879_() == ((Integer)this.f_19804_.m_135370_(LEFT_ARM_ENTITY)).intValue()) {
            return new Vec3(this.getLeftArm());
        }
        this.f_19804_.m_135381_(RIGHT_ARM_DELAY, (Object)100);
        this.f_19804_.m_135381_(LEFT_ARM_DELAY, (Object)100);
        return super.m_7688_(passenger);
    }

    public void updateHeight() {
        boolean wantsLowStance;
        float current;
        if (this.m_9236_().f_46443_) {
            return;
        }
        float target = current = this.getExtendedHeight();
        boolean deep = this.inDeepWater(this.m_20097_());
        if (deep) {
            if (this.getWaterTicks() <= 180) {
                this.setWaterTicks(this.getWaterTicks() + 5);
            }
        } else if (this.getWaterTicks() > 0) {
            this.setWaterTicks(this.getWaterTicks() - 5);
        }
        boolean deepWater = this.isInDeepWater();
        double wantedY = this.f_21342_.m_25001_() + 2.0;
        boolean bl = wantsLowStance = wantedY < this.m_20186_() + (double)this.m_20206_() && this.f_19862_;
        target = wantsLowStance || deepWater ? (target -= 0.05f) : (target += 0.08f);
        target = Math.max(0.0f, Math.min(4.0f, target));
        if (Math.abs(target - current) > 0.01f) {
            this.setHeight(target);
        }
    }

    protected boolean inDeepWater(BlockPos pos) {
        BlockPos firstPos = pos.m_7918_(-3, 2, -3);
        BlockPos secondPos = pos.m_7918_(3, 5, 3);
        return BlockPos.m_121990_((BlockPos)firstPos, (BlockPos)secondPos).allMatch(this::checkForFluid);
    }

    boolean checkForFluid(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        FluidState fluidstate = state.m_60819_();
        return state.m_60812_((BlockGetter)this.m_9236_(), pos).m_83281_() && fluidstate.m_205070_(FluidTags.f_13131_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.graken_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.graken_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.graken_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_((Attribute)SAttributes.REJUVENATION.get(), 0.0).m_22268_((Attribute)SAttributes.LOCALIZATION.get(), 0.0).m_22268_((Attribute)SAttributes.LACERATION.get(), 0.0).m_22268_((Attribute)SAttributes.CORROSIVES.get(), 0.0).m_22268_((Attribute)SAttributes.BALLISTIC.get(), 0.0).m_22268_((Attribute)SAttributes.GRINDING.get(), 0.0);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (HEIGHT.equals(dataAccessor)) {
            this.m_274367_((float)(1.5 + (double)this.getExtendedHeight()));
            this.m_6210_();
        }
        if (SEARCH_AREA.equals(dataAccessor) && this.getSearchArea() != BlockPos.f_121853_) {
            this.setVortexTimeout(1200);
            this.setVortexVector(BlockPos.f_121853_);
        }
        super.m_7350_(dataAccessor);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.graken_loot.get();
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new AOEMeleeAttackGoal(this, 1.5, false, 2.5, 6.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            public boolean m_8036_() {
                return !Grakensenker.this.hasVortex() && super.m_8036_();
            }

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                float f = Grakensenker.this.m_20205_();
                return f * 2.0f * f * 2.0f + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(6, (Goal)new CalamityInfectedCommand(this));
        this.f_21345_.m_25352_(7, (Goal)new SummonScentInCombat(this));
        this.f_21345_.m_25352_(8, (Goal)new SporeBurstSupport(this));
        super.m_8099_();
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>();
        for (HitboxesForParts hitboxes : this.innatePartList) {
            HitboxesForParts part = this.calculateChance(hitboxes, 0.85f);
            if (part == null) continue;
            values.add(part);
        }
        return values;
    }

    public Vec3 applyYaw(Vec3 offset) {
        float yawRad = this.m_146908_() * ((float)Math.PI / 180);
        float spinRad = (float)this.getWaterTicks() * 0.05f;
        return offset.m_82524_(-yawRad - 1.5707964f + spinRad);
    }

    @Nullable
    public BlockPos findVortexCenter(Level level) {
        if (!this.m_20069_()) {
            return null;
        }
        Vec3 random = this.applyYaw(new Vec3((double)this.m_217043_().m_216339_(3, 7), 0.0, (double)this.m_217043_().m_216339_(-5, 5)));
        Vec3 base = this.m_20182_().m_82549_(random);
        for (int dy = 0; dy <= 32; ++dy) {
            BlockPos pos = BlockPos.m_274561_((double)base.f_82479_, (double)(base.f_82480_ + (double)dy), (double)base.f_82481_);
            BlockState water = level.m_8055_(pos);
            BlockState air = level.m_8055_(pos.m_7494_());
            if (!water.m_60713_(Blocks.f_49990_) || !air.m_60795_()) continue;
            if (dy <= 12) {
                return null;
            }
            return pos;
        }
        return null;
    }

    public void handleVortexBehavior() {
        if (!this.hasVortex()) {
            return;
        }
        if (this.getVortexTimeOut() > 0) {
            return;
        }
        this.m_21573_().m_26573_();
        this.m_20256_(Vec3.f_82478_);
        this.f_19812_ = false;
        this.lookAtVortex(this.getVortexVector());
    }

    private void lookAtVortex(BlockPos target) {
        double dx = (double)target.m_123341_() - this.m_20185_();
        double dz = (double)target.m_123343_() - this.m_20189_();
        double dy = (double)target.m_123342_() - this.m_20188_();
        double dist = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        float pitch = (float)(-(Math.atan2(dy, dist) * 57.29577951308232));
        this.m_146922_(yaw);
        this.m_146926_(pitch);
        this.f_20883_ = yaw;
        this.f_20885_ = yaw;
    }

    public void applyVortexForces() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Vec3[] funnelPoints = this.getVortexFunnel().getEntities();
        if (funnelPoints == null || funnelPoints.length < 2) {
            return;
        }
        Vec3 base = funnelPoints[0];
        for (int i = 0; i < funnelPoints.length; ++i) {
            Vec3 segmentPos = funnelPoints[i];
            double distanceFromBase = (double)i / (double)(funnelPoints.length - 1);
            double radius = 1.0 + distanceFromBase * 4.0 + (double)i / 4.0;
            AABB area = Grakensenker.getAabb(distanceFromBase, segmentPos, radius);
            List entities = this.m_9236_().m_6443_(Entity.class, area, e -> {
                LivingEntity living;
                return (e instanceof LivingEntity && (living = (LivingEntity)e) != this && Utilities.TARGET_SELECTOR.Test(living) && TargetingConditions.m_148352_().m_26885_((LivingEntity)this, living) || e instanceof Boat) && e.m_20069_();
            });
            for (Entity entity : entities) {
                if (entity.m_20160_() && this.getVortexVector().m_203193_((Position)entity.m_20182_()) < 120.0) {
                    entity.m_20153_();
                }
                this.applyVortexForceToEntity(entity, segmentPos, radius, i, funnelPoints.length, base);
            }
        }
    }

    @NotNull
    private static AABB getAabb(double distanceFromBase, Vec3 segmentPos, double radius) {
        double verticalScale = 1.0 + (1.0 - distanceFromBase) * 2.0;
        double horizontalScale = 0.8 + distanceFromBase * 1.2;
        return new AABB(segmentPos.f_82479_ - radius * horizontalScale, segmentPos.f_82480_ - radius * verticalScale * 0.5, segmentPos.f_82481_ - radius * horizontalScale, segmentPos.f_82479_ + radius * horizontalScale, segmentPos.f_82480_ + radius * verticalScale * 1.5, segmentPos.f_82481_ + radius * horizontalScale);
    }

    private void applyVortexForceToEntity(Entity entity, Vec3 center, double radius, int segmentIndex, int totalSegments, Vec3 basePosition) {
        double maxSpeed;
        Vec3 entityPos = entity.m_20182_();
        Vec3 toCenter = center.m_82546_(entityPos);
        double distance = toCenter.m_82553_();
        if (distance < 0.2 || distance > radius) {
            return;
        }
        double normalizedDistance = distance / radius;
        double funnelPosition = (double)segmentIndex / (double)(totalSegments - 1);
        double baseMultiplier = Math.pow(1.0 - funnelPosition, 2.0);
        double pullStrength = segmentIndex == 0 ? 0.25 * (1.0 + normalizedDistance * 0.5) : (segmentIndex < totalSegments / 3 ? 0.18 * (0.8 + normalizedDistance * 0.4) : 0.12 * (0.6 + normalizedDistance * 0.3));
        Vec3 radialPull = toCenter.m_82541_().m_82490_(pullStrength);
        Vec3 spinDir = new Vec3(-toCenter.f_82481_, 0.0, toCenter.f_82479_).m_82541_();
        double spinStrength = 0.8 * (1.0 - normalizedDistance) * (0.3 + baseMultiplier * 0.7);
        Vec3 spinForce = spinDir.m_82490_(spinStrength);
        Vec3 toBase = basePosition.m_82546_(entityPos);
        double distanceToBase = toBase.m_82553_();
        double flowStrength = Grakensenker.getFlowStrength(segmentIndex, totalSegments, distanceToBase);
        Vec3 flowForce = toBase.m_82541_().m_82490_(flowStrength);
        double sinkStrength = segmentIndex > totalSegments - 4 ? 0.01 * (1.0 - funnelPosition) : 0.01 * baseMultiplier;
        Vec3 sinkForce = new Vec3(0.0, -sinkStrength * (1.0 - normalizedDistance), 0.0);
        Vec3 totalForce = segmentIndex == 0 ? radialPull.m_82490_(2.0).m_82549_(flowForce.m_82490_(0.5)).m_82549_(spinForce.m_82490_(0.3)) : (segmentIndex < 4 ? flowForce.m_82490_(1.5).m_82549_(radialPull).m_82549_(spinForce.m_82490_(0.7)).m_82549_(sinkForce.m_82490_(0.5)) : flowForce.m_82549_(radialPull.m_82490_(0.8)).m_82549_(spinForce).m_82549_(sinkForce.m_82490_(0.8)));
        Vec3 motion = entity.m_20184_().m_82549_(totalForce);
        if (segmentIndex == 0) {
            maxSpeed = entity instanceof Boat ? 0.2 : 0.4;
        } else if (segmentIndex < 4) {
            maxSpeed = entity instanceof Boat ? 0.3 : 0.6;
        } else {
            double d = maxSpeed = entity instanceof Boat ? 0.5 : 1.0;
        }
        if (motion.m_82553_() > maxSpeed) {
            motion = motion.m_82541_().m_82490_(maxSpeed);
        }
        if (segmentIndex <= 5 && this.shouldConsumeEntity(entity, center)) {
            this.consumeEntity(entity);
            return;
        }
        entity.m_20256_(motion);
        entity.f_19864_ = true;
    }

    private static double getFlowStrength(int segmentIndex, int totalSegments, double distanceToBase) {
        double flowStrength = segmentIndex == 0 ? 0.02 : (segmentIndex < 3 ? 0.3 * (1.0 - distanceToBase / 10.0) : (segmentIndex < totalSegments / 2 ? 0.15 : 0.08));
        return flowStrength;
    }

    private boolean shouldConsumeEntity(Entity entity, Vec3 baseCenter) {
        if (!entity.m_6084_()) {
            return false;
        }
        if (entity.m_20159_()) {
            return false;
        }
        double distSq = entity.m_20182_().m_82557_(baseCenter);
        return distSq < 10.240000000000002 && entity instanceof LivingEntity;
    }

    private void consumeEntity(Entity entity) {
        entity.m_20256_(Vec3.f_82478_);
        entity.f_19789_ = 0.0f;
        entity.m_8127_();
        Vec3 basePos = this.getVortexFunnel().getEntities()[0];
        entity.m_6034_(basePos.f_82479_, basePos.f_82480_, basePos.f_82481_);
        entity.m_20329_((Entity)this);
    }

    static enum GrakenLegsModifiers {
        BACK_LEFT_TENTACLE(new Vec3(-3.0, 3.5, 0.75), new Vec3(-6.0, -1.0, 6.0), new Vec3(1.0, -3.0, 4.0)),
        BACK_RIGHT_TENTACLE(new Vec3(-3.0, 3.5, -0.75), new Vec3(-6.0, -1.0, -6.0), new Vec3(1.0, -3.0, -4.0)),
        MIDDLE_LEFT_TENTACLE(new Vec3(-1.0, 2.0, 0.75), new Vec3(0.0, -1.0, 6.0), new Vec3(0.0, 1.0, 7.0)),
        MIDDLE_RIGHT_TENTACLE(new Vec3(-1.0, 2.0, -0.75), new Vec3(0.0, -1.0, -6.0), new Vec3(0.0, 1.0, -7.0)),
        FRONT_LEFT_TENTACLE(new Vec3(-2.0, 3.0, 0.75), new Vec3(9.0, -1.0, 6.0), new Vec3(8.0, 1.0, 4.0)),
        FRONT_RIGHT_TENTACLE(new Vec3(-2.0, 3.0, -0.75), new Vec3(9.0, -1.0, -6.0), new Vec3(8.0, 1.0, -4.0)),
        LEFT_ARM(new Vec3(0.0, 3.0, 1.0), new Vec3(8.0, 2.5, 6.0), new Vec3(16.0, 4.5, 8.0)),
        RIGHT_ARM(new Vec3(0.0, 3.0, -1.0), new Vec3(8.0, 2.5, -6.0), new Vec3(16.0, 4.5, -8.0));

        private final Vec3 bodySet;
        private final Vec3 offset;
        private final Vec3 underwaterOffset;

        private GrakenLegsModifiers(Vec3 bodySet, Vec3 offset, Vec3 underwaterOffset) {
            this.bodySet = bodySet;
            this.offset = offset;
            this.underwaterOffset = underwaterOffset;
        }
    }
}

