/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BasicInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.AI.HybridPathNavigation;
import com.Harbinger.Spore.Sentities.AI.InfectedConsumeFromRemains;
import com.Harbinger.Spore.Sentities.AI.InfectedPanicGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.BufferAI;
import com.Harbinger.Spore.Sentities.AI.LocHiv.FollowOthersGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.LocalTargettingGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.MovementControls.WaterXlandMovement;
import com.Harbinger.Spore.Sentities.Utility.HyperClaw;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.BairnSkins;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Bairn
extends Infected
implements VariantKeeper {
    @Nullable
    private BlockPos Targetpos;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Bairn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Bairn(EntityType<? extends Infected> type, Level level) {
        super(type, level);
        this.f_21342_ = new WaterXlandMovement((Mob)this);
        this.f_21344_ = new HybridPathNavigation((Mob)this, this.m_9236_());
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(2, (Goal)new SearchAroundGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 1.5 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    protected void m_8024_() {
        if (!this.m_21525_() && GoalUtils.m_26894_((Mob)this) && ((Boolean)SConfig.SERVER.higher_thinking.get()).booleanValue() && (this.getVariant() == BairnSkins.VILLAGER || this.getVariant() == BairnSkins.ZOMBIE_VILLAGER)) {
            ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        }
        super.m_8024_();
    }

    @Override
    protected void addRegularGoals() {
        this.f_21345_.m_25352_(3, (Goal)new LocalTargettingGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BufferAI(this));
        this.f_21345_.m_25352_(3, (Goal)new OpenDoorGoal((Mob)this, true){

            public boolean m_8036_() {
                return super.m_8036_() && (Bairn.this.getVariant() == BairnSkins.VILLAGER || Bairn.this.getVariant() == BairnSkins.ZOMBIE_VILLAGER);
            }

            public void m_8056_() {
                this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                super.m_8056_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FollowOthersGoal(this, HyperClaw.class, entity -> this.m_20202_() == null){

            @Override
            public boolean m_8036_() {
                return Bairn.this.m_20202_() == null && super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                LivingEntity living = Bairn.this.getFollowPartner();
                return living != null && living.m_20270_((Entity)Bairn.this) > 36.0f;
            }

            public void m_8041_() {
                super.m_8041_();
                LivingEntity living = Bairn.this.getFollowPartner();
                if (living != null) {
                    Bairn.this.m_20329_((Entity)living);
                }
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new InfectedPanicGoal(this, 1.5));
        this.f_21345_.m_25352_(6, (Goal)new FloatDiveGoal((Mob)this){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Bairn.this.getVariant() != BairnSkins.DROWNED;
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new InfectedConsumeFromRemains(this));
    }

    public boolean canDrownInFluidType(FluidType type) {
        return this.getVariant() != BairnSkins.DROWNED && super.canDrownInFluidType(type);
    }

    @Override
    public void m_7023_(Vec3 input) {
        if (this.m_21515_() && this.isInFluidType() && this.getVariant() == BairnSkins.DROWNED) {
            this.m_19920_(0.1f, input);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.85));
        } else {
            super.m_7023_(input);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.bairn_loot.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.bairn_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.bairn_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.bairn_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22282_, 0.3);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.BAIRN.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    private void setVariant(BairnSkins variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public BairnSkins getVariant() {
        return BairnSkins.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(i > BairnSkins.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return BairnSkins.values().length;
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.Targetpos;
    }

    public void setTargetPos(@Nullable BlockPos pos) {
        this.Targetpos = pos;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        BairnSkins variant = (BairnSkins)((Object)Util.m_214670_((Object[])BairnSkins.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(serverLevelAccessor, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public void searchBlocks() {
        AABB aabb = this.m_20191_().m_82377_(20.0, 4.0, 20.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            Container container;
            BlockEntity blockEntity = this.m_9236_().m_7702_(blockpos);
            if (!(blockEntity instanceof Container) || !this.food(container = (Container)blockEntity) || !this.hasLineOfSightBlocks(blockpos) || !(this.f_19796_.m_188501_() < 0.5f)) continue;
            this.setTargetPos(blockpos);
            break;
        }
    }

    public boolean hasLineOfSightBlocks(BlockPos pos) {
        BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockPos position = raytraceresult.m_82425_();
        return pos.equals((Object)position) || this.m_9236_().m_46859_(pos) || this.m_9236_().m_7702_(pos) == this.m_9236_().m_7702_(position);
    }

    private boolean food(Container container) {
        return container.m_216874_(item -> item.getFoodProperties((LivingEntity)this) != null);
    }

    public boolean interractWithBlock(BlockPos pos) {
        Container container;
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity instanceof Container && this.food(container = (Container)blockEntity)) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                FoodProperties properties = stack.getFoodProperties((LivingEntity)this);
                if (properties == null) continue;
                int amount = stack.m_41613_() > 1 ? this.f_19796_.m_188503_(stack.m_41613_()) : stack.m_41613_();
                this.m_216990_(SoundEvents.f_11912_);
                stack.m_41774_(amount);
                this.setKills(this.getKills() + (int)((float)properties.m_38744_() + properties.m_38745_()) * amount);
            }
        } else {
            this.m_9236_().m_46953_(pos, true, (Entity)this);
        }
        return true;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            if (this.getVariant() == BairnSkins.HUSK) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 1200, 0));
            }
        }
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            if (this.getVariant() == BairnSkins.ZOMBIE_VILLAGER) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            }
        }
        return super.m_7327_(entity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 100 == 0) {
            this.searchBlocks();
        }
    }

    public static class SearchAroundGoal
    extends Goal {
        private final Bairn specter;
        public int tryTicks;

        public SearchAroundGoal(Bairn specter) {
            this.specter = specter;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.specter.getTargetPos() != null && this.specter.m_5448_() == null;
        }

        protected void moveToBlock(BlockPos pos) {
            Path path = this.specter.f_21344_.m_7864_(pos, 1);
            if (path != null) {
                this.specter.m_21573_().m_26536_(path, 1.0);
            }
        }

        public void m_8056_() {
            this.moveToBlock(this.specter.getTargetPos());
            this.tryTicks = 0;
            super.m_8056_();
        }

        public boolean m_8045_() {
            return this.specter.m_5448_() == null;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.tryTicks;
            BlockPos pos = this.specter.getTargetPos();
            if (pos != null && this.shouldRecalculatePath()) {
                this.moveToBlock(pos);
            }
            if (pos != null && pos.m_203195_((Position)this.specter.m_20182_(), 3.5)) {
                this.specter.interractWithBlock(pos);
                this.openChest(pos);
                this.specter.setTargetPos(null);
                this.specter.searchBlocks();
            }
        }

        public void openChest(BlockPos pos) {
            BlockEntity entity = this.specter.m_9236_().m_7702_(pos);
            if (entity instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlock = (ChestBlockEntity)entity;
                this.specter.m_216990_(SoundEvents.f_11749_);
                this.specter.m_9236_().m_7696_(pos, chestBlock.m_58900_().m_60734_(), 1, 1);
                this.specter.m_9236_().m_46672_(pos, chestBlock.m_58900_().m_60734_());
                this.specter.m_9236_().m_46672_(pos.m_7495_(), chestBlock.m_58900_().m_60734_());
            }
        }
    }
}

