/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities.IkUtil;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.IkUtil.IkKrakenLeg;
import com.Harbinger.Spore.Sentities.Calamities.Grakensenker;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class IkKrakenArm
extends IkKrakenLeg {
    protected final boolean rightArm;
    @Nullable
    protected LivingEntity target;
    private final Vec3 RightVec = new Vec3(4.0, 0.0, -16.0);
    private final Vec3 LeftVec = new Vec3(4.0, 0.0, 16.0);
    private final Vec3 RightMidVec = new Vec3(4.0, 3.5, -5.0);
    private final Vec3 LeftMidVec = new Vec3(4.0, 3.5, 5.0);
    private final Vec3 RightMidVec2 = new Vec3(7.0, 1.5, -5.0);
    private final Vec3 LeftMidVec2 = new Vec3(7.0, 1.5, 5.0);
    private final Vec3 MouthPosition = new Vec3(0.0, 1.5, 0.0);
    private final Vec3 RightWaterVec = new Vec3(8.0, 4.5, -6.0);
    private final Vec3 LeftWaterVec = new Vec3(8.0, 4.5, 6.0);
    private static final Vector3f nullVec = new Vector3f(0.0f);

    public IkKrakenArm(Grakensenker owner, int amount, Vec3 defaultBodyOffset, Vec3 defaultLimbOffset, Vec3 underwater, float maxDistance, boolean rightArm) {
        super(owner, amount, defaultBodyOffset, defaultLimbOffset, underwater, maxDistance);
        this.rightArm = rightArm;
    }

    @Override
    public float getWiggleAmplitude() {
        return 0.01f;
    }

    @Override
    public float getWiggleSpeed() {
        return 0.5f;
    }

    @Override
    public void refreshLegStandingPoint() {
        Vector3f vector3f;
        int hitValues = this.rightArm ? this.owner.getRightArmDelay() : this.owner.getLeftArmDelay();
        boolean full = this.rightArm ? this.owner.isRightArmFull() : this.owner.isLeftArmFull();
        Vector3f vector3f2 = vector3f = this.rightArm ? this.owner.getRightArm() : this.owner.getLeftArm();
        if (this.owner.m_9236_().f_46443_) {
            Vec3 vec3 = this.sitPosition = vector3f == nullVec || hitValues > 0 ? this.getLegBasePos() : new Vec3(vector3f).m_82520_(0.0, 1.0, 0.0);
            this.lastSitPosition = this.sitPosition = full ? (this.owner.isInDeepWater() ? this.getUnderwaterLegOffset() : this.getMouthPosition()) : this.sitPosition;
        } else {
            Vec3 vec3 = this.sitPosition = this.target == null || hitValues > 0 ? this.getLegBasePos() : this.target.m_20182_().m_82520_(0.0, 1.0, 0.0);
            this.lastSitPosition = this.sitPosition = full ? (this.owner.isInDeepWater() ? this.getUnderwaterLegOffset() : this.getMouthPosition()) : this.sitPosition;
            if (this.owner.f_19797_ % 10 == 0 && hitValues <= 0 && !full) {
                this.setTarget();
            }
        }
    }

    @Override
    protected void moveTipTowards(Vec3 value) {
        Vec3 newPos;
        int tip = this.entities.length - 1;
        Vec3 currentPos = this.entities[tip];
        int val = this.entities.length - 1;
        this.entities[val] = newPos = currentPos.m_165921_(value, this.owner.m_9236_().f_46443_ ? (double)0.35f : (double)0.2f);
    }

    public void setTarget() {
        Optional<LivingEntity> targetOp = this.findAndSetTarget();
        this.target = targetOp.isPresent() ? targetOp.get() : null;
    }

    public Optional<LivingEntity> findAndSetTarget() {
        Level level = this.owner.m_9236_();
        Vec3 pivot = this.applyYaw(this.rightArm ? this.RightVec : this.LeftVec);
        AABB searchBox = new AABB(this.owner.m_20185_() - 16.0, this.owner.m_20186_(), this.owner.m_20189_() - 16.0, this.owner.m_20185_() + 16.0, this.owner.m_20186_() + (double)this.owner.getExtendedHeight() + 4.0, this.owner.m_20189_() + 16.0).m_82383_(pivot);
        return level.m_6443_(LivingEntity.class, searchBox, e -> e.m_6084_() && e != this.owner && e.m_20202_() != this.owner && Utilities.TARGET_SELECTOR.Test((LivingEntity)e) && TargetingConditions.m_148352_().m_26885_((LivingEntity)this.owner, e)).stream().findFirst();
    }

    public Vec3 getMidSecPivot() {
        Vec3 pivot = this.applyYaw(this.rightArm ? this.RightMidVec : this.LeftMidVec);
        return this.owner.m_20182_().m_82549_(pivot).m_82520_(0.0, (double)this.owner.getExtendedHeight(), 0.0);
    }

    public Vec3 getMidSecPivot2() {
        Vec3 pivot = this.applyYaw(this.rightArm ? this.RightMidVec2 : this.LeftMidVec2);
        return this.owner.m_20182_().m_82549_(pivot).m_82520_(0.0, (double)this.owner.getExtendedHeight(), 0.0);
    }

    public Vec3 getMidSecPivot3() {
        Vec3 pivot = this.applyYaw(this.rightArm ? this.RightWaterVec : this.LeftWaterVec);
        return this.owner.m_20182_().m_82549_(pivot).m_82520_(0.0, (double)this.owner.getExtendedHeight(), 0.0);
    }

    public Vec3 getMouthPosition() {
        Vec3 pivot = this.applyYaw(this.MouthPosition);
        return this.owner.m_20182_().m_82549_(pivot).m_82520_(0.0, (double)this.owner.getExtendedHeight(), 0.0);
    }

    protected void moveMidSegmentTowards(int index, Vec3 target) {
        Vec3 newPos;
        if (this.target != null || this.owner.isInDeepWater()) {
            return;
        }
        Vec3 currentPos = this.entities[index];
        this.entities[index] = newPos = currentPos.m_165921_(target, (double)0.2f);
    }

    protected void moveMidSegmentWaterTowards(int index, Vec3 target) {
        if (this.target == null && this.owner.isInDeepWater()) {
            Vec3 newPos;
            Vec3 currentPos = this.entities[index];
            this.entities[index] = newPos = currentPos.m_165921_(target, (double)0.45f);
        }
    }

    @Override
    public void applyIK() {
        super.applyIK();
        this.moveMidSegmentTowards(this.entities.length / 4, this.getMidSecPivot());
        this.moveMidSegmentTowards(this.entities.length / 2, this.getMidSecPivot2());
        this.moveMidSegmentWaterTowards(this.entities.length / 4, this.getMidSecPivot3());
        float x = (float)this.entities[this.entities.length - 1].m_7096_();
        float y = (float)this.entities[this.entities.length - 1].m_7098_();
        float z = (float)this.entities[this.entities.length - 1].m_7094_();
        if (!this.owner.m_9236_().f_46443_) {
            if (this.rightArm) {
                this.owner.setRightArm(new Vector3f(x, y, z));
            } else {
                this.owner.setLeftArm(new Vector3f(x, y, z));
            }
        }
    }
}

